function mec_rsvp_module_init($){

    if( 0 == $('.mec_rsvp_form').length ){

        return;
    }
    var primary_box, rsvp_id, nonce, answer_id, event_date, total_attendees, creator_email;

    function mec_get_body_form_step_1(el, replace_vars = false) {

        var primary_box = $(el).parents('.mec-custom-form-box');
        var form = $(el).parents('.mec_rsvp_form');
        var data = {
            action: 'mec-rsvp-get-body-form-step1',
            event_id: $('input[name="event_id"]').val(),
            event_date: $(el).val(),
            nonce: $('#_mec_nonce_s1').val(),
        };

        $(form).css('opacity', '0.7');
        $('.mec-loading-1', primary_box).show();
        $('.mec-rsvp-step-1-box .mec-body-form', primary_box).hide();
        $.post(
            mec_rsvp.ajaxurl,
            data,
            function (r) {

                if (r.success == true) {
                    $('.mec-rsvp-step-1-box .mec-body-form', primary_box).html(r.html);
                } else {
                    if (r.error_message_html) {
                        $('.mec-rsvp-message-box', form).html(r.error_message_html);
                    }
                }
                $('.mec-loading-1', primary_box).hide();
                $(form).css('opacity', '1');
                $('.mec-rsvp-step-1-box .mec-body-form', primary_box).show();

                mec_custom_form_init();

                if (true === replace_vars) {

                    $('h4', primary_box).html('Edit RSVP - ' + rsvp_id);
                    $('select[name="rsvp[event_date]"]', form).prop('disabled', true);
                    $('select[name="rsvp[event_date]"]', form).hide();
                    $('[name="rsvp[attendees_count]"]', form).val(total_attendees);
                    $('[name="rsvp[email]"]', form).val(creator_email);

                    $('#mec-rsvp-rsvp_' + answer_id, form).trigger('click');
                    $('#rsvp_email', form).parent().hide();

                    if ($('input[name="rsvp[rsvp_id]"]', form).length > 0) {

                        $('input[name="rsvp[rsvp_id]"]', form).val(rsvp_id);
                        $('input[name="rsvp[rsvp_nonce]"]', form).val(nonce);
                        $('input[name="rsvp[event_date]"]', form).val(event_date);
                    } else {

                        $(form).append('<input type="hidden" name="rsvp[rsvp_id]" value="' + rsvp_id + '" />');
                        $(form).append('<input type="hidden" name="rsvp[rsvp_nonce]" value="' + nonce + '" />');
                        $(form).append('<input type="hidden" name="rsvp[event_date]" class="mec-rsvp-event-days" value="' + event_date + '" />');
                    }
                }

                /** Init reCaptcha */
                var recaptcha_check = jQuery('#mec-rsvp-g-recaptcha').length;
                if (recaptcha_check != 0) {
                    jQuery('#mec-rsvp-g-recaptcha').html('');
                    grecaptcha.render("mec-rsvp-g-recaptcha", {
                        sitekey: mecdata.recapcha_key
                    });
                }
            }
        );
    }

    function mec_scroll_to_rsvp_form(btn) {

        var custom_form = $(btn).parents('.mec-custom-form-box');
        $('html, body').animate({
            scrollTop: $(custom_form).offset().top - 20,
            scrollLeft: $(custom_form).offset().left - 20,
        });
    }

    function mec_rsvp_form_init(is_edit_form = false) {

        if (is_edit_form) {

            var body = $('.mec-rsvp-modification');
        } else {

            var body = $(document);
        }

        $('.mec-rsvp-event-days', body).on('change', function () {
            mec_get_body_form_step_1($(this));
        });

        $('.mec-move-to-step-2', body).on('click', function (e) {
            var btn = $(this);
            var primary_box = $(e.currentTarget).parents('.mec-custom-form-box');
            var form = $(e.currentTarget).parents('.mec_rsvp_form');
            var fdata = $(form).serializeArray();
            var data = {
                'action': $('[name="rsvp_action"]', form).val(),
            };

            $.each(fdata, function (i, v) {
                data[v['name']] = v['value'];
            });

            $('.mec-rsvp-message-box').html();
            $(form).css('opacity', '0.7');
            $(btn).addClass('loading');
            $.post(
                mec_rsvp.ajaxurl,
                data,
                function (r) {

                    if (r.success == true) {
                        $('.mec-rsvp-step-2-box', primary_box).html(r.html);
                        $('.mec-rsvp-step-2-box', primary_box).removeClass('hidden');
                        $('.mec-rsvp-step-1-box', primary_box).addClass('hidden');

                        var input_email_selector = 'input[type=email][name="rsvp[attendees][0][mec_email]"]';
                        var email = $(input_email_selector, primary_box).val();
                        $(input_email_selector, primary_box).prop('disabled', true);

                        var hidden_input_selector = 'input[type=hidden][name="rsvp[attendees][0][mec_email]"]';
                        if ($(hidden_input_selector, primary_box).length == 0) {

                            $(input_email_selector, primary_box).parent().append('<input type="hidden" name="rsvp[attendees][0][mec_email]" value="' + email + '">');
                        }

                        if ($('[name="rsvp[first_for_all]"]', primary_box).is(':checked')) {

                            $('[name="rsvp[attendees][0][first_name]"]').on('change', function () {

                                $('input[name$="[first_name]"][name!="rsvp[attendees][0][first_name]"]', primary_box).val($(this).val());
                            });

                            $('[name="rsvp[attendees][0][last_name]"]').on('change', function () {

                                $('input[name$="[last_name]"][name!="rsvp[attendees][0][last_name]"]', primary_box).val($(this).val());
                            });
                        }

                        if ($('[name="rsvp[rsvp_id]"]', primary_box).length == 0 || $('[name="rsvp[first_for_all]"]', primary_box).is(':checked')) {

                            $('input[name$="[mec_email]"]', primary_box).val(email);
                        }
                        $('[name="rsvp[email]"]', primary_box).val(email);
                        $(hidden_input_selector, primary_box).val(email);
                    } else {
                        if (r.error_message_html) {
                            $('.mec-rsvp-message-box', form).html(r.error_message_html);
                        }
                    }
                    $(btn).removeClass('loading');
                    $(form).css('opacity', '1');
                    mec_custom_form_init();
                    mec_scroll_to_rsvp_form(e.currentTarget);
                }
            );

            return false;
        });
    }

    mec_rsvp_form_init();

    function mec_custom_form_init() {
        $('.mec-move-to-step-1').on('click', function (e) {
            var primary_box = $(e.currentTarget).parents('.mec-custom-form-box');

            $(primary_box).find(' > div').addClass('hidden');
            $(primary_box).find('.mec-rsvp-step-1-box').removeClass('hidden');
            mec_scroll_to_rsvp_form(e.currentTarget);

            /** Refresh reCaptcha */
            if ( typeof grecaptcha !== "undefined") {
                grecaptcha.reset();
            }

            return false;
        });

        $('input , select , textarea').on('change', function () {
            if ($(this).val().length == 0) {
                if (true == $(this).prop('required')) {

                    $(this).addClass('mec-error');
                }
            } else {
                $(this).removeClass('mec-error');
            }
        });

        $('.mec-custom-form-box .mec-submit').on('click', function (e) {

            var btn = $(this);
            var form = $(this).parents('form').get(0);
            var primary_box = $(e.currentTarget).parents('.mec-custom-form-box');
            var result_box = $('.mec-rsvp-result-box', primary_box);
            var data = {
                'action': $('[name="mec-action-2"]', primary_box).val(),
            };

            var can_submit = true;
            var fdata;
            $.each($('.mec_rsvp_form', primary_box), function (f, form) {

                fdata = $(form).serializeArray();
                $.each(fdata, function (i, v) {
                    data[v['name']] = v['value'];

                    var el = $('[name="' + v['name'] + '"]', primary_box);
                    if (true == $(el).prop('required') && true != $(el).prop('disabled')) {
                        if (v['value'].length === 0) {

                            $(el).addClass('mec-error');
                            can_submit = false;
                        }
                    }
                });
            });

            if (!can_submit) {

                alert(mec_rsvp.error_form_data);
                return false;
            }

            $(primary_box).css('opacity', '0.7');
            $(btn).addClass('loading');

            if ($(result_box).find('.mec-rsvp-message-box').length > 1) {

                $(result_box).find('.mec-rsvp-message-box').html();
            } else {

                $(result_box).append('<div class="mec-rsvp-message-box"></div>');
            }

            $(btn).prop('disabled', true);
            $.post(
                mec_rsvp.ajaxurl,
                data,
                function (r) {
                    if (r.success == true) {

                        $(primary_box).find(' > div').addClass('hidden');
                        $(result_box).removeClass('hidden');

                        $(result_box).html(r.html);
                    } else {
                        if (r.error_message_html) {
                            $('.mec-rsvp-message-box', form).html(r.error_message_html);
                        }
                    }

                    $(btn).removeClass('loading');
                    $(primary_box).css('opacity', '1');
                    mec_scroll_to_rsvp_form(e.currentTarget);
                    $(btn).prop('disabled', false);
                }
            );

            return false;
        });

        function mec_rsvp_attendees_first_for_all(el) {
            var form = $(el).parents('.mec_rsvp_form');
            if (form.length > 1) {
                form = form[0];
            }
            if ($(el).is(':checked')) {
                $('.mec-attendees-detail-inputs', form).addClass('hidden');
            } else {
                $('.mec-attendees-detail-inputs', form).removeClass('hidden');
            }
        }

        $('.mec_rsvp_first_for_all').on('change', function (e) {
            mec_rsvp_attendees_first_for_all(this);
        });
        $('.rsvp-first-for-all-label').on('click', function (e) {
            console.log('webnus')
            var form = $(this).parents('.mec_rsvp_form');
            var input = $(this).parents('.mec-fill-attendees').find(".mec_rsvp_first_for_all");
            console.log(input)
            console.log(form)
            if (form.length > 1) {
                form = form[0];
            }
            if (!input.is(":checked")) {
                input.prop("checked", true);
                $('.mec-attendees-detail-inputs', form).addClass('hidden');
            }
            else {
                input.prop("checked", false);
                $('.mec-attendees-detail-inputs', form).removeClass('hidden');
            }
            //mec_rsvp_attendees_first_for_all(this);
        });

        $.each($('.mec_rsvp_first_for_all'), function (i, v) {
            mec_rsvp_attendees_first_for_all(v);
        });

        function mec_load_more_attendees_init() {

            $('.mec-load-attendees').on('click', function (e) {

                var btn = $(this);
                var form = $(this).parents('form').get(0);
                var primary_box = $(e.currentTarget).parents('.mec-custom-form-box');
                var result_box = $('.mec-rsvp-result-box', primary_box);

                var data = {
                    action: "mec-get-more-attendees",
                    event_id: $(this).data('event_id'),
                    answer: $(this).data('answer'),
                    event_date: $(this).data('event_date'),
                    offset: $(this).data('offset'),
                };

                $(primary_box).css('opacity', '0.7');
                $(btn).addClass('mec-load-more-loading');

                $.post(
                    mec_rsvp.ajaxurl,
                    data,
                    function (r) {

                        var tab = $('#mec-rsvp-answer-rsvp_' + data.answer + '-details');
                        var new_attendees = $(r).filter('.mec-attendees').html();
                        if ('undefined' !== typeof new_attendees) {

                            $('.mec-attendees', tab).append(new_attendees);
                        }

                        var load_more = $(r).filter('.mec-load-more-wrap').html();
                        if ('undefined' !== typeof load_more) {

                            $('.mec-load-more-wrap', tab).html(load_more);
                            mec_load_more_attendees_init();
                        } else {

                            $('.mec-load-more-wrap', tab).remove();
                        }

                        $(btn).removeClass('mec-load-more-loading');
                        $(primary_box).css('opacity', '1');
                    }
                );

                return false;
            });
        }

        mec_load_more_attendees_init();

        $('.mec-rsvp-answers-details-links input').on('change', function (e) {

            $(e.currentTarget).parents('.mec-rsvp-answers-details-links').find('div').removeClass('active');
            $(e.currentTarget).parents('.mec-rsvp-answer').find('.mec-rsvp-answers-details-tabs div').removeClass('active');
            if ($(e.currentTarget).is(':checked')) {

                $(e.currentTarget).parents('div').addClass('active');
                var target_id = $(e.currentTarget).data('target-id');
                $(e.currentTarget).parents('.mec-rsvp-answer').find('.mec-rsvp-answers-details-tabs #' + target_id).addClass('active');
            }
            return true;
        });
    }

    mec_get_body_form_step_1($('.mec-rsvp-event-days'));
    mec_custom_form_init();

    /** RSVP edit form start */
    $('.mec-show-rsvp-modification').on('click', function (e) {

        $(this).hide();
        $(this).parent().find('.mec-rsvp-search-form').toggle();
    });

    $("#mec-rsvp-search-by-email").on('click', function () {

        var primary_box = $(this).parents('.mec-rsvp-modification');
        var form = $(this).parents('.mec-rsvp-search-form');
        var data = {
            action: $('[name="action"]').val(),
            event_id: $('[name="event_id"]').val(),
            email: $('[name="mec-rsvp-search-form[email]"]').val(),
            nonce: $('#mec-rsvp-search-form-nonce').val(),
            verification_code: $('input[name="mec-rsvp-verification-code"]').val(),
        };

        $('.mec-loading-1', form).show();
        $('.mec-rsvps', primary_box).show();
        $.post(
            mec_rsvp.ajaxurl,
            data,
            function (r) {

                $('.mec-loading-1', form).hide();
                if (r.success == true) {
                    $('.mec-rsvps', primary_box).html(r.html);
                } else if ('need_verification' == r.success) {
                    $('.mec-email-confirmation', form).removeClass('hidden');

                    return;
                } else {
                    if (r.error_message_html) {
                        $('.mec-rsvp-message-box', primary_box).html(r.error_message_html);

                        return;
                    }
                }
                $('.mec-loading-1', form).hide();
                $('.mec-rsvps', primary_box).show();
                $(form).hide();

                mec_rsvp_form_init(true);
                mec_edit_rsvp_init();
            }
        );
    });

    function mec_edit_rsvp_init() {

        $(".mec-edit-rsvp").on('click', function (e) {

            var primary_box = $(this).parents('.mec-rsvp-modification');
            rsvp_id = $(this).data('rsvp_id');
            nonce = $(this).data('nonce');
            answer_id = $(this).data('answer_id');
            event_date = $(this).data('event_date');
            total_attendees = $(this).data('total_attendees');
            creator_email = $(this).data('creator_email');

            var data = {
                action: 'mec-get-rsvp-form-for-edit',
                event_id: $('[name="event_id"]').val(),
            };

            $('.mec-loading-1', primary_box).show();
            $('.mec-edit-form-rsvp', primary_box).hide();
            $('.mec-rsvps', primary_box).hide();
            $.post(
                mec_rsvp.ajaxurl,
                data,
                function (r) {

                    if (r.success == true) {
                        $('.mec-edit-form-rsvp', primary_box).html(r.html);
                        mec_get_body_form_step_1($('.mec-edit-form-rsvp .mec-rsvp-event-days ', primary_box), true);

                        var form = $(primary_box).find('.mec-rsvp-step-1-box .mec_rsvp_form');

                    } else {
                        if (r.error_message_html) {
                            $('.mec-rsvp-message-box', primary_box).html(r.error_message_html);
                        }
                    }
                    $('.mec-loading-1', primary_box).hide();
                    $('.mec-edit-form-rsvp', primary_box).show();
                    $('.mec-rsvps').hide();

                    mec_rsvp_form_init(true);
                }
            );

            return false;
        });
    }
    /** RSVP edit form end */
}

jQuery(document).ready(function ($) {
    mec_rsvp_module_init($);
});