<?php

namespace MEC_RSVP\Settings;


use MEC\Singleton;
use MEC_RSVP\Base;

class SettingsPage extends Singleton {

	/**
	 * @var \MEC_Main
	 */
	public $main;

	/**
	 * @var array
	 */
	public $settings;

	/**
	 * Init
	 */
	public function init() {

		add_filter( 'mec_is_custom_settings', [ $this, 'is_rsvp_settings' ], 10, 2 );
		add_action( 'mec_settings_sidebar', [ $this, 'sidebar' ] );
		add_filter( 'mec_save_options_final', [ $this, 'update_options' ] );
	}

	public function is_rsvp_settings( $true, $tab ) {

		if ( $true ) {
			return $true;
		}

		$tab = strtolower( $tab );

		switch ( $tab ) {
			case 'mec-rsvp':
				$this->display();
				$true = true;
		}

		return $true;
	}

	/**
	 * Display Settings Page
	 */
	public function display() {

		$this->main = Base::get_main();
		include __DIR__ . '/template-settings-page.php';
	}

	/**
	 * @return array
	 */
	public function get_form_types() {

		return array(
				'general' => __( 'RSVP Form', 'mec-rsvp' ),
				'yes'     => __( 'RSVP Form "Yes"', 'mec-rsvp' ),
				'no'      => __( 'RSVP Form "No"', 'mec-rsvp' ),
				'maybe'   => __( 'RSVP Form "Maybe"', 'mec-rsvp' ),
		);
	}

	/**
	 * Display Settings menu Sidebar
	 *
	 * @param $active_menu
	 */
	public function sidebar( $active_menu ) {

		$submenus = array(
			__( 'RSVP', 'mec-rsvp' )              => 'rsvp_option',
		);

		if(mec_rsvp_is_enabled()){

			$submenus = array_merge_recursive(
				$submenus,
				array(
					__( 'RSVP Shortcode', 'mec-rsvp' )    => 'rsvp_shortcode',
					__( 'RSVP Form', 'mec-rsvp' )         => 'rsvp_form_option-rsvp_general',
					__( 'RSVP Form "Yes"', 'mec-rsvp' )   => 'rsvp_form_option-rsvp_yes',
					__( 'RSVP Form "No"', 'mec-rsvp' )    => 'rsvp_form_option-rsvp_no',
					__( 'RSVP Form "Maybe"', 'mec-rsvp' ) => 'rsvp_form_option-rsvp_maybe',
					__( 'Upload Field', 'mec-rsvp' )      => 'uploadfield_option',
				)
			);

		}

		$this->main = Base::get_main();
		$submenus   = apply_filters( 'mec-settings-item-rsvp', $submenus, $active_menu );

		?>
		<!-- RSVP -->
		<li class="wns-be-group-menu-li mec-settings-menu <?php echo $active_menu === 'rsvp' ? 'active' : ''; ?>">
			<a href="<?php echo $this->main->add_qs_var( 'tab', 'mec-rsvp' ); ?>" id="" class="wns-be-group-tab-link-a">
				<i class="mec-sl-directions"></i>
				<span class="wns-be-group-menu-title"><?php _e( 'RSVP', 'mec-rsvp' ); ?></span>
			</a>
			<ul class="<?php echo $active_menu === 'rsvp' ? 'subsection' : 'mec-settings-submenu'; ?>">

				<?php foreach ( $submenus as $menu_name => $menu_link ) {
					if ( in_array( $menu_link, array_values( $submenus ), true ) ) {
						?>
						<li>
							<a
									<?php if ( $active_menu === 'rsvp' ): ?>
										data-id="<?php echo $menu_link; ?>" <?php echo $menu_link !== 'rsvp_option' ? 'data-group_id="rsvp"' : ''; ?> class="wns-be-group-tab-link-a WnTabLinks"
									<?php else: ?>
										href="<?php echo $this->main->add_qs_var( 'tab', 'mec-rsvp' ) . '#' . $menu_link; ?>"
									<?php endif; ?>
							>
								<span class="pr-be-group-menu-title"><?php echo $menu_name; ?></span>
							</a>
						</li>
						<?php

					}
				} ?>
			</ul>
		</li>
		<?php
	}

	public function update_options( $options ) {

		$groups      = $this->get_form_types();
		$field_types = array(
				'reg',
				'bfixed',
		);

		foreach ( $groups as $group_id => $title ) {

			foreach ( $field_types as $field_type ) {

				$key = 'rsvp_'.$group_id . '_' . $field_type . '_fields';
				$new_notification_options = array();
				if ( isset( $_POST['mec'][ $key ] ) ) {

					$notification_options = is_array( $_POST['mec'][ $key ] ) ? $_POST['mec'][ $key ] : array();

					foreach($notification_options as $k => $field){

						$field_key = isset($field['key']) && !empty($field['key']) ? $field['key'] : $k;
						$field_key = strtolower( str_replace( [
							' ',
							',',
							':',
							'"',
							"'",
						], '_', trim( $field_key ) ) );

						if(isset($field['key'])){

							$field['key'] = $field_key;
						}

						$new_notification_options[$field_key] = $field;
					}

					$options[ $key ] = $new_notification_options;
				} elseif( !isset( $options[ $key ] ) ) {

					$options[ $key ] = array();
				}
			}
		}

		return $options;
	}

}