<?php
/** no direct access **/

use MEC\Settings\Settings;

defined( 'MECEXEC' ) or die();

/** @var \MEC_RSVP\Settings\SettingsPage $this */

$settings = $this->main->get_settings();

// WordPress Pages
$pages = get_pages();

// User Roles
$roles = array_reverse( wp_roles()->roles );

?>
<div class="wns-be-container wns-be-container-sticky">
	<div id="wns-be-infobar">
		<div class="mec-search-settings-wrap">
			<i class="mec-sl-magnifier"></i>
			<input id="mec-search-settings" type="text" placeholder="<?php esc_html_e( 'Search...', 'mec-rsvp' ); ?>">
		</div>
		<a id="" class="dpr-btn dpr-save-btn"><?php _e( 'Save Changes', 'mec-rsvp' ); ?></a>
	</div>

	<div class="wns-be-sidebar">
		<?php $this->main->get_sidebar_menu( 'rsvp' ); ?>
	</div>

	<div class="wns-be-main">
		<div id="wns-be-notification"></div>
		<div id="wns-be-content">
			<div class="wns-be-group-tab">
				<div class="mec-container">

					<form id="mec_rsvp_form">

						<div id="rsvp_option" class="mec-options-fields active">
							<h4 class="mec-form-subtitle"><?php _e( 'RSVP', 'mec-rsvp' ); ?></h4>
							<div class="mec-form-row">
								<label for="mec_rsvp_status">
									<input type="hidden" name="mec[settings][rsvp_status]" value="0"/>
									<input id="mec_rsvp_status" onchange="jQuery('#mec_rsvp_container_toggle , [data-group_id=rsvp]').toggle();" value="1" type="checkbox" name="mec[settings][rsvp_status]" <?php if ( isset( $settings['rsvp_status'] ) and $settings['rsvp_status'] ) {
										echo 'checked="checked"';
									} ?> /> <?php _e( 'Enable RSVP module', 'mec-rsvp' ); ?>
								</label>
							</div>
							<div id="mec_rsvp_container_toggle" class="<?php if ( ( isset( $settings['rsvp_status'] ) and !$settings['rsvp_status'] ) or !isset( $settings['rsvp_status'] ) ) {
								echo 'mec-util-hidden';
							} ?>">


								<h5 class="title"><?php _e( 'Captcha', 'mec-rsvp' ); ?></h5>
								<div class="mec-form-row">
                                    <label>
                                        <input type="hidden" name="mec[settings][google_recaptcha_rsvp]" value="0" />
                                        <input value="1" type="checkbox" name="mec[settings][google_recaptcha_rsvp]" <?php if(isset($settings['google_recaptcha_rsvp']) and $settings['google_recaptcha_rsvp']) echo 'checked="checked"'; ?> /> <?php _e('Enable Google Captcha on RSVP form', 'mec-rsvp'); ?>
                                    </label>
                                </div>

								<h5 class="title"><?php _e( 'Display Options', 'mec-rsvp' ); ?></h5>
								<div class="mec-form-row">
									<label class="mec-col-3" for="mec_settings_rsvp_attendees_list"><?php _e( 'Display Attendees List in RSVP Form', 'mec-rsvp' ); ?></label>
									<div class="mec-col-9">
										<?php
											$answers = array(
												'yes'   => __( 'Yes', 'mec-rsvp' ),
												'no'    => __( 'No', 'mec-rsvp' ),
												'maybe' => __( 'Maybe', 'mec-rsvp' ),
											);

											$display_attendees_settings = isset($settings['rsvp_attendees_list']) ? (array)$settings['rsvp_attendees_list'] : ['yes','no','maybe'];
											echo '<input type="hidden" name="mec[settings][rsvp_attendees_list]" value="0" />';
											foreach($answers as $answer_id => $answer_text){

												$checked = in_array($answer_id,$display_attendees_settings,true);
												echo '<label><input type="checkbox" id="mec_settings_rsvp_attendees_list_'.$answer_id.'" name="mec[settings][rsvp_attendees_list]['.$answer_id.']" value="'.$answer_id.'" '.checked(true,$checked,false).'/>'.$answer_text.'</label>';
											}
										?>

									</div>
                                </div>
								<div class="mec-form-row">
									<div class="mec-col-12">
										<?php
										$checked = isset($settings['rsvp_display_form_only_for_logged_in_users']) ? (bool)$settings['rsvp_display_form_only_for_logged_in_users'] : false;
										?>
										<input type="hidden" name="mec[settings][rsvp_display_form_only_for_logged_in_users]" value="0"/>
										<label><input type="checkbox" id="mec_settings_rsvp_display_form_only_for_logged_in_users" name="mec[settings][rsvp_display_form_only_for_logged_in_users]" value="1" <?php checked(true,$checked); ?>/><?php esc_html_e('Display form only for logged in users','mec-rsvp'); ?></label>

									</div>
                                </div>
								<div class="mec-form-row">
									<div class="mec-col-12">
										<?php
										$checked = isset($settings['rsvp_display_rsvp_report']) ? (bool)$settings['rsvp_display_rsvp_report'] : false;
										?>
										<input type="hidden" name="mec[settings][rsvp_display_rsvp_report]" value="0"/>
										<label><input type="checkbox" id="mec_settings_rsvp_display_rsvp_report" name="mec[settings][rsvp_display_rsvp_report]" value="1" <?php checked(true,$checked); ?>/><?php esc_html_e('Display RSVP report in RSVP from','mec-rsvp'); ?></label>
									</div>
                                </div>
								<div class="mec-form-row">
									<label class="mec-col-3" for="mec_settings_rsvp_min_attendees"><?php _e( 'Minimum attendees to start the event', 'mec-rsvp' ); ?></label>
									<div class="mec-col-9">
										<input type="number" id="mec_settings_rsvp_min_attendees" name="mec[settings][rsvp_min_attendees]" value="<?php echo( ( isset( $settings['rsvp_min_attendees'] ) and trim( $settings['rsvp_min_attendees'] ) != '' ) ? $settings['rsvp_min_attendees'] : '' ); ?>"/>
									</div>
								</div>
								<div class="mec-form-row">
									<div class="mec-col-12">
										<?php
										$checked = isset($settings['rsvp_display_conversation']) ? (bool)$settings['rsvp_display_conversation'] : false;
										?>
										<input type="hidden" name="mec[settings][rsvp_display_conversation]" value="0"/>
										<label><input type="checkbox" id="mec_settings_rsvp_display_conversation" name="mec[settings][rsvp_display_conversation]" value="1" <?php checked(true,$checked); ?>/><?php esc_html_e('Display RSVP conversation','mec-rsvp'); ?></label>
									</div>
                                </div>
								<div class="mec-form-row">
									<div class="mec-col-12">
										<?php
										$checked = isset($settings['rsvp_display_rsvp_modification']) ? (bool)$settings['rsvp_display_rsvp_modification'] : false;
										?>
										<input type="hidden" name="mec[settings][rsvp_display_rsvp_modification]" value="0"/>
										<label><input type="checkbox" id="mec_settings_rsvp_display_rsvp_modification" name="mec[settings][rsvp_display_rsvp_modification]" value="1" <?php checked(true,$checked); ?>/><?php esc_html_e('Enable RSVP modification in event page','mec-rsvp'); ?></label>
									</div>
                                </div>
								<div class="mec-form-row">
									<div class="mec-col-12">
										<?php
										$checked = isset($settings['rsvp_modification_without_email_verification']) ? (bool)$settings['rsvp_modification_without_email_verification'] : false;
										?>
										<input type="hidden" name="mec[settings][rsvp_modification_without_email_verification]" value="0"/>
										<label><input type="checkbox" id="mec_settings_rsvp_modification_without_email_verification" name="mec[settings][rsvp_modification_without_email_verification]" value="1" <?php checked(true,$checked); ?>/><?php esc_html_e('Enable RSVP modification without email verification','mec-rsvp'); ?></label>
									</div>
                                </div>
								<div class="mec-form-row">
									<label class="mec-col-3"><?php esc_html_e('RSVP modification location','mec-rsvp'); ?></label>
									<?php
									$modification_form_location = isset($settings['rsvp_display_rsvp_modification_location']) ? $settings['rsvp_display_rsvp_modification_location'] : 'top';
									?>
									<div class="mec-col-9">
										<select name="mec[settings][rsvp_display_rsvp_modification_location]">
											<option value="top" <?php selected( 'top', $modification_form_location ) ?>><?php esc_html_e( 'Top', 'mec-rsvp' ) ?></option>
											<option value="bottom" <?php selected( 'bottom', $modification_form_location ) ?>><?php esc_html_e( 'Bottom', 'mec-rsvp' ) ?></option>
										</select>
									</div>
                                </div>

								<h5 class="title"><?php _e( 'Date Options', 'mec-rsvp' ); ?></h5>
								<div class="mec-form-row">
									<label class="mec-col-3" for="mec_settings_rsvp_date_format1"><?php _e( 'Date Format', 'mec-rsvp' ); ?></label>
									<div class="mec-col-9">
										<input type="text" id="mec_settings_rsvp_date_format1" name="mec[settings][rsvp_date_format1]" value="<?php echo( ( isset( $settings['rsvp_date_format1'] ) and trim( $settings['rsvp_date_format1'] ) != '' ) ? $settings['rsvp_date_format1'] : 'Y-m-d' ); ?>"/>
										<span class="mec-tooltip">
                                            <div class="box left">
                                                <h5 class="title"><?php _e( 'Date Format', 'mec-rsvp' ); ?></h5>
                                                <div class="content"><p><?php esc_attr_e( "Default is Y-m-d", 'mec-rsvp' ); ?><a href="https://webnus.net/dox/modern-events-calendar/rsvp/" target="_blank"><?php _e( 'Read More', 'mec-rsvp' ); ?></a></p></div>
                                            </div>
                                            <i title="" class="dashicons-before dashicons-editor-help"></i>
                                        </span>
									</div>
								</div>
								<div class="mec-form-row">
									<label class="mec-col-3" for="mec_settings_rsvp_maximum_dates"><?php _e( 'Maximum Dates', 'mec-rsvp' ); ?></label>
									<div class="mec-col-9">
										<input type="number" id="mec_settings_rsvp_maximum_dates" name="mec[settings][rsvp_maximum_dates]" value="<?php echo( ( isset( $settings['rsvp_maximum_dates'] ) and trim( $settings['rsvp_maximum_dates'] ) != '' ) ? $settings['rsvp_maximum_dates'] : '6' ); ?>" placeholder="<?php esc_attr_e( 'Default is 6', 'mec-rsvp' ); ?>" min="1"/>
									</div>
								</div>
								<!--<div class="mec-form-row">
									<label class="mec-col-3" for="mec_settings_rsvp_date_selection"><?php _e( 'Date Selection', 'mec-rsvp' ); ?></label>
									<div class="mec-col-9">
										<select id="mec_settings_rsvp_date_selection" name="mec[settings][rsvp_date_selection]">
											<option value="dropdown" <?php echo( ( !isset( $settings['rsvp_date_selection'] ) or ( isset( $settings['rsvp_date_selection'] ) and $settings['rsvp_date_selection'] == 'dropdown' ) ) ? 'selected="selected"' : '' ); ?>><?php _e( 'Dropdown', 'mec-rsvp' ); ?></option>
											<option value="calendar" <?php echo( ( isset( $settings['rsvp_date_selection'] ) and $settings['rsvp_date_selection'] == 'calendar' ) ? 'selected="selected"' : '' ); ?>><?php _e( 'Calendar', 'mec-rsvp' ); ?></option>
										</select>
									</div>
								</div>-->
								<h5 class="title"><?php _e( 'Interval Options', 'mec-rsvp' ); ?></h5>
								<div class="mec-form-row">
									<label class="mec-col-3" for="mec_settings_show_rsvp_form_interval"><?php _e( 'Show RSVP Form Interval', 'mec-rsvp' ); ?></label>
									<div class="mec-col-9">
										<input type="number" id="mec_settings_show_rsvp_form_interval" name="mec[settings][show_rsvp_form_interval]" value="<?php echo( ( isset( $settings['show_rsvp_form_interval'] ) and trim( $settings['show_rsvp_form_interval'] ) != '0' ) ? $settings['show_rsvp_form_interval'] : '0' ); ?>" placeholder="<?php esc_attr_e( 'Minutes (e.g 5)', 'mec-rsvp' ); ?>"/>
										<span class="mec-tooltip">
                                            <div class="box left">
                                                <h5 class="title"><?php _e( 'Show RSVP Form Interval', 'mec-rsvp' ); ?></h5>
                                                <div class="content"><p><?php esc_attr_e( "You can show RSVP form only at certain times before event start. If you set this option to 30 then RSVP form will open only 30 minutes before starting the event! One day is 1440 minutes.", 'mec-rsvp' ); ?></p></div>
                                            </div>
                                            <i title="" class="dashicons-before dashicons-editor-help"></i>
                                        </span>
									</div>
								</div>
								<div class="mec-form-row">
									<label class="mec-col-3" for="mec_settings_rsvp_cancellation_period_from"><?php _e( 'Cancellation Period', 'mec-rsvp' ); ?></label>
									<div class="mec-col-9">
										<div class="cancellation-period-box">
											<input type="number" id="mec_settings_rsvp_cancellation_period_from" name="mec[settings][rsvp_cancellation_period_from]" value="<?php echo( ( isset( $settings['rsvp_cancellation_period_from'] ) and trim( $settings['rsvp_cancellation_period_from'] ) != '' ) ? $settings['rsvp_cancellation_period_from'] : '' ); ?>" placeholder="<?php esc_attr_e( 'From e.g 48', 'mec-rsvp' ); ?>"/>
											<input type="number" id="mec_settings_rsvp_cancellation_period_time" name="mec[settings][rsvp_cancellation_period_time]" value="<?php echo( ( isset( $settings['rsvp_cancellation_period_time'] ) and trim( $settings['rsvp_cancellation_period_time'] ) != '' ) ? $settings['rsvp_cancellation_period_time'] : '' ); ?>" placeholder="<?php esc_attr_e( 'To e.g 24', 'mec-rsvp' ); ?>"/>
										</div>
										<select name="mec[settings][rsvp_cancellation_period_p]" title="<?php esc_attr_e( 'Period', 'mec-rsvp' ); ?>">
											<option value="hour" <?php echo ( isset( $settings['rsvp_cancellation_period_p'] ) and $settings['rsvp_cancellation_period_p'] == 'hour' ) ? 'selected="selected"' : ''; ?>><?php esc_html_e( 'Hour(s)', 'mec-rsvp' ); ?></option>
											<option value="day" <?php echo ( isset( $settings['rsvp_cancellation_period_p'] ) and $settings['rsvp_cancellation_period_p'] == 'day' ) ? 'selected="selected"' : ''; ?>><?php esc_html_e( 'Day(s)', 'mec-rsvp' ); ?></option>
										</select>
										<select name="mec[settings][rsvp_cancellation_period_type]" title="<?php esc_attr_e( 'Type', 'mec-rsvp' ); ?>">
											<option value="before" <?php echo ( isset( $settings['rsvp_cancellation_period_type'] ) and $settings['rsvp_cancellation_period_type'] == 'before' ) ? 'selected="selected"' : ''; ?>><?php esc_html_e( 'Before', 'mec-rsvp' ); ?></option>
											<option value="after" <?php echo ( isset( $settings['rsvp_cancellation_period_type'] ) and $settings['rsvp_cancellation_period_type'] == 'after' ) ? 'selected="selected"' : ''; ?>><?php esc_html_e( 'After', 'mec-rsvp' ); ?></option>
										</select>
										<div>
											<?php esc_html_e( 'Event Start', 'mec-rsvp' ); ?>
											<span class="mec-tooltip">
                                                <div class="box left">
                                                    <h5 class="title"><?php _e( 'Cancellation Period', 'mec-rsvp' ); ?></h5>
                                                    <div class="content"><p><?php esc_attr_e( "You can restrict the ability to cancel RSVPs. Leave empty for cancellation at any time. For example if you insert 48 to 24 hours before event start then RSVPers are able to cancel their RSVPs between this time and before or after that they're not able to do that.", 'mec-rsvp' ); ?></p></div>
                                                </div>
                                                <i title="" class="dashicons-before dashicons-editor-help"></i>
                                            </span>
										</div>
									</div>
								</div>
								<h5 class="title"><?php _e( 'User Registration', 'mec-rsvp' ); ?></h5>
								<div class="mec-form-row">
									<label class="mec-col-3" for="mec_settings_rsvp_registration"><?php _e( 'Registration', 'mec-rsvp' ); ?></label>
									<div class="mec-col-9">
										<select id="mec_settings_rsvp_registration" name="mec[settings][rsvp_registration]" onchange="jQuery('#mec_settings_rsvp_registration_wrapper').toggleClass('w-hidden');">
											<option <?php echo( ( isset( $settings['rsvp_registration'] ) and $settings['rsvp_registration'] == '1' ) ? 'selected="selected"' : '' ); ?> value="1"><?php echo esc_html__( 'Enabled', 'mec-rsvp' ); ?></option>
											<option <?php echo( ( isset( $settings['rsvp_registration'] ) and $settings['rsvp_registration'] == '0' ) ? 'selected="selected"' : '' ); ?> value="0"><?php echo esc_html__( 'Disabled', 'mec-rsvp' ); ?></option>
										</select>
										<span class="mec-tooltip">
                                            <div class="box left">
                                                <h5 class="title"><?php _e( 'Registration', 'mec-rsvp' ); ?></h5>
                                                <div class="content"><p><?php esc_attr_e( "If enabled MEC would create a WordPress User for main attendees. It's recommended to keep it enabled.", 'mec-rsvp' ); ?></p></div>
                                            </div>
                                            <i title="" class="dashicons-before dashicons-editor-help"></i>
                                        </span>
									</div>
								</div>
								<div id="mec_settings_rsvp_registration_wrapper" class="<?php echo ( !isset( $settings['rsvp_registration'] ) or ( isset( $settings['rsvp_registration'] ) and $settings['rsvp_registration'] ) ) ? "" : "w-hidden"; ?>">
									<div class="mec-form-row">
										<label class="mec-col-3" for="mec_settings_rsvp_user_role"><?php _e( 'User Role', 'mec-rsvp' ); ?></label>
										<div class="mec-col-9">
											<select id="mec_settings_rsvp_user_role" name="mec[settings][rsvp_user_role]">
												<option value="">----</option>
												<?php foreach ( $roles as $role => $r ): ?>
													<option <?php echo( ( isset( $settings['rsvp_user_role'] ) and $settings['rsvp_user_role'] == $role ) ? 'selected="selected"' : '' ); ?> value="<?php echo $role; ?>"><?php echo $r['name']; ?></option>
												<?php endforeach; ?>
											</select>
											<span class="mec-tooltip">
                                            <div class="box left">
                                                <h5 class="title"><?php _e( 'User Role', 'mec-rsvp' ); ?></h5>
                                                <div class="content"><p><?php esc_attr_e( "MEC creates a user for the main attendee after each RSVP. Default role of the user is subscriber but you can change it if needed.", 'mec-rsvp' ); ?><a href="https://webnus.net/dox/modern-events-calendar/rsvp/" target="_blank"><?php _e( 'Read More', 'mec-rsvp' ); ?></a></p></div>
                                            </div>
                                            <i title="" class="dashicons-before dashicons-editor-help"></i>
                                        </span>
										</div>
									</div>
									<div class="mec-form-row">
										<label class="mec-col-3" for="mec_settings_rsvp_userpass"><?php _e( 'Username & Password', 'mec-rsvp' ); ?></label>
										<div class="mec-col-9">
											<select id="mec_settings_rsvp_userpass" name="mec[settings][rsvp_userpass]">
												<option value="auto" <?php echo( ( isset( $settings['rsvp_userpass'] ) and trim( $settings['rsvp_userpass'] ) == 'auto' ) ? 'selected="selected"' : '' ); ?>><?php echo esc_html__( 'Auto', 'mec-rsvp' ); ?></option>
												<option value="manual" <?php echo( ( isset( $settings['rsvp_userpass'] ) and trim( $settings['rsvp_userpass'] ) == 'manual' ) ? 'selected="selected"' : '' ); ?>><?php echo esc_html__( 'Manual', 'mec-rsvp' ); ?></option>
											</select>
											<span class="mec-tooltip">
                                            <div class="box left">
                                                <h5 class="title"><?php _e( 'Username & Password', 'mec-rsvp' ); ?></h5>
                                                <div class="content"><p><?php esc_attr_e( "If you set it to manual option then users can insert a username and password during the RSVP for registration otherwise MEC use their email and an auto generated password.", 'mec-rsvp' ); ?></p></div>
                                            </div>
                                            <i title="" class="dashicons-before dashicons-editor-help"></i>
                                        </span>
										</div>
									</div>
								</div>

								<h5 class="mec-form-subtitle"><?php _e( 'Limitation', 'mec-rsvp' ); ?></h5>

								<div class="mec-form-row">
									<label class="mec-col-3" for="mec_settings_rsvp_total_attendees_in_each_rsvp_limit"><?php _e( 'Total attendees in each RSVP limit', 'mec-rsvp' ); ?></label>
									<div class="mec-col-9">
										<input type="number" id="mec_settings_rsvp_total_attendees_in_each_rsvp_limit" name="mec[settings][rsvp_total_attendees_in_each_rsvp_limit]" value="<?php echo( ( isset( $settings['rsvp_total_attendees_in_each_rsvp_limit'] ) and trim( $settings['rsvp_total_attendees_in_each_rsvp_limit'] ) != '' ) ? $settings['rsvp_total_attendees_in_each_rsvp_limit'] : '' ); ?>" placeholder="<?php esc_attr_e( 'Default is empty', 'mec-rsvp' ); ?>"/>
										<span class="mec-tooltip">
                                            <div class="box left">
                                                <h5 class="title"><?php _e( 'Total attendees in each RSVP limit', 'mec-rsvp' ); ?></h5>
                                                <div class="content"><p><?php esc_html_e( 'If you want to set a limit on total attendees in each RSVP, put a limitation number.', 'mec-rsvp' ); ?></p></div>
                                            </div>
                                            <i title="" class="dashicons-before dashicons-editor-help"></i>
                                        </span>
									</div>
								</div>

								<div class="mec-form-row">
									<label class="mec-col-3" for="mec_settings_rsvp_limit_by_email"><?php _e( 'Limit By Email', 'mec-rsvp' ); ?></label>
									<div class="mec-col-9">
										<input type="number" id="mec_settings_rsvp_limit_by_email" name="mec[settings][rsvp_limit_by_email]" value="<?php echo( ( isset( $settings['rsvp_limit_by_email'] ) and trim( $settings['rsvp_limit_by_email'] ) != '' ) ? $settings['rsvp_limit_by_email'] : '' ); ?>" placeholder="<?php esc_attr_e( 'Default is empty', 'mec-rsvp' ); ?>"/>
										<span class="mec-tooltip">
                                            <div class="box left">
                                                <h5 class="title"><?php _e( 'RSVP Limit By Email', 'mec-rsvp' ); ?></h5>
                                                <div class="content"><p><?php esc_html_e( "Total number of RSVP recorded with one email per event.", 'mec-rsvp' ); ?></p></div>
                                            </div>
                                            <i title="" class="dashicons-before dashicons-editor-help"></i>
                                        </span>
									</div>
								</div>
								<div class="mec-form-row">
									<label class="mec-col-3" for="mec_settings_rsvp_limit"><?php _e( 'Limit By IP', 'mec-rsvp' ); ?></label>
									<div class="mec-col-9">
										<input type="number" id="mec_settings_rsvp_limit" name="mec[settings][rsvp_limit]" value="<?php echo( ( isset( $settings['rsvp_limit'] ) and trim( $settings['rsvp_limit'] ) != '' ) ? $settings['rsvp_limit'] : '' ); ?>" placeholder="<?php esc_attr_e( 'Default is empty', 'mec-rsvp' ); ?>"/>
										<span class="mec-tooltip">
                                            <div class="box left">
                                                <h5 class="title"><?php _e( 'RSVP Attendees Limit By IP', 'mec-rsvp' ); ?></h5>
                                                <div class="content"><p><?php esc_attr_e( "Total Attendees that a user can RSVP. Leave it empty for unlimited RSVPs.", 'mec-rsvp' ); ?></p></div>
                                            </div>
                                            <i title="" class="dashicons-before dashicons-editor-help"></i>
                                        </span>
									</div>
								</div>
								<div class="mec-form-row">
									<label class="mec-col-3" for="mec_settings_rsvp_ip_restriction"><?php _e( 'IP restriction', 'mec-rsvp' ); ?></label>
									<div class="mec-col-9">
										<select id="mec_settings_rsvp_ip_restriction" name="mec[settings][rsvp_ip_restriction]">
											<option value="1" <?php echo( ( isset( $settings['rsvp_ip_restriction'] ) and trim( $settings['rsvp_ip_restriction'] ) == 1 ) ? 'selected="selected"' : '' ); ?>><?php echo esc_html__( 'Enabled', 'mec-rsvp' ); ?></option>
											<option value="0" <?php echo( ( isset( $settings['rsvp_ip_restriction'] ) and trim( $settings['rsvp_ip_restriction'] ) == 0 ) ? 'selected="selected"' : '' ); ?>><?php echo esc_html__( 'Disabled', 'mec-rsvp' ); ?></option>
										</select>
										<span class="mec-tooltip">
                                            <div class="box left">
                                                <h5 class="title"><?php _e( 'IP restriction', 'mec-rsvp' ); ?></h5>
                                                <div class="content"><p><?php esc_attr_e( "If you set a limit for total tickets that users can RSVP, MEC will use IP and email to prevent users to RSVP many tickets. You can disable the IP restriction if you don't need it.", 'mec-rsvp' ); ?></p></div>
                                            </div>
                                            <i title="" class="dashicons-before dashicons-editor-help"></i>
                                        </span>
									</div>
								</div>
								<div class="mec-form-row">
									<label class="mec-col-3" for="mec_settings_rsvp_lock_prefilled"><?php _e( 'Lock Pre-filled Fields', 'mec-rsvp' ); ?></label>
									<div class="mec-col-9">
										<select id="mec_settings_rsvp_lock_prefilled" name="mec[settings][rsvp_lock_prefilled]">
											<option value="0" <?php echo ( isset( $settings['rsvp_lock_prefilled'] ) and $settings['rsvp_lock_prefilled'] == '0' ) ? 'selected="selected"' : ''; ?>><?php esc_html_e( 'Disabled', 'mec-rsvp' ); ?></option>
											<option value="1" <?php echo ( isset( $settings['rsvp_lock_prefilled'] ) and $settings['rsvp_lock_prefilled'] == '1' ) ? 'selected="selected"' : ''; ?>><?php esc_html_e( 'Enabled', 'mec-rsvp' ); ?></option>
											<option value="2" <?php echo ( isset( $settings['rsvp_lock_prefilled'] ) and $settings['rsvp_lock_prefilled'] == '2' ) ? 'selected="selected"' : ''; ?>><?php esc_html_e( 'Enabled Only for Main Attendee', 'mec-rsvp' ); ?></option>
										</select>
										<span class="mec-tooltip">
                                            <div class="box left">
                                                <h5 class="title"><?php _e( 'Lock Pre-filled Fields', 'mec-rsvp' ); ?></h5>
                                                <div class="content"><p><?php esc_attr_e( "When users are logged in, name and email fields will be pre-filled but users can change them. If you enable the lock, then logged in users cannot change the pre-filled fields.", 'mec-rsvp' ); ?><a href="https://webnus.net/dox/modern-events-calendar/rsvp/" target="_blank"><?php _e( 'Read More', 'mec-rsvp' ); ?></a></p></div>
                                            </div>
                                            <i title="" class="dashicons-before dashicons-editor-help"></i>
                                        </span>
									</div>
								</div>
								<h5 class="mec-form-subtitle"><?php _e( 'Thank You Page', 'mec-rsvp' ); ?></h5>
								<div class="mec-form-row">
									<label class="mec-col-3" for="mec_settings_rsvp_thankyou_page"><?php _e( 'Thank You Page', 'mec-rsvp' ); ?></label>
									<div class="mec-col-9">
										<select id="mec_settings_rsvp_thankyou_page" name="mec[settings][rsvp_thankyou_page]">
											<option value="">----</option>
											<?php foreach ( $pages as $page ): ?>
												<option <?php echo( ( isset( $settings['rsvp_thankyou_page'] ) and $settings['rsvp_thankyou_page'] == $page->ID ) ? 'selected="selected"' : '' ); ?> value="<?php echo $page->ID; ?>"><?php echo $page->post_title; ?></option>
											<?php endforeach; ?>
										</select>
										<span class="mec-tooltip">
                                            <div class="box left">
                                                <h5 class="title"><?php _e( 'Thank You Page', 'mec-rsvp' ); ?></h5>
                                                <div class="content"><p><?php esc_attr_e( "User redirects to this page after rsvp. Leave it empty if you want to disable it.", 'mec-rsvp' ); ?><a href="https://webnus.net/dox/modern-events-calendar/rsvp/" target="_blank"><?php _e( 'Read More', 'mec-rsvp' ); ?></a></p></div>
                                            </div>
                                            <i title="" class="dashicons-before dashicons-editor-help"></i>
                                        </span>
									</div>
								</div>
								<div class="mec-form-row">
									<label class="mec-col-3" for="mec_settings_rsvp_thankyou_page_time"><?php _e( 'Thank You Page Time Interval', 'mec-rsvp' ); ?></label>
									<div class="mec-col-9">
										<input type="number" id="mec_settings_rsvp_thankyou_page_time" name="mec[settings][rsvp_thankyou_page_time]" value="<?php echo( ( isset( $settings['rsvp_thankyou_page_time'] ) and trim( $settings['rsvp_thankyou_page_time'] ) != '0' ) ? $settings['rsvp_thankyou_page_time'] : '2000' ); ?>" placeholder="<?php esc_attr_e( '2000 means 2 seconds', 'mec-rsvp' ); ?>"/>
										<span class="mec-tooltip">
                                            <div class="box left">
                                                <h5 class="title"><?php _e( 'Thank You Page Time Interval', 'mec-rsvp' ); ?></h5>
                                                <div class="content"><p><?php esc_attr_e( "Waiting time before redirecting to thank you page. It's in miliseconds so 2000 means 2 seconds.", 'mec-rsvp' ); ?><a href="https://webnus.net/dox/modern-events-calendar/rsvp/" target="_blank"><?php _e( 'Read More', 'mec-rsvp' ); ?></a></p></div>
                                            </div>
                                            <i title="" class="dashicons-before dashicons-editor-help"></i>
                                        </span>
									</div>
								</div>
								<h5 class="mec-form-subtitle"><?php _e( 'RSVP Elements', 'mec-rsvp' ); ?></h5>
								<div class="mec-form-row">
									<div class="mec-col-12">
										<label for="mec_settings_rsvp_first_for_all">
											<input type="hidden" name="mec[settings][rsvp_first_for_all]" value="0"/>
											<input type="checkbox" name="mec[settings][rsvp_first_for_all]" id="mec_settings_rsvp_first_for_all" <?php echo( ( !isset( $settings['rsvp_first_for_all'] ) or ( isset( $settings['rsvp_first_for_all'] ) and $settings['rsvp_first_for_all'] == '1' ) ) ? 'checked="checked"' : '' ); ?> value="1"/>
											<?php _e( 'Enable Express Attendees Form', 'mec-rsvp' ); ?>
										</label>
										<span class="mec-tooltip">
                                            <div class="box">
                                                <h5 class="title"><?php _e( 'Attendees Form', 'mec-rsvp' ); ?></h5>
                                                <div class="content"><p><?php esc_attr_e( "Apply the info from the first attendee to all purchased ticket by that user. Uncheck if you want every ticket to have its own attendee’s info.", 'mec-rsvp' ); ?><a href="https://webnus.net/dox/modern-events-calendar/rsvp/" target="_blank"><?php _e( 'Read More', 'mec-rsvp' ); ?></a></p></div>
                                            </div>
                                            <i title="" class="dashicons-before dashicons-editor-help"></i>
                                        </span>
									</div>
								</div>
								<?php do_action( 'add_rsvp_variables', $settings ); ?>
								<h5 class="mec-form-subtitle"><?php _e( 'Email verification', 'mec-rsvp' ); ?></h5>
								<div class="mec-form-row">
									<div class="mec-col-12">
										<label for="mec_settings_rsvp_auto_verify">
											<input type="hidden" name="mec[settings][rsvp_auto_verify]" value="0"/>
											<input type="checkbox" name="mec[settings][rsvp_auto_verify]" id="mec_settings_rsvp_auto_verify" <?php echo( ( isset( $settings['rsvp_auto_verify'] ) and $settings['rsvp_auto_verify'] == '1' ) ? 'checked="checked"' : '' ); ?> value="1"/>
											<?php _e( 'Auto verification for RSVPs', 'mec-rsvp' ); ?>
										</label>
									</div>
								</div>
								<div class="mec-form-row">
									<div class="mec-col-12">
										<label for="mec_settings_rsvp_auto_verify_send_email">
											<input type="hidden" name="mec[settings][rsvp_auto_verify_send_email]" value="0"/>
											<input type="checkbox" name="mec[settings][rsvp_auto_verify_send_email]" id="mec_settings_rsvp_auto_verify_send_email" <?php echo( ( isset( $settings['rsvp_auto_verify_send_email'] ) and $settings['rsvp_auto_verify_send_email'] == '1' ) ? 'checked="checked"' : '' ); ?> value="1"/>
											<?php _e( 'Send verification email in auto verification mode', 'mec-rsvp' ); ?>
										</label>
									</div>
								</div>

								<h5 class="mec-form-subtitle"><?php _e( 'RSVP Confirmation', 'mec-rsvp' ); ?></h5>
								<div class="mec-form-row">
									<div class="mec-col-12">
										<label for="mec_settings_rsvp_auto_confirm">
											<input type="hidden" name="mec[settings][rsvp_auto_confirm]" value="0"/>
											<input type="checkbox" name="mec[settings][rsvp_auto_confirm]" id="mec_settings_rsvp_auto_confirm" <?php echo( ( isset( $settings['rsvp_auto_confirm'] ) and $settings['rsvp_auto_confirm'] == '1' ) ? 'checked="checked"' : '' ); ?> value="1"/>
											<?php _e( 'Auto confirmation for RSVPs', 'mec-rsvp' ); ?>
										</label>
									</div>
								</div>
								<div class="mec-form-row">
									<div class="mec-col-12">
										<label for="mec_settings_rsvp_auto_confirm_send_email">
											<input type="hidden" name="mec[settings][rsvp_auto_confirm_send_email]" value="0"/>
											<input type="checkbox" name="mec[settings][rsvp_auto_confirm_send_email]" id="mec_settings_rsvp_auto_confirm_send_email" <?php echo( ( isset( $settings['rsvp_auto_confirm_send_email'] ) and $settings['rsvp_auto_confirm_send_email'] == '1' ) ? 'checked="checked"' : '' ); ?> value="1"/>
											<?php _e( 'Send confirmation email in auto confirmation mode', 'mec-rsvp' ); ?>
										</label>
									</div>
								</div>
							</div>
						</div>

						<?php if ( isset( $settings['rsvp_status'] ) && $settings['rsvp_status'] ): ?>

							<?php do_action( 'mec_reg_menu_start', $this->main, $settings ); ?>

							<div id="rsvp_shortcode" class="mec-options-fields">
								<h4 class="mec-form-subtitle"><?php _e( 'RSVP Shortcode', 'mec-rsvp' ); ?></h4>

								<div class="mec-form-row">
									<div class="mec-col-12">
										<p><?php echo sprintf( __( "RSVP module is available in the event details page but if you like to embed rsvp module of certain event into a custom WP page or post or any shortcode compatible widgets, all you need to do is to insert %s shortcode into the page content and place the event id instead of 1.", 'mec-rsvp' ), '<strong>[mec-rsvp event-id="1"]</strong>' ); ?></p>
										<p><?php echo sprintf(__('Put %s shortcode into your desired page. Then users are able to see the history of their RSVPs.', 'mec'), '<code>[mec-my-rsvps]</code>'); ?></p>
									</div>
								</div>

							</div>


							<!-- rsvp_form_option-$group_id begin -->
							<script>
								jQuery(document).ready(function ($) {
									function mec_custom_form_status(status_element) {
										var status = $(status_element).val();
										var form = $(status_element).parents('.mec-options-fields');
										switch (status) {
											case 'enable':
												$(form).find('.mec-rsvp-fields').css('display','block');
												break;
											case 'default':
											default:
												$(form).find('.mec-rsvp-fields').css('display','none');
												break;
										}
									}



									$('.mec-form-status').on('change',function (e) {
										mec_custom_form_status(e.currentTarget);
									});

									$.each($('.mec-form-status:checked'),function(i,v){
										mec_custom_form_status($(v));
									});

								});
							</script>
							<?php
							$form_types = $this->get_form_types();
							foreach ( $form_types as $group_id => $title ):
								$group_id = 'rsvp_'.$group_id;
								?>
								<div id="rsvp_form_option-<?php echo $group_id ?>" class="mec-options-fields">

									<h4 class="mec-form-subtitle"><?php echo esc_html( $title ); ?></h4>

									<?php
									if ( 'rsvp_general' !== $group_id ):
										$status_key = 'form_'.$group_id.'_status';
										$status = Settings::getInstance()->get_settings($status_key);
										$status = !empty($status) ? $status : 'default';
										?>
										<div class="mec-form-status-box mec-form-row" style="margin: 10px 0;">
											<label style="margin-right:17px;">
												<input style="margin-right:1px;" class="mec-form-status" type="radio" name="mec[settings][<?php echo $status_key ?>]" <?php checked($status,'default') ?> value="default" />
												<?php esc_html_e( 'Inherit from Main RSVP Form', 'mec-rsvp' ) ?>
											</label>
											<label style="margin-right:17px;">
												<input style="margin-right:1px;" class="mec-form-status" type="radio" name="mec[settings][<?php echo $status_key ?>]" <?php checked($status,'enable') ?> value="enable" />
												<?php esc_html_e( 'Enable Custom Form', 'mec-rsvp' ) ?>
											</label>
										</div>
										<?php endif; ?>

										<div class="mec-rsvp-fields">
											<div class="mec-rsvp-per-attendee-fields">
												<h5 class="mec-form-subtitle"><?php _e( 'Per Attendee Fields', 'mec-rsvp' ); ?></h5>
												<?php
												\MEC\Forms\SettingsForm::getInstance()->display_settings_form_fields( $group_id )
												?>
											</div>
											<div class="mec-rsvp-fixed-fields">
												<h5 class="mec-form-subtitle"><?php _e( 'Fixed Fields', 'mec-rsvp' ); ?></h5>
												<?php
												\MEC\Forms\SettingsForm::getInstance()->display_settings_form_fixed_fields( $group_id );
												?>
											</div>
										</div>
									</div>
								<?php endforeach; ?>
							<!-- rsvp_form_option-$group_id end -->

							<div id="uploadfield_option" class="mec-options-fields">
								<h4 class="mec-form-subtitle"><?php _e( 'Upload Field Options', 'mec-rsvp' ); ?></h4>
								<div class="mec-form-row">
									<label class="mec-col-3" for="mec_rsvp_form_upload_field_mime_types"><?php _e( 'Mime types', 'mec-rsvp' ); ?></label>
									<div class="mec-col-9">
										<input type="text" id="mec_rsvp_form_upload_field_mime_types" name="mec[settings][upload_field_mime_types]" placeholder="jpeg,jpg,png,pdf" value="<?php echo( ( isset( $settings['upload_field_mime_types'] ) and trim( $settings['upload_field_mime_types'] ) != '' ) ? $settings['upload_field_mime_types'] : '' ); ?>"/>
									</div>
									<p class="description"><?php echo __( 'Split mime types with ",".', 'mec-rsvp' ); ?>
										<br/> <?php esc_attr_e( "Default: jpeg,jpg,png,pdf", 'mec-rsvp' ); ?></p>
								</div>
								<div class="mec-form-row">
									<label class="mec-col-3" for="mec_rsvp_form_upload_field_max_upload_size"><?php _e( 'Maximum file size', 'mec-rsvp' ); ?></label>
									<div class="mec-col-9">
										<input type="number" id="mec_rsvp_form_upload_field_max_upload_size" name="mec[settings][upload_field_max_upload_size]" value="<?php echo( ( isset( $settings['upload_field_max_upload_size'] ) and trim( $settings['upload_field_max_upload_size'] ) != '' ) ? $settings['upload_field_max_upload_size'] : '' ); ?>"/>
									</div>
									<p class="description"><?php echo __( 'The unit is Megabyte "MB"', 'mec-rsvp' ); ?></p>
								</div>
							</div>

						<?php endif; ?>

						<div class="mec-options-fields">
							<?php wp_nonce_field( 'mec_options_form' ); ?>
							<button style="display: none;" id="mec_rsvp_form_button" class="button button-primary mec-button-primary" type="submit"><?php _e( 'Save Changes', 'mec-rsvp' ); ?></button>
						</div>
					</form>

				</div>
			</div>
		</div>
	</div>

	<div id="wns-be-footer">
		<a id="" class="dpr-btn dpr-save-btn"><?php _e( 'Save Changes', 'mec-rsvp' ); ?></a>
	</div>

</div>

<script type="text/javascript">
	jQuery(document).ready(function () {
		jQuery(".dpr-save-btn").on('click', function (event) {
			event.preventDefault();
			jQuery("#mec_rsvp_form_button").trigger('click');
		});
	});

	jQuery('#mec_gateways_form_container .mec-required').on('change', function () {
		var val = jQuery(this).val();
		if (val) {
			// Remove Focus Style
			jQuery(this).removeClass('mec-mandatory');
		}
	});

	jQuery("#mec_rsvp_form").on('submit', function (event) {
		event.preventDefault();

		var validated = true;
		var first_field;

		jQuery('#mec_gateways_form_container').find('.mec-required').each(function () {
			// Remove Focus Style
			jQuery(this).removeClass('mec-mandatory');

			var val = jQuery(this).val();
			if (jQuery(this).is(':visible') && !val) {
				// Add Focus Style
				jQuery(this).addClass('mec-mandatory');

				validated = false;
				if (!first_field) first_field = this;
			}
		});

		if (!validated && first_field) {
			jQuery(first_field).focus();
			jQuery('html, body').animate(
					{
						scrollTop: (jQuery(first_field).offset().top - 200)
					}, 500);

			return false;
		}

		// Add loading Class to the button
		jQuery(".dpr-save-btn").addClass('loading').text("<?php echo esc_js( esc_attr__( 'Saved', 'mec-rsvp' ) ); ?>");
		jQuery('<div class="wns-saved-settings"><?php echo esc_js( esc_attr__( 'Settings Saved!', 'mec-rsvp' ) ); ?></div>').insertBefore('#wns-be-content');

		if (jQuery(".mec-purchase-verify").text() != '<?php echo esc_js( esc_attr__( 'Verified', 'mec-rsvp' ) ); ?>') {
			jQuery(".mec-purchase-verify").text("<?php echo esc_js( esc_attr__( 'Checking ...', 'mec-rsvp' ) ); ?>");
		}

		var settings = jQuery("#mec_rsvp_form").serialize();
		jQuery.ajax(
				{
					type: "POST",
					url: ajaxurl,
					data: "action=mec_save_settings&" + settings,
					beforeSend: function () {
						jQuery('.wns-be-main').append('<div class="mec-loarder-wrap mec-settings-loader"><div class="mec-loarder"><div></div><div></div><div></div></div></div>');
					},
					success: function (data) {
						// Remove the loading Class to the button
						setTimeout(function () {
							jQuery(".dpr-save-btn").removeClass('loading').text("<?php echo esc_js( esc_attr__( 'Save Changes', 'mec-rsvp' ) ); ?>");
							jQuery('.wns-saved-settings').remove();
							jQuery('.mec-loarder-wrap').remove();
							if (jQuery(".mec-purchase-verify").text() != '<?php echo esc_js( esc_attr__( 'Verified', 'mec-rsvp' ) ); ?>') {
								jQuery(".mec-purchase-verify").text("<?php echo esc_js( esc_attr__( 'Please Refresh Page', 'mec-rsvp' ) ); ?>");
							}
						}, 1000);
					},
					error: function (jqXHR, textStatus, errorThrown) {
						// Remove the loading Class to the button
						setTimeout(function () {
							jQuery(".dpr-save-btn").removeClass('loading').text("<?php echo esc_js( esc_attr__( 'Save Changes', 'mec-rsvp' ) ); ?>");
							jQuery('.wns-saved-settings').remove();
							jQuery('.mec-loarder-wrap').remove();
						}, 1000);
					}
				});
	});

	jQuery(document).ready(function($){

		if($('li.active .subsection li.active').length == 0 ){

			$('li.active .subsection li:first-child a').trigger('click');
		}else{

			$('li.active .subsection li.active a').trigger('click');
		}
	});
</script>