<?php

namespace MEC_RSVP\StatusProvider;

use MEC_RSVP\RSVP\RSVP;

class Display {

	public static function enqueue() {

		?>
		<style>
			.mec-status-form select {
				display: block;
				width: 99%;
				margin-top: 10px;
				margin-bottom: 10px;
			}
		</style>
		<?php
	}

	/**
	 * Display Metabox Confirmation and Verification
	 *
	 * @param \WP_Post $post
	 *
	 * @return void
	 */
	public static function output( $post ) {

		$rsvp      = new RSVP( $post );
		$confirmed = $rsvp->get_confirm_status();
		$verified  = $rsvp->get_verification_status();
		$event_id  = $rsvp->get_event_id();

		self::enqueue();
		?>
		<div class="mec-status-form">
			<?php wp_nonce_field( 'mec_status_nf_' . date( 'd' ), 'mec_status_nonce' ) ?>
			<div class="mec-row">
				<label for="mec_confirmation"><?php _e( 'Confirmation', 'mec-rsvp' ); ?></label>
				<select id="mec_confirmation" name="mec_confirmation">
					<option value="0" <?php echo $confirmed == '0' ? 'selected="selected"' : ''; ?>><?php _e( 'Pending', 'mec-rsvp' ); ?></option>
					<option value="1" <?php echo $confirmed == '1' ? 'selected="selected"' : ''; ?>><?php _e( 'Confirmed', 'mec-rsvp' ); ?></option>
					<option value="-1" <?php echo $confirmed == '-1' ? 'selected="selected"' : ''; ?>><?php _e( 'Rejected', 'mec-rsvp' ); ?></option>
				</select>
			</div>
			<div class="mec-row">
				<label for="mec_verification"><?php _e( 'Verification', 'mec-rsvp' ); ?></label>
				<select id="mec_verification" name="mec_verification">
					<option value="0" <?php echo $verified == '0' ? 'selected="selected"' : ''; ?>><?php _e( 'Waiting', 'mec-rsvp' ); ?></option>
					<option value="1" <?php echo $verified == '1'  ? 'selected="selected"' : ''; ?>><?php _e( 'Verified', 'mec-rsvp' ); ?></option>
					<option value="-1" <?php echo $verified == '-1' ? 'selected="selected"' : ''; ?>><?php _e( 'Canceled', 'mec-rsvp' ); ?></option>
				</select>
			</div>

			<?php if ( $confirmed == 1 or $verified == 0 ) : ?>
				<div class="mec-row" style="margin: 20px 0;">
					<?php if ( $confirmed == 1 ) : ?>
						<div class="mec-row">
							<label><input type="checkbox" name="resend_confirmation_email" value="1"><?php esc_html_e( 'Resend Confirmation Email', 'mec-rsvp' ); ?>
							</label>
						</div>
					<?php endif; ?>

					<?php if ( $verified == 0 ) : ?>
						<div class="mec-row">
							<label><input type="checkbox" name="resend_verification_email" value="1"><?php esc_html_e( 'Resend Verification Email', 'mec-rsvp' ); ?>
							</label>
						</div>
					<?php endif; ?>
				</div>
			<?php endif; ?>
		</div>
		<?php
	}

}
