<?php

namespace MEC_RSVP;

use MEC\Settings\Settings;
use MEC\Attendees\Attendees;
use MEC_RSVP\RSVP\RSVPsQuery;

class User extends \MEC_user{

    private static $instance;

	public static function instance() {

		if ( is_null( self::$instance ) ) {

			self::$instance = new self();
		}

		return self::$instance;
	}

    public function rsvp($id){

        $mec_user_id = get_post_meta($id, 'mec_user_id', true);
        if(trim($mec_user_id) and is_numeric($mec_user_id)) {
            return $this->mec($mec_user_id);
        }

        return $this->wp(get_post($id)->post_author);
    }

    public function assign($rsvp_id, $user_id){
        // Registration is disabled
        $registration = (bool)Settings::getInstance()->get_settings('rsvp_registration');
        $user = get_user_by('ID', $user_id);
        if(!$registration && !$user) {

            update_post_meta($rsvp_id, 'mec_user_id', $user_id);
        } else {

            update_post_meta($rsvp_id, 'mec_user_id', 'wp');
        }
    }

    public function has_rsvp($user_email,$event_id){

        $conditions = [
            'event_id' => $event_id,
            'email' => $user_email,
            'confirmation' => 1,
            'verification' => 1,
        ];

        $rsvp_ids = array_column(
            Attendees::getInstance()->_get_attendees($conditions),
            'post_id'
        );

        if ( empty( $rsvp_ids ) ) {
            return false;
        }

        $query = array(
            'post__in' => $rsvp_ids,
        );

        $rsvps = RSVPsQuery::getInstance()->get_rsvps($query);

        return count($rsvps) > 0 ? true : false;
    }

    public function register($attendee, $args)
    {

        $registration = (bool)Settings::getInstance()->get_settings('rsvp_registration');
        $role = Settings::getInstance()->get_settings('rsvp_user_role');
        $role = $role ? $role : 'subscriber';

        $name = isset($attendee['name']) ? $attendee['name'] : '';
        $raw = (isset($attendee['reg']) and is_array($attendee['reg'])) ? $attendee['reg'] : array();

        $email = isset($attendee['email']) ? $attendee['email'] : '';
        if(!filter_var($email, FILTER_VALIDATE_EMAIL)) return false;

        $reg = array();
        foreach($raw as $k => $v) $reg[$k] = (is_array($v) ? $v : stripslashes($v));

        $existed_user_id = $this->main->email_exists($email);

        // User already exist
        if($existed_user_id !== false) return $existed_user_id;

        // Update WordPress user first name and last name
        if(strpos($name, ',') !== false)
        {
            $ex = explode(',', $name);
            $first_name = isset($ex[0]) ? $ex[0] : '';
            $last_name = '';
        }
        else
        {
            $ex = explode(' ', $name);
            $first_name = isset($ex[0]) ? $ex[0] : '';
            $last_name = '';
        }

        if(isset($ex[1]))
        {
            unset($ex[0]);
            $last_name = implode(' ', $ex);
        }

        // Registration is disabled
        if( !$registration ) {

            $existed_user_id = $this->db->select("SELECT `id` FROM `#__mec_users` WHERE `email`='".$this->db->escape($email)."'", 'loadResult');

            // User already exist
            if($existed_user_id) return $existed_user_id;

            $now = date('Y-m-d H:i:s');
            $user_id = (int) $this->db->q("INSERT INTO `#__mec_users` (`first_name`,`last_name`,`email`,`reg`,`created_at`,`updated_at`) VALUES ('".$this->db->escape($first_name)."','".$this->db->escape($last_name)."','".$this->db->escape($email)."','".$this->db->escape(json_encode($reg))."','".$now."','".$now."')", "INSERT");

            // Make sure we won't create MEC users with id lower than 1 million
            // To avoid conflicts with wp users of course
            if($user_id < 1000000)
            {
                $new_id = $user_id + 1000000;
                $this->db->q("UPDATE `#__mec_users` SET `id`='".esc_sql($new_id)."' WHERE `id`='".esc_sql($user_id)."'");

                $user_id = $new_id;
            }
        } else {
            $username = $email;
            $password = wp_generate_password(12, true, true);

            if(isset($args['username']) and trim($args['username'])) $username = $args['username'];
            if(isset($args['password']) and trim($args['password'])) $password = $args['password'];

            $user_id = $this->main->register_user($username, $email, $password);

            $user = new \stdClass();
            $user->ID = $user_id;
            $user->first_name = $first_name;
            $user->last_name = $last_name;

            wp_update_user($user);
            update_user_meta($user_id, 'mec_name', $name);
            update_user_meta($user_id, 'mec_reg', $reg);
            update_user_meta($user_id, 'nickname', $name);

            // Map Data
            $event_id = (isset($args['event_id']) ? $args['event_id'] : 0);
            if($event_id)
            {
                $reg_fields = $this->main->get_reg_fields($event_id);

                foreach($reg as $reg_id => $reg_value)
                {
                    $reg_field = (isset($reg_fields[$reg_id]) ? $reg_fields[$reg_id] : array());
                    if(isset($reg_field['mapping']) and trim($reg_field['mapping']))
                    {
                        $reg_value = maybe_unserialize($reg_value);
                        $meta_value = is_array($reg_value) ? implode(',', $reg_value) : $reg_value;

                        update_user_meta($user_id, $reg_field['mapping'], $meta_value);
                    }
                }
            }

            $wpuser = new \WP_User($user_id);
            $wpuser->set_role($role);
        }

        return $user_id;
    }
}