<?php

namespace MEC_RSVP\Tests\RSVP;

use MEC_RSVP\RSVP\RSVP;

class RSVPTest extends \WP_UnitTestCase {

	public static $instance;

	public static $data;

	public static function setUpBeforeClass() {

		parent::setUpBeforeClass();
		$attendees = array(
			array(
				'name' => 'user 1',
			),
			array(
				'name' => 'user 2',
			),
			array(
				'name' => 'user 3',
			),
			array(
				'name' => 'user 4',
			),
		);

		$location_id = wp_insert_term( 'location 1', 'mec_location' );

		self::$data = array(
			'post_type'   => 'mec-rsvp',
			'post_title'  => 'RSVP 1',
			'meta_input'  => array(
				'mec_event_id'         => 2,
				'mec_confirmed'        => rand( -1, 1 ),
				'mec_verified'         => rand( -1, 1 ),
				'mec_attendees'        => $attendees,
				'mec_attention_time'   => '1:2',
				'mec_rsvp_location' => $location_id,
			),
			'post_status' => 'publish',
		);
		$rsvp_id    = wp_insert_post( self::$data );

		self::$instance = new RSVP( $rsvp_id );
	}

	public function test__construct() {

		$this->assertEquals( self::$instance->type, 'rsvp' );
	}
}