jQuery(document).ready(function($){

    function mec_invoice_filter_report_init(){

        $('.mec-reports-selectbox-checkin, .mec-report-event-attendee-email, .mec-report-event-attendee-name').on('change', function(e){

            e.preventDefault();
            var checkin = $('.mec-reports-selectbox-checkin').val();
            var id = $('.mec-reports-selectbox-event').val();
            var occurrence = $('.mec-reports-selectbox-dates').val();
            var email = $('.mec-report-event-attendee-email').val();
            var name = $('.mec-report-event-attendee-name').val();

            if(typeof occurrence === 'undefined') occurrence = '';

            jQuery.ajax(
            {
                url: mec_admin_localize.ajax_url,
                type: 'POST',
                dataType: 'JSON',
                data: {
                    action: 'mec_attendees',
                    id: id,
                    occurrence: occurrence,
                    checkin: checkin,
                    email: email,
                    name: name,
                },
                success: function(response)
                {
                    if (response.email_button != '') {
                        jQuery('.mec-report-selected-event-attendees-wrap').show();
                        jQuery('.mec-report-selected-event-attendees-wrap .w-row .w-col-sm-12').html(response.html);
                        jQuery('.mec-report-sendmail-wrap').show();
                        jQuery('.mec-report-sendmail-wrap .w-row .w-col-sm-12').html(response.email_button);
                    } else {
                        jQuery('.mec-report-selected-event-attendees-wrap').show();
                        jQuery('.mec-report-sendmail-wrap').hide();
                        jQuery('.mec-report-selected-event-attendees-wrap .w-row .w-col-sm-12').html(response.html);
                        jQuery('.mec-report-sendmail-wrap .w-row .w-col-sm-12').html('');
                    }
                },
                error: function()
                {
                }
            });
        });


    }



    $(window).on('mec_booking_report_change_event',function( e, response ){
        if( $('[name="mec-report-event-checkin"]').length ){
            return;
        }

        var html = '';

        html += '<div class="w-row" style="margin-top:20px"><div class="" style="padding-left:5px;padding-right:5px;">';
            html += '<select name="mec-report-event-checkin" class="mec-reports-selectbox mec-reports-selectbox-checkin hidden">'
                    html += '<option value="">'+ MEC_Invoice.checkin_options_select +'</option>';
                    $.each(MEC_Invoice.checkin_options,function(k,v){

                        html += '<option value="'+ k +'">'+ v +'</option>';
                    });
            html += '</select>';

            html += '<input type="email" name="mec-report-event-attendee-email" class="mec-report-event-attendee-email hidden" placeholder="'+ MEC_Invoice.placeholder_attendee_email +'" />';
            html += '<input type="text" name="mec-report-event-attendee-name" class="mec-report-event-attendee-name hidden" placeholder="'+ MEC_Invoice.placeholder_attendee_name +'"/>';
        html += '</div></div>';


        $('.mec-report-select-event-wrap').append( html );
        mec_invoice_filter_report_init();
    });

    $(window).on('mec_booking_report_change_occurrence',function(){

        var occurrence = $('[name="mec-report-event-dates"]').val();
        if( 'none' != occurrence && occurrence.length > 0 ){

            $('[name="mec-report-event-checkin"]').removeClass('hidden');
            $('[name="mec-report-event-attendee-email"]').removeClass('hidden');
            $('[name="mec-report-event-attendee-name"]').removeClass('hidden');
        }else{

            $('[name="mec-report-event-checkin"]').addClass('hidden');
            $('[name="mec-report-event-attendee-email"]').removeClass('hidden');
            $('[name="mec-report-event-attendee-name"]').removeClass('hidden');
        }

        $('[name="mec-report-event-checkin"]').val('');
        $('[name="mec-report-event-attendee-email"]').val('');
        $('[name="mec-report-event-attendee-name"]').val('');
    });

});