<?php

namespace MEC_Invoice;

// Don't load directly
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}
/**
 ** Mec Invoice Attendee Helpers.
 **
 ** @author     Webnus <info@webnus.biz>
 ** @package     Modern Events Calendar
 ** @since     1.0.0
 **/
class Attendee
{
    /**
    ** Do i have access to control attendees?
    ** return true/false
    ** @since     1.0.0
    */
    public static function doIHaveAccess () {

        if( current_user_can( 'mec_invoice_cap' ) ){

            return true;
        }

        $acceptedRoles = \MEC_Invoice\Helper::getOption('mec_invoice_checkin_roles', ['administrator']);
        $user = wp_get_current_user();
        foreach ($acceptedRoles as $role => $value) {

            if ($value == 'on' && in_array($role, (array) $user->roles)) {
               return true;
            } else if (in_array('administrator', (array) $user->roles)) {
                return true;
            }
        }
        return false;
    }

    public static function get_invoice_start_timestamp( $invoice_id ){

        $transaction = Helper::TransactionObject( $invoice_id );

        return $transaction->get_closest_occurrence_start_timestamp();
    }

    public static function get_invoice_end_timestamp( $invoice_id ){

        $transaction = Helper::TransactionObject( $invoice_id );

        return $transaction->get_closest_occurrence_end_timestamp();
    }

    public static function get_checkedin_time( $invoiceID, $place = null, $timestamp = null ) {

        if( is_null( $timestamp ) ){

            $timestamp = self::get_invoice_start_timestamp( $invoiceID );
        }

        if( is_null( $place ) ){

            $is_checkedin = true;
            $checkedin_time = '';

            $transaction = Helper::Transaction( $invoiceID );

            foreach( $transaction['tickets'] as $k => $t_ticket ){

                if( !isset( $t_ticket['id'] ) ){

                    continue;
                }
                $t_place = $k + 1;

                $ticket_timestamps = explode( ':', $t_ticket['date'] ?? '' );

                if( isset( $t_ticket['date'] ) && $timestamp !=  $ticket_timestamps[0] ) {

                    continue;
                }

                $checkedin_time = self::get_checkedin_time($invoiceID, $t_place, $timestamp);
                $is_checkedin = $is_checkedin && !empty( $checkedin_time );
            }

            return $is_checkedin ? $checkedin_time : '';
        }

        $checkedin_time = get_post_meta($invoiceID, 'checkedInTime-' . $timestamp . '-' . $place, true);

        return !empty( $checkedin_time ) ? $checkedin_time : get_post_meta($invoiceID, 'checkedInTime-' . $place, true);
    }

    /**
    ** Has Checked In?
    ** return true/false
    ** @since     1.0.0
    */
    public static function hasCheckedIn ( $invoiceID , $attendee , $place = null, $timestamp = null ) {

        $r = self::get_checkedin_time( $invoiceID, $place, $timestamp );
        if ( !empty( $r ) && $r ) {
            return true;
        } else {
            return false;
        }
    }

    /**
    ** Do checkin operation.
    ** return true/false
    ** @since     1.0.0
    */
    public static function doCheckIn ( $invoiceID , $attendee , $place = null, $timestamp = null, $access_api = null) {

        if (is_null($access_api)) {
            if (!static::doIHaveAccess()) {
                return -1;
            }
        }

        if( is_null( $place ) ){

            $transaction = Helper::Transaction( $invoiceID );

            foreach( $transaction['tickets'] as $k => $t_ticket ){

                if( !isset( $t_ticket['id'] ) ){

                    continue;
                }

                $t_place = $k + 1;
                $t_attendee = $t_ticket['email'];
                self::doCheckIn($invoiceID, $t_attendee, $t_place, $timestamp);
            }
        }

        if( is_null( $timestamp ) ){

            $timestamp = self::get_invoice_start_timestamp( $invoiceID );
        }

        if (static::hasCheckedIn($invoiceID, $attendee, $place, $timestamp)) {
            return true;
        }

        $book_id = get_post_meta($invoiceID, 'book_id', true);
        $event_id = get_post_meta($invoiceID, 'event_id', true);

        if(!$book_id || !$event_id) {
            return false;
        }

        do_action('mec-invoice-check-in', $invoiceID , $attendee , $place, $timestamp);

        update_post_meta($invoiceID, 'checkedIn-' . $place, $attendee);
        update_post_meta($invoiceID, 'checkedInTime-' . $timestamp . '-' . $place, current_time('timestamp'));
        update_post_meta($invoiceID, "checked_time_".$place, current_time('timestamp'));

        return true;
    }

    /**
    ** Do uncheck operation.
    ** return true/false
    ** @since     1.0.0
    */
    public static function doCheckOut ( $invoiceID , $attendee , $place = null, $timestamp = null, $access_api = null) {

        if (is_null($access_api)) {
            if (!static::doIHaveAccess()) {
                return -1;
            }
        }

        if( is_null( $place ) ){

            $transaction = Helper::Transaction( $invoiceID );

            foreach( $transaction['tickets'] as $k => $t_ticket ){

                if( !isset( $t_ticket['id'] ) ){

                    continue;
                }

                $t_place = $k + 1;
                $t_attendee = $t_ticket['email'];
                self::doCheckOut($invoiceID, $t_attendee, $t_place, $timestamp);
            }
        }

        if( is_null( $timestamp ) ){

            $timestamp = self::get_invoice_start_timestamp( $invoiceID );
        }

        if (!static::hasCheckedIn($invoiceID, $attendee, $place, $timestamp)) {
            return true;
        }

        if( ! self::get_checkedin_time( $invoiceID, $place, $timestamp ) ) {
            return true;
        }

        $book_id = get_post_meta($invoiceID, 'book_id', true);
        $event_id = get_post_meta($invoiceID, 'event_id', true);

        if(!$book_id || !$event_id) {
            return false;
        }

        do_action('mec-invoice-check-out', $invoiceID , $attendee , $place, $timestamp);

        delete_post_meta($invoiceID, 'checkedIn-' . $place, $attendee);
        delete_post_meta($invoiceID, 'checkedInTime-' . $timestamp . '-' . $place, '');

        return true;
    }

} //Attendee
