<?php
namespace MEC_Invoice;

// Don't load directly
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}
/**
** Mec Invoice Helpers.
**
** @author     Webnus <info@webnus.biz>
** @package     Modern Events Calendar
** @since     1.0.0
**/
class Helper
{
   /*
    **  Get MEC Options
    **
    **  @since     1.0.0
    */
    public static function getOption ($option, $default = false) {
        $main = \MEC::getInstance('app.libraries.main');
        $mec_settings = $main->get_settings();

        if ( isset( $mec_settings[$option] ) && !empty($mec_settings[$option])) {
            if(!is_array($mec_settings[$option]) && !is_object($mec_settings[$option])) {
                return \stripslashes(\htmlentities($mec_settings[$option]));
            }
            return $mec_settings[$option];
        }
        return $default;
    }

   /*
    **  Get Mec Events Last Event ID
    **
    **  @since     1.0.0
    */
    public static function LastEventID ( $InvoiceID = false ) {

        if(!$InvoiceID){

            $InvoiceID = static::LastInvoiceID();
        }

        return get_post_meta($InvoiceID, 'event_id', true);
    }

    public static function applyCurrency ($price) {

        return \MEC\Base::get_main()->render_price($price);
    }

    public static function get_short_link_query( $Hash ) {

        return get_option( 'mec_invoice_short_link_' . $Hash, false );
    }

    public static function get_short_link_by_query( $query ) {

        global $wpdb;
        $sql = $wpdb->prepare(
            "SELECT `option_name` FROM `{$wpdb->options}` WHERE `option_value` = '%s'",
            $query
        );

        $row = $wpdb->get_row( $sql, ARRAY_A );

        $Hash = $row['option_name'] ?? '';

        return str_replace( 'mec_invoice_short_link_', '', $Hash );
    }

    public static function update_short_link_query( $Hash, $query ) {

        update_option( 'mec_invoice_short_link_' . $Hash, $query );
    }

    public static function upgrade_short_links_db() {

        $links = static::get_short_links();

        foreach( $links as $Hash => $link ) {

            $url_components = parse_url($link);
            parse_str($url_components['query'], $params);
            // $params['url'] = $url_components['query'];
            // $links[$Hash] = $params;

            if( isset( $url_components['query'] ) && !empty( $url_components['query'] ) ) {

                static::update_short_link_query( $Hash, $url_components['query'] );
            }
        }
    }

    public static function get_short_links() {

        $upload = wp_upload_dir();
        $upload_dir = $upload['basedir'];
        $upload_dir = $upload_dir . '/mec-invoices';
        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0700);
        }
        $filename = $upload_dir . '/invoice-db.php';
        if(!file_exists($filename)) {
            $content = '<?php die("Access Denied!"); ?>[]';
            file_put_contents($filename, $content);
        }

        $DB = file_get_contents($filename);
        $DB = str_replace('<?php die("Access Denied!"); ?>', '', $DB);
        $DB = json_decode($DB, true);

        return $DB;
    }

   /*
    **  Get ShortLink
    **
    **  @since     1.0.0
    */
    public static function getShortLink ($url) {

        $url_components = parse_url( $url );

        $Hash = static::get_short_link_by_query( $url_components['query'] );

        if( !$Hash ) {

            $Hash = crypt(md5($url), 'st');
            $Hash = str_replace([DIRECTORY_SEPARATOR, '/'],'-',$Hash);

            if( isset( $url_components['query'] ) && !empty( $url_components['query'] ) ) {

                static::update_short_link_query( $Hash, $url_components['query'] );
            }
        }

        return get_site_url() . '/invoice/' . $Hash;
    }

    /*
    **  Get ShortLink
    **
    **  @since     1.0.0
    */
    public static function getShortLinkDes( $Hash ) {

        $query = static::get_short_link_query( $Hash );

        return get_site_url() . "?$query";
    }

    /*
    **  Get Templates
    **
    **  @since     1.0.0
    */
    public static function getTemplate($name = 'invoice')
    {
        $path = realpath(MECINVOICEDIR . '/templates/' . $name . '.tpl');
        if (file_exists($path)) {
            $content = file_get_contents($path);
            preg_match_all('/\[\[(.*?)\]\]/i', $content, $translatableMatches);
            foreach ($translatableMatches[0] as $key => $text) {
                $content = str_replace($text, __($translatableMatches[1][$key], 'mec-invoice'), $content);
            }
            return $content;
        }
        return "";
    }

    /**
    * Return Invoice DateTime Format
    */
    public static function get_invoice_date_format(){

        if(\MEC_Invoice\Helper::getOption('mec_invoice_show_time_in_modern_type', '') == 'on') {

            return \MEC_Invoice\Helper::getOption('invoice_date_format', get_option('date_format')) . ' - ' . get_option('time_format');
        } else {

            return \MEC_Invoice\Helper::getOption('invoice_date_format', get_option('date_format'));
        }
    }

    /**
    * Get Event Date Label
    *
    * @since     1.0.0
    */
    public static function get_date_label ($date, $event_id) {

        $date_format = self::get_invoice_date_format();
        $time_format = get_option('time_format');
        $event_end_date  = '';
        if(strpos($date, ' - ')) {
            $event_date = $date ? explode(' - ', $date) : array();
        } else {
            $event_date = $date ? explode(':', $date) : array();
        }

        $event_start_time = $event_end_time = $new_event_start_time = $new_event_end_time = '';
        if(!isset($event_date[1])) {
            $event_date[1] = $event_date[0];
        }
        if (is_numeric($event_date[0]) and is_numeric($event_date[1])) {
            $start_datetime = date($date_format . ' ' . $time_format, $event_date[0]);
            $end_datetime = date($date_format . ' ' . $time_format, $event_date[1]);
        } else {
            $start_datetime = $event_date[0];
            $end_datetime = $event_date[1];
        }
        if (isset($start_datetime) and !empty($start_datetime)) {
            $new_event_start_time = explode(' ', $start_datetime);
        }
        if (isset($end_datetime) and !empty($end_datetime)) {
            $new_event_end_time = explode(' ', $end_datetime);
        }

        if (isset($new_event_start_time[1]) and !empty($new_event_start_time[1]) and isset($new_event_start_time[2]) and !empty($new_event_start_time[2]))  $event_start_time = $new_event_start_time[1] . ' ' . $new_event_start_time[2];


        if (isset($new_event_end_time[1]) and !empty($new_event_end_time[1]) and isset($new_event_end_time[2]) and !empty($new_event_end_time[2])) $event_end_time = $new_event_end_time[1] . ' ' . $new_event_end_time[2];

        if (isset($new_event_start_time[0]) and !empty($new_event_start_time[0]))  $event_start_date = $new_event_start_time[0];
        if (isset($new_event_end_time[0]) and !empty($new_event_end_time[0]))  $event_end_date = $new_event_end_time[0];

        $event = get_post($event_id);
        $render = \MEC::getInstance('app.libraries.render');
        $event->data = $render->data($event_id);
        $allday = isset($event->data->meta['mec_allday']) ? $event->data->meta['mec_allday'] : 0;
        if ($allday == '0' and isset($event->data->time) and trim($event->data->time['start'])) :
            $new_event_date = ($event_end_date == $event_start_date) ? $event_start_date : $event_start_date . ' ' . $event_start_time . ' - ' . $event_end_date . ' ' . $event_end_time;
        else :
            $new_event_date = ($event_end_date == $event_start_date) ? $event_start_date : $event_start_date . ' - ' . $event_end_date;
        endif;

        return $new_event_date;
    }

   /*
    **  Get Mec Last Invoice ID
    **
    **  @since     1.0.0
    */
    public static function LastInvoiceID () {

        if (isset($_GET['invoiceID']) && isset($_GET['makePreview'])) {
            $InvoiceID = htmlentities($_GET['invoiceID']);
            $Hash = htmlentities($_GET['makePreview']);
            if ($Hash == get_post_meta($InvoiceID, 'invoiceID', true)) {
                return $InvoiceID;
            }
        }
        global $wpdb;
        $LastRow = $wpdb->get_col("SELECT ID FROM {$wpdb->prefix}posts where post_type='mec_invoice' AND post_status!='auto-draft'  ORDER BY post_date DESC ");
        $ID = isset($LastRow[0]) ? $LastRow[0] : false;

        return $ID;
    }

   /*
    **  Get Mec Last Invoice Transaction ID
    **
    **  @since     1.0.0
    */
    public static function TransactionID ($InvoiceID = 0) {

        if(!$InvoiceID){

            $InvoiceID = static::LastInvoiceID();
        }
        $book_id = get_post_meta($InvoiceID, 'book_id', true);
        $transaction_id = get_post_meta($book_id, 'mec_transaction_id', true);
        if (!$transaction_id) {

            $transaction_id = get_post_meta($book_id, 'transaction_id', true);
        }

        return $transaction_id;
    }

    /*
    **  Get Mec Last Invoice Transaction Data
    **
    **  @since     1.0.0
    */
    public static function Transaction ($InvoiceID = 0) {

        $transaction_id = self::TransactionID( $InvoiceID );

        return get_option( $transaction_id, array() );
    }

    /**
     * Return transaction object
     *
     * @param  int $InvoiceID
     *
     * @return \MEC\Transactions\Transaction
     */
    public static function TransactionObject ( $InvoiceID ) {

        $transaction_id = self::TransactionID( $InvoiceID );

        return new \MEC\Transactions\Transaction( $transaction_id );
    }

    public static function get_ticket_filters_for_transaction( $transactionObject, $InvoiceID, $attendee = false, $row_id = false ){

        if (!$attendee && get_post_meta($InvoiceID, 'attendee', true)) {
            $attendee = get_post_meta($InvoiceID, 'attendee', true);
        }

        $filters = array();
        if ( ( isset($_GET['attendee']) || !in_array( $attendee, array( null, false ), true ) || !in_array( $row_id, array( null, false ), true ) ) /*&& !$transactionObject->is_first_for_all()*/ ) {

            //TODO: check attendee key
            if(isset($_GET['attendee'])) {

                $attendee = $_GET['attendee'];
            }

            if( 'all' !== $attendee ) {

                $filters['email'] = is_array( $attendee ) ? $attendee['email'] : $attendee;
            }

            if( false !== $row_id ) {

                $filters['row_id'] = ++$row_id;
            }
        }

        return $filters;
    }

   /*
    **  Get Mec Last Invoice Discount
    **
    **  @since     1.0.0
    */
    public static function ِInvoiceDiscount ($InvoiceID = false, $attendee = false, $attendee_key = false) {

        if(!$InvoiceID) {
            $InvoiceID = static::LastInvoiceID();
        }

        $transactionObject = Helper::TransactionObject( $InvoiceID );

        $filters = static::get_ticket_filters_for_transaction( $transactionObject, $InvoiceID, $attendee, $attendee_key );

        $discount = $transactionObject->get_discounts( $filters );

        return $discount;
    }

    public static function ِInvoiceFeeDetailRows($InvoiceID = false, $attendee = false, $attendee_key = false) {

        if(!$InvoiceID) {
            $InvoiceID = static::LastInvoiceID();
        }

        $transactionObject = Helper::TransactionObject( $InvoiceID );

        $filters = static::get_ticket_filters_for_transaction( $transactionObject, $InvoiceID, $attendee, $attendee_key );

        $fees_details = $transactionObject->get_fees_details( $filters );

        $rows = array();
        foreach( $fees_details as $fee_details ) {

            $rows[ $fee_details['description'] ] = self::applyCurrency( $fee_details['amount'] );
        }

        return $rows;
    }

   /*
    **  Get Mec Last Invoice Discount
    **
    **  @since     1.0.0
    */
    public static function ِInvoiceFee($InvoiceID = false, $attendee = false, $attendee_key = false) {

        if(!$InvoiceID) {
            $InvoiceID = static::LastInvoiceID();
        }

        $transactionObject = Helper::TransactionObject( $InvoiceID );

        $filters = static::get_ticket_filters_for_transaction( $transactionObject, $InvoiceID, $attendee, $attendee_key );

        $fee = $transactionObject->get_fees( $filters );

        return $fee;
    }

   /*
    **  Get Mec Last Invoice Total Price
    **
    **  @since     1.0.0
    */
    public static function TotalPrice ($InvoiceID = false, $attendee = false, $attendee_key = false) {

        if(!$InvoiceID) {
            $InvoiceID = static::LastInvoiceID();
        }

        $transactionObject = Helper::TransactionObject( $InvoiceID );

        $filters = static::get_ticket_filters_for_transaction( $transactionObject, $InvoiceID, $attendee, $attendee_key );

        $totalprc = $transactionObject->get_total( $filters );

        return $totalprc;
    }

    public static function render_price ($price, $event = null) {

        return \MEC\Base::get_main()->render_price( $price, $event );
    }

    public static function upgrade_invoices_total_price () {

        $args = array(
            'posts_per_page' => 100,
            'post_type' => 'mec_invoice',
            'post_status' => 'any',
            'fields' => 'ids',
            'meta_query' => array(
                array(
                    'key' => 'mec_upgrade_invoice_prices',
                    'compare' => 'NOT EXISTS',
                )
            )
        );

        $invoice_ids = get_posts($args);
        foreach ( $invoice_ids as $invoice_id ) {

            $total_price = Helper::TotalPrice( $invoice_id );
            update_post_meta( $invoice_id, 'price', $total_price );
            update_post_meta( $invoice_id, 'mec_upgrade_invoice_prices', 'yes' );
        }

        return count( $invoice_ids );
    }
} //Helper
