<?php

namespace MEC_Invoice;

class NotificationsSettings {

    public static $base_field_name = "mec[notifications]";

    public static function init(){

        add_filter('mec-settings-item-notifications',[__CLASS__,'display_menu']);
        add_filter('mec_event_notifications',[__CLASS__,'display_event_settings']);
        add_filter('mec_settings_notifications_js_notifications',[__CLASS__,'global_js_render_textarea_settings']);
        add_action('mec_notifications_tabs_content',[__CLASS__,'display_settings']);
    }

    public static function get_placeholders($group_id){

        $placeholders = array(
            '%%name%%' => __( 'Attendee Name', 'mec-invoice' ),
            '%%blog_name%%' => __( 'Blog Name', 'mec-invoice' ),
            '%%InvoiceLink%%' => __( 'Invoice Link', 'mec-invoice' ),
            '%%PDFLink%%' => __( 'PDF Link', 'mec-invoice' ),
            '%%WebSiteUrl%%' => __( 'Web Site Url', 'mec-invoice' ),
            '%%FavIcon%%' => __( 'Fav Icon', 'mec-invoice' ),
            '%%TotalPrice%%' => __( 'Total Price', 'mec-invoice' ),
            '%%Paid%%' => __( 'Paid', 'mec-invoice' ),
            '%%Discount%%' => __( 'Discount', 'mec-invoice' ),
            '%%Currency%%' => __( 'Currency', 'mec-invoice' ),
            '%%Tax%%' => __( 'Tax', 'mec-invoice' ),
            '%%TaxDetail%%' => __( 'Tax Detail', 'mec-invoice' ),
            '%%TicketSeatNumbers%%' => __( 'Ticket Seat Numbers', 'mec-invoice' ),
            '%%QRCodeUrl%%' => __( 'QR Code Url', 'mec-invoice' ),
            '%%EventID%%' => __( 'Event ID', 'mec-invoice' ),
            '%%EventName%%' => __( 'Event Name', 'mec-invoice' ),
            '%%EventUrl%%' => __( 'Event Url', 'mec-invoice' ),
            '%%EventDate%%' => __( 'Event Date', 'mec-invoice' ),
            '%%EventTime%%' => __( 'Event Time', 'mec-invoice' ),
            '%%TicketName%%' => __( 'Ticket Name', 'mec-invoice' ),
            '%%TicketDate%%' => __( 'Ticket Date', 'mec-invoice' ),
            '%%TicketTime%%' => __( 'Ticket Time', 'mec-invoice' ),
            '%%TicketTimeStart%%' => __( 'Ticket Time Start', 'mec-invoice' ),
            '%%TicketTimeEnd%%' => __( 'Ticket Time End', 'mec-invoice' ),
            '%%InvoiceID%%' => __( 'Invoice ID', 'mec-invoice' ),
            '%%InvoiceTitle%%' => __( 'Invoice Title', 'mec-invoice' ),
            '%%InvoiceDescription%%' => __( 'Invoice Description', 'mec-invoice' ),
            '%%InvoiceDate%%' => __( 'Invoice Date', 'mec-invoice' ),
            '%%InvoiceDateD%%' => __( 'Invoice Date', 'mec-invoice' ),
            '%%InvoiceDateT%%' => __( 'Invoice Date Time', 'mec-invoice' ),
            '%%InvoiceNumber%%' => __( 'Invoice Number', 'mec-invoice' ),
            '%%TransactionID%%' => __( 'Transaction ID', 'mec-invoice' ),
            '%%InvoiceMoreInfo%%' => __( 'Invoice More Info', 'mec-invoice' ),
            '%%AttendeesList%%' => __( 'Attendees List', 'mec-invoice' ),
            '%%CartItems%%' => __( 'Cart Items', 'mec-invoice' ),
            '%%Tickets%%' => __( 'Tickets', 'mec-invoice' ),
            '%%CompanyURL%%' => __( 'Company URL', 'mec-invoice' ),
            '%%CompanyURLV%%' => __( 'Company URL V', 'mec-invoice' ),
            '%%CompanyName%%' => __( 'Company Name', 'mec-invoice' ),
            '%%CompanyAddress%%' => __( 'Company Address', 'mec-invoice' ),
            '%%CompanyDescription%%' => __( 'Company Description', 'mec-invoice' ),
            '%%CompanyPhone%%' => __( 'Company Phone', 'mec-invoice' ),
            '%%CompanyVatNumber%%' => __( 'Company Vat Number', 'mec-invoice' ),
            '%%CompanyEmail%%' => __( 'Company Email', 'mec-invoice' ),
            '%%CompanyLogoUrl%%' => __( 'Company Logo Url', 'mec-invoice' ),
            '%%EventDescriptions%%' => __( 'Event Descriptions', 'mec-invoice' ),
            '%%OrganizerImage%%' => __( 'Organizer Image', 'mec-invoice' ),
            '%%OrganizerName%%' => __( 'Organizer Name', 'mec-invoice' ),
            '%%OrganizerPhone%%' => __( 'Organizer Phone', 'mec-invoice' ),
            '%%OrganizerEmail%%' => __( 'Organizer Email', 'mec-invoice' ),
            '%%OrganizerSite%%' => __( 'Organizer Site', 'mec-invoice' ),
            '%%EventLocation%%' => __( 'Event Location', 'mec-invoice' ),
            '%%EventLocationAddress%%' => __( 'Event Location Address', 'mec-invoice' ),

        );

        return $placeholders;
    }

    public static function get_default_settings($group_id){

        if(!$group_id){

            return [];
        }

        $group_id = str_replace('_notification','',$group_id);
        $settings_groups = static::get_sections_settings();

        return $settings_groups[$group_id]['default_options'] ? $settings_groups[$group_id]['default_options'] : [];
    }

    public static function get_sections_settings(){

        return array(
            'invoice' => array(
                'group_id' => 'invoice',
                'section_title' => __('Invoice', 'mec-invoice'),
                'enable_options_text' => __('Enable Invoice notification', 'mec-invoice'),
                'enable_options_description' => __('Sent to attendee after Invoice to notify them.', 'mec-invoice'),
                'base_field_name' => static::$base_field_name,
                'default_options' => [
                    'status'=>'1',

                    'subject' => __('Your Invoice is created.','mec-invoice'),
                    'recipients'=>'',
                    'content'=>__("Hello %%name%%,

                        Your Invoice is received. We will check and confirm your Invoice as soon as possible.
                        Thank you for your patience.

                        Regards,
                        %%blog_name%%",
                        'mec-invoice'
                    ),
                ],
            ),
        );
    }

    public static function display_menu($notifications_items){

        $settings_sections = static::get_sections_settings();
        foreach($settings_sections as $group_id => $section_args){

            $title = $section_args['section_title'];
            $group_id = $group_id . '_notification_section';
            $notifications_items[$title] = $group_id;
        }

        return $notifications_items;
    }

    public static function display_event_settings($notifications_items){

        $settings_sections = static::get_sections_settings();
        foreach($settings_sections as $group_id => $section_args){

            $title = $section_args['section_title'];
            $group_id = $group_id . '_notification';
            $notifications_items[$group_id] = array(
                'label' => $title,
            );
        }

        return $notifications_items;
    }

    public static function global_js_render_textarea_settings($notifications_items){

        $settings_sections = static::get_sections_settings();
        foreach($settings_sections as $group_id => $section_args){

            $group_id = $group_id . '_notification';
            $notifications_items[$group_id] = $group_id;
        }

        return $notifications_items;
    }

    public static function display_settings($notifications){

        $settings_sections = static::get_sections_settings();

        $factory = new DisplayNotificationSettings();
        foreach($settings_sections as $group_id => $atts){

            $default_options = isset($atts['default_options']) && is_array($atts['default_options']) ? $atts['default_options'] : [];
            $atts['options'] = isset($notifications[$group_id . '_notification']) ? $notifications[$group_id . '_notification'] : $default_options;
            $atts['placeholders'] = static::get_placeholders( $group_id );
            $factory->output($atts);
        }
    }
}
