<?php

if(!defined('ABSPATH')){
    die || exit;
}

$class = $atts['class'];
$group_id = $atts['group_id'];
$base_field_name = $atts['base_field_name'];
$section_title = $atts['section_title'];
$enable_options_text = $atts['enable_options_text'];
$enable_options_description = $atts['enable_options_description'];
$placeholders = $atts['placeholders'];
$options = $atts['options'];

?>

<div id="<?php echo esc_attr( $group_id ) ?>_notification_section" class="mec-options-fields <?php echo esc_attr( $class ) ?>">

    <h4 class="mec-form-subtitle"><?php echo esc_attr( $section_title ); ?></h4>
    <div class="mec-form-row">
    <div class="mec-col-12">
        <label>
            <input type="hidden" name="<?php echo esc_attr( $base_field_name ); ?>[<?php echo esc_attr( $group_id ); ?>_notification][status]" value="0" />
            <input onchange="jQuery('#mec_notification_<?php echo esc_attr( $group_id ); ?>_notification_container_toggle').toggle();" value="1" type="checkbox" name="<?php echo esc_attr( $base_field_name ); ?>[<?php echo esc_attr( $group_id ); ?>_notification][status]" <?php if(!isset($options['status']) or (isset($options['status']) and $options['status'])) echo 'checked="checked"'; ?> /> <?php $enable_options_text; ?>
        </label>
    </div>
    <p class="mec-col-12 description"><?php echo esc_html($enable_options_description); ?></p>
    </div>
    <div id="mec_notification_<?php echo esc_attr( $group_id );  ?>_notification_container_toggle" class="<?php if(isset($options) and isset($options['status']) and !$options['status']) echo 'mec-util-hidden'; ?>">

        <div class="mec-form-row">
            <label for="mec_notifications_<?php echo esc_attr( $group_id );  ?>_notification_content"><?php esc_html_e('Email Content', 'mec'); ?></label>
            <?php
            $content = isset($options['content']) ? $options['content'] : '';
            wp_editor(
                stripcslashes($content),
                'mec_notifications_' . esc_attr($group_id) . '_notification_content',
                array(
                    'textarea_name'=> esc_attr($base_field_name.'['. $group_id.'_notification][content]')
                )
            );
            ?>
        </div>

        <?php do_action( 'mec_notifications_settings_after_editor', $group_id, $options ); ?>

        <div class="mec-form-row">
            <div class="mec-col-12">
                <p class="description"><?php esc_html_e('You can use the following placeholders', 'mec'); ?></p>
                <ul>
                    <?php foreach($placeholders as $p_key => $p_text): ?>
                        <li><span><?php echo esc_attr( $p_key ) ?></span>: <?php echo esc_html( $p_text ); ?></li>
                    <?php endforeach; ?>
                    <?php do_action( 'mec_extra_field_notifications', $group_id ); ?>
                </ul>
            </div>
        </div>

        <?php do_action( 'mec_notifications_settings_end', $group_id, $options ); ?>

    </div>
</div>
