<?php

namespace MEC_Invoice\Pages;
use MEC_Invoice\Attendee;
use MEC_Invoice\Notifications;
use WP_REST_Response;

// Don't load directly
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}

/**
** Invoice Preview Page.
**
** @author      Webnus <info@webnus.biz>
** @package     Modern Events Calendar
** @since       1.0.0
**/
class InvoicePreview
{

   /*
     **  Instance of this class.
     **
     **  @since   1.0.0
     **  @access  public
     **  @var     MEC_Invoice
     */
    public static $instance;

   /*
     **  The directory of this file
     **
     **  @access  public
     **  @var     string
     */
    public static $dir;

   /*
     **  Provides access to a single instance of a module using the Singleton pattern.
     **
     **  @since   1.0.0
     **  @return  object
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }


    public function __construct()
    {
        if (self::$instance === null) {
            self::$instance = $this;
        }
        self::settingUp($this);
        self::setHooks();
    }

   /*
     **  Set Hooks.
     **
     **  @since   1.0.0
     */
    public static function setHooks()
    {
        add_action('wp_loaded', [self::$instance, 'renderContent']);
    }

   /*
     **  Global Variables.
     **
     **  @since   1.0.0
     */
    public static function settingUp($This)
    {
        self::$dir  = MECINVOICEDIR . 'core' . DS . 'pages';
    }

   /*
     **  Render Content.
     **  MECInvoicePreview
     **  @since   1.0.0
     */
    public static function renderContent()
    {
        if (isset($_GET['invoiceID']) && isset($_GET['makePreview'])) {
            $InvoiceID = htmlentities($_GET['invoiceID']);

            if( 'on' === \MEC_Invoice\Helper::getOption('mec_invoice_display_invoice_number_in_checkin', 'off') ){

                $invoice_id = \MEC_Invoice\Helper\Invoice::get_invoice_number($InvoiceID);
            }else{

                $invoice_id = $InvoiceID;
            }

            $_InvoiceID = $invoice_id . (isset($_GET['place']) ? '-' . esc_attr($_GET['place']) : '');

            if(get_post_meta($InvoiceID, 'status', true) == 'open' || current_user_can('administrator') ) {
                $Hash = htmlentities($_GET['makePreview']);
                if ($Hash != get_post_meta($InvoiceID, 'invoiceID', true)) {
                    return false;
                }

                $Invoice = get_post($InvoiceID);
                if ($Invoice) {
                    if(isset($_GET['showPDF'])) {
                        $url = get_site_url(null, '?invoiceID=' . $InvoiceID . '&makePreview=' . $Hash);
                        if(isset($_GET['attendee']) && $attendee = $_GET['attendee']) {
                            $url .= '&attendee='. $attendee;
                        }

                        $html2pdfApiKey = \MEC_Invoice\Helper::getOption('mec_invoice_html2pdf', '');
                        $selectpdfApiKey = \MEC_Invoice\Helper::getOption('mec_invoice_selectpdf', '');
                        $selectpdfMarginTop = \MEC_Invoice\Helper::getOption('mec_invoice_selectpdf_margin_top', '5');
                        $selectpdfMarginRight = \MEC_Invoice\Helper::getOption('mec_invoice_selectpdf_margin_right', '5');
                        $selectpdfMarginBottom = \MEC_Invoice\Helper::getOption('mec_invoice_selectpdf_margin_bottom', '5');
                        $selectpdfMarginLeft = \MEC_Invoice\Helper::getOption('mec_invoice_selectpdf_margin_left', '5');

                        if ( isset($selectpdfApiKey) and !empty($selectpdfApiKey) ){
                            $data = [
                                'url' => $url,
                                'key' => $selectpdfApiKey,
                                'use_css_print' => true,
                                'page_size' => 'A4',
                                'engine' => 'WebKit',
                                'page_numbers' => false,
                                'web_page_width' => '793',
                                'margin_top' => $selectpdfMarginTop,
                                'margin_right' => $selectpdfMarginRight,
                                'margin_bottom' => $selectpdfMarginBottom,
                                'margin_left' => $selectpdfMarginLeft,
                            ];
                            $dataString = json_encode($data);
                            $ch = curl_init('https://selectpdf.com/api2/convert/');
                        } else {
                            $data = [
                                'url' => $url,
                                'apiKey' => $html2pdfApiKey,
                                'media' => 'print',
                                'format' => 'A4',
                            ];
                            $dataString = json_encode($data);
                            $ch = curl_init('https://api.html2pdf.app/v1/generate');
                        }

                        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
                        curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($ch, CURLOPT_HTTPHEADER, [
                            'Content-Type: application/json',
                        ]);

                        $response = curl_exec($ch);
                        $err = curl_error($ch);
                        curl_close($ch);

                        if ($err) {
                            echo 'Error #:' . $err;
                            die();
                        } else {
                            header('Content-Type: application/pdf');
                            header('Content-Disposition: inline; filename="Invoice-'. $InvoiceID .'.pdf"');
                            header('Content-Transfer-Encoding: binary');
                            header('Accept-Ranges: bytes');

                            echo $response;
                        }
                        die();
                    }
                    if (isset($_GET['doCheckin']) && $_GET['doCheckin'] === get_post_meta($InvoiceID, 'CheckinHash', true)) {

                        if (!Attendee::doIHaveAccess()) {
                            $content = \MEC_Invoice\Helper::getTemplate('permission-denied');
                            $content = str_replace('{{invoiceID}}',  $_InvoiceID, $content);
                            echo $content;
                            die();
                        }
                        $transactionID =  \MEC_Invoice\Helper::TransactionID();
                        $transaction  = get_option($transactionID);
                        $date = $transaction['date'];
                        if(!is_array($date)) {
                            if(strpos($date, '-')) {
                                $date = explode('-', $date);
                            } elseif(strpos($date, ':')) {
                                $date = explode(':', $date);
                            }
                        }
                        if (!isset($date[1])) {
                            $date[1] = $date[0];
                        }

                        $start_date = is_numeric($date[0]) ? $date[0] : strtotime($date[0]);
                        $end_date = is_numeric($date[1]) ? $date[1] : strtotime($date[1]);

                        $approved = false;
                        if ($start_date < current_time('timestamp')
                        ) {
                            $approved = true;
                        }

                        if ($end_date < current_time('timestamp')) {
                            $approved = false;
                        }

                        if (!$approved && \MEC_Invoice\Helper::getOption('mec_invoice_early_checkin', false) == 'on') {
                            $content = \MEC_Invoice\Helper::getTemplate('early-checkin');
                            $content = str_replace('{{invoiceID}}',  $_InvoiceID, $content);
                            echo $content;
                            die();
                        }

                        $book_id = get_post_meta($InvoiceID, 'book_id', true);
                        $verified = get_post_meta($book_id, 'mec_verified', true);
                        if ($verified !== '1') {
                            $content = \MEC_Invoice\Helper::getTemplate('permission-denied');
                            $content = str_replace('{{invoiceID}}',  $_InvoiceID ,$content);
                            echo $content;
                            die();
                        }


                        $event_id = get_post_meta($InvoiceID, 'event_id', true);
                        $event_tickets = get_post_meta($event_id, 'mec_tickets', true);
                        if (get_post_status($event_id) != 'publish') {
                            $content = \MEC_Invoice\Helper::getTemplate('permission-denied');
                            $content = str_replace('{{invoiceID}}',  $_InvoiceID, $content);
                            echo $content;
                            die();
                        }


                        $count = 0;
                        foreach ($transaction['tickets'] as $key => $_ticket) {
                            $key++;
                            if (isset($_ticket['id'])) {
                                if (!\MEC_Invoice\Attendee::hasCheckedIn($InvoiceID, $_ticket['email'], $key, $start_date)) {
                                    $count++;
                                    \MEC_Invoice\Attendee::doCheckIn($InvoiceID, $_ticket['email'], $key, $start_date);
                                } else {
                                    // \MEC_Invoice\Attendee::doCheckOut($InvoiceID, $_ticket['email'], $key);
                                }
                            }
                        }

                        $checkedTime = date_i18n(get_option('date_format') . ' - ' . get_option('time_format'), current_time('timestamp'));

                        if(!$count) {
                            $content = \MEC_Invoice\Helper::getTemplate('already-checked');
                        } else {
                            $content = \MEC_Invoice\Helper::getTemplate('successfully-checked');
                        }

                        $place = isset($_GET['place']) ? $_GET['place'] : 'all';
                        $attendee_email = is_numeric( $place ) && isset( $transaction['tickets'][$place - 1]['email'] ) ? $transaction['tickets'][$place - 1]['email'] : '-';
                        $_InvoiceID = $invoice_id . ( $place ? '-' . esc_attr( $place ) : '');

                        $attendee_ticket_ids = is_numeric( $place ) ? [ $transaction['tickets'][$place - 1]['id'] ] : array_column($transaction['tickets'],'id');

                        $ticket_names = array();
                        foreach( $attendee_ticket_ids as $attendee_ticket_id ){

                            $ticket_names[] = $event_tickets[$attendee_ticket_id]['name'] ?? '';
                        }
                        $ticket_name = implode( ', ', $ticket_names );

                        $data = [
                            'invoiceID'     => $_InvoiceID,
                            'attendeeName'  => $count ? '×' . $count . ' - ' . __('Attendee(s)') : __('All attendees have been checked already','mec-invoice') ,
                            'attendeeEmail' => $attendee_email,
                            'eventName'     => get_the_title($event_id),
                            'checkedTime'   => $checkedTime,
                            'unCheckUrl'    =>  get_site_url(null, '?invoiceID=' . $InvoiceID . '&checkIn=' . $attendee_email . '&place=' . $place . '&Hash=' . $Hash . '&un-check=true'),
                            'CheckUrl'      =>  "#",
                            'TicketSeatNumbers' => '',
                            'ticketName' => $ticket_name,
                        ];

                        $invoice_timestamp = Attendee::get_invoice_start_timestamp( $InvoiceID );

                        $attendee = [];
                        if( !is_array( $attendee_email ) ){

                            if( 'all' !== $place ){

                                $book_attendees = get_post_meta( $book_id, 'mec_attendees', true );
                                $attendee = $book_attendees[ $place ] ?? array();
                            }
                        }
                        $data = apply_filters( 'mec_invoice_checkin_data', $data, $book_id, $attendee, $invoice_timestamp );

                        foreach ($data as $name => $value) {
                            $content = str_replace('{{' . $name . '}}', $value, $content);
                        }

                        echo $content;
                        die();

                    }

                    echo Notifications::getInvoiceContent($InvoiceID,'invoice')->content;

                    echo '<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.1/jquery.min.js"></script>';
                    echo '<script src="' . MECINVOICEASSETS . 'js/printThis.js"></script>';
                    echo "<script>jQuery(document).ready(function() {
                        jQuery('.mec-invoice-print-btn').on('click', function() {
                              window.print();
                        });
                    })</script>";

                    exit();
                }
            } else {
                include realpath(MECINVOICEDIR . '/templates/invoice-canceled.tpl');
                exit();
            }

        } else if (isset($_GET['invoiceID']) && isset($_GET['downloadInvoice'])) {
            $InvoiceID = htmlentities($_GET['invoiceID']);
            $Hash = htmlentities($_GET['downloadInvoice']);
            if ($Hash != get_post_meta($InvoiceID, 'invoiceID', true)) {
                return false;
            }
            \MEC_Invoice\PDF::createFromInvoice($InvoiceID);
            exit();
        } else {
            $url = $_SERVER['REQUEST_URI'];
            if($url && strpos($url, '/invoice/') !== false) {
                $hash = preg_replace('#(.*?)\/invoice\/#','', $url);
                if(strpos($hash, '/') !== false) {
                    return;
                }
                $des = \MEC_Invoice\Helper::getShortLinkDes($hash);

                if (!$des) {
                    return;
                }

                $method = $_SERVER['REQUEST_METHOD'];

                if (strtoupper($method) === 'POST') {
                    //API Checkin for Scanner QrCode
                    $parts = parse_url($des);
                    parse_str($parts['query'], $query);
                    $all_checked = $query['place'] ?? "all";
                    $book_id = get_post_meta($query['invoiceID'], 'book_id', true);
                    if (isset($_POST['key']) && get_option("api-key-app") === $_POST['key']) {

                        if (isset($book_id) && isset($query['invoiceID'])) {
                            $invoiceId = $query['invoiceID'];
                            if (isset($all_checked) && $all_checked == "all") {
                                $verified = get_post_meta($book_id, 'mec_verified', true);

                                if ($verified !== '1') {
                                    $data_response = array('status' => 404, 'status_scan' => -1, 'msg' => "Booking Is Not Verified!", 'data' => null);
                                    $response_scan = new WP_REST_Response($data_response);
                                    $response_scan->set_status(404);
                                    echo json_encode($response_scan);
                                    die();
                                }

                                $atts = get_post_meta($book_id, 'mec_attendees', true);
                                $j = 1;
                                $checkin = 0;
                                $already = 0;

                                foreach ($atts as $key_att => $att) {
                                    if (!Attendee::hasCheckedIn($invoiceId, $att['email'], $j)) {
                                        Attendee::doCheckIn($invoiceId, $att['email'], $j, null, true);
                                        $checkin++;
                                    } else {
                                       // Attendee::doCheckOut($invoiceId, $att['email'], $j, null, true);
                                        $already++;
                                    }
                                    $j++;
                                }

                                if ($checkin >= $already) {
                                    $text = __('All Checkin', 'mec-invoice');
                                    $status = 1;
                                    $status_scan = 1;
                                } else {
                                    $text = __('All Ticket Already Checked-in!', 'mec-invoice');
                                    $status = 0;
                                    $status_scan = 0;
                                }

                                $data_response = array('status' => 200, 'status_scan' => $status_scan, 'msg' => $text, 'data' => array(
                                    'status' => $status,
                                ));
                                $response_scan = new WP_REST_Response($data_response);
                                $response_scan->set_status(200);
                                echo json_encode($response_scan);
                                die();

                            } else {
                                if (isset($query['checkIn']) && isset($query['place'])) {
                                    $email = $query['checkIn'];
                                    $key = $query['place'];
                                    $verified = get_post_meta($book_id, 'mec_verified', true);

                                    if ($verified !== '1') {
                                        $data_response = array('status' => 404, 'status_scan' => -1, 'msg' => "Booking Is Not Verified!", 'data' => null);
                                        $response_scan = new WP_REST_Response($data_response);
                                        $response_scan->set_status(404);
                                        echo json_encode($response_scan);
                                        die();
                                    }

                                    if (!Attendee::hasCheckedIn($invoiceId, $email, $key)) {
                                        Attendee::doCheckIn($invoiceId, $email, $key, null, true);
                                        $text = __('Checkin', 'mec-invoice');
                                        $status = 1;
                                        $status_scan = 1;
                                    } else {
//                                        Attendee::doCheckOut($invoiceId, $email, $key, null, true);
                                        $text = __('Ticket Already Checked-in!', 'mec-invoice');
                                        $status = 0;
                                        $status_scan = 0;
                                    }

                                    $data_response = array('status' => 200, 'status_scan' => $status_scan, 'msg' => $text, 'data' => array(
                                        'status' => $status,
                                    ));
                                    $response_scan = new WP_REST_Response($data_response);
                                    $response_scan->set_status(200);
                                    echo json_encode($response_scan);
                                    die();
                                } else {
                                    $data_response = array('status' => 404, 'status_scan' => -1, 'msg' => "Not Found Event.", 'data' => null);
                                    $response_scan = new WP_REST_Response($data_response);
                                    $response_scan->set_status(200);
                                    echo json_encode($response_scan);
                                    die();
                                }
                            }

                        } else {
                            $data_response = array('status' => 404, 'status_scan' => -1, 'msg' => "Not Found Event.", 'data' => null);
                            $response_scan = new WP_REST_Response($data_response);
                            $response_scan->set_status(404);
                            echo json_encode($response_scan);
                            die();
                        }
                    } else {
                        $data_response = array('status' => 404, 'status_scan' => -1, 'msg' => "Invalid Key.", 'data' => null);
                        $response_scan = new WP_REST_Response($data_response);
                        $response_scan->set_status(404);
                        echo json_encode($response_scan);
                        die();
                    }

                } else {
                    ob_get_clean();
                    ob_start();
                    header('Location: ' . $des);
                    die();
                }
            }
        }
        return false;
    }
} //InvoicePreview
InvoicePreview::instance();
