<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:o="urn:schemas-microsoft-com:office:office">
    <head>
        <meta name="generator" content="HTML Tidy for Linux (vers 25 March 2009), see www.w3.org" />
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="format-detection" content="telephone=no" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0,
                                 maximum-scale=1.0, user-scalable=no">
        <link rel="icon" href="{{FavIcon}}" sizes="32x32" />
        <title>{{InvoiceTitle}}</title>
        <style type="text/css">
            /*<![CDATA[*/
               /* -------------------------------------
                   GLOBAL RESETS
               ------------------------------------- */
               /* latin */
               @font-face {
               font-family: 'DM Sans';
               font-style: italic;
               font-weight: 400;
               font-display: swap;
               src: url(https://fonts.gstatic.com/s/dmsans/v6/rP2Fp2ywxg089UriCZa4Hz-D.woff2) format('woff2');
               unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
               }
               /* latin */
               @font-face {
               font-family: 'DM Sans';
               font-style: normal;
               font-weight: 400;
               font-display: swap;
               src: url(https://fonts.gstatic.com/s/dmsans/v6/rP2Hp2ywxg089UriCZOIHQ.woff2) format('woff2');
               unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
               }
               /* latin */
               @font-face {
               font-family: 'DM Sans';
               font-style: normal;
               font-weight: 500;
               font-display: swap;
               src: url(https://fonts.gstatic.com/s/dmsans/v6/rP2Cp2ywxg089UriAWCrCBimCw.woff2) format('woff2');
               unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
               }
               /* latin */
               @font-face {
               font-family: 'DM Sans';
               font-style: normal;
               font-weight: 700;
               font-display: swap;
               src: url(https://fonts.gstatic.com/s/dmsans/v6/rP2Cp2ywxg089UriASitCBimCw.woff2) format('woff2');
               unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
               }
               img {
                 border: none;
                 -ms-interpolation-mode: bicubic;
                 max-width: 100%; }

               html {
                 width: 100%;
               }

               body {
                 font-family: "DM Sans",Roboto, sans-serif;;
                 -webkit-font-smoothing: antialiased;
                 font-size: 14px;
                 line-height: 1.4;
                 margin: 0;
                 padding: 0;
                 -ms-text-size-adjust: 100%;
                 -webkit-text-size-adjust: 100%; }

               table {
                 border-collapse: separate;
                 mso-table-lspace: 0pt;
                 mso-table-rspace: 0pt;
                 width: 100%; }
                 table td {
                   font-family: sans-serif;
                   font-size: 14px;
                   vertical-align: top; }

               /* -------------------------------------
                   BODY & CONTAINER
               ------------------------------------- */

               .wn-body {
                 background-color: #fff;
                 width: 100%;
                 max-width: 100%;
                 font-family: "DM Sans",Roboto, sans-serif;
               }
               .mec-invoice-table-container {
                 max-width: 1002px;
                 margin: 0 auto !important;
               }
               .wn-footer {
                 clear: both;
                 margin-top: 10px;
                 width: 100%;
                 color: #999999;
                 font-size: 12px;
                 text-align: center;
                 padding-bottom: 20px; }
               .wn-footer a { color: #868991; }

               /* -------------------------------------
                   TYPOGRAPHY
               ------------------------------------- */
               h1,
               h2,
               h3,
               h4 {
                 color: #1b1e2f;
                 font-family: "DM Sans",Roboto, sans-serif;
                 font-weight: 400;
                 line-height: 1.4;
                 margin: 0;
                 margin-bottom: 15px; }

               h1 {
                 font-size: 35px;
                 font-weight: 400;
                 text-transform: capitalize; }

               p,
               ul,
               ol {
                 font-family: "DM Sans",Roboto, sans-serif;
                 font-size: 14px;
                 font-weight: normal;
                 margin: 0;
                 margin-bottom: 15px;
                 line-height:  1.68;
                 color: #1b1e2f;
                 }
                 p li,
                 ul li,
                 ol li {
                   list-style-position: inside;
                   margin-left: 5px; }

               a {
                 color: #3498db;
                 text-decoration: underline; }

               .mec-invoice-attendee {
                 padding-bottom: 20px;
                 padding-right: 10px;
                 margin-bottom: 25px;
                 border-bottom: 1px solid #d1d2d3;
                 clear: both;
                 overflow: hidden;
               }

               .mec-invoice-attendee img.attendee-profile {
                 width: 40px;
                 height: 40px;
                 border-radius: 8px;
                 margin-right: 12px;
                 margin-bottom: 5px;
               }

               .mec-invoice-attendee img.attendee-qr {
                 float: right;
                 width: 62px;
                 height: 62px;
                 border-radius: 0;
                 margin-left: 12px;
               }

               .mec-invoice-header, .mec-invoice-body {
                 border: 1px solid #d1d2d3;
               }

               .mec-modern-ticket-body:last-of-type .modern-ticket-devider {
                    display: none;
                }

            .mec-modern-ticket-wrap .mec-modern-ticket-cut-col{
                width: 50px!important;
                padding: 0px!important;
            }
            .mec-modern-ticket-wrap .mec-modern-ticket-cut-col img{
                min-width: 68px!important;
                height: 100%!important;
            }

            @media only screen and (max-width: 1025px) {
            }

            @media only screen and (max-width: 960px) {
                .mec-modern-ticket-wrap table td .mec-modern-ticket-ticket-data-wrapper{
                    display: flex;
                    flex-wrap: wrap;
                }
                .mec-modern-ticket-wrap .mec-modern-ticket-cut-col{
                    width: 50px!important;
                    padding: 0px!important;
                }
                .mec-modern-ticket-wrap .mec-modern-ticket-cut-col img{
                    min-width: 68px!important;
                    height: 100%!important;
                }
            }

            @media only screen and (max-width: 640px) {
                .mec-invoice-table-container { max-width: 100% !important; }
                .mec-invoice-title {
                    padding: 15px 0px 15px 20px!important;
                    display: flex;
                    align-content: center;
                    justify-content: space-around;
                    align-items: center;
                    font-size: 15px !important;
                    border-radius: 10px !important;
                    margin: 15px 0 20px !important;
                }
                .mec-invoice-title .mec-invoice-pdf-btn{
                    margin-left: 10px;
                }
                .mec-modern-ticket-wrap table td{
                    padding: 10px!important;
                }
                .mec-modern-ticket-wrap table td .mec-modern-ticket-ticket-data-wrapper{
                    display: flex;
                    flex-wrap: wrap;
                    flex-direction: column;
                }
                .mec-modern-ticket-wrap .mec-modern-ticket-event-title{
                    font-size: 25px !important;
                }
                .mec-modern-ticket-wrap .mec-modern-ticket-f4box{
                    width: 45%!important
                }
                .mec-modern-ticket-wrap .mec-modern-ticket-cut-col{
                    width: 55px!important;
                    padding: 0px!important;
                }
                .mec-modern-ticket-wrap .mec-modern-ticket-cut-col img{
                    min-width: 100%!important;
                    height: 100%!important;
                    min-height: 100%!important;
                    max-height: 100%!important;
                }
            }

            @media only screen and (max-width: 600px) {
                .mec-modern-ticket-wrap .mec-modern-ticket-f4box{
                    width: 45%!important
                }
                .mec-modern-ticket-wrap .mec-modern-ticket-cut-col{
                    width: 62px!important;
                    padding: 0px!important;
                }
                .mec-modern-ticket-wrap .mec-modern-ticket-cut-col img{
                    min-width: 100%!important;
                    height: 100%!important;
                    min-height: 100%!important;
                    max-height: 100%!important;
                }
            }

            @media only screen and (max-width: 550px) {
                .mec-modern-ticket-wrap .mec-modern-ticket-f4box{
                    width: 45%!important
                }
                .mec-modern-ticket-wrap .mec-modern-ticket-cut-col{
                    width: 75px!important;
                    padding: 0px!important;
                }
                .mec-modern-ticket-wrap .mec-modern-ticket-cut-col img{
                    min-width: 100%!important;
                    height: 100%!important;
                    min-height: 100%!important;
                    max-height: 100%!important;
                }
            }

            @media only screen and (max-width: 480px) {
                .mec-invoice-table-container { max-width: 100% !important; }
                .mec-invoice-title {
                    padding: 15px 0px 15px 20px!important;
                    display: flex;
                    align-content: center;
                    justify-content: space-around;
                    align-items: center;
                    font-size: 15px !important;
                    border-radius: 10px !important;
                    margin: 15px 0 20px !important;
                }
                .mec-invoice-title .mec-invoice-pdf-btn{
                    margin-left: 10px;
                }
                .wn-body table td{
                    padding: 5px !important;
                }
                .mec-invoice-items-w > table {
                    table-layout: auto !important;
                }
                .mec-invoice-header{
                    padding: 15px !important;
                    margin: 0 0 -25px !important;
                }
                .mec-invoice-header > table > tbody > tr{
                    width: 100%;
                    display: flex;
                    flex-direction: column;
                }
                .mec-invoice-header > table > tbody > tr .mec-invoice-header-half2 tbody{
                    display: flex;
                    width: 100%;
                    flex-direction: column;
                }
                .mec-modern-ticket-wrap table tr{
                    width: 100%;
                    display: flex;
                    flex-direction: row;
                    flex-wrap: wrap;
                    align-content: center;
                    align-items: center;
                    border: 1px solid #d1d2d3;
                    border-radius: 10px;
                }
                .mec-modern-ticket-wrap table td{
                    border: none !important;
                    border-radius: 0 !important;
                    padding: 0 !important;
                    width: 100%;
                }
                .mec-modern-ticket-wrap .mec-modern-ticket-event-data-wrapper,
                .mec-modern-ticket-wrap .mec-modern-ticket-ticket-data-wrapper{
                    border-bottom: 1px solid #d1d2d3;
                    margin-bottom: 10px!important;
                }
                .mec-modern-ticket-wrap .mec-modern-ticket-event-data-wrapper,
                .mec-modern-ticket-wrap .mec-modern-ticket-ticket-data-wrapper {
                    display: flex;
                    flex-wrap: wrap;
                    flex-direction: column;
                    padding: 20px!important;
                }
                .mec-modern-ticket-wrap .mec-modern-ticket-ticket-data-wrapper > div{
                    margin-bottom: 20px!important;
                }
                .mec-modern-ticket-wrap .mec-modern-ticket-tcol2{
                    display: flex;
                    flex-wrap: wrap;
                    flex-direction: column;
                    justify-content: center;
                    align-content: center;
                    align-items: center;
                    padding: 15px!important;
                }
                .mec-modern-ticket-wrap .mec-modern-ticket-tcol2 img{
                    max-width: 50% !important;
                }
                .mec-modern-ticket-wrap .mec-modern-ticket-event-date-wrapper{
                    width: 100% !important;
                    max-width: 100% !important;
                    min-width: 100% !important;
                }
                .mec-modern-ticket-wrap .mec-modern-ticket-cut-col{
                    display: none !important;
                }
                .mec-modern-ticket-wrap .mec-modern-ticket-event-title{
                    font-size: 25px !important;
                }
                .mec-modern-ticket-wrap .mec-modern-ticket-f4box {
                    width: 100%!important;
                }
            }

               @media print {
                    .mec-invoice-title {
                        display: none !important;
                    }

                    .powered-by-mec {
                        display: none !important;
                    }

                    .mec-modern-ticket-body:last-of-type {
                        page-break-after:avoid !important;
                    }

                    .mec-invoice-event-featured-image {
                        display: none !important;
                    }

                    .mec-modern-ticket-wrap {
                        margin: 25px 0 !important;
                    }

                    .mec-invoice-items-table td.mec-invoice-item {
                        padding: 10px 2px !important;
                    }

                    .mec-invoice-body-half1 .mec-invoice-info, .mec-invoice-body-half1 .mec-invoice-organizer-title, .mec-invoice-items-w, .mec-invoice-header {
                        padding: 30px !important;
                    }
               }

             {{CustomStyle}}

               /*]]>*/
        </style>
    </head>
    <!--[if gte mso 9]>
        <xml>
            <o:OfficeDocumentSettings>
                <o:AllowPNG />
                <o:PixelsPerInch>96</o:PixelsPerInch>
            </o:OfficeDocumentSettings>
        </xml>
    <![endif]-->
    <!--[if !mso]><!-->
    <!--<![endif]-->
    <body class="wn-body" style="-ms-text-size-adjust: 100% !important; -webkit-font-smoothing: antialiased !important; -webkit-text-size-adjust: 100% !important; margin: 0px auto; padding: 0px;" bgcolor="#EDF0F3">
        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="wn-body-t" bgcolor="#ffffff" style="background-color: #ffffff; border-collapse: collapse; mso-table-lspace: 0px; mso-table-rspace: 0px;">
            <tr>
                <td style="padding: 0; vertical-align: top;" align="center" valign="top">
                    <!--[if (gte mso 9)|(IE)]>
            <table width="680" align="center" border="0" cellspacing="0" cellpadding="0">
               <tr>
                  <td width="680" align="center" valign="top">
                     <![endif]-->
                    <table align="center" border="0" cellspacing="0" cellpadding="0" class="mec-invoice-table-container" style="border-collapse: collapse; mso-table-lspace: 0px; mso-table-rspace: 0px; table-layout: fixed;">
                        <tr>
                            <td style="padding: 0 10px;">
                                <!-- Invoice Title -->
                                <div
                                    class="mec-invoice-title"
                                    style="
                                        margin: 45px 0 50px;
                                        background: #5d6165;
                                        border-radius: 12px;
                                        color: #fff;
                                        font-family: 'DM Sans', Roboto, sans-serif;
                                        font-size: 30px;
                                        font-weight: 700;
                                        text-align: left;
                                        padding: 20px 0px 20px 40px;
                                        line-height: 40px;
                                    "
                                >
                                    <span class="mec-invoice-nubber">{{InvoiceTitle}}</span>
                                    <span class="mec-invoice-buttons">
                                        <a
                                            class="mec-invoice-pdf-btn"
                                            style="text-decoration: none; color: #fff; font-size: 14px; padding: 0 35px; border-left: 1px solid #ffffff38; font-weight: 400; float: right; {{DownloadBtnStyles}}"
                                            href="{{PDFLink}}"
                                        >
                                            <img style="vertical-align: sub; margin-right: 6px;" src="https://img.icons8.com/material-sharp/18/ffffff/pdf-2.png" />
                                            [[Download PDF]]
                                        </a>
                                        <a
                                            class="mec-invoice-print-btn"
                                            style="text-decoration: none; color: #fff; font-size: 14px; padding: 0 35px; border-left: 1px solid #ffffff38; font-weight: 400; float: right; {{PrintButtonStyles}}"
                                            href="#"
                                        >
                                            <img style="vertical-align: sub; margin-right: 6px;" src="https://img.icons8.com/windows/18/ffffff/print.png" />
                                            [[Print]]
                                        </a>
                                        <a
                                            class="mec-invoice-print-and-download-btn"
                                            style="text-decoration: none; color: #fff; font-size: 14px; padding: 0 35px; border-left: 1px solid #ffffff38; font-weight: 400; float: right;{{PrintAndDownloadButtonStyles}}"
                                            href="{{InvoiceLink}}"
                                        >
                                            <img style="vertical-align: sub; margin-right: 6px;" src="https://img.icons8.com/windows/18/ffffff/print.png" />
                                            [[Print and Download]]
                                        </a>
                                    </span>
                                </div>
                                <div class="mec-invoice-tickets">
                                    {{Tickets}}
                                </div>
                            </td>
                        </tr>
                    </table>
                    <div class="powered-by-mec" style="padding: 10px 0 30px; text-align: center; color: #a1a2a3; font-family: 'DM Sans', Roboto, sans-serif; font-size: 12px; font-weight: 300;">
                        Powered by <a style="text-decoration: none; color: #a1a2a3;" href="https://webnus.net/modern-events-calendar/" target="_blank">Modern Events Calendar</a>
                    </div>
                </td>
            </tr>
        </table>
    </body>
</html>
