function mec_waiting_fields_option_listeners()
{
    jQuery('button.mec-waiting-field-add-option').off('click').on('click', function()
    {
        var field_id = jQuery(this).data('field-id');
        var key = jQuery('#mec_new_waiting_field_option_key_'+field_id).val();
        var html = jQuery('#mec_waiting_field_option').html().replace(/:i:/g, key).replace(/:fi:/g, field_id);

        jQuery('#mec_waiting_fields_'+field_id+'_options_container').append(html);
        jQuery('#mec_new_waiting_field_option_key_'+field_id).val(parseInt(key)+1);
    });

    if(typeof jQuery.fn.sortable !== 'undefined')
    {
        jQuery("#mec_waiting_form_fields").sortable(
        {
            handle: '.mec_waiting_field_sort'
        });

        jQuery(".mec_waiting_fields_options_container").sortable(
        {
            handle: '.mec_waiting_field_option_sort'
        });
    }
}

function mec_waiting_fields_option_remove(field_key, key)
{
    jQuery("#mec_waiting_fields_option_"+field_key+"_"+key).remove();
}

function mec_waiting_fields_remove(key)
{
    jQuery("#mec_waiting_fields_"+key).remove();
}


jQuery(document).ready(function($) {

    /* Load event dates in Report page */
    if ( $('.mec-reports-selectbox-event').length > 0 )
    {
        $('.mec-reports-selectbox-event').select2();
        $('.mec-reports-selectbox-event').on('change', function(e)
        {
            e.preventDefault();
            var id = $('.mec-reports-selectbox-event').val();
            $.ajax({
                url: mec_admin_localize.ajax_url,
                type: 'POST',
                data: {
                    action: 'report_event_dates',
                    nonce: mec_admin_localize.ajax_nonce,
                    event_id: id,
                },
                success: function (response) {
                    $('.mec-report-selected-event-attendees-wrap').hide();
                    $('.mec-reports-selectbox-dates').remove();
                    $('.mec-report-selected-event-attendees-wrap .w-row .w-col-sm-12').html('');
                    $('.mec-report-select-event-wrap .w-row .w-col-sm-12').append(response);
                    $('.mec-report-sendmail-wrap').hide();
                    $('.mec-report-backtoselect-wrap').hide();
                },
            });
        });
    }


    jQuery('[name="mec[waiting_form][waiting_form_id]"]').on("change", function() {
        if (jQuery(this).data("name") == "waiting_form_id") {
            jQuery("div#mec_waiting_form_container").removeClass("mec-util-hidden");
            jQuery("#waiting_form_id").addClass("mec-util-hidden");
        } else {
            jQuery("div#mec_waiting_form_container").addClass("mec-util-hidden");
            jQuery("#waiting_form_id").removeClass("mec-util-hidden");
            jQuery(this).val( jQuery("#waiting_form_id").val() );
        }
    });
    jQuery("#waiting_form_id").on("change", function() {
        jQuery("input[data-name=formBuilder_waiting_form_id]").val( jQuery(this).val() );
    })

    if ( typeof(mec_default_waiting_form_id) != "undefined" ) {
        jQuery("input[data-name=formBuilder_waiting_form_id]").prop("checked", true);
        jQuery("#waiting_form_id").removeClass("mec-util-hidden");
        jQuery("div#mec_waiting_form_container").addClass("mec-util-hidden");
        jQuery("input[data-name=formBuilder_waiting_form_id]").val( mec_default_waiting_form_id );
    } else {
        jQuery("input[data-name=waiting_form_id]").prop("checked", true);
    }

    $('#mec_waiting_form_field_types button').on('click', function()
    {
        var type = $(this).data('type');

        if (type == 'mec_email') {
            if ($('#mec_waiting_form_fields').find('input[value="mec_email"][type="hidden"]').length) {
                return false;
            }
        }

        if (type == 'name') {
            if ($('#mec_waiting_form_fields').find('input[value="name"][type="hidden"]').length) {
                return false;
            }
        }
        
        var key  = $('#mec_new_waiting_field_key').val();
        var html = $('#mec_waiting_field_'+type).html().replace(/:i:/g, key);

        $('#mec_waiting_form_fields').append(html);
        $('#mec_new_waiting_field_key').val(parseInt(key)+1);

        // Set onclick listener for add option fields
        mec_waiting_fields_option_listeners();
    });

    // Set onclick listener for add option fields
    mec_waiting_fields_option_listeners();
});
