<?php

namespace MEC_Waiting_List\Core;

use MEC\Settings\Settings;

class User extends \MEC_user{

    private static $instance;

	public static function instance() {

		if ( is_null( self::$instance ) ) {

			self::$instance = new self();
		}

		return self::$instance;
	}

    public function waiting($id){

        $mec_user_id = get_post_meta($id, 'mec_user_id', true);
        if(trim($mec_user_id) and is_numeric($mec_user_id)) {
            return $this->mec($mec_user_id);
        }

        return $this->wp(get_post($id)->post_author);
    }

    public function assign($waiting_id, $user_id){
        // Registration is disabled
        $registration = Settings::getInstance()->get_settings('waiting_registration');

        $registration = (bool) $registration;

        $user = get_user_by('ID', $user_id);
        if(!$registration && !$user) {

            update_post_meta($waiting_id, 'mec_user_id', $user_id);
        } else {

            update_post_meta($waiting_id, 'mec_user_id', 'wp');
        }
    }
}