<?php

namespace MEC_Waiting_List\Core\Admin;

/** no direct access **/
// defined('MECEXEC') or die();

/**
 * Webnus MEC books class.
 * @author Webnus <info@webnus.biz>
 */
class MEC_feature_report {
	public static $factory;
	public static $main;
	public static $PT;
	public static $class;


	/**
	 * Instance of this class.
	 *
	 * @since   1.0.0
	 * @access  public
	 * @var     MEC_Waiting_List
	 */
	public static $instance;

	/**
	 * The directory of the file.
	 *
	 * @access  public
	 * @var     string
	 */
	public static $dir;

	/**
	 * The Args
	 *
	 * @access  public
	 * @var     array
	 */
	public static $args;

	/**
	 * Provides access to a single instance of a module using the singleton pattern.
	 *
	 * @since   1.0.0
	 * @return  object
	 */
	public static function instance() {
		if (self::$instance === null) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Constructor method
	 * @author Webnus <info@webnus.biz>
	 */
	public function __construct() {
		add_action('init', function () {
			self::init($this);
		}, 10, 1);
	}

	public static function init($class) {

		// Import MEC Factory
		self::$factory = \MEC::getInstance('app.libraries.factory');

		// // Import MEC Main
		self::$main = \MEC::getInstance('app.libraries.main');

		// // MEC Book Post Type Name
		self::$PT = 'mec-waiting';

		add_action( 'admin_enqueue_scripts', array($class,'load_assets'), 11, 1 );

		self::$class = $class;
	}

	/**
	 * Initialize books feature
	 * @author Webnus <info@webnus.biz>
	 */
	public static function load_assets($class) {

		//Include Select2
		wp_enqueue_script('mec-select2-script');
		wp_enqueue_style('mec-select2-style');

		// Include MEC backend script file
		wp_enqueue_script('mec-backend-script');

		// Settings
		$settings = self::$main->get_settings();

		wp_localize_script('mec-backend-script', 'mec_admin_localize', array(
			'ajax_url' => admin_url('admin-ajax.php'),
			'ajax_nonce' => wp_create_nonce('mec_settings_nonce'),
			'mce_items' => self::$main->mce_get_shortcode_list(),
			'datepicker_format' => (isset($settings['datepicker_format']) and trim($settings['datepicker_format'])) ? trim($settings['datepicker_format']) : 'yy-mm-dd',
		));

		self::$factory->action('admin_menu', array($class, 'menus'), 10, 1);
		self::$factory->filter('mec_attendees_list_data', array($class, 'list_data'), 10, 3);
		return true;
	}

	public static function list_data($event_id, $attendees, $date) {

        $ref = isset($_SERVER['HTTP_REFERER'])?$_SERVER['HTTP_REFERER']:null;
        if(!$ref){
           return $attendees;
        }

        if(strpos("{$ref}", 'MEC-waiting-report')===false){
            return $attendees;
        }


		if (!count($attendees)) {
			return $attendees;
		}

		$waiting = get_posts(array(
			'posts_per_page' => -1,
			'post_type' => self::$PT,
			'post_status' => 'any',
			'meta_key' => 'mec_event_id',
			'meta_value' => $event_id,
			'meta_compare' => '=',
			'meta_query' => array
			(
				'relation' => 'AND',
				array(
					'key' => 'mec_verified',
					'value' => '1',
					'compare' => '=',
				),
				array(
					'key' => 'mec_confirmed',
					'value' => '1',
					'compare' => '=',
				),
				array(
					'key' => 'mec_date',
					'value' => "{$date}:",
					'compare' => 'like',
				),
			),
		));

		$ret = array();
		foreach ($waiting as $waite) {
			$atts = get_post_meta($waite->ID, 'mec_attendees', true);
			if (isset($atts['attachments'])) {
				unset($atts['attachments']);
			}

			foreach ($atts as $key => $value) {
				if (!is_numeric($key)) {
					continue;
				}

				$atts[$key]['book_id'] = $waite->ID;
				$atts[$key]['key'] = ($key + 1);
			}

			$ret = array_merge($ret, $atts);
		}

		return $ret;
	}

	public static function menus() {
		add_submenu_page('mec-intro', __('MEC - Waiting Report', 'mec-waiting-list'), __('Waiting Report', 'mec-waiting-list'), 'manage_options', 'MEC-waiting-report', array(self::$class, 'report'), 13);
	}

	public static function report() {

		$path = MECWAITINGLISTDIR . DS . 'core' . DS . 'ui' . DS . 'report.php';

		$options = self::$main->get_options();
		$styling = (isset($options['styles']) ? $options['styles'] : array());

		ob_start();
		include $path;
		$output = ob_get_clean();
		echo $output;

	}
}