<?php

namespace MEC_Waiting_List\Core;
// don't load directly.
if (!defined('ABSPATH')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit;
}
/**
 * Loader.
 *
 * @author      author
 * @package     package
 * @since       1.0.0
 */
class Loader
{

    /**
     * Instance of this class.
     *
     * @since   1.0.0
     * @access  public
     * @var     MEC_Invoice
     */
    public static $instance;

    /**
     * The directory of the file.
     *
     * @access  public
     * @var     string
     */
    public static $dir;

    /**
     * Provides access to a single instance of a module using the singleton pattern.
     *
     * @since   1.0.0
     * @return  object
     */
    public static function instance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }


    public function __construct()
    {
        self::settingUp();
        self::preLoad();
        self::setHooks();
        self::registerAutoloadFiles();
        self::loadInits();
    }

    /**
     * Global Variables.
     *
     * @since   1.0.0
     */
    public static function settingUp()
    {
        self::$dir     = MECWAITINGLISTDIR . 'core';
    }

    /**
     * Hooks
     *
     * @since     1.0.0
     */
    public static function setHooks()
    {
        add_action('admin_init', function () {
            \MEC_Waiting_List\Autoloader::load('MEC_Waiting_List\Core\checkLicense\WaitingListAddonUpdateActivation');
        });
    }

    /**
     * preLoad
     *
     * @since     1.0.0
     */
    public static function preLoad()
    {
        include_once self::$dir . DS . 'autoloader' . DS . 'autoloader.php';
    }

    /**
     * Register Autoload Files
     *
     * @since     1.0.0
     */
    public static function registerAutoloadFiles()
    {
        if (!class_exists('\MEC_Waiting_List\Autoloader')) {
            return;
        }

        \MEC_Waiting_List\Autoloader::addClasses(
            [
                'MEC_Waiting_List\\Core\\Base\\MEC_feature_waiting' => self::$dir . '/base/waiting.php',
                'MEC_Waiting_List\\Core\\Admin\\MecAdmin' => self::$dir . '/admin/admin.php',
                'MEC_Waiting_List\\Core\\Admin\\MEC_feature_report' => self::$dir . '/admin/report.php',

                'MEC_Waiting_List\\Core\\Ui\\MecUi' => self::$dir . '/ui/ui.php',

                'MEC_Waiting_List\\Core\\checkLicense\\WaitingListAddonUpdateActivation' => self::$dir . '/checkLicense/update-activation.php',

                'MEC_Waiting_List\\Core\\User' => self::$dir . '/User.php',
                'MEC_Waiting_List\\Core\\ShortcodeWaitingList' => self::$dir . '/ShortcodeWaitingList.php',

            ]
        );
    }

    /**
     * Load Init
     *
     * @since     1.0.0
     */
    public static function loadInits()
    {
        $options = get_option('mec_options', array());
		if (isset($options['settings']) && isset($options['settings']['booking_status']) && $options['settings']['booking_status'] == 1) {

            \MEC_Waiting_List\Autoloader::load('MEC_Waiting_List\Core\Base\MEC_feature_waiting');
            \MEC_Waiting_List\Autoloader::load('MEC_Waiting_List\Core\Admin\MecAdmin');
            \MEC_Waiting_List\Autoloader::load('MEC_Waiting_List\Core\Admin\MEC_feature_report');

            \MEC_Waiting_List\Autoloader::load('MEC_Waiting_List\Core\Ui\MecUi');
        }
    }
} //Loader

Loader::instance();
