<?php

namespace MEC_Waiting_List\Core\Base;

use MEC_Waiting_List\Core\User;
use MEC_Waiting_List\Core\ShortcodeWaitingList;

/** no direct access **/
// defined('MECEXEC') or die();

/**
 * Webnus MEC books class.
 * @author Webnus <info@webnus.biz>
 */
class MEC_feature_waiting {
	public static $factory;
	public static $main;
	public static $db;
	public static $book;
	public static $PT;
	public static $PT_BOOK;
	public static $settings;
	public static $thus;

	/**
	 * Instance of this class.
	 *
	 * @since   1.0.0
	 * @access  public
	 * @var     MEC_Waiting_List
	 */
	public static $instance;

	/**
	 * The directory of the file.
	 *
	 * @access  public
	 * @var     string
	 */
	public static $dir;

	/**
	 * The Args
	 *
	 * @access  public
	 * @var     array
	 */
	public static $args;

	/**
	 * Provides access to a single instance of a module using the singleton pattern.
	 *
	 * @since   1.0.0
	 * @return  object
	 */
	public static function instance() {
		if (self::$instance === null) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Constructor method
	 * @author Webnus <info@webnus.biz>
	 */
	public function __construct() {
		add_action('init', function () {
			self::init($this);
		}, 10, 1);
	}

	public static function init($class) {

		// Import MEC Factory
		self::$factory = \MEC::getInstance('app.libraries.factory');

		// // Import MEC Main
		self::$main = \MEC::getInstance('app.libraries.main');

		// // Import MEC DB
		self::$db = \MEC::getInstance('app.libraries.db');

		// // Import MEC Book
		self::$book = \MEC::getInstance('app.libraries.book');

		// // MEC Book Post Type Name
		self::$PT = 'mec-waiting';
		self::$PT_BOOK = 'mec-books';

		// // MEC Settings
		self::$settings = self::$main->get_settings();

		self::load($class);

		$action = isset($_GET['mecwaiteaction']) ? $_GET['mecwaiteaction'] : null;
		if ($action == 'trash') {
			$ids = isset($_GET['ids']) ? explode(',', $_GET['ids']) : array();
			self::send_to_trash($ids);
		}
	}

	public static function getPRO() {
		return \MEC::getInstance(base64_decode('YXBwLmxpYnJhcmllcy5wcm8='));
	}

	/**
	 * Initialize books feature
	 * @author Webnus <info@webnus.biz>
	 */
	public static function load($class) {

		self::register_post_type();
		self::$factory->action('add_meta_boxes_' . self::$PT, array($class, 'remove_taxonomies_metaboxes'));

		self::$factory->action('save_post', array($class, 'save_waiting'), 10);
		self::$factory->action('save_post', array($class, 'change_tickets_count_handler'), 9999);

		self::$factory->action('add_meta_boxes', array($class, 'register_meta_boxes'), 1);
		self::$factory->action('restrict_manage_posts', array(__CLASS__, 'add_filters'));
		self::$factory->action('wp_ajax_mec_waiting_filters_occurrence', array($class, 'add_occurrence_filter_ajax'));

		// // Details Meta Box
		self::$factory->action('mec_waiting_metabox_details', array($class, 'meta_box_nonce'), 10);
		self::$factory->action('mec_waiting_metabox_details', array($class, 'meta_box_waiting_form'), 10);
		self::$factory->action('mec_waiting_metabox_details', array($class, 'meta_box_waiting_info'), 10);

		self::$factory->action('mec_booking_canceled', array(__CLASS__, 'process_waiting'), 10);
		self::$factory->action('mec_booking_rejected', array(__CLASS__, 'process_waiting'), 10);
		self::$factory->action('mec_book_edit_after', array(__CLASS__, 'process_waiting'), 10);

		// // Status Meta Box
		self::$factory->action('mec_waiting_metabox_status', array($class, 'meta_box_status_form'), 10);

		// // Invoice Meta Box
		self::$factory->action('mec_waiting_metabox_status', array($class, 'meta_box_invoice'), 10);

		self::$factory->action('pre_get_posts', array(__CLASS__, 'filter_query'));
		self::$factory->filter('manage_' . self::$PT . '_posts_columns', array($class, 'filter_columns'));
		self::$factory->filter('manage_edit-' . self::$PT . '_sortable_columns', array($class, 'filter_sortable_columns'));
		self::$factory->filter('mec_verified_value', array(__CLASS__, 'mec_verified_value'), 1, 2);
		self::$factory->action('manage_' . self::$PT . '_posts_custom_column', array($class, 'filter_columns_content'), 10, 2);

		// // Waiting Actions
		self::$factory->action('admin_footer-edit.php', array($class, 'add_bulk_actions'));
		self::$factory->action('load-edit.php', array($class, 'do_bulk_actions'));

		// // Waiting Event form
		self::$factory->action('wp_ajax_mec_waiting_form', array(__CLASS__, 'waiting'));
		self::$factory->action('wp_ajax_mec_waiting_form_upload_file', array(__CLASS__, 'waiting'));
		self::$factory->action('wp_ajax_nopriv_mec_waiting_form', array(__CLASS__, 'waiting'));

		// // Waiting Event form Submit
		self::$factory->action('wp_ajax_mec_waiting_form_submit', array($class, 'waiting_submit'));
		self::$factory->action('wp_ajax_nopriv_mec_waiting_form_submit', array($class, 'waiting_submit'));

		// Tickets Availability
		self::$factory->action('wp_ajax_mec_tickets_availability', array($class, 'tickets_availability'));
		self::$factory->action('wp_ajax_nopriv_mec_tickets_availability', array($class, 'tickets_availability'));

		self::$factory->action('mec_booking_sold_out', array(__CLASS__, 'booking_sold_out'), 10, 4);
		self::$factory->action('wp_ajax_mec_waiting_content', array($class, 'waiting_content'));
		self::$factory->action('wp_ajax_nopriv_mec_waiting_content', array($class, 'waiting_content'));

		self::$factory->action('mec_waiting_completed', array($class, 'email_verification'), 10);
		self::$factory->action('mec_waiting_confirmated', array($class, 'email_confimation'), 10, 2);

		self::$factory->shortcode('waiting_notif_page', array(__CLASS__, 'email_notif_content'));
		self::$factory->action('transition_post_status', array(__CLASS__, 'post_status'), 10, 3);

		self::$factory->action('trashed_post', array($class, 'trash_booking'), 10, 3);


		add_filter('mec_notification_reg_fields', array(__CLASS__, 'replace_notification_reg_fields'), 10, 3);
		add_filter('mec_bookign_reg_form', array(__CLASS__, 'booking_reg_form'), 10, 3);

		add_shortcode( 'mec-my-waiting-list', [ ShortcodeWaitingList::class, 'render' ] );

		self::$thus = $class;

		return true;
	}

	public static function booking_reg_form($reg_form, $event_id, $post) {

		if( empty( $post ) ){
			return $reg_form;
		}
		$meta = get_post_meta($post->ID, 'mec_booking_by_waiting', true);
		if ($meta == 1) {
			return self::get_waite_fields($event_id);
		}
		return $reg_form;
	}

	public static function replace_notification_reg_fields($reg_form, $event_id, $post_id) {

		if( 'mec-waiting' !== get_post_type( $post_id ) ){

			return $reg_form;
		}

		return self::get_waite_fields($event_id);
	}

	public static function post_status($new, $old, $post) {
		if ("{$post->post_type}" != 'mec-books') {
			return;
		}

		if ("{$new}" == "{$old}") {
			return;
		}

		if ("{$new}" == 'publish') {
			return;
		}
		if ("{$new}" == 'trash') {
			self::process_waiting($post->ID);
		}
	}

	public static function email_notif_content() {
		$verify = isset($_GET['waiteverify']) ? $_GET['waiteverify'] : null;
		$cancel = isset($_GET['waitecancel']) ? $_GET['waitecancel'] : null;
		if (isset($verify)):
		?>
		<div class="mec-wrap  clearfix" id="mec_skin_verify">
        <article class="row mec-single-event">
        <div class="col-md-8">
            <div class="mec-events-event-image"></div>
            <div class="mec-event-content">
            	<?php
		$res = self::verify_user_waiting($verify);
		if ($res == 1) {
			?>
            		<div class="mec-sold-tickets warning-msg" style="background-color: #c2f0bb">
            		<?php _e('Success Verify Waiting', 'mec-waiting-list');?>
            		</div>
            	<?php } elseif ($res == 2) {?>
					<div class="mec-sold-tickets warning-msg" style="background-color: #f5e9d0">
            		<?php _e('Already verified the booking waiting', 'mec-waiting-list');?>
            		</div>
            	<?php } else {?>
            	<div class="mec-sold-tickets warning-msg">
            		<?php _e('Verify Link is wrong!', 'mec-waiting-list');?>
            	</div>
            <?php }?>
            </div>
        </div>
    	</article>
    	</div>
		<?php else: ?>
		<div class="mec-wrap  clearfix" id="mec_skin_cancel">
        <article class="row mec-single-event">
        <div class="col-md-8">
            <div class="mec-events-event-image"></div>
            <div class="mec-event-content">
            	<?php
		$res = self::cancel_user_waiting($cancel);
		if ($res == 1) {
			?>
            		<div class="mec-sold-tickets warning-msg" style="background-color: #c2f0bb">
            		<?php _e('Canceled Waiting', 'mec-waiting-list');?>
            		</div>
            	<?php } elseif ($res == 2) {?>
					<div class="mec-sold-tickets warning-msg" style="background-color: #f5e9d0">
            		<?php _e('Already canceled the booking waiting', 'mec-waiting-list');?>
            		</div>
            	<?php } else {?>
            	<div class="mec-sold-tickets warning-msg">
            		<?php _e('Cancel link invalid!', 'mec-waiting-list');?>
            	</div>
            <?php }?>
            </div>
        </div>
    	</article>
    	</div>
    	<?php
	endif;
	}

	public static function cancel_user_waiting($cancel) {
		$query = new \WP_Query(
			array(
				'post_type' => self::$PT,
				'meta_query' => array(
					array(
						'key' => 'mec_cancellation_key',
						'value' => $cancel,
						'compare' => '=',
					),
				),
				'post_status' => array('publish', 'pending', 'draft', 'future', 'private', 'trash'),
			)
		);

		if (!$query->found_posts) {
			return false;
		}

		$mec_canceled = get_post_meta($query->post->ID, 'mec_canceled', true);
		if ($mec_canceled == 1) {
			return 2;
		}

		update_post_meta($query->post->ID, 'mec_canceled', 1);
		wp_trash_post($query->post->ID);
		return 1;
	}

	public static function verify_user_waiting($verify) {
		$query = new \WP_Query(
			array(
				'post_type' => self::$PT,
				'meta_query' => array(
					array(
						'key' => 'mec_verification_key',
						'value' => $verify,
						'compare' => '=',
					),
				),
				'post_status' => 'publish',
			)
		);

		if (!$query->found_posts) {
			error_log('Cannot found post');
			return false;
		}

		$mec_verified = get_post_meta($query->post->ID, 'mec_verified', true);
		if ($mec_verified == 1) {
			return 2;
		}

		update_post_meta($query->post->ID, 'mec_verified', 1);
		return 1;
	}

	/**
	 * Waiting Send email verification notification
	 * @author Webnus <info@webnus.biz>
	 * @param int $waite_id
	 * @return boolean
	 */
	public function email_verification($waite_id) {
		$waiter_id = get_post_field('post_author', $waite_id);
		$waiter = get_userdata($waiter_id);

		$notif_settings = self::$main->get_notifications();
		$settings = self::$main->get_settings();
		$notification = \MEC::getInstance('app.libraries.notifications');

		$enable = isset($notif_settings['waiting_verification']['enable']) && $notif_settings['waiting_verification']['enable'] != '1' ? false : true;
		if (!$enable) {
			return true;
		}

		if (!isset($waiter->user_email)) {
			return false;
		}

		// Auto verification for free bookings is enabled so don't send the verification email
		if (isset($settings['waiting_verified']) and $settings['waiting_verified'] == 1) {
			return false;
		}

		$subject = isset($notif_settings['waiting_verification']['subject']) ? $notification->content(__($notif_settings['waiting_verification']['subject'], 'mec-waiting-list'), $waite_id) : __('Please verify your email.', 'mec-waiting-list');
		$headers = array('Content-Type: text/html; charset=UTF-8');

		$recipients_str = isset($notif_settings['waiting_verification']['recipients']) ? $notif_settings['waiting_verification']['recipients'] : '';
		$recipients = trim($recipients_str) ? explode(',', $recipients_str) : array();

		$users = isset($notif_settings['waiting_verification']['receiver_users']) ? $notif_settings['waiting_verification']['receiver_users'] : array();
		$users_down = self::$main->get_emails_by_users($users);
		$recipients = array_merge($users_down, $recipients);

		$roles = isset($notif_settings['waiting_verification']['receiver_roles']) ? $notif_settings['waiting_verification']['receiver_roles'] : array();
		$user_roles = self::$main->get_emails_by_roles($roles);
		$recipients = array_merge($user_roles, $recipients);

		// Unique Recipients
		$recipients = array_unique($recipients);

		foreach ($recipients as $recipient) {
			// Skip if it's not a valid email
			if (trim($recipient) == '' or !filter_var($recipient, FILTER_VALIDATE_EMAIL)) {
				continue;
			}

			$headers[] = 'BCC: ' . $recipient;
		}

		// Attendees
		$attendees = get_post_meta($waite_id, 'mec_attendees', true);
		if (!is_array($attendees) or (is_array($attendees) and !count($attendees))) {
			$attendees = array(get_post_meta($waite_id, 'mec_attendee', true));
		}

		// Do not send email twice!
		$done_emails = array();

		// Waite Data
		$key = get_post_meta($waite_id, 'mec_verification_key', true);
		$event_id = get_post_meta($waite_id, 'mec_event_id', true);

		$notif_page = isset($settings['waiting_notif_page']) ? $settings['waiting_notif_page'] : $event_id;

		$link = get_permalink($notif_page);
		$link = add_query_arg('waiteverify', $key, $link);

		// Changing some sender email info.
		$notification->mec_sender_email_notification_filter();

		// Set Email Type to HTML
		add_filter('wp_mail_content_type', array(self::$main, 'html_email_type'));

		// Send the emails
		foreach ($attendees as $attendee) {
			$to = isset($attendee['email']) ? $attendee['email'] : '';
			if (!trim($to) or in_array($to, $done_emails) or !filter_var($to, FILTER_VALIDATE_EMAIL)) {
				continue;
			}

			$message = isset($notif_settings['waiting_verification']['content']) ? $notification->content($notif_settings['waiting_verification']['content'], $waite_id, $attendee) : '';
			$message = str_replace('%%verification_link%%', $link, $message);
			$message = str_replace('%%link%%', $link, $message);

			$message = $notification->add_template($message);

			// Filter the email
			$mail_arg = array(
				'to' => $to,
				'subject' => $subject,
				'message' => $message,
				'headers' => $headers,
				'attachments' => array(),
			);

			$mail_arg = apply_filters('mec_before_send_email_verification', $mail_arg, $waite_id, 'waiting_verification');

			// Send the mail
			wp_mail($mail_arg['to'], html_entity_decode(stripslashes($mail_arg['subject']), ENT_HTML5), wpautop(stripslashes($mail_arg['message'])), $mail_arg['headers'], $mail_arg['attachments']);
			// For prevention of email repeat send
			$done_emails[] = $to;
		}

		// Remove the HTML Email filter
		remove_filter('wp_mail_content_type', array(self::$main, 'html_email_type'));

		return true;
	}

	/**
	 * Waiting Send email confirmation notification
	 * @author Webnus <info@webnus.biz>
	 * @param int $waite_id
	 * @param string $mode
	 * @return boolean
	 */
	public function email_confimation($waite_id, $mode = 'manually') {

		$waiter_id = get_post_field('post_author', $waite_id);
		$waiter = get_userdata($waiter_id);

		$notif_settings = self::$main->get_notifications();
		$settings = self::$main->get_settings();
		$notification = \MEC::getInstance('app.libraries.notifications');

		$enable = isset($notif_settings['waiting_confirmation']['enable']) && $notif_settings['waiting_confirmation']['enable'] != '1' ? false : true;
		if (!$enable) {
			return true;
		}

		if (!isset($waiter->user_email)) {
			return false;
		}

		// Auto verification for waiting is enabled so don't send the confirmation email
		$auto_confirm = isset($settings['waiting_confirmation']) && $settings['waiting_confirmation'] === '1' ? true : false;
		$auto_confirm_send_email = isset($settings['waiting_auto_confirm_send_email']) && $settings['waiting_auto_confirm_send_email'] === '1' ? true : false;
		if (
			( $auto_confirm && 'manually' === $mode )
			||
			( $auto_confirm && 'auto' === $mode && !$auto_confirm_send_email )
			 ) {
			return false;
		}

		// Waite Data
		$cancel_key = get_post_meta($waite_id, 'mec_cancellation_key', true);
		$notif_page = isset($settings['waiting_notif_page']) ? $settings['waiting_notif_page'] : $waite_id;
		$cancel_link = get_permalink($notif_page);
		$cancel_link = add_query_arg('waitecancel', $cancel_key, $cancel_link);

		$subject = isset($notif_settings['waiting_confirmation']['subject']) ? $notification->content(__($notif_settings['waiting_confirmation']['subject'], 'mec-waiting-list'), $waite_id) : __('Your waiting status is confirmed.', 'mec-waiting-list');
		$headers = array('Content-Type: text/html; charset=UTF-8');

		$recipients_str = isset($notif_settings['waiting_confirmation']['recipients']) ? $notif_settings['waiting_confirmation']['recipients'] : '';
		$recipients = trim($recipients_str) ? explode(',', $recipients_str) : array();

		$users = isset($notif_settings['waiting_confirmation']['receiver_users']) ? $notif_settings['waiting_confirmation']['receiver_users'] : array();
		$users_down = self::$main->get_emails_by_users($users);
		$recipients = array_merge($users_down, $recipients);

		$roles = isset($notif_settings['waiting_confirmation']['receiver_roles']) ? $notif_settings['waiting_confirmation']['receiver_roles'] : array();
		$user_roles = self::$main->get_emails_by_roles($roles);
		$recipients = array_merge($user_roles, $recipients);

		// Unique Recipients
		$recipients = array_unique($recipients);

		foreach ($recipients as $recipient) {
			// Skip if it's not a valid email
			if (trim($recipient) == '' or !filter_var($recipient, FILTER_VALIDATE_EMAIL)) {
				continue;
			}

			$headers[] = 'BCC: ' . $recipient;
		}

		// Attendees
		$attendees = get_post_meta($waite_id, 'mec_attendees', true);
		if (!is_array($attendees) or (is_array($attendees) and !count($attendees))) {
			$attendees = array(get_post_meta($waite_id, 'mec_attendee', true));
		}

		// Do not send email twice!
		$done_emails = array();

		// Changing some sender email info.
		$notification->mec_sender_email_notification_filter();

		// Set Email Type to HTML
		add_filter('wp_mail_content_type', array(self::$main, 'html_email_type'));

		// Send the emails
		foreach ($attendees as $attendee) {
			$to = isset($attendee['email']) ? $attendee['email'] : '';
			if (!trim($to) or in_array($to, $done_emails) or !filter_var($to, FILTER_VALIDATE_EMAIL)) {
				continue;
			}

			$message = isset($notif_settings['waiting_confirmation']['content']) ? $notification->content($notif_settings['waiting_confirmation']['content'], $waite_id, $attendee) : '';
			$message = str_replace('%%waiting_cancellation_link%%', $cancel_link, $message);
			$message = $notification->add_template($message);
			// Filter the email
			$mail_arg = array(
				'to' => $to,
				'subject' => $subject,
				'message' => $message,
				'headers' => $headers,
				'attachments' => array(),
			);

			$mail_arg = apply_filters('mec_before_send_email_confirmation', $mail_arg, $waite_id, 'waiting_confirmation');

			// Send the mail
			wp_mail($mail_arg['to'], html_entity_decode(stripslashes($mail_arg['subject']), ENT_HTML5), wpautop(stripslashes($mail_arg['message'])), $mail_arg['headers'], $mail_arg['attachments']);

			// For prevention of email repeat send
			$done_emails[] = $to;
		}

		// Remove the HTML Email filter
		remove_filter('wp_mail_content_type', array(self::$main, 'html_email_type'));

		return true;
	}

	/**
	 * Registers books post type and assign it to some taxonomies
	 * @author Webnus <info@webnus.biz>
	 */
	public static function register_post_type() {
		register_post_type(self::$PT,
			array(
				'labels' => array
				(
					'name' => __('Waiting List', 'mec-waiting-list'),
					'singular_name' => __('Waiting List', 'mec-waiting-list'),
					'add_new' => __('Add Waiting List', 'mec-waiting-list'),
					'add_new_item' => __('Add Waiting List', 'mec-waiting-list'),
					'not_found' => __('No found!', 'mec-waiting-list'),
					'all_items' => __('Waiting List', 'mec-waiting-list'),
					'edit_item' => __('Edit Waiting List', 'mec-waiting-list'),
					'not_found_in_trash' => __('No found in Trash!', 'mec-waiting-list'),
				),
				'public' => false,
				'show_ui' => (current_user_can('edit_others_posts') ? true : false),
				'show_in_menu' => true,
				'show_in_admin_bar' => false,
				'has_archive' => false,
				'exclude_from_search' => true,
				'publicly_queryable' => false,
				'menu_icon' => MECWAITINGLISTASSETS . '/img/mec-waiting.svg',
				'menu_position' => 28,
				'supports' => array('title', 'author'),
				'capabilities' => array
				(
					'read_post' => 'edit_dashboard',
					'create_posts' => 'manage_options',
				),
				'map_meta_cap' => true,
			)
		);
	}

	public static function waiting_queue_remove($event_id, $ticket_id, $date, $count = 1) {

		$q_args = array(
			'post_type' => self::$PT,
			'orderby' => 'ID',
			'posts_per_page' => '-1',
			'order' => 'ASC',
			'meta_query' => array(
				array(
					'key' => 'mec_event_id',
					'value' => $event_id,
					'compare' => '=',
				),
				array(
					'key' => 'mec_ticket_id',
					'value' => $ticket_id,
					'compare' => '=',
				),
				array(
					'key' => 'mec_verified',
					'value' => 1,
					'compare' => '=',
				),
				array(
					'key' => 'mec_confirmed',
					'value' => 1,
					'compare' => '=',
				),
				array(
					'key' => 'mec_attendees_count',
					'value' => $count == 1 ? array('1', '1') : array('1', $count),
					'compare' => 'BETWEEN',
				),
			),
			'post_status' => 'publish',
		);

		if( $date ){

			$q_args['meta_query']['date'] = array(
				'key' => 'mec_date',
				'value' => $date,
				'compare' => '=',
			);
		}

		$query = new \WP_Query( $q_args );

		if ($query->found_posts == 0) {
			return false;
		}

		$posts = $query->get_posts();

		return $posts;

	}

	/**
	 * checked loop from cancel
	 * 1: the first loop of cancel
	 * 2. loop 2 for cance
	 * on value==2 remove the meta and clear, ready to manual cance
	 * @param  integer $verify  base state
	 * @param  integer $book_id booking id
	 * @return integer          0:cance of submit canceled, other: ready to cancel
	 */
	public static function mec_verified_value($verify, $book_id) {
		$mec_from_waiting = get_post_meta($book_id, 'mec_from_waiting', true);

		if ($mec_from_waiting == 1) {
			update_post_meta($book_id, 'mec_from_waiting', 2);
			return 0;
		} else if ($mec_from_waiting == 2) {
			delete_post_meta($book_id, 'mec_from_waiting');
			return 0;
		}
		return $verify;
	}

	public static function send_to_trash($ids) {

		if (count($ids) > 0) {

			foreach ($ids as $waite_id) {
				$is_trash = get_post_meta($waite_id, 'waite_direct_trash', true);
				if ($is_trash != '1') {
					error_log('the trash is not submit!' . $waite_id);
					continue;
				}

				wp_trash_post($waite_id);
			}
		}
		$url = admin_url('/edit.php?post_type=mec-waiting');
		if (wp_redirect($url, 302, 'WordPress')) {
			exit();
		}

	}

	public static function remove_save_book_action(){
		global $wp_filter;
		$all_actions =  $wp_filter['save_post'];;
		foreach($all_actions as $priority => $actions){

			foreach($actions as $action_key => $callback){
				if(false === strpos($action_key,'save_book')){

					continue;
				}

				if(isset($callback['function'][0]) && is_a($callback['function'][0],'MEC_feature_books')){

					remove_action('save_post',array($callback['function'][0],'save_book'));
				}
				// wp_die(print_r($callback['function']));
			}
		}
	}

	public static function process_waiting($book_id, $direct_call = false) {
		$event_id = get_post_meta($book_id, 'mec_event_id', true);

		$id = $event_id;
		$render = \MEC::getInstance('app.libraries.render');
		$rendered = $render->data($event_id, '');

		$event = new \stdClass();
		$event->ID = $event_id;
		$event->data = $rendered;

		$date_meta = get_post_meta($book_id, 'mec_date', true);
		$ticket_id = get_post_meta($book_id, 'mec_ticket_id', true);

		if (!is_numeric($ticket_id)) {
			$t = explode(',', $ticket_id);
			foreach ($t as $tid) {
				if (is_numeric($tid)) {
					$ticket_id = $tid;
					break;
				}
			}
		}

		$user_in_waiting = self::user_in_waiting($event, $ticket_id);
		if ($user_in_waiting == 0) {
			// waiting list is empty or not verify,confirm of waitings in ticket
			return;
		}

		$date_ex = explode(':', $date_meta);
		$occurrence_time = (int) $date_ex[0];
		$event_id = $event->ID;
		$tickets = isset($event->data->tickets) ? $event->data->tickets : array();
		$default_ticket_number = 0;
		if (count($tickets) == 1) {
			$default_ticket_number = 1;
		}

		$book = \MEC::getInstance('app.libraries.book');
		$availability = $book->get_tickets_availability($event_id, $occurrence_time);
		if ($availability[$ticket_id] <= 0) {
			// ticket avalable not process!
			return;
		}

		$available = $availability[$ticket_id];

		$waites = self::waiting_queue_remove($event_id, $ticket_id, $date_meta, $available);
		if ($waites == false) {
			// Cannot find waiting in ticket
			return;
		}
		$settings = self::$main->get_settings();

		// Initialize Pay Locally Gateway to handle the booking
		$gateway = new \MEC_gateway_pay_locally();

		$redirect = false;
		$trashed_ids = array();

		if ( has_action( 'mec_waiting_process_waiting_custom_action' ) ) {

			do_action( 'mec_waiting_process_waiting_custom_action', $waites );
			return;
		}

		foreach ($waites as $k => $waite) {
			$waite->attendees_count = get_post_meta($waite->ID, 'mec_attendees_count', true);
			if ($waite->attendees_count > $available) {
				continue;
			}
			if ($available <= 0) {
				break;
			}
			$available = $available - $waite->attendees_count;
			$user = User::instance()->waiting($waite->ID);
			if (!$user) {
				continue;
			}
			$email = $user->data->user_email;
			$mec_attendees = get_post_meta($waite->ID, 'mec_attendees');
			$mec_attendees = $mec_attendees[0];
			$attendees_count = get_post_meta($waite->ID, 'mec_attendees_count', true);
			$mec_price = get_post_meta($waite->ID, 'mec_price', true);
			$mec_date = get_post_meta($waite->ID, 'mec_date', true);
			$date_e = explode(':', $mec_date);
			$transaction = array();
			$transaction['tickets'] = $mec_attendees;
			$transaction['date'] = $mec_date;
			$transaction['event_id'] = $event_id;
			$all_dates = array($mec_date);
			$raw_tickets = array($ticket_id => $attendees_count);
			$event_tickets = get_post_meta($event_id, 'mec_tickets', true);
			$ticket_ids = array();
			for ($i = 0; $i < $attendees_count; $i++) {
				array_push($ticket_ids, $ticket_id);
			}
			$price_details = self::$book->get_price_details($raw_tickets, $event_id, $event_tickets, array(), $all_dates);
			$transaction['price_details'] = $price_details;
			$transaction['total'] = $price_details['total'];
			$transaction['discount'] = 0;
			$transaction['price'] = $price_details['total'];
			$transaction['coupon'] = NULL;
			$transaction_id = self::$book->temporary($transaction);
			update_option($transaction_id, $transaction, false);
			$meta = array(
				'mec_waiting_verified' => 0,
				'mec_waiting_confirmed' => 0,
				'mec_from_waiting' => 1,
				'mec_booking_by_waiting' => 1,
			);
			$ins_book = $book->add(
				array(
					'post_author' => $user->ID,
					'post_type' => self::$PT_BOOK,
					'post_title' => $waite->post_title,
					'post_date' => date('Y-m-d H:i:s', strtotime($mec_date)),
					'post_status' => 'publish',
					'attendees_info' => array($email => array('count' => $attendees_count)),
					'mec_attendees' => $mec_attendees,
					'mec_gateway' => 'MEC_gateway_pay_locally',
					'mec_gateway_label' => $gateway->label(),
				),
				$transaction_id,
				',' . implode(',', $ticket_ids) . ','
			);
			if (!$ins_book) {
				return;
			}

			foreach ($meta as $meta_key => $meta_value) {
				update_post_meta($ins_book, $meta_key, $meta_value);
			}

			remove_action('mec_booking_rejected', array(self::$thus, 'process_waiting'));
			remove_action('mec_booking_canceled', array(self::$thus, 'process_waiting'));
			self::remove_save_book_action();

			if ($direct_call == false) {
				wp_trash_post($waite->ID);
			} else {
				array_push($trashed_ids, $waite->ID);
				update_post_meta($waite->ID, 'waite_direct_trash', '1');
			}

			update_post_meta($waite->ID, 'mec_waite_to_booking', array(
				'booking_id' => $ins_book,
				'date' => time(),
			));

			global $mec_create_booking_from_waiting;
			$mec_create_booking_from_waiting = true;

			do_action('mec_booking_completed', $ins_book);
			$redirect = true;
		}

		$url = admin_url('/edit.php?post_type=mec-waiting&mecwaiteaction=trash&ids=' . implode(',', $trashed_ids));

		if ($redirect == true && $direct_call == true && wp_redirect($url, 302, 'WordPress')) {
			exit();
		}

	}

	/**
	 * Remove normal meta boxes for some taxonomies
	 * @author Webnus <info@webnus.biz>
	 */
	public function remove_taxonomies_metaboxes() {
		remove_meta_box('tagsdiv-mec_coupon', self::$PT, 'side');
	}

	/**
	 * Registers 2 meta boxes for book data
	 * @author Webnus <info@webnus.biz>
	 */
	public function register_meta_boxes() {
		add_meta_box('mec_waiting_metabox_details', __('Waiting Details', 'mec-waiting-list'), array($this, 'meta_box_details'), self::$PT, 'normal', 'high');
		add_meta_box('mec_waiting_metabox_status', __('Status & Invoice', 'mec-waiting-list'), array($this, 'meta_box_status'), self::$PT, 'side', 'default');
	}

	/**
	 * Show content of status meta box
	 * @author Webnus <info@webnus.biz>
	 * @param object $post
	 */
	public function meta_box_status($post) {
		do_action('mec_waiting_metabox_status', $post);
	}

	/**
	 * Show confirmation form
	 * @author Webnus <info@webnus.biz>
	 * @param $post
	 */
	public function meta_box_status_form($post) {
		$confirmed = get_post_meta($post->ID, 'mec_confirmed', true);
		$event_id = get_post_meta($post->ID, 'mec_event_id', true);
		$verified = get_post_meta($post->ID, 'mec_verified', true);
		?>
		 <div class="mec-book-status-form">
            <div class="mec-row">
                <label for="mec_waite_confirmation"><?php _e('Confirmation', 'mec-waiting-list');?></label>
                <select id="mec_waite_confirmation" name="confirmation">
                    <option value="0"><?php _e('Pending', 'mec-waiting-list');?></option>
                    <option value="1" <?php echo (($confirmed == '1' or !$event_id) ? 'selected="selected"' : ''); ?>><?php _e('Confirmed', 'mec-waiting-list');?></option>
                    <option value="-1" <?php echo ($confirmed == '-1' ? 'selected="selected"' : ''); ?>><?php _e('Rejected', 'mec-waiting-list');?></option>
                </select>
            </div>
            <div class="mec-row">
                <label for="mec_waite_verification"><?php _e('Verification', 'mec-waiting-list');?></label>
                <select id="mec_waite_verification" name="verification">
                    <option value="0"><?php _e('Waiting', 'mec-waiting-list');?></option>
                    <option value="1" <?php echo (($verified == '1' or !$event_id) ? 'selected="selected"' : ''); ?>><?php _e('Verified', 'mec-waiting-list');?></option>
                    <option value="-1" <?php echo ($verified == '-1' ? 'selected="selected"' : ''); ?>><?php _e('Canceled', 'mec-waiting-list');?></option>
                </select>
            </div>
        </div>
    <?php
	}

	public function meta_box_invoice($post) {
		$transaction_id = get_post_meta($post->ID, 'mec_transaction_id', true);

		// Return if Transaction ID is not exists (Normally happens for new booking page)
		if (!$transaction_id) {
			return false;
		}

		?>
        <p class="mec-waiting-invoice">
            <?php
		if (!isset(self::$settings['waiting_invoice']) or (isset(self::$settings['waiting_invoice']) and self::$settings['waiting_invoice'])) {
			echo sprintf(__('Here, you can get %s the invoice for transaction %s.', 'mec-waiting-list'), '<a href="' . self::$waiting->get_invoice_link($transaction_id) . '" target="_blank">' . __('download', 'mec-waiting-list') . '</a>', '<strong>' . $transaction_id . '</strong>');
		}

		?>
        </p>
    <?php
	}

	/**
	 * Show content of details meta box
	 * @author Webnus <info@webnus.biz>
	 * @param object $post
	 */
	public function meta_box_details($post) {
		do_action('mec_waiting_metabox_details', $post);
	}

	/**
	 * Add a security nonce to the Add/Edit books page
	 * @author Webnus <info@webnus.biz>
	 */
	public function meta_box_nonce($post) {
		// Add a nonce field so we can check for it later.
		wp_nonce_field('mec_waite_data', 'mec_waite_nonce');
	}

	/**
	 * Show book form
	 * @author Webnus <info@webnus.biz>
	 * @param $post
	 * @return bool
	 */
	public function meta_box_waiting_form($post) {
		$meta = self::$main->get_post_meta($post->ID);
		$event_id = (isset($meta['mec_event_id']) and $meta['mec_event_id']) ? $meta['mec_event_id'] : 0;

		// The booking is saved so we will skip this form and show booking info instead.
		if ($event_id) {
			return false;
		}

		// Events
		$events = self::$main->get_events();
		?>
        <div class="info-msg"><?php _e('Creates a new waiting entry', 'mec-waiting-list');?></div>
        <div class="mec-waiting-form">
            <h3><?php _e('Waiting List Form', 'mec-waiting-list');?></h3>
            <div class="mec-form-row">
                <div class="mec-col-2">
                    <label for="mec_waiting_form_event_id"><?php _e('Event', 'mec-waiting-list');?></label>
                </div>
                <div class="mec-col-6">
                    <select id="mec_waiting_form_event_id" class="widefat" name="mec_event_id">
                        <option value="">-----</option>
                        <?php foreach ($events as $event): ?>
                        <option value="<?php echo $event->ID; ?>"><?php echo $event->post_title; ?></option>
                        <?php endforeach;?>
                    </select>
                </div>
            </div>
            <div id="mec_date_tickets_booking_form_container">
            </div>
            <input type="hidden" name="mec_is_new_waiting" value="1" />
        </div>
        <script type="text/javascript">
        jQuery(document).ready(function()
        {
            jQuery('#mec_waiting_form_event_id').on('change', function()
            {
                var event_id = this.value;

                jQuery.ajax(
                {
                    url: "<?php echo admin_url('admin-ajax.php', NULL); ?>",
                    data: "action=mec_bbf_date_tickets_booking_form&event_id="+event_id,
                    dataType: "json",
                    type: "GET",
                    success: function(response)
                    {
                        jQuery('#mec_date_tickets_booking_form_container').html(response.output);
                    },
                    error: function()
                    {
                        jQuery('#mec_date_tickets_booking_form_container').html('');
                    }
                });
            });
        });
        </script>
        <?php
	}

	/**
	 * Returns registration form fields
	 * @author Webnus <info@webnus.biz>
	 * @param integer $event_id
	 * @return array
	 */
	public function get_waiting_fields($event_id = NULL) {
		$options = self::$main->get_options();
		$waiting_fields = isset($options['waiting_fields']) ? $options['waiting_fields'] : array();

		// Event Booking Fields
		if ($event_id) {
			$global_inheritance = get_post_meta($event_id, 'mec_waiting_fields_global_inheritance', true);
			if (trim($global_inheritance) == '') {
				$global_inheritance = 1;
			}

			if (!$global_inheritance) {
				$event_waiting_fields = get_post_meta($event_id, 'mec_waiting_fields', true);
				if (is_array($event_waiting_fields)) {
					$waiting_fields = $event_waiting_fields;
				}

			}
		}

		return apply_filters('mec_get_waiting_fields', $waiting_fields, $event_id);
	}

	public static function user_in_waiting($event, $ticket_id) {
		$query = new \WP_Query(
			array(
				'post_type' => self::$PT,
				'meta_query' => array(
					array(
						'key' => 'mec_event_id',
						'value' => $event->ID,
						'compare' => '=',
					),
					array(
						'key' => 'mec_ticket_id',
						'value' => $ticket_id,
						'compare' => '=',
					),
					array(
						'key' => 'mec_confirmed',
						'value' => 1,
						'compare' => '=',
					),
				),
				'post_status' => 'publish',
			)
		);

		$ret = 0;

		if ($query->have_posts()) {
			while ($query->have_posts()) {
				$query->the_post();
				$attendees = get_post_meta(get_the_ID(), 'mec_attendees');
                if ($attendees) {
					$ret += count($attendees[0]);
				}
			}
		}

		wp_reset_postdata();
		wp_reset_query();

		return $ret;
	}

    public static function list_user_waiting($event, $ticket_id) {
		$query = new \WP_Query(
			array(
				'post_type' => self::$PT,
				'meta_query' => array(
					array(
						'key' => 'mec_event_id',
						'value' => $event->ID,
						'compare' => '=',
					),
					array(
						'key' => 'mec_ticket_id',
						'value' => $ticket_id,
						'compare' => '=',
					),
					array(
						'key' => 'mec_confirmed',
						'value' => 1,
						'compare' => '=',
					),
				),
				'post_status' => 'publish',
			)
		);

        $ist=array();

		if ($query->have_posts()) {
			while ($query->have_posts()) {
				$query->the_post();
				$attendees = get_post_meta(get_the_ID(), 'mec_attendees');

                $event_times = get_post_meta( get_the_ID(), 'mec_date', true );
                $timestamps = explode(':', $event_times);
                $start_time = isset($timestamps[0]) ? $timestamps[0] : '';

                if ($attendees) {
                    if (isset($ist[$start_time])){
                        $ist[$start_time] += count($attendees[0]);
                    }else{
                        $ist[$start_time] = count($attendees[0]);
                    }
				}
			}
		}

		wp_reset_postdata();
		wp_reset_query();

		return $ist;
	}

	public static function booking_sold_out($event, $ticket, $ticket_id, $dates) {

		$single_load = false;

		// Extract ticket from single date and sold out without from booking module.
		if ($ticket == null) {
			$tickets = isset($event->data->tickets) ? $event->data->tickets : array();
			if (count($tickets) > 0) {
				foreach ($tickets as $t_ticket_id => $t_ticket) {
					$ticket = $t_ticket;
					$ticket_id = $t_ticket_id;
					$single_load = true;
					break;
				}
			}
		}

		// Disable waiting on specific ticket
		if (isset($ticket['waiting_disable']) && $ticket['waiting_disable'] == 1) {
			return;
		}

		$booking_options = get_post_meta($event->ID, 'mec_booking', true);
		if (!is_array($booking_options)) {
			$booking_options = array();
		}

		echo '<br/>';

		echo self::waiting($event, $ticket_id, $dates, $single_load);
	}

	public function timestamp($start, $end) {
		// Timestamp is already available
		if (isset($start['timestamp']) and isset($end['timestamp'])) {
			return $start['timestamp'] . ':' . $end['timestamp'];
		}

		$s_hour = $start['hour'];
		if (strtoupper($start['ampm']) == 'AM' and $s_hour == '0') {
			$s_hour = 12;
		}

		$e_hour = $end['hour'];
		if (strtoupper($end['ampm']) == 'AM' and $e_hour == '0') {
			$e_hour = 12;
		}

		$start_time = $start['date'] . ' ' . sprintf("%02d", $s_hour) . ':' . sprintf("%02d", $start['minutes']) . ' ' . $start['ampm'];
		$end_time = $end['date'] . ' ' . sprintf("%02d", $e_hour) . ':' . sprintf("%02d", $end['minutes']) . ' ' . $end['ampm'];

		return strtotime($start_time) . ':' . strtotime($end_time);
	}

	/**
	 * Show book details
	 * @param object $post
	 * @author Webnus <info@webnus.biz>
	 * @return boolean
	 */
	public function meta_box_waiting_info($post) {
		$meta = self::$main->get_post_meta($post->ID);
		$event_id = (isset($meta['mec_event_id']) and $meta['mec_event_id']) ? $meta['mec_event_id'] : 0;

		// The booking is not saved so we will skip this and show booking form instead.
		if (!$event_id) {
			return false;
		}

		$tickets = get_post_meta($event_id, 'mec_tickets', true);

		$date_format = (isset(self::$settings['waiting_date_format1']) and trim(self::$settings['waiting_date_format1'])) ? self::$settings['waiting_date_format1'] : 'Y-m-d';
		$time_format = get_option('time_format');

		$dates = isset($meta['mec_date']) ? explode(':', $meta['mec_date']) : array();
		if (isset($dates[0]) and isset($dates[1]) and is_numeric($dates[0]) and is_numeric($dates[1])) {
			$start_datetime = date($date_format . ' ' . $time_format, $dates[0]);
			$end_datetime = date($date_format . ' ' . $time_format, $dates[1]);
		} else {
			$start_datetime = isset($dates[0]) ? $dates[0] : '';
			$end_datetime = isset($dates[1]) ? $dates[1] : '';
		}

		$attendees = isset($meta['mec_attendees']) ? $meta['mec_attendees'] : (isset($meta['mec_attendee']) ? array($meta['mec_attendee']) : array());
		$waite_fields = self::get_waiting_fields($event_id);

		$status = get_post_meta($post->ID, 'mec_verified', true);
		$coupon_code = (isset($meta['mec_coupon_code']) and trim($meta['mec_coupon_code'])) ? $meta['mec_coupon_code'] : '';
		$waite_to_booking = isset($meta['mec_waite_to_booking']) ? $meta['mec_waite_to_booking'] : null;
		?>
        <div class="mec-waiting-details">
            <h3><?php echo __('Waiting List', 'mec-waiting-list'); ?></h3>

            <?php if ($waite_to_booking): ?>
           	<div class="mec-row">
                <strong><?php _e('Waiting List Booking Details', 'mec-waiting-list');?>: </strong>
                <span><?php echo '<a href="' . get_edit_post_link($waite_to_booking['booking_id']) . '"> Booking: #' . $waite_to_booking['booking_id'] . '</a>'; ?>
                </span>
                <span><?php echo 'On Date:' . date('Y-m-d H:i:s', $waite_to_booking['date']) . '</a>'; ?>
                </span>
            </div>
            <?php endif;?>

            <div class="mec-row">
                <strong><?php _e('Event', 'mec-waiting-list');?>: </strong>
                <span><?php echo ($event_id ? '<a href="' . get_permalink($event_id) . '">' . get_the_title($event_id) . '</a>' : __('Unknown', 'mec-waiting-list')); ?></span>
            </div>
            <div class="mec-row">
                <strong><?php _e('Date & Time', 'mec-waiting-list');?>: </strong>
                <span><?php echo ((isset($dates[0]) and isset($dates[1])) ? sprintf(__('%s to %s', 'mec-waiting-list'), $start_datetime, $end_datetime) : __('Unknown', 'mec-waiting-list')); ?></span>
            </div>

            <?php if ($status == '-1'): ?>
            <div class="mec-row">
                <strong><?php _e('Cancellation Date', 'mec-waiting-list');?>: </strong>
                <span>
                    <?php
		$mec_cancellation_date = get_post_meta($post->ID, 'mec_cancelled_date', true);
		echo trim($mec_cancellation_date) ? $mec_cancellation_date : __('Unknown', 'mec-waiting-list');
		?>
                </span>
            </div>
            <?php endif;?>

            <div class="mec-row">
                <strong><?php _e('Total Attendees', 'mec-waiting-list');?>: </strong>
                <span><?php echo self::get_total_attendees($post->ID); ?></span>
            </div>


            <?php if (isset($attendees['attachments']) && !empty($attendees['attachments'])): ?>
            <h3><?php _e('Attachments', 'mec-waiting-list');?></h3>
            <hr>
            <?php foreach ($attendees['attachments'] as $attachment): ?>
            <div class="mec-attendee">
                <?php if (!isset($attachment['error']) && $attachment['response'] === 'SUCCESS'): ?>
                    <?php
		@$a = getimagesize($attachment['url']);
		$image_type = $a[2];
		if (in_array($image_type, array(IMAGETYPE_GIF, IMAGETYPE_JPEG, IMAGETYPE_PNG, IMAGETYPE_BMP))):
		?>
                        <a href="<?php echo $attachment['url'] ?>" target="_blank">
                            <img src="<?php echo $attachment['url'] ?>" alt="<?php echo $attachment['filename'] ?>" title="<?php echo $attachment['filename'] ?>" style="max-width:250px;float: left;margin: 5px;">
                        </a>
                    <?php else: ?>
                        <a href="<?php echo $attachment['url'] ?>" target="_blank"><?php echo $attachment['filename'] ?></a>
                    <?php endif;?>
                <?php endif;?>
            </div>
            <?php endforeach;?>
            <div class="clear"></div>
            <?php endif;?>

            <h3><?php _e('Attendees', 'mec-waiting-list');?></h3>
            <?php foreach ($attendees as $key => $attendee): $waite_form = isset($attendee['reg']) ? $attendee['reg'] : array();?>
									            <?php
	if ($key === 'attachments') {
				continue;
			}

			if (isset($attendee[0]['MEC_TYPE_OF_DATA'])) {
				continue;
			}

			?>
		        <hr>
		        <div class="mec-attendee">
		            <h4><strong><?php echo ((isset($attendee['name']) and trim($attendee['name'])) ? $attendee['name'] : '---'); ?></strong></h4>
		            <div class="mec-row">
		                <strong><?php _e('Email', 'mec-waiting-list');?>: </strong>
		                <span><?php echo ((isset($attendee['email']) and trim($attendee['email'])) ? $attendee['email'] : '---'); ?></span>
		            </div>
		            <div class="mec-row">
		                <strong><?php echo self::$main->m('ticket', __('Ticket', 'mec-waiting-list')); ?>: </strong>
		                <span><?php echo ((isset($attendee['id']) and isset($tickets[$attendee['id']]['name'])) ? $tickets[$attendee['id']]['name'] : __('Unknown', 'mec-waiting-list')); ?></span>
		            </div>
		            <?php
	// Ticket Variations
			if (isset($attendee['variations']) and is_array($attendee['variations']) and count($attendee['variations'])) {
				$ticket_variations = self::$main->ticket_variations($event_id);
				foreach ($attendee['variations'] as $variation_id => $variation_count) {
					if (!$variation_count or ($variation_count and $variation_count < 0)) {
						continue;
					}

					$variation_title = (isset($ticket_variations[$variation_id]) and isset($ticket_variations[$variation_id]['title'])) ? $ticket_variations[$variation_id]['title'] : '';
					if (!trim($variation_title)) {
						continue;
					}

					echo '<div class="mec-row">
								<span>+ ' . $variation_title . '</span>
								<span>(' . $variation_count . ')</span>
								</div>';
				}
			}
			?>
								<?php if (isset($waite_form) && !empty($waite_form)): foreach ($waite_form as $field_id => $value): $label = isset($waite_fields[$field_id]) ? $waite_fields[$field_id]['label'] : '';
					$type = isset($waite_fields[$field_id]) ? $waite_fields[$field_id]['type'] : '';?>
												<?php if ($type == 'agreement'): ?>
												<div class="mec-row">
												<strong><?php echo sprintf(__($label, 'mec-waiting-list'), '<a href="' . get_the_permalink($waite_fields[$field_id]['page']) . '">' . get_the_title($waite_fields[$field_id]['page']) . '</a>'); ?>: </strong>
												<span><?php echo ($value == '1' ? __('Yes', 'mec-waiting-list') : __('No', 'mec-waiting-list')); ?></span>
												</div>
												<?php else: ?>
				                <div class="mec-row">
				                    <strong><?php _e($label, 'mec-waiting-list');?>: </strong>
				                    <span><?php echo (is_string($value) ? $value : (is_array($value) ? implode(', ', $value) : '---')); ?></span>
				                </div>
				            <?php endif;?>
					<?php endforeach;endif;?>
            </div>
            <?php endforeach;?>

        </div>

        <?php
		// Events
		$events = self::$main->get_events();

		// Ticket Variations
		$ticket_variations = self::$main->ticket_variations($event_id);

		$render = \MEC::getInstance('app.libraries.render');
		$occurrences = $render->dates($event_id, NULL, 100);

		$date_format = (isset(self::$settings['booking_date_format1']) and trim(self::$settings['booking_date_format1'])) ? self::$settings['booking_date_format1'] : 'Y-m-d';

		$repeat_type = get_post_meta($event_id, 'mec_repeat_type', true);
		if ($repeat_type === 'custom_days') {
			$date_format .= ' ' . get_option('time_format');
		}

		?>
        <div class="mec-waiting-edit">
            <h1 id="mec_booking_edit_heading"><?php _e('Edit Waiting List', 'mec-waiting-list');?></h1>
            <div class="info-msg"><?php _e('Do not edit waiting list entries unless absolutely needed!', 'mec-waiting-list');?></div>

            <input type="hidden" name="mec_waiting_edit_status" value="0">
            <input type="checkbox" name="mec_waiting_edit_status" id="mec_waiting_edit_status" value="1" onchange="jQuery('#mec_waiting_edit_form').toggleClass('mec-util-hidden');">
            <label for="mec_waiting_edit_status"><?php _e('I need to edit the details of a waiting list entry', 'mec-waiting-list');?></label>

            <div id="mec_waiting_edit_form" class="mec-waiting-form mec-util-hidden">
                <div class="mec-form-row">
                    <div class="mec-col-2">
                        <label for="mec_waiting_form_event_id"><?php _e('Event', 'mec-waiting-list');?></label>
                    </div>
                    <div class="mec-col-6">
                        <select id="mec_waiting_form_event_id" class="widefat" name="mec_event_id">
                            <option value="">-----</option>
                            <?php foreach ($events as $event): ?>
                                <option value="<?php echo $event->ID; ?>" <?php echo ($event_id == $event->ID ? 'selected="selected"' : ''); ?>><?php echo $event->post_title; ?></option>
                            <?php endforeach;?>
                        </select>
                    </div>
                </div>
                <div id="mec_waiting_edit_form_event_message">
                </div>
                <div id="mec_waiting_edit_form_event_options">
                    <div class="mec-form-row">
                        <div class="mec-col-2">
                            <label for="mec_waiting_form_date"><?php _e('Date', 'mec-waiting-list');?></label>
                        </div>
                        <div class="mec-col-6">
                            <select id="mec_waiting_form_date" class="widefat mec-waiting-edit-form-dates" name="mec_date">
                                <option value="">-----</option>
                                <?php foreach ($occurrences as $occurrence): if (!isset($occurrence['start'])) {
				continue;
			}

			$occ_timestamp = self::timestamp($occurrence['start'], $occurrence['end']);?>
									                                    <option value="<?php echo $occ_timestamp; ?>" <?php if (isset($meta['mec_date'])) {
				echo (($meta['mec_date'] == $occ_timestamp or $meta['mec_date'] == $occurrence['start']['date'] . ':' . $occurrence['end']['date']) ? 'selected="selected"' : '');
			}
			?>>
									                                        <?php echo strip_tags(self::$main->date_label($occurrence['start'], $occurrence['end'], $date_format)); ?>
									                                    </option>
									                                <?php endforeach;?>
                            </select>
                        </div>
                    </div>
                    <div class="mec-form-row">
                        <div class="mec-col-8" style="text-align: right;">
                            <button type="button" class="button mec-add-attendee"><?php _e('Add Attendee', 'mec-waiting-list');?></button>
                        </div>
                    </div>
                    <div id="mec_date_tickets_waiting_form_attendees">
                        <h3><?php _e('Attendees', 'mec-waiting-list');?></h3>
                        <div id="mec_date_tickets_waiting_form_attendees_list">
                            <?php $i = 0;foreach ($attendees as $key => $attendee): $i = max($i, $key);
			$attachments = (isset($attendees['attachments']) and is_array($attendees['attachments'])) ? $attendees['attachments'] : NULL;?>
									                                <?php
	if ($key === 'attachments') {
				continue;
			}

			if (isset($attendee[0]['MEC_TYPE_OF_DATA'])) {
				continue;
			}

			?>
		                        <div class="mec-attendee" id="mec_attendee<?php echo $key; ?>">
		                            <hr>
		                            <div class="mec-form-row">
		                                <div class="mec-col-8" style="text-align: right;">
		                                    <button type="button" class="button mec-remove-attendee" data-key="<?php echo $key; ?>"><?php _e('Remove Attendee', 'mec-waiting-list');?></button>
		                                </div>
		                            </div>
		                            <div class="mec-form-row">
		                                <div class="mec-col-2">
		                                    <label for="att_<?php echo $key; ?>_name"><?php _e('Name', 'mec-waiting-list');?></label>
		                                </div>
		                                <div class="mec-col-6">
		                                    <input type="text" value="<?php echo ((isset($attendee['name']) and trim($attendee['name'])) ? $attendee['name'] : ''); ?>" id="att_<?php echo $key; ?>_name" name="mec_att[<?php echo $key; ?>][name]" placeholder="<?php esc_attr_e('Name', 'mec-waiting-list');?>" class="widefat">
		                                </div>
		                            </div>
		                            <div class="mec-form-row">
		                                <div class="mec-col-2">
		                                    <label for="att_<?php echo $key; ?>_email"><?php _e('Email', 'mec-waiting-list');?></label>
		                                </div>
		                                <div class="mec-col-6">
		                                    <input type="email" value="<?php echo ((isset($attendee['email']) and trim($attendee['email'])) ? $attendee['email'] : ''); ?>" id="att_<?php echo $key; ?>_email" name="mec_att[<?php echo $key; ?>][email]" placeholder="<?php esc_attr_e('Email', 'mec-waiting-list');?>" class="widefat">
		                                </div>
		                            </div>
		                            <div class="mec-form-row">
		                                <div class="mec-col-2">
		                                    <label for="att_<?php echo $key; ?>_ticket"><?php echo self::$main->m('ticket', __('Ticket', 'mec-waiting-list')); ?></label>
		                                </div>
		                                <div class="mec-col-6">
		                                    <select id="att_<?php echo $key; ?>_ticket" name="mec_att[<?php echo $key; ?>][id]" class="widefat mec-waiting-edit-form-tickets">
		                                        <?php foreach ($tickets as $t_id => $ticket): ?>
		                                            <option value="<?php echo $t_id; ?>" <?php echo ($t_id == $attendee['id'] ? 'selected="selected"' : ''); ?>><?php echo $ticket['name']; ?></option>
		                                        <?php endforeach;?>
        </select>
    </div>
	</div>
	<?php if (count($waite_fields)): ?>
    <div class="mec-waiting-fields" data-key="<?php echo $key; ?>">
        <?php foreach ($waite_fields as $waite_field_id => $waite_field): if (!is_numeric($waite_field_id) or !isset($waite_field['type']) or (isset($waite_field['type']) and !trim($waite_field['type']))) {
				continue;
			}
			?>
		                                        <div class="mec-form-row mec-waiting-field-<?php echo $waite_field['type']; ?> <?php echo ((isset($waite_field['mandatory']) and $waite_field['mandatory']) ? 'mec-reg-mandatory' : ''); ?>" data-field-id="<?php echo $waite_field_id; ?>">
		                                            <div class="mec-col-2">
		                                                <?php if (isset($waite_field['label']) and $waite_field['type'] != 'agreement' && $waite_field['type'] != 'name' && $waite_field['type'] != 'mec_email'): ?><label for="mec_book_waite_field_reg<?php echo $key . '_' . $waite_field_id; ?>"><?php _e($waite_field['label'], 'mec-waiting-list');?><?php echo ((isset($waite_field['mandatory']) and $waite_field['mandatory']) ? '<span class="wbmec-mandatory">*</span>' : ''); ?></label><?php endif;?>
                </div>
                <div class="mec-col-6">

                    <?php /** Text **/if ($waite_field['type'] == 'text'): ?>
                    <input class="widefat" id="mec_book_waite_field_reg<?php echo $key . '_' . $waite_field_id; ?>" type="text" name="mec_att[<?php echo $key; ?>][reg][<?php echo $waite_field_id; ?>]" value="<?php echo ((isset($attendee['reg']) and isset($attendee['reg'][$waite_field_id])) ? $attendee['reg'][$waite_field_id] : ''); ?>" placeholder="<?php if (isset($waite_field['placeholder']) and $waite_field['placeholder']) {_e($waite_field['placeholder'], 'mec-waiting-list');} else {_e($waite_field['label'], 'mec-waiting-list');};?>" <?php if (isset($waite_field['placeholder']) and $waite_field['placeholder']) {
			echo 'placeholder="' . $waite_field['placeholder'] . '" ';
		}
		?> <?php if (isset($waite_field['mandatory']) and $waite_field['mandatory']) {
			echo 'required';
		}
		?> />

                    <?php /** Date **/elseif ($waite_field['type'] == 'date'): ?>
                    <input class="widefat" id="mec_book_waite_field_reg<?php echo $key . '_' . $waite_field_id; ?>" type="date" name="mec_att[<?php echo $key; ?>][reg][<?php echo $waite_field_id; ?>]" value="<?php echo ((isset($attendee['reg']) and isset($attendee['reg'][$waite_field_id])) ? $attendee['reg'][$waite_field_id] : ''); ?>" placeholder="<?php if (isset($waite_field['placeholder']) and $waite_field['placeholder']) {_e($waite_field['placeholder'], 'mec-waiting-list');} else {_e($waite_field['label'], 'mec-waiting-list');};?>" <?php if (isset($waite_field['mandatory']) and $waite_field['mandatory']) {
			echo 'required';
		}
		?> min="1970-01-01" max="2099-12-31" />

                    <?php /** Email **/elseif ($waite_field['type'] == 'email'): ?>
                    <input class="widefat" id="mec_book_waite_field_reg<?php echo $key . '_' . $waite_field_id; ?>" type="email" name="mec_att[<?php echo $key; ?>][reg][<?php echo $waite_field_id; ?>]" value="<?php echo ((isset($attendee['reg']) and isset($attendee['reg'][$waite_field_id])) ? $attendee['reg'][$waite_field_id] : ''); ?>" placeholder="<?php if (isset($waite_field['placeholder']) and $waite_field['placeholder']) {_e($waite_field['placeholder'], 'mec-waiting-list');} else {_e($waite_field['label'], 'mec-waiting-list');};?>" <?php if (isset($waite_field['mandatory']) and $waite_field['mandatory']) {
			echo 'required';
		}
		?> />

                    <?php /** Tel **/elseif ($waite_field['type'] == 'tel'): ?>
                    <input class="widefat" id="mec_book_waite_field_reg<?php echo $key . '_' . $waite_field_id; ?>" oninput="this.value=this.value.replace(/(?![0-9])./gmi,'')" type="tel" name="mec_att[<?php echo $key; ?>][reg][<?php echo $waite_field_id; ?>]" value="<?php echo ((isset($attendee['reg']) and isset($attendee['reg'][$waite_field_id])) ? $attendee['reg'][$waite_field_id] : ''); ?>" placeholder="<?php if (isset($waite_field['placeholder']) and $waite_field['placeholder']) {_e($waite_field['placeholder'], 'mec-waiting-list');} else {_e($waite_field['label'], 'mec-waiting-list');};?>" <?php if (isset($waite_field['mandatory']) and $waite_field['mandatory']) {
			echo 'required';
		}
		?> />

                    <?php /** File **/elseif ($waite_field['type'] == 'file'): ?>
                    <button type="button" class="mec-choose-file" data-for="mec_book_waite_field_reg<?php echo $key . '_' . $waite_field_id; ?>"><?php echo __('Select File', 'mec-waiting-list'); ?></button><input type="hidden" class="widefat" id="mec_book_waite_field_reg<?php echo $key . '_' . $waite_field_id; ?>" name="mec_att[<?php echo $key; ?>][reg][<?php echo $waite_field_id; ?>]" value="" />
                    <?php if ($attachments and is_array($attachments)): foreach ($attachments as $attachment): ?><a href="<?php echo $attachment['url']; ?>" target="_blank"><?php echo $attachment['filename']; ?></a> <?php endforeach;endif;?>

                    <?php /** Textarea **/elseif ($waite_field['type'] == 'textarea'): ?>
                    <textarea class="widefat" id="mec_book_waite_field_reg<?php echo $key . '_' . $waite_field_id; ?>" name="mec_att[<?php echo $key; ?>][reg][<?php echo $waite_field_id; ?>]" placeholder="<?php if (isset($waite_field['placeholder']) and $waite_field['placeholder']) {_e($waite_field['placeholder'], 'mec-waiting-list');} else {_e($waite_field['label'], 'mec-waiting-list');};?>" <?php if (isset($waite_field['mandatory']) and $waite_field['mandatory']) {
			echo 'required';
		}
		?>><?php echo ((isset($attendee['reg']) and isset($attendee['reg'][$waite_field_id])) ? $attendee['reg'][$waite_field_id] : ''); ?></textarea>

                    <?php /** Dropdown **/elseif ($waite_field['type'] == 'select'): ?>
                    <select class="widefat" id="mec_book_waite_field_reg<?php echo $key . '_' . $waite_field_id; ?>" name="mec_att[<?php echo $key; ?>][reg][<?php echo $waite_field_id; ?>]" placeholder="<?php if (isset($waite_field['placeholder']) and $waite_field['placeholder']) {_e($waite_field['placeholder'], 'mec-waiting-list');} else {_e($waite_field['label'], 'mec-waiting-list');};?>" <?php if (isset($waite_field['mandatory']) and $waite_field['mandatory']) {
			echo 'required';
		}
		?>>
                        <?php foreach ($waite_field['options'] as $waite_field_option): ?>
                            <option value="<?php esc_attr_e($waite_field_option['label'], 'mec-waiting-list');?>" <?php echo ((isset($attendee['reg']) and isset($attendee['reg'][$waite_field_id]) and $attendee['reg'][$waite_field_id] == $waite_field_option['label']) ? 'selected="selected"' : ''); ?>><?php _e($waite_field_option['label'], 'mec-waiting-list');?></option>
                        <?php endforeach;?>
                    </select>

                    <?php /** Radio **/elseif ($waite_field['type'] == 'radio'): ?>
                    <?php foreach ($waite_field['options'] as $waite_field_option): ?>
                        <label for="mec_book_waite_field_reg<?php echo $key . '_' . $waite_field_id . '_' . strtolower(str_replace(' ', '_', $waite_field_option['label'])); ?>">
                            <input type="radio" id="mec_book_waite_field_reg<?php echo $key . '_' . $waite_field_id . '_' . strtolower(str_replace(' ', '_', $waite_field_option['label'])); ?>" name="mec_att[<?php echo $key; ?>][reg][<?php echo $waite_field_id; ?>]" value="<?php _e($waite_field_option['label'], 'mec-waiting-list');?>" <?php echo ((isset($attendee['reg']) and isset($attendee['reg'][$waite_field_id]) and $attendee['reg'][$waite_field_id] == $waite_field_option['label']) ? 'checked="checked"' : ''); ?> />
                            <?php _e($waite_field_option['label'], 'mec-waiting-list');?>
                        </label>
                    <?php endforeach;?>

                    <?php /** Checkbox **/elseif ($waite_field['type'] == 'checkbox'): ?>
                    <?php foreach ($waite_field['options'] as $waite_field_option): ?>
                        <label for="mec_book_waite_field_reg<?php echo $key . '_' . $waite_field_id . '_' . strtolower(str_replace(' ', '_', $waite_field_option['label'])); ?>">
                            <input type="checkbox" id="mec_book_waite_field_reg<?php echo $key . '_' . $waite_field_id . '_' . strtolower(str_replace(' ', '_', $waite_field_option['label'])); ?>" name="mec_att[<?php echo $key; ?>][reg][<?php echo $waite_field_id; ?>][]" value="<?php _e($waite_field_option['label'], 'mec-waiting-list');?>" <?php echo ((isset($attendee['reg']) and isset($attendee['reg'][$waite_field_id]) and in_array($waite_field_option['label'], $attendee['reg'][$waite_field_id])) ? 'checked="checked"' : ''); ?> />
                            <?php _e($waite_field_option['label'], 'mec-waiting-list');?>
                        </label>
                    <?php endforeach;?>

                    <?php /** Agreement **/elseif ($waite_field['type'] == 'agreement'): ?>
                    <label for="mec_book_waite_field_reg<?php echo $key . '_' . $waite_field_id; ?>">
                        <input type="checkbox" id="mec_book_waite_field_reg<?php echo $key . '_' . $waite_field_id; ?>" name="mec_att[<?php echo $key; ?>][reg][<?php echo $waite_field_id; ?>]" value="1" <?php echo ((isset($attendee['reg']) and isset($attendee['reg'][$waite_field_id]) and $attendee['reg'][$waite_field_id] == 1) ? 'checked="checked"' : ''); ?> />
                        <?php echo ((isset($waite_field['mandatory']) and $waite_field['mandatory']) ? '<span class="wbmec-mandatory">*</span>' : ''); ?>
                        <?php echo sprintf(__(stripslashes($waite_field['label']), 'mec-waiting-list'), '<a href="' . get_the_permalink($waite_field['page']) . '" target="_blank">' . get_the_title($waite_field['page']) . '</a>'); ?>
                    </label>
                    <?php endif;?>

                </div>
            </div>
        <?php endforeach;?>
    </div>
	<?php endif;?>
	<?php if (isset(self::$settings['ticket_variations_status']) and self::$settings['ticket_variations_status'] and count($ticket_variations)): ?>
	<div class="mec-book-ticket-variations" data-key="<?php echo $key; ?>">
    <?php foreach ($ticket_variations as $ticket_variation_id => $ticket_variation): if (!is_numeric($ticket_variation_id) or !isset($ticket_variation['title']) or (isset($ticket_variation['title']) and !trim($ticket_variation['title']))) {
				continue;
			}
			?>
		                                <div class="mec-form-row">
		                                    <div class="mec-col-2">
		                                        <label for="mec_att_<?php echo $key; ?>_variations_<?php echo $ticket_variation_id; ?>" class="mec-ticket-variation-name"><?php echo $ticket_variation['title']; ?></label>
		                                    </div>
		                                    <div class="mec-col-6">
		                                        <input id="mec_att_<?php echo $key; ?>_variations_<?php echo $ticket_variation_id; ?>" type="number" min="0" max="<?php echo ((is_numeric($ticket_variation['max']) and $ticket_variation['max']) ? $ticket_variation['max'] : 1); ?>" name="mec_att[<?php echo $key; ?>][variations][<?php echo $ticket_variation_id; ?>]" value="<?php echo (isset($attendee['variations']) and isset($attendee['variations'][$ticket_variation_id])) ? $attendee['variations'][$ticket_variation_id] : 0; ?>">
		                                    </div>
		                                </div>
		                                <?php endforeach;?>
                                    </div>
                                    <?php endif;?>
                                </div>
                            <?php endforeach;?>
                        </div>
                        <input type="hidden" id="mec_booking_edit_new_key" value="<?php echo $i + 1; ?>">
                    </div>
                </div>
            </div>
        </div>
        <script type="text/javascript">
        function mec_init_booking_media_file()
        {
            jQuery('.mec-choose-file').off('click').on('click', function(event)
            {
                event.preventDefault();

                var _for = jQuery(this).data('for');

                var frame;
                if(frame)
                {
                    frame.open();
                    return;
                }

                frame = wp.media();
                frame.on('select', function()
                {
                    // Grab the selected attachment.
                    var attachment = frame.state().get('selection').first();

                    jQuery('#'+_for).val(attachment.id);
                    console.log('#'+_for, attachment.id);
                    frame.close();
                });

                frame.open();
            });
        }

        jQuery(document).ready(function()
        {
            // Init File Media
            mec_init_booking_media_file();

            jQuery('.mec-remove-attendee').on('click', function()
            {
                var key = jQuery(this).data('key');
                jQuery('#mec_attendee'+key).remove();
            });

            jQuery('.mec-add-attendee').on('click', function()
            {
                var key = jQuery('#mec_booking_edit_new_key').val();
                var event_id = jQuery('#mec_waiting_form_event_id').val();

                jQuery('#mec_book_edit_form_event_message').html('');

                jQuery.ajax(
                {
                    url: "<?php echo admin_url('admin-ajax.php', NULL); ?>",
                    data: "action=mec_bbf_edit_event_add_attendee&event_id="+event_id+"&key="+key,
                    dataType: "json",
                    type: "GET",
                    success: function(response)
                    {
                        if(response.success === 1)
                        {
                            jQuery('#mec_date_tickets_waiting_form_attendees_list').append(response.output);
                            jQuery('#mec_booking_edit_new_key').val(parseInt(key)+1);

                            jQuery('html, body').animate(
                            {
                                scrollTop: jQuery("#mec_attendee"+key).offset().top
                            }, 500);

                            // Init File Media
                            mec_init_booking_media_file();
                        }
                        else
                        {
                            jQuery('#mec_book_edit_form_event_message').html(response.output);
                        }
                    },
                    error: function()
                    {
                    }
                });
            });

            jQuery('#mec_book_form_event_id').on('change', function()
            {
                var event_id = this.value;
                jQuery('#mec_book_edit_form_event_message').html('');

                jQuery.ajax(
                {
                    url: "<?php echo admin_url('admin-ajax.php', NULL); ?>",
                    data: "action=mec_bbf_edit_event_options&event_id="+event_id,
                    dataType: "json",
                    type: "GET",
                    success: function(response)
                    {
                        if(response.success === 1)
                        {
                            jQuery('.mec-booking-edit-form-dates').html(response.dates);
                            jQuery('.mec-booking-edit-form-tickets').html(response.tickets);

                            jQuery(".mec-book-ticket-variations").each(function()
                            {
                                var key = jQuery(this).data('key');
                                jQuery(this).html(response.variations.replace(/:key:/g, key));
                            });

                            jQuery(".mec-book-reg-fields").each(function()
                            {
                                var key = jQuery(this).data('key');
                                jQuery(this).html(response.waite_fields.replace(/:key:/g, key));
                            });

                            jQuery('#mec_book_edit_form_event_options').show();

                            // Init File Media
                            mec_init_booking_media_file();
                        }
                        else
                        {
                            jQuery('#mec_book_edit_form_event_message').html(response.output);
                            jQuery('#mec_book_edit_form_event_options').hide();
                        }
                    },
                    error: function()
                    {
                    }
                });
            });
        });
        </script>
    <?php
	}

	/**
	 * Filters columns of book feature
	 * @author Webnus <info@webnus.biz>
	 * @param array $columns
	 * @return array
	 */
	public function filter_columns($columns) {
		unset($columns['title']);
		unset($columns['date']);
		unset($columns['author']);

		$columns['id'] = __('ID', 'mec-waiting-list');
		$columns['title'] = __('Title', 'mec-waiting-list');
		$columns['attendees'] = __('Attendees', 'mec-waiting-list');
		$columns['event'] = __('Event', 'mec-waiting-list');
		$columns['confirmation'] = __('Confirmation', 'mec-waiting-list');
		$columns['verification'] = __('Verification', 'mec-waiting-list');
		$columns['bdate'] = __('Waiting List Date', 'mec-waiting-list');
		$columns['mec_booking_location'] = __('Location', 'mec-waiting-list');

		return $columns;
	}

	/**
	 * Filters sortable columns of book feature
	 * @author Webnus <info@webnus.biz>
	 * @param array $columns
	 * @return array
	 */
	public function filter_sortable_columns($columns) {
		$columns['id'] = 'id';
		$columns['event'] = 'event';
		$columns['price'] = 'price';
		$columns['confirmation'] = 'confirmation';
		$columns['verification'] = 'verification';
		$columns['bdate'] = 'date';
		$columns['order_time'] = 'order_time';
		$columns['mec_booking_location'] = 'mec_booking_location';

		return $columns;
	}

	public function get_total_attendees($book_id) {
		$attendees = get_post_meta($book_id, 'mec_attendees', true);
		$count = 0;

		if (is_array($attendees)) {
			foreach ($attendees as $key => $attendee) {
				if ($key === 'attachments') {
					continue;
				}

				if (!isset($attendee[0]['MEC_TYPE_OF_DATA'])) {
					$count++;
				} elseif ($attendee[0]['MEC_TYPE_OF_DATA'] != 'attachment') {
					$count++;
				}

			}
		}

		return $count;
	}

	/**
	 * Filters columns content of book feature
	 * @author Webnus <info@webnus.biz>
	 * @param string $column_name
	 * @param int $post_id
	 * @return string
	 */
	public function filter_columns_content($column_name, $post_id) {
		if ($column_name == 'event') {
			$event_id = get_post_meta($post_id, 'mec_event_id', true);

			$title = get_the_title($event_id);
			$tickets = get_post_meta($event_id, 'mec_tickets', true);

			$ticket_ids_str = get_post_meta($post_id, 'mec_ticket_id', true);
			$ticket_ids = explode(',', trim($ticket_ids_str, ', '));

			echo ($event_id ? '<a href="' . self::$main->add_qs_var('mec_event_id', $event_id) . '">' . $title . '</a>' : '');
			foreach ($ticket_ids as $ticket_id) {
				echo (isset($tickets[$ticket_id]['name']) ? ' - <a title="' . self::$main->m('ticket', __('Ticket', 'mec-waiting-list')) . '" href="' . self::$main->add_qs_vars(array('mec_ticket_id' => $ticket_id, 'mec_event_id' => $event_id)) . '">' . $tickets[$ticket_id]['name'] . '</a>' : '');
			}
		} elseif ($column_name == 'attendees') {
			$attendees = self::$book->get_attendees($post_id);

			$unique_attendees = array();
			foreach ($attendees as $attendee) {
				if (!isset($unique_attendees[$attendee['email']])) {
					$unique_attendees[$attendee['email']] = $attendee;
				} else {
					$unique_attendees[$attendee['email']]['count'] += 1;
				}

			}

			echo '<strong>' . count($attendees) . '</strong>';
			echo '<div class="mec-booking-attendees-tooltip">';
			echo '<ul>';

			foreach ($unique_attendees as $unique_attendee) {
				echo '<li>';
				echo '<div class="mec-booking-attendees-tooltip-name">' . $unique_attendee['name'] . ($unique_attendee['count'] > 1 ? ' (' . $unique_attendee['count'] . ')' : '') . '</div>';
				echo '<div class="mec-booking-attendees-tooltip-email"><a href="mailto:' . $unique_attendee['email'] . '">' . $unique_attendee['email'] . '</a></div>';
				echo '</li>';
			}

			echo '</ul>';
			echo '</div>';

		} elseif ($column_name == 'price') {
			$price = get_post_meta($post_id, 'mec_price', true);

			echo self::$main->render_price(($price ? $price : 0));
			echo ' ' . get_post_meta($post_id, 'mec_gateway_label', true);
		} elseif ($column_name == 'confirmation') {
			$confirmed = get_post_meta($post_id, 'mec_confirmed', true);

			echo '<a href="' . self::$main->add_qs_var('mec_confirmed', $confirmed) . '">' . self::$main->get_confirmation_label($confirmed) . '</a>';
		} elseif ($column_name == 'verification') {
			$verified = get_post_meta($post_id, 'mec_verified', true);

			echo '<a href="' . self::$main->add_qs_var('mec_verified', $verified) . '">' . self::$main->get_verification_label($verified) . '</a>';
		} elseif ($column_name == 'transaction') {
			$transaction_id = get_post_meta($post_id, 'mec_transaction_id', true);
			echo '<a href="' . self::$main->add_qs_var('mec_transaction_id', $transaction_id) . '">' . $transaction_id . '</a>';
		} elseif ($column_name == 'bdate') {
			echo '<a href="' . self::$main->add_qs_var('m', date('Ymd', get_post_time('U', false, $post_id))) . '">' . get_the_date('', $post_id) . '</a>';
		} elseif ($column_name == 'id') {
			echo $post_id;
		} elseif ($column_name == 'order_time') {
			echo get_post_meta($post_id, 'mec_waiting_time', true);
		} elseif ($column_name == 'mec_booking_location') {
			$event_id = get_post_meta($post_id, 'mec_event_id', true);
			$location_id = get_post_meta($event_id, 'mec_location_id', true);
			$location = get_term_by('id', $location_id, 'mec_location');
			echo isset($location->name) ? $location->name : '';
		}
	}

	/**
	 * @param WP_Query $query
	 */
	public static function filter_query($query) {
		if (!is_admin() or !$query->is_main_query() or $query->get('post_type') != self::$PT) {
			return;
		}

		$orderby = $query->get('orderby');

		if ($orderby == 'event') {
			$query->set('meta_key', 'mec_event_id');
			$query->set('orderby', 'mec_event_id');
		} elseif ($orderby == 'booker') {
			$query->set('orderby', 'user_id');
		} elseif ($orderby == 'price') {
			$query->set('meta_key', 'mec_price');
			$query->set('orderby', 'mec_price');
		} elseif ($orderby == 'confirmation') {
			$query->set('meta_key', 'mec_confirmed');
			$query->set('orderby', 'mec_confirmed');
		} elseif ($orderby == 'verification') {
			$query->set('meta_key', 'mec_verified');
			$query->set('orderby', 'mec_verified');
		} elseif ($orderby == 'order_time') {
			$query->set('meta_key', 'mec_waiting_time');
			$query->set('orderby', 'mec_waiting_time');
		} elseif ($orderby == 'id' or trim($orderby) == '') {
			$query->set('orderby', 'ID');
		}

		// Meta Query
		$meta_query = array();

		// Filter by Event ID
		if (isset($_REQUEST['mec_event_id']) and trim($_REQUEST['mec_event_id'])) {
			$meta_query[] = array(
				'key' => 'mec_event_id',
				'value' => sanitize_text_field($_REQUEST['mec_event_id']),
				'compare' => '=',
				'type' => 'numeric',
			);
		}

		// Filter by Occurrence
		if (isset($_REQUEST['mec_occurrence']) and trim($_REQUEST['mec_occurrence'])) {
			$date_query = array(
				array(
					'year' => date('Y', $_REQUEST['mec_occurrence']),
					'monthnum' => date('m', $_REQUEST['mec_occurrence']),
					'day' => date('d', $_REQUEST['mec_occurrence']),
					'hour' => date('H', $_REQUEST['mec_occurrence']),
					'minute' => date('i', $_REQUEST['mec_occurrence']),
				),
			);

			$query->set('date_query', $date_query);
		}

		// Filter by Ticket ID
		if (isset($_REQUEST['mec_ticket_id']) and trim($_REQUEST['mec_ticket_id'])) {
			$meta_query[] = array(
				'key' => 'mec_ticket_id',
				'value' => ',' . sanitize_text_field($_REQUEST['mec_ticket_id']) . ',',
				'compare' => 'LIKE',
			);
		}

		// Filter by Ticket Name
		if (isset($_REQUEST['mec_ticket_name']) and trim($_REQUEST['mec_ticket_name'])) {
			$mec_ticket_end = explode(':..:', $_REQUEST['mec_ticket_name']);
			$meta_query[] = array(
				'relation' => 'AND',
				array(
					'key' => 'mec_ticket_id',
					'value' => sanitize_text_field(end($mec_ticket_end)),
					'compare' => 'LIKE',
				),
				array(
					'key' => 'mec_event_id',
					'value' => sanitize_text_field(current(explode(':..:', $_REQUEST['mec_ticket_name']))),
					'type' => 'numeric',
					'compare' => '=',
				),
			);
		}
		// Filter by Confirmation
		if (isset($_REQUEST['mec_confirmed']) and trim($_REQUEST['mec_confirmed']) != '') {
			$meta_query[] = array(
				'key' => 'mec_confirmed',
				'value' => sanitize_text_field($_REQUEST['mec_confirmed']),
				'compare' => '=',
				'type' => 'numeric',
			);
		}

		// Filter by ID
		if (isset($_REQUEST['id']) and trim($_REQUEST['id']) != '') {
			$meta_query[] = array(
				'orderby' => 'ID',
			);
		}

		// Filter by Order Date
		if (isset($_REQUEST['mec_order_date']) and trim($_REQUEST['mec_order_date']) != '') {
			$type = $_REQUEST['mec_order_date'];

			$min = current_time('Y-m-d');
			$max = date('Y-m-d', strtotime('Tomorrow'));

			if ($type == 'yesterday') {
				$min = date('Y-m-d', strtotime('Yesterday'));
				$max = current_time('Y-m-d');
			} elseif ($type == 'current_month') {
				$min = current_time('Y-m-01');
			} elseif ($type == 'last_month') {
				$min = date('Y-m-01', strtotime('Last Month'));
				$max = date('Y-m-t', strtotime('Last Month'));
			} elseif ($type == 'current_year') {
				$min = current_time('Y-01-01');
			} elseif ($type == 'last_year') {
				$min = date('Y-01-01', strtotime('Last Year'));
				$max = date('Y-12-31', strtotime('Last Year'));
			}

			$meta_query[] = array(
				'key' => 'mec_waiting_time',
				'value' => array($min, $max),
				'compare' => 'BETWEEN',
				'type' => 'DATETIME',
			);
		}

		// Filter by Location
		if (isset($_REQUEST['mec_booking_location']) and trim($_REQUEST['mec_booking_location']) != '') {
			$meta_query[] = array(
				'key' => 'mec_booking_location',
				'value' => sanitize_text_field($_REQUEST['mec_booking_location']),
				'compare' => '=',
				'type' => 'numeric',
			);
		}

		if (count($meta_query)) {
			$query->set('meta_query', $meta_query);
		}

	}

	public static function add_filters($post_type) {
		if ($post_type != self::$PT) {
			return;
		}

		$events = get_posts(array('post_type' => self::$main->get_main_post_type(), 'post_status' => 'publish', 'posts_per_page' => -1));
		$mec_event_id = isset($_REQUEST['mec_event_id']) ? sanitize_text_field($_REQUEST['mec_event_id']) : '';

		echo '<select name="mec_event_id" id="mec_filter_event_id">';
		echo '<option value="">' . __('Event', 'mec-waiting-list') . '</option>';
		foreach ($events as $event) {
			echo '<option value="' . $event->ID . '" ' . ($mec_event_id == $event->ID ? 'selected="selected"' : '') . '>' . $event->post_title . '</option>';
		}

		echo '</select>';

		echo "<script>
        jQuery(document).ready(function()
        {
            jQuery('#mec_filter_event_id').on('change', function()
            {
                jQuery('#mec_filter_occurrence').remove();

                var event_id = jQuery(this).val();
                jQuery.ajax(
                {
                    type: 'POST',
                    url: ajaxurl,
                    data: 'action=mec_booking_filters_occurrence&event_id='+event_id,
                    dataType: 'json',
                    success: function(data)
                    {
                        jQuery('#mec_filter_event_id').after(data.html);
                    },
                    error: function(jqXHR, textStatus, errorThrown)
                    {
                    }
                });
            });
        });
        </script>";

		if ($mec_event_id) {
			echo self::add_occurrence_filter($mec_event_id);
		}

		$tickets = self::$db->select("SELECT `post_id`, `meta_value` FROM `#__postmeta` WHERE `meta_key`='mec_tickets'", 'loadAssocList');
		if (!is_array($tickets)) {
			$tickets = array();
		}

		$mec_ticket_name = isset($_REQUEST['mec_ticket_name']) ? sanitize_text_field($_REQUEST['mec_ticket_name']) : '';

		echo '<select name="mec_ticket_name">';
		echo '<option value="">' . __('Ticket', 'mec-waiting-list') . '</option>';

		foreach ($tickets as $single_ticket) {
			$ticket_value = (is_serialized($single_ticket['meta_value'])) ? unserialize($single_ticket['meta_value']) : array();
			foreach ($ticket_value as $ticket) {
				$rendered_tickets = array();
				if (!in_array($ticket['name'], $rendered_tickets)) {
					$value = $single_ticket['post_id'] . ':..:' . ',' . key($ticket_value) . ',';
					echo '<option value="' . $value . '"' . selected($value, $mec_ticket_name) . '>' . (!trim($ticket['name']) ? get_the_title($single_ticket['post_id']) . __(' - Ticket', 'mec-waiting-list') . intval(key($ticket_value)) : $ticket['name']) . '</option>';
					$rendered_tickets[] = $ticket['name'];
				}

				next($ticket_value);
			}
		}

		echo '</select>';

		$mec_confirmed = isset($_REQUEST['mec_confirmed']) ? sanitize_text_field($_REQUEST['mec_confirmed']) : '';

		echo '<select name="mec_confirmed">';
		echo '<option value="">' . __('Confirmation', 'mec-waiting-list') . '</option>';
		echo '<option value="0" ' . ($mec_confirmed == '0' ? 'selected="selected"' : '') . '>' . __('Pending', 'mec-waiting-list') . '</option>';
		echo '<option value="-1" ' . ($mec_confirmed == '-1' ? 'selected="selected"' : '') . '>' . __('Rejected', 'mec-waiting-list') . '</option>';
		echo '</select>';

		$mec_order_date = isset($_REQUEST['mec_order_date']) ? sanitize_text_field($_REQUEST['mec_order_date']) : '';

		echo '<select name="mec_order_date">';
		echo '<option value="">' . __('Order Date', 'mec-waiting-list') . '</option>';
		echo '<option value="today" ' . ($mec_order_date == 'today' ? 'selected="selected"' : '') . '>' . __('Today', 'mec-waiting-list') . '</option>';
		echo '<option value="yesterday" ' . ($mec_order_date == 'yesterday' ? 'selected="selected"' : '') . '>' . __('Yesterday', 'mec-waiting-list') . '</option>';
		echo '<option value="current_month" ' . ($mec_order_date == 'current_month' ? 'selected="selected"' : '') . '>' . __('Current Month', 'mec-waiting-list') . '</option>';
		echo '<option value="last_month" ' . ($mec_order_date == 'last_month' ? 'selected="selected"' : '') . '>' . __('Last Month', 'mec-waiting-list') . '</option>';
		echo '<option value="current_year" ' . ($mec_order_date == 'current_year' ? 'selected="selected"' : '') . '>' . __('Current Year', 'mec-waiting-list') . '</option>';
		echo '<option value="last_year" ' . ($mec_order_date == 'last_year' ? 'selected="selected"' : '') . '>' . __('Last Year', 'mec-waiting-list') . '</option>';
		echo '</select>';

		$locations = get_terms('mec_location', array('hide_empty' => true));
		if (!is_array($locations)) {
			$locations = array();
		}

		$mec_booking_location = isset($_REQUEST['mec_booking_location']) ? sanitize_text_field($_REQUEST['mec_booking_location']) : '';

		echo '<select name="mec_booking_location">';
		echo '<option value="">' . __('Location', 'mec-waiting-list') . '</option>';
		foreach ($locations as $key => $value) {
			echo '<option value="' . $value->term_id . '" ' . ($mec_booking_location == $value->term_id ? 'selected="selected"' : '') . '>' . $value->name . '</option>';
		}
		echo '</select>';
	}

	public function add_bulk_actions() {
		global $post_type;

		if ($post_type == self::$PT) {
			?>
            <script type="text/javascript">
            jQuery(document).ready(function()
            {
                <?php foreach (array(
				'pending' => __('Pending', 'mec-waiting-list'),
				'confirm' => __('Confirm', 'mec-waiting-list'),
				'reject' => __('Reject', 'mec-waiting-list'),
				'verify' => __('Verify', 'mec-waiting-list'),
				'csv-export' => __('CSV Export', 'mec-waiting-list'),
				'ms-excel-export' => __('MS Excel Export', 'mec-waiting-list')) as $action => $label): ?>
                jQuery('<option>').val('<?php echo $action; ?>').text('<?php echo $label; ?>').appendTo("select[name='action']");
                jQuery('<option>').val('<?php echo $action; ?>').text('<?php echo $label; ?>').appendTo("select[name='action2']");
                <?php endforeach;?>
            });
            </script>
            <?php
	}
		}

	public function do_bulk_actions() {
		$wp_list_table = _get_list_table('WP_Posts_List_Table');

		$action = $wp_list_table->current_action();
		if (!$action) {
			return false;
		}

		$post_type = isset($_REQUEST['post_type']) ? sanitize_text_field($_REQUEST['post_type']) : 'post';
		if ($post_type != self::$PT) {
			return false;
		}

		check_admin_referer('bulk-posts');

		switch ($action) {
		case 'confirm':

			$post_ids = (isset($_REQUEST['post']) and is_array($_REQUEST['post'])) ? $_REQUEST['post'] : array();
			foreach ($post_ids as $post_id) {
				self::confirm((int) $post_id);
			}

			break;
		case 'pending':

			$post_ids = (isset($_REQUEST['post']) and is_array($_REQUEST['post'])) ? $_REQUEST['post'] : array();
			foreach ($post_ids as $post_id) {
				self::pending((int) $post_id);
			}

			break;
		case 'reject':

			$post_ids = (isset($_REQUEST['post']) and is_array($_REQUEST['post'])) ? $_REQUEST['post'] : array();
			foreach ($post_ids as $post_id) {
				self::reject((int) $post_id);
			}

			break;
		case 'verify':

			$post_ids = (isset($_REQUEST['post']) and is_array($_REQUEST['post'])) ? $_REQUEST['post'] : array();
			foreach ($post_ids as $post_id) {
				self::verify((int) $post_id);
			}

			break;
		case 'csv-export':
		case 'ms-excel-export':
            $filename='';
			if( 'ms-excel-export' === $action ){
                $filename ='waiting-list-'.md5(time().mt_rand(100, 999)).'.xlsx';
            }elseif( 'csv-export' === $action ){
                $filename ='waiting-list-' . md5(time() . mt_rand(100, 999)) . '.csv';
            }


			$post_ids = (isset($_REQUEST['post']) and is_array($_REQUEST['post'])) ? $_REQUEST['post'] : array();
			$event_ids = array();
			foreach ($post_ids as $post_id) {
				$event_ids[] = get_post_meta($post_id, 'mec_event_id', true);
			}

			$event_ids = array_unique($event_ids);

			$main_event_id = NULL;
			if (count($event_ids) == 1) {
				$main_event_id = $event_ids[0];
			}

			$columns = array(
				'ID' => __('ID', 'mec-waiting-list'),
				'name' => __('Event', 'mec-waiting-list'),
				'start_datetime' => __('Start Date & Time', 'mec-waiting-list'),
				'end_datetime' => __('End Date & Time', 'mec-waiting-list'),
				'order_time' => __('Waiting List Submission Time', 'mec-waiting-list'),
				'ticket_name' => self::$main->m('ticket', __('Ticket', 'mec-waiting-list')),
				'transaction_id' => __('Transaction ID', 'mec-waiting-list'),
				'total_price' => __('Total Price', 'mec-waiting-list'),
				'attendee_name' => __('Name', 'mec-waiting-list'),
				'attendee_email' => __('Email', 'mec-waiting-list'),
				'verified' => __('Verification', 'mec-waiting-list'),
				'confirmed' => __('Confirmation', 'mec-waiting-list')
			);

			$waite_fields = self::get_waite_fields($main_event_id);

            foreach ($waite_fields as $waite_field_key => $waite_field) {
				// Placeholder Keys
				if (!is_numeric($waite_field_key)) {
					continue;
				}

				$type = isset($waite_field['type']) ? $waite_field['type'] : '';
				$label = isset($waite_field['label']) ? __($waite_field['label'], 'mec-waiting-list') : '';

				if (trim($label) == '' or $type == 'name' or $type == 'mec_email') {
					continue;
				}

				if ($type == 'agreement') {
					$label = sprintf($label, get_the_title($waite_field['page']));
				}

				$columns[] = $label;
			}

            $columns = apply_filters('mec_csv_export_columns', $columns);

			$columns['attachments'] = 'Attachments';

			// Date & Time Format
			$datetime_format = get_option('date_format') . ' ' . get_option('time_format');
            $rows = [];
            $rows[] = $columns;
			foreach ($post_ids as $post_id) {
				$post_id = (int) $post_id;

				$event_id = get_post_meta($post_id, 'mec_event_id', true);
				$booker_id = get_post_field('post_author', $post_id);
				$transaction_id = get_post_meta($post_id, 'mec_transaction_id', true);
				$order_time = get_post_meta($post_id, 'mec_waiting_time', true);
				$tickets = get_post_meta($event_id, 'mec_tickets', true);
				$timestamps = explode(':', get_post_meta($post_id, 'mec_date', true));

				$attendees = get_post_meta($post_id, 'mec_attendees', true);
				if (!is_array($attendees) or (is_array($attendees) and !count($attendees))) {
					$attendees = array(get_post_meta($post_id, 'mec_attendee', true));
				}

				$price = get_post_meta($post_id, 'mec_price', true);
				$booker = get_userdata($booker_id);

				$confirmed = self::$main->get_confirmation_label(get_post_meta($post_id, 'mec_confirmed', true));
				$verified = self::$main->get_verification_label(get_post_meta($post_id, 'mec_verified', true));

				$ticket_variations = self::$main->ticket_variations($event_id);
				$transaction = array();

				$attachments = '';
				if (isset($attendees['attachments'])) {
					foreach ($attendees['attachments'] as $attachment) {
						$attachments .= @$attachment['url'] . "\n";
					}
				}

				$bookings = [];
				$counter = 0;
				foreach ($attendees as $key => $attendee) {
					if ($key === 'attachments') {
						continue;
					}

					if (isset($attendee[0]['MEC_TYPE_OF_DATA'])) {
						continue;
					}

					$ticket_variations_output = '';

					$ticket_id = isset($attendee['id']) ? $attendee['id'] : get_post_meta($post_id, 'mec_ticket_id', true);
					$location_name = isset($location_name) ? $location_name : '';
					$gateway_label = isset($gateway_label) ? $gateway_label : '';
					$other_dates_formatted = isset($other_dates_formatted) && is_array($other_dates_formatted) ? $other_dates_formatted : [];
					$booking = array(
						'ID' => $post_id,
						'Event' => get_the_title($event_id),
						'Start Date & Time' => date($datetime_format, $timestamps[0]),
						'End Date & Time' => date($datetime_format, $timestamps[1]),
						'Order Time' => $order_time ? date($datetime_format, strtotime($order_time)) : '',
						'Ticket' => (isset($tickets[$ticket_id]['name']) ? $tickets[$ticket_id]['name'] : __('Unknown', 'mec-waiting-list')),
						'Transaction ID' => $transaction_id,
						'Total Price' => self::$main->render_price(($price ? $price : 0)),
						'Name' => (isset($attendee['name']) ? $attendee['name'] : (isset($booker->first_name) ? trim($booker->first_name . ' ' . $booker->last_name) : '')),
						'Email' => (isset($attendee['email']) ? $attendee['email'] : @$booker->user_email),
						'Verification' => $verified,
						'Confirmation' => $confirmed,
					);
					$booking = apply_filters('mec_csv_export_waiting', $booking, $post_id);

					$reg_form = isset($attendee['reg']) ? $attendee['reg'] : array();
					foreach ($waite_fields as $field_id => $waite_field) {
					    if (!is_numeric($field_id)) {
					        continue;
					    }
					    $type = isset($waite_field['type']) ? $waite_field['type'] : '';
					    $label = isset($waite_field['label']) ? __($waite_field['label'], 'mec-waiting-list') : '';
					    if (trim($label) == '' or $type == 'name' or $type == 'mec_email') {
					        continue;
					    }
					    $booking[] = isset($reg_form[$field_id]) ? ((is_string($reg_form[$field_id]) and trim($reg_form[$field_id])) ? $reg_form[$field_id] : (is_array($reg_form[$field_id]) ? implode(' | ', $reg_form[$field_id]) : '---')) : '';
					}


					foreach($booking as $f_id => $f_v){

						$booking[$f_id] = str_replace(";", "&#59", $f_v);
					}

					if ($attachments) {
						$booking[] = $attachments;
						$attachments = '';
					}

					$bookings[] = $booking;
					$counter++;
				}

				$bookings = apply_filters('mec_csv_export_waiting_all', $bookings);
				foreach ($bookings as $b) $rows[] = $b;
				foreach ($rows as &$row) {
					foreach ($columns as $key => $col_name) {
						if (!isset($row[$key])) {
							$row[$key] = '';
						}
					}
				}
			}
            self::$main->generate_download_excel($rows, $filename);
			exit;

			break;
		default:return true;
		}

		wp_redirect('edit.php?post_type=' . self::$PT);
		exit;
	}

	/**
	 * Confirm a waiting
	 * @author Webnus <info@webnus.biz>
	 * @param int $waite_id
	 * @param string $mode
	 * @return boolean
	 */
	public static function confirm($waite_id, $mode = 'manually') {

		update_post_meta($waite_id, 'mec_confirmed', 1);

		do_action('mec_waiting_confirmated', $waite_id, $mode );

		return true;
	}

	/**
	 * Reject a waiting
	 * @author Webnus <info@webnus.biz>
	 * @param int $waite_id
	 * @return boolean
	 */
	public static function reject($waite_id) {
		update_post_meta($waite_id, 'mec_confirmed', -1);

		// Fires after rejecting a booking to send notifications etc.
		do_action('mec_waiting_rejected', $waite_id);

		return true;
	}

	/**
	 * Make a waiting pending
	 * @author Webnus <info@webnus.biz>
	 * @param int $waite_id
	 * @return boolean
	 */
	public static function pending($waite_id) {
		update_post_meta($waite_id, 'mec_confirmed', 0);

		// Fires after pending a waiting to send notifications etc.
		do_action('mec_waiting_pended', $waite_id);

		return true;
	}

	/**
	 * Verify a waiting
	 * @author Webnus <info@webnus.biz>
	 * @param int $waite_id
	 * @return boolean
	 */
	public static function verify($waite_id) {
		update_post_meta($waite_id, 'mec_verified', 1);

		// Fires after verifying a waiting to send notifications etc.
		do_action('mec_waiting_verified', $waite_id);

		return true;
	}

	/**
	 * Cancel a waiting
	 * @author Webnus <info@webnus.biz>
	 * @param int $waite_id
	 * @return boolean
	 */
	public static function cancel($waite_id) {
		update_post_meta($waite_id, 'mec_verified', -1);
		update_post_meta($waite_id, 'mec_cancelled_date', date('Y-m-d H:i:s', current_time('timestamp', 0)));

		// Fires after canceling a waiting to send notifications etc.
		do_action('mec_waiting_canceled', $waite_id);

		return true;
	}

	/**
	 * Waiting a waiting
	 * @author Webnus <info@webnus.biz>
	 * @param int $book_id
	 * @return boolean
	 */
	public function status_waiting($waite_id) {
		update_post_meta($waite_id, 'mec_verified', 0);

		// Fires after waiting a waiting to send notifications etc.
		do_action('mec_waiting_waiting', $waite_id);

		return true;
	}

	/**
	 * Save book data from backend
	 * @author Webnus <info@webnus.biz>
	 * @param int $post_id
	 * @return void
	 */
	public function save_waiting($post_id) {

		// Check if our nonce is set.
		if (!isset($_POST['mec_waite_nonce'])) {
			return;
		}

		// Verify that the nonce is valid.
		if (!wp_verify_nonce(sanitize_text_field($_POST['mec_waite_nonce']), 'mec_waite_data')) {
			return;
		}

		// If this is an autosave, our form has not been submitted, so we don't want to do anything.
		if (defined('DOING_AUTOSAVE') and DOING_AUTOSAVE) {
			return;
		}

		// New Booking
		$is_new_waiting = isset($_POST['mec_is_new_waiting']) ? sanitize_text_field($_POST['mec_is_new_waiting']) : 0;
		if ($is_new_waiting) {
			// Initialize Pay Locally Gateway to handle the booking
			$gateway = new \MEC_gateway_pay_locally();

			// Register Attendee
			$attendees = isset($_POST['mec_attendee']) ? $_POST['mec_attendee'] : array();
			$attendee = current( $attendees );

			$user_id = $gateway->register_user($attendee);

			$attention_date = isset($_POST['mec_date']) ? $_POST['mec_date'] : '';
			$attention_date = is_array( $attention_date ) ? sanitize_text_field( current( $attention_date ) ) : sanitize_text_field( $attention_date );

			$attention_times = explode(':', $attention_date);
			$date = date('Y-m-d H:i:s', trim($attention_times[0]));

			$date_ins = date('Y-m-d H:i:s', $attention_times[0]);

			$name = isset($attendee['name']) ? $attendee['name'] : '';
			$email = isset($attendee['email']) ? $attendee['email'] : '';

			$event_id = isset($_POST['mec_event_id']) ? sanitize_text_field($_POST['mec_event_id']) : '';

			$confirmation = isset($_POST['confirmation']) ? sanitize_text_field($_POST['confirmation']) : '';
			$verification = isset($_POST['verification']) ? sanitize_text_field($_POST['verification']) : '';

			$attendees_count = (int) (isset($_POST['mec_attendees_count']) ? sanitize_text_field($_POST['mec_attendees_count']) : 1);
			if ($attendees_count < 1) {
				$attendees_count = 1;
			}

			$tickets = array();
			for ($i = 1; $i <= $attendees_count; $i++) {
				$tickets[] = array_merge($attendee, array(
					'count' => 1,
					'variations' => array(),
					'reg' => null,
					'name' => $name,
					'email' => $email,
				));
			}

			$raw_tickets = array($ticket_id => $attendees_count);
			$event_tickets = get_post_meta($event_id, 'mec_tickets', true);

			$transaction = array();
			$transaction['tickets'] = $tickets;
			$transaction['date'] = $attention_date;
			$transaction['event_id'] = $event_id;
			$all_dates = array( $attention_date );

			// Calculate price of bookings
			$price_details = self::$book->get_price_details($raw_tickets, $event_id, $event_tickets, array(), $all_dates);

			$transaction['price_details'] = $price_details;
			$transaction['total'] = $price_details['total'];
			$transaction['discount'] = 0;
			$transaction['price'] = $price_details['total'];
			$transaction['coupon'] = NULL;

			remove_action('save_post', array(self::$thus, 'save_waiting'), 10); // In order to don't create infinitive

			wp_update_post(array(
				'ID' => $post_id,
				'post_title' => "{$name} {$email}",
				'post_date' => $date_ins,
			));
			update_post_meta($post_id, 'mec_attendees', $tickets);
			update_post_meta($post_id, 'mec_attendees_count', count($tickets));

			update_post_meta($post_id, 'mec_waite', (isset($attendee['waite']) ? $attendee['waite'] : array()));
			update_post_meta($post_id, 'mec_gateway', 'MEC_gateway_pay_locally');
			update_post_meta($post_id, 'mec_gateway_label', $gateway->label());
			update_post_meta($post_id, 'mec_event_id', $event_id);
			update_post_meta($post_id, 'mec_price', $price_details['total']);
			update_post_meta($post_id, 'mec_date', $attention_date);
			update_post_meta($post_id, 'mec_confirmed', $confirmation);
			update_post_meta($post_id, 'mec_verified', $verification);
			update_post_meta($post_id, 'attendees_info', array
				(
					"{$email}" => array(
						'count' => $attendees_count,
					),
				)
			);

			update_post_meta($post_id, 'mec_ticket_id', $ticket_id);
			update_post_meta($post_id, 'mec_waiting_time', current_time('Y-m-d H:i:s'));

			// For Waiting Badge
			update_post_meta($post_id, 'mec_waite_date_submit', date('YmdHis', current_time('timestamp', 0)));
		}

		// Edit Waiting
		$is_edit_waiting = isset($_POST['mec_waiting_edit_status']) ? sanitize_text_field($_POST['mec_waiting_edit_status']) : 0;

		if ($is_edit_waiting) {

			$event_id = isset($_POST['mec_event_id']) ? sanitize_text_field($_POST['mec_event_id']) : '';
			if ($event_id) {
				update_post_meta($post_id, 'mec_event_id', $event_id);
			}

			$attention_date = isset($_POST['mec_date']) ? sanitize_text_field($_POST['mec_date']) : '';
			if ($attention_date) {
				update_post_meta($post_id, 'mec_date', $attention_date);
			}

			$attention_times = explode(':', $attention_date);
			$date = date('Y-m-d H:i:s', trim($attention_times[0]));

			// Attendees
			$mec_attendees = get_post_meta($post_id, 'mec_attendees', true);
			$mec_atts = (isset($_POST['mec_att']) and is_array($_POST['mec_att'])) ? $_POST['mec_att'] : array();

			// Attachments
			$attachments = (isset($mec_attendees['attachments']) and is_array($mec_attendees['attachments'])) ? $mec_attendees['attachments'] : NULL;

			$waite_fields = self::get_waite_fields($event_id);

			$ticket_ids = '';
			$raw_tickets = array();
			$raw_variations = array();
			$done_files = array();

			$new_attendees = array();
			$new_attachments = array();
			foreach ($mec_atts as $key => $mec_att) {
				$original = isset($mec_attendees[$key]) ? $mec_attendees[$key] : array();

				$waite_data = (isset($mec_att['waite']) and is_array($mec_att['waite'])) ? $mec_att['waite'] : array();
				foreach ($waite_data as $waite_id => $waite_value) {
					if (!$waite_value) {
						continue;
					}

					$waite_field = isset($waite_fields[$waite_id]) ? $waite_fields[$waite_id] : NULL;
					if (!$waite_field) {
						continue;
					}

					$waite_field_type = isset($waite_field['type']) ? $waite_field['type'] : NULL;
					if ($waite_field_type !== 'file') {
						continue;
					}

					if (in_array($waite_value, $done_files)) {
						continue;
					}

					$new_attachments[] = array(
						'MEC_TYPE_OF_DATA' => 'attachment',
						'response' => 'SUCCESS',
						'filename' => basename(get_attached_file($waite_value)),
						'url' => wp_get_attachment_url($waite_value),
						'type' => get_post_mime_type($waite_value),
					);

					$done_files[] = $waite_value;
				}

				$new_attendee = array_merge($original, $mec_att);
				$new_attendees[] = $new_attendee;

				$ticket_id = isset($mec_att['id']) ? $mec_att['id'] : '';
				if ($ticket_id) {
					$ticket_ids .= $mec_att['id'] . ',';

					if (!isset($raw_tickets[$ticket_id])) {
						$raw_tickets[$ticket_id] = 1;
					} else {
						$raw_tickets[$ticket_id]++;
					}

					if (isset($new_attendee['variations']) and is_array($new_attendee['variations']) and count($new_attendee['variations'])) {
						foreach ($new_attendee['variations'] as $variation_id => $variation_count) {
							if (!trim($variation_count)) {
								continue;
							}

							if (!isset($raw_variations[$variation_id])) {
								$raw_variations[$variation_id] = $variation_count;
							} else {
								$raw_variations[$variation_id] += $variation_count;
							}

						}
					}
				}
			}

			// Apply Attachments
			if (count($new_attachments)) {
				$attachments = $new_attachments;
			}

			if (is_array($attachments)) {
				$new_attendees['attachments'] = $attachments;
			}

			update_post_meta($post_id, 'mec_attendees', $new_attendees);
			update_post_meta($post_id, 'mec_attendees_count', count($new_attendees));

			update_post_meta($post_id, 'mec_ticket_id', trim($ticket_id));

			// Pricing
			$event_tickets = get_post_meta($event_id, 'mec_tickets', true);
			$price_details = self::$book->get_price_details($raw_tickets, $event_id, $event_tickets, $raw_variations, $all_dates);

			update_post_meta($post_id, 'mec_price', $price_details['total']);

			remove_action('save_post', array(self::$thus, 'save_waiting'), 10); // In order to don't create infinitive loop!

			// Update Post
			wp_update_post(array(
				'ID' => $post_id,
				'post_date' => $date,
				'post_date_gmt' => get_gmt_from_date($date),
				'post_status' => 'publish',
			));

		}

		$new_confirmation = isset($_POST['confirmation']) ? sanitize_text_field($_POST['confirmation']) : NULL;
		$new_verification = isset($_POST['verification']) ? sanitize_text_field($_POST['verification']) : NULL;

		$confirmed = get_post_meta($post_id, 'mec_confirmed', true);
		$verified = get_post_meta($post_id, 'mec_verified', true);

		// Change Confirmation Status
		if (!is_null($new_confirmation) and $new_confirmation != $confirmed) {
			switch ($new_confirmation) {
			case '1':

				self::confirm($post_id);
				break;

			case '-1':

				self::reject($post_id);
				break;

			default:

				self::pending($post_id);
				break;
			}
		}

		// Change Verification Status
		if (!is_null($new_verification) and $new_verification != $verified) {
			switch ($new_verification) {
			case '1':

				self::verify($post_id);
				break;

			case '-1':

				self::cancel($post_id);
				break;

			default:

				self::status_waiting($post_id);
				break;
			}
		}

		if (get_post_status($post_id) == 'future') {
			wp_publish_post($post_id);
		}

		self::process_waiting($post_id, true);

	}

	public static function get_waite_fields($event_id = NULL) {
		$options = get_option('mec_options', array());
		$waite_fields = isset($options['waiting_fields']) ? $options['waiting_fields'] : array();

		// Event Booking Fields
		if ($event_id) {
			$global_inheritance = get_post_meta($event_id, 'mec_waiting_fields_global_inheritance', true);
			if (trim($global_inheritance) == '') {
				$global_inheritance = 1;
			}

			if (!$global_inheritance) {
				$event_reg_fields = get_post_meta($event_id, 'mec_waiting_fields', true);
				if (is_array($event_reg_fields)) {
					$waite_fields = $event_reg_fields;
				}

			}
		}

		return apply_filters('mec_get_waiting_reg_fields', $waite_fields, $event_id);
	}

	/**
	 * Process book steps from book form in frontend
	 * @author Webnus <info@webnus.biz>
	 */
	public static function waiting($event = null, $ticket_id = null, $dates = array(), $single_load = false) {

		if (!isset($event) || $event == null) {
			return;
		}

		$event_id = sanitize_text_field($event->ID);
		$waite_fields = self::get_waite_fields($event->ID);

		$path = MECWAITINGLISTDIR . DS . 'core' . DS . 'ui' . DS . 'form.php';
		$date = $dates[0]['start']['timestamp'] . ':' . $dates[0]['end']['timestamp'];

		ob_start();
		include $path;
		$output = ob_get_clean();
		return $output;
	}

	public function waiting_content() {
		$event_id = isset($_POST['event_id']) ? $_POST['event_id'] : null;
		$ticket_id = isset($_POST['ticket_id']) ? $_POST['ticket_id'] : null;
		$count = isset($_POST['count']) ? $_POST['count'] : null;

		$render = \MEC::getInstance('app.libraries.render');
		$rendered = $render->data($event_id, '');

		$event = new \stdClass();
		$event->ID = $event_id;
		$event->data = $rendered;

		if (!isset($event) || $event == null) {
			return 'Failed';
		}

		$event_id = sanitize_text_field($event->ID);
		$waite_fields = self::get_waite_fields($event->ID);

		$path = MECWAITINGLISTDIR . DS . 'core' . DS . 'ui' . DS . 'form_content.php';

		ob_start();
		include $path;
		$output = ob_get_clean();
		echo $output;
		exit();
	}

	public static function get_user_waiting_limit($event_id) {
		$unlimited = false;
		$limit = 12;
		$mec_settings = self::$main->get_settings();
		$waiting_options = get_post_meta($event_id, 'mec_waiting', true);

		// Total user booking limited
		if (isset($waiting_options['waiting_user_limit_unlimited']) and !trim($waiting_options['waiting_user_limit_unlimited'])) {
			$limit = (isset($waiting_options['waiting_user_limit']) and trim($waiting_options['waiting_user_limit'])) ? trim($waiting_options['waiting_user_limit']) : $limit;
		} else {
			// If Inherit from global options activate
			if (!isset($mec_settings['waiting_limit']) or (isset($mec_settings['waiting_limit']) and !trim($mec_settings['waiting_limit']))) {
				$unlimited = true;
			} else {
				$limit = trim($mec_settings['waiting_limit']);
			}

		}

		return array($limit, $unlimited);
	}

	/**
	 * User limited for waiting a ticket
	 * @author Webnus <info@webnus.biz>
	 * @param string $user_email
	 * @param array $ticket_info
	 * @param integer $limit
	 * @return array|boolean
	 */
	public function waiting_permitted($user_email, $ticket_info, $limit, $ticket_id) {
		if (!is_array($ticket_info) or is_array($ticket_info) and count($ticket_info) < 2) {
			return false;
		}

		$user_email = sanitize_email($user_email);
		$user = get_user_by('email', $user_email);
		$user_id = (isset($user->data) and isset($user->data->ID)) ? $user->data->ID : 0;

		// It's the first booking of this email
		if (!$user_id) {
			return true;
		}

		$event_id = isset($ticket_info['event_id']) ? intval($ticket_info['event_id']) : 0;
		$count = isset($ticket_info['count']) ? intval($ticket_info['count']) : 0;

		$timestamp = isset($ticket_info['date']) ? $ticket_info['date'] : '';
		if (!is_numeric($timestamp)) {
			$timestamp = strtotime($timestamp);
		}

		$year = date('Y', $timestamp);
		$month = date('m', $timestamp);
		$day = date('d', $timestamp);
		$hour = date('H', $timestamp);
		$minutes = date('i', $timestamp);

		$permission = true;
		$query = new \WP_Query(array
			(
				'post_type' => self::$PT,
				'author' => $user_id,
				'posts_per_page' => -1,
				'post_status' => array('publish', 'pending', 'draft', 'future', 'private'),
				'year' => $year,
				'monthnum' => $month,
				'day' => $day,
				'hour' => $hour,
				'minute' => $minutes,
				'meta_query' => array
				(
					array('key' => 'mec_ticket_id', 'value' => $ticket_id, 'compare' => '='),
					array('key' => 'mec_verified', 'value' => '-1', 'compare' => '!='), // Don't include canceled bookings
					array('key' => 'mec_confirmed', 'value' => '-1', 'compare' => '!='), // Don't include rejected bookings
				),
			));

		$bookings = 0;
		if ($query->have_posts()) {
			while ($query->have_posts()) {
				$query->the_post();

				$ticket_ids_string = trim(get_post_meta(get_the_ID(), 'mec_ticket_id', true), ', ');
				$ticket_ids_count = count(explode(',', $ticket_ids_string));

				$bookings += $ticket_ids_count;
			}
		}

		if (($bookings + $count) > $limit) {
			$permission = false;
		}

		return array('booking_count' => $bookings, 'permission' => $permission);
	}

	public function waiting_submit() {

		$waiting = $_REQUEST['waiting'];
		$event_id = isset($_POST['event_id']) ? $_POST['event_id'] : null;
		$ticket_id = isset($_POST['ticket_id']) ? $_POST['ticket_id'] : null;
		$date = isset($waiting['date']) ? $waiting['date'] : NULL;
		$tickets = isset($waiting['tickets']) ? $waiting['tickets'] : NULL;
		$uniqueid = isset($_REQUEST['uniqueid']) ? sanitize_text_field($_REQUEST['uniqueid']) : $event_id;
		$all_dates = array( $date );

		$options = self::$main->get_options();
		$settings = isset($options['settings']) ? $options['settings'] : array();

		if (is_null($date) or is_null($tickets)) {
			return wp_send_json_error(array(
				'success' => 0,
				'message' => __('Invalid request.', 'mec-waiting-list'),
				'code' => 'INVALID_REQUEST')
			);
		}

		// Render libraary
		$render = \MEC::getInstance('app.libraries.render');
		$rendered = $render->data($event_id, '');

		$event = new \stdClass();
		$event->ID = $event_id;
		$event->data = $rendered;

		$response_data = array();

		// User Booking Limits
		list($limit, $unlimited) = self::get_user_waiting_limit($event_id);

		$raw_tickets = array();
		$raw_variations = array();
		$validated_tickets = array();

		// Apply first attendee information for all attendees
		$first_for_all = isset($waiting['first_for_all']) ? $waiting['first_for_all'] : 0;

		if ($first_for_all) {
			$first_attendee = NULL;

			$rendered_tickets = array();
			foreach ($tickets as $ticket) {
				// Find first ticket
				if (is_null($first_attendee)) {
					$first_attendee = $ticket;
				}

				$ticket['name'] = $first_attendee['name'];
				$ticket['email'] = $first_attendee['email'];
				$ticket['reg'] = isset($first_attendee['reg']) ? $first_attendee['reg'] : '';
				$ticket['variations'] = isset($first_attendee['variations']) ? $first_attendee['variations'] : array();

				$rendered_tickets[] = $ticket;
			}

			$tickets = $rendered_tickets;
		}

		$booking_options = get_post_meta($event_id, 'mec_booking', true);
		$attendees_info = array();

		foreach ($tickets as $ticket) {
			if (isset($ticket['email']) and (trim($ticket['email']) == '' or !filter_var($ticket['email'], FILTER_VALIDATE_EMAIL))) {
				continue;
			}

			// Booking limit attendee
			if (!$unlimited) {
				if (!array_key_exists($ticket['email'], $attendees_info)) {
					$attendees_info[$ticket['email']] = array('count' => $ticket['count']);
				} else {
					$attendees_info[$ticket['email']]['count'] = ($attendees_info[$ticket['email']]['count'] + $ticket['count']);
				}

			}

			if (!isset($ticket['name']) or (isset($ticket['name']) and trim($ticket['name']) == '')) {
				continue;
			}

			if (!isset($raw_tickets[$ticket['id']])) {
				$raw_tickets[$ticket['id']] = 1;
			} else {
				$raw_tickets[$ticket['id']] += 1;
			}

			if (isset($ticket['variations']) and is_array($ticket['variations']) and count($ticket['variations'])) {
				foreach ($ticket['variations'] as $variation_id => $variation_count) {
					if (!trim($variation_count)) {
						continue;
					}

					if (!isset($raw_variations[$variation_id])) {
						$raw_variations[$variation_id] = $variation_count;
					} else {
						$raw_variations[$variation_id] += $variation_count;
					}

				}
			}

			$validated_tickets[] = $ticket;
		}

		if (!$unlimited) {
			foreach ($attendees_info as $attendee_email => $attendee_info) {
				if ($attendee_info['count'] > $limit) {

					return wp_send_json_error(array(
						'success' => 0,
						'message' => sprintf(__("You selected %s waiting in sold up book but maximum number of waites per user is %s waite.", 'mec-waiting-list'),$attendee_info['count'],$limit),
						'code' => 'LIMIT_REACHED')
					);

				} else {
					$permitted_info = self::waiting_permitted($attendee_email, array('event_id' => $event_id, 'date' => explode(':', $date)[0], 'count' => $attendee_info['count']), $limit, $ticket_id);
					if ($permitted_info['permission'] === false) {

						return wp_send_json_error(array(
							'success' => 0,
							'message' => __("You booked {$permitted_info['booking_count']} tickets till now but maximum number of tickets per user is {$limit} tickets.", 'mec-waiting-list'),
							'code' => 'LIMIT_REACHED')
						);

					}
				}
			}
		}

		// Attendee form is not filled correctly
		if (count($validated_tickets) != count($tickets)) {

			return wp_send_json_error(array(
				'success' => 0,
				'message' => __('Please fill in the form correctly. Email and Name fields are required!', 'mec-waiting-list'),
				'code' => 'LIMIT_REACHED')
			);
		}

		// Attachments
		if (isset($attachments)) {
			$validated_tickets['attachments'] = $attachments;
		}

		// Tickets
		$event_tickets = isset($event->data->tickets) ? $event->data->tickets : array();

		// Calculate price of bookings
		$price_details = self::$book->get_price_details($raw_tickets, $event_id, $event_tickets, $raw_variations, $all_dates);

		$book['tickets'] = $validated_tickets;
		$book['price_details'] = $price_details;
		$book['total'] = $price_details['total'];
		$book['discount'] = 0;
		$book['price'] = $price_details['total'];
		$book['coupon'] = NULL;

		// $transaction_id = self::$book->temporary($book);
		$gateway = new \MEC_gateway_pay_locally();
		$args = array(
			'name' => $validated_tickets[0]['name'],
			'email' => $validated_tickets[0]['email'],
			'event_id' => $event_id,
			'source' => 'waiting'
		);
		$user_id = $gateway->register_user($args);
		$date_e = explode(':', $date);
		//$date_ins = date_i18n( get_option('date_format'), $date_e[0] );
		$date_ins = date('Y-m-d H:i:s', $date_e[0]);
		$values = array(
			'post_author' => $user_id,
			'post_type' => self::$PT,
			'post_title' => "{$validated_tickets[0]['name']} {$validated_tickets[0]['email']}",
			'post_date' => $date_ins,
			'attendees_info' => array
			(
				"{$validated_tickets[0]['email']}" => array(
					'count' => count($book['tickets']),
				),

			),
			'mec_attendees' => $validated_tickets,
			'post_status' => 'publish',
		);

		$waite_id = wp_insert_post($values);

		User::instance()->assign( $waite_id, $user_id );

		// Publish it
		wp_publish_post($waite_id);
		$msg = __('Submit Waiting List', 'mec-waiting-list');

		update_post_meta($waite_id, 'mec_date', $date);
		update_post_meta($waite_id, 'mec_price', $book['price']);

		update_post_meta($waite_id, 'mec_event_id', $event_id);
		update_post_meta($waite_id, 'mec_ticket_id', $ticket_id);
		update_post_meta($waite_id, 'mec_waiting_time', current_time('Y-m-d H:i:s'));
		update_post_meta($waite_id, 'mec_waiting_date_submit', date('YmdHis', current_time('timestamp', 0)));

		// For Badget Bubble Notification Alert Count From It.
		update_post_meta($waite_id, 'mec_waite_date_submit', date('YmdHis', current_time('timestamp', 0)));

		$location_id = get_post_meta($event_id, 'mec_location_id', true);
		if (!empty($location_id)) {
			update_post_meta($waite_id, 'mec_booking_location', $location_id);
		}

		if (isset($values['mec_attendees'])) {
			foreach ($values['mec_attendees'] as $k => $mec_attendee) {
				if (!is_numeric($k)) {
					continue;
				}

				$values['mec_attendees'][$k]['buyerip'] = self::$main->get_client_ip();
			}

			update_post_meta($waite_id, 'mec_attendees', $values['mec_attendees']);
			update_post_meta($waite_id, 'mec_attendees_count', count($values['mec_attendees']));
		}

		if (isset($settings['waiting_verified']) && $settings['waiting_verified'] == '1') {

			self::verify( $waite_id );
			$msg = __('Waiting List Submission Successful!', 'mec-waiting-list');
		} else {

			update_post_meta($waite_id, 'mec_verified', 0);
			$msg = __('Please Verify Email address by email inbox verify link.', 'mec-waiting-list');
		}
		update_post_meta($waite_id, 'mec_verification_key', md5(time() . mt_rand(10000, 99999)));
		update_post_meta($waite_id, 'mec_cancellation_key', md5(time() . mt_rand(10000, 99999)));

		if (isset($settings['waiting_confirmation']) && $settings['waiting_confirmation'] == '1') {
            if (isset($settings['waiting_verified']) && $settings['waiting_verified'] == '1') {
                self::confirm($waite_id, 'auto');
            }
		} else {

			update_post_meta($waite_id, 'mec_confirmed', 0);
		}

		do_action('mec_waiting_completed', $waite_id);

		return wp_send_json_success(array('waite_id' => $waite_id, 'msg' => $msg));

	}

	public function change_tickets_count_handler($event_id){

		if( 'mec-events' !== get_post_type( $event_id ) ){

			return;
		}

		$tickets = get_post_meta($event_id, 'mec_tickets', true);
		$tickets = is_array( $tickets ) ? $tickets : array();

		$done = array();

		foreach( $tickets as $ticket_id => $ticket ){

			$waites = self::waiting_queue_remove($event_id, $ticket_id, 0, 99999 );
			if ($waites == false) {
				// Cannot find waiting in ticket
				continue;
			}

			foreach( $waites as $waiting ){

				$waiting_id = $waiting->ID;
				if( 'trash' === get_post_status( $waiting_id ) ){

					continue;
				}

				$date_meta = get_post_meta($waiting_id, 'mec_date', true);

				$date_ex = explode(':', $date_meta);
				$occurrence_time = (int) $date_ex[0];

				if( $occurrence_time < current_time('timestamp') ){

					continue;
				}

				if( !isset( $done[ $ticket_id ][ $occurrence_time ] ) ){

					self::process_waiting( $waiting_id );

					$done[ $ticket_id ][ $occurrence_time ] = 1;
				}
			}
		}
	}

	public function tickets_availability() {
		$event_id = isset($_REQUEST['event_id']) ? sanitize_text_field($_REQUEST['event_id']) : '';
		$date = isset($_REQUEST['date']) ? sanitize_text_field($_REQUEST['date']) : '';

		$ex = explode(':', $date);
		$date = $ex[0];

		$availability = self::$book->get_tickets_availability($event_id, $date);
		$prices = self::$book->get_tickets_prices($event_id, current_time('Y-m-d'), 'price_label');

		$this->main->response(array('success' => 1, 'availability' => $availability, 'prices' => $prices));
	}

	public function bbf_date_tickets_booking_form() {
		$event_id = isset($_REQUEST['event_id']) ? sanitize_text_field($_REQUEST['event_id']) : '';

		// Event is invalid!
		if (!trim($event_id)) {
			$this->main->response(array('success' => 0, 'output' => '<div class="warning-msg">' . __('Event is invalid. Please select an event.', 'mec-waiting-list') . '</div>'));
		}

		$tickets = get_post_meta($event_id, 'mec_tickets', true);

		$render = $this->getRender();
		$dates = $render->dates($event_id, NULL, 10);

		// Invalid Event, Tickets or Dates
		if (!is_array($tickets) or (is_array($tickets) and !count($tickets))) {
			$this->main->response(array('success' => 0, 'output' => '<div class="warning-msg">' . __('No ticket or future date found for this event! Please try another event.', 'mec-waiting-list') . '</div>'));
		}

		$date_format = (isset(self::$settings['booking_date_format1']) and trim(self::$settings['booking_date_format1'])) ? self::$settings['booking_date_format1'] : 'Y-m-d';

		$repeat_type = get_post_meta($event_id, 'mec_repeat_type', true);
		if ($repeat_type === 'custom_days') {
			$date_format .= ' ' . get_option('time_format');
		}

		// Date Option
		$date_options = '';
		foreach ($dates as $date) {
			$date_options .= '<option value="' . self::$book->timestamp($date['start'], $date['end']) . '">' . strip_tags($this->main->date_label($date['start'], $date['end'], $date_format)) . '</option>';
		}

		$output = '<div class="mec-form-row"><div class="mec-col-2"><label for="mec_book_form_date">' . __('Date', 'mec-waiting-list') . '</label></div>';
		$output .= '<div class="mec-col-6"><select class="widefat" name="mec_date" id="mec_book_form_date">' . $date_options . '</select></div></div>';

		// Ticket option
		$ticket_options = '';
		foreach ($tickets as $ticket_id => $ticket) {
			$ticket_options .= '<option value="' . $ticket_id . '">' . $ticket['name'] . '</option>';
		}

		$output .= '<div class="mec-form-row"><div class="mec-col-2"><label for="mec_book_form_ticket_id">' . __('Ticket', 'mec-waiting-list') . '</label></div>';
		$output .= '<div class="mec-col-6"><select class="widefat" name="mec_ticket_id" id="mec_book_form_ticket_id">' . $ticket_options . '</select></div></div>';

		// Number of Attendees
		$output .= '<div class="mec-form-row"><div class="mec-col-2"><label for="mec_book_form_attendees_count">' . __('Number of Attendees', 'mec-waiting-list') . '</label></div>';
		$output .= '<div class="mec-col-6"><input type="number" class="widefat" name="mec_attendees_count" id="mec_book_form_attendees_count" value="1" min="1"></div></div>';

		// Booking Form
		$waite_fields = $this->main->get_waite_fields($event_id);

		$mec_email = false;
		$mec_name = false;
		foreach ($waite_fields as $field) {
			if (isset($field['type'])) {
				if ($field['type'] == 'mec_email') {
					$mec_email = true;
				}

				if ($field['type'] == 'name') {
					$mec_name = true;
				}

			}
		}

		if (!$mec_name) {
			$waite_fields[] = array(
				'mandatory' => '0',
				'type' => 'name',
				'label' => esc_html__('Name', 'mec-waiting-list'),
			);
		}

		if (!$mec_email) {
			$waite_fields[] = array(
				'mandatory' => '0',
				'type' => 'mec_email',
				'label' => esc_html__('Email', 'mec-waiting-list'),
			);
		}

		$booking_form_options = '';

		if (count($waite_fields)) {
			foreach ($waite_fields as $waite_field_id => $waite_field) {
				if (!is_numeric($waite_field_id) or !isset($waite_field['type'])) {
					continue;
				}

				$booking_form_options .= '<div class="mec-form-row">';

				if (isset($waite_field['label']) and $waite_field['type'] != 'agreement') {
					$booking_form_options .= '<div class="mec-col-2"><label for="mec_book_waite_field_reg' . $waite_field_id . '">' . __($waite_field['label'], 'mec-waiting-list') . '</label></div>';
				} elseif (isset($waite_field['label']) and $waite_field['type'] == 'agreement') {
					$booking_form_options .= '<div class="mec-col-2"></div>';
				}

				$booking_form_options .= '<div class="mec-col-6">';
				$mandatory = (isset($waite_field['mandatory']) and $waite_field['mandatory']) ? true : false;

				if ($waite_field['type'] == 'name') {
					$booking_form_options .= '<input class="widefat" id="mec_book_waite_field_reg' . $waite_field_id . '" type="text" name="mec_attendee[name]" value="" placeholder="' . __('Name', 'mec-waiting-list') . '" required="required" />';
				} elseif ($waite_field['type'] == 'mec_email') {
					$booking_form_options .= '<input class="widefat" id="mec_book_waite_field_reg' . $waite_field_id . '" type="email" name="mec_attendee[email]" value="" placeholder="' . __('Email', 'mec-waiting-list') . '" required="required" />';
				} elseif ($waite_field['type'] == 'text') {
					$booking_form_options .= '<input class="widefat" id="mec_book_waite_field_reg' . $waite_field_id . '" type="text" name="mec_attendee[reg][' . $waite_field_id . ']" value="" placeholder="' . __($waite_field['label'], 'mec-waiting-list') . '" ' . ($mandatory ? 'required="required"' : '') . ' />';
				} elseif ($waite_field['type'] == 'date') {
					$booking_form_options .= '<input class="widefat" id="mec_book_waite_field_reg' . $waite_field_id . '" type="date" name="mec_attendee[reg][' . $waite_field_id . ']" value="" placeholder="' . __($waite_field['label'], 'mec-waiting-list') . '" ' . ($mandatory ? 'required="required"' : '') . ' min="1970-01-01" max="2099-12-31" />';
				} elseif ($waite_field['type'] == 'email') {
					$booking_form_options .= '<input class="widefat" id="mec_book_waite_field_reg' . $waite_field_id . '" type="email" name="mec_attendee[reg][' . $waite_field_id . ']" value="" placeholder="' . __($waite_field['label'], 'mec-waiting-list') . '" ' . ($mandatory ? 'required="required"' : '') . ' />';
				} elseif ($waite_field['type'] == 'tel') {
					$booking_form_options .= '<input class="widefat" oninput="this.value=this.value.replace(/(?![0-9])./gmi,"")" id="mec_book_waite_field_reg' . $waite_field_id . '" type="tel" name="mec_attendee[reg][' . $waite_field_id . ']" value="" placeholder="' . __($waite_field['label'], 'mec-waiting-list') . '" ' . ($mandatory ? 'required="required"' : '') . ' />';
				} elseif ($waite_field['type'] == 'textarea') {
					$booking_form_options .= '<textarea class="widefat" id="mec_book_waite_field_reg' . $waite_field_id . '" name="mec_attendee[reg][' . $waite_field_id . ']" placeholder="' . __($waite_field['label'], 'mec-waiting-list') . '" ' . ($mandatory ? 'required="required"' : '') . '></textarea>';
				} elseif ($waite_field['type'] == 'p') {
					$booking_form_options .= '<p>' . __($waite_field['content'], 'mec-waiting-list') . '</p>';
				} elseif ($waite_field['type'] == 'select') {
					$booking_form_options .= '<select class="widefat" id="mec_book_waite_field_reg' . $waite_field_id . '" name="mec_attendee[reg][' . $waite_field_id . ']" placeholder="' . __($waite_field['label'], 'mec-waiting-list') . '" ' . ($mandatory ? 'required="required"' : '') . '>';
					foreach ($waite_field['options'] as $waite_field_option) {
						$booking_form_options .= '<option value="' . esc_attr__($waite_field_option['label'], 'mec-waiting-list') . '">' . __($waite_field_option['label'], 'mec-waiting-list') . '</option>';
					}

					$booking_form_options .= '</select>';
				} elseif ($waite_field['type'] == 'radio') {
					foreach ($waite_field['options'] as $waite_field_option) {
						$booking_form_options .= '<label for="mec_book_waite_field_reg' . $waite_field_id . '_' . strtolower(str_replace(' ', '_', $waite_field_option['label'])) . '">
                            <input type="radio" id="mec_book_waite_field_reg' . $waite_field_id . '_' . strtolower(str_replace(' ', '_', $waite_field_option['label'])) . '" name="mec_attendee[reg][' . $waite_field_id . ']" value="' . __($waite_field_option['label'], 'mec-waiting-list') . '" />
                            ' . __($waite_field_option['label'], 'mec-waiting-list') . '
                        </label>';
					}
				} elseif ($waite_field['type'] == 'checkbox') {
					foreach ($waite_field['options'] as $waite_field_option) {
						$booking_form_options .= '<label for="mec_book_waite_field_reg' . $waite_field_id . '_' . strtolower(str_replace(' ', '_', $waite_field_option['label'])) . '">
                            <input type="checkbox" id="mec_book_waite_field_reg' . $waite_field_id . '_' . strtolower(str_replace(' ', '_', $waite_field_option['label'])) . '" name="mec_attendee[reg][' . $waite_field_id . '][]" value="' . __($waite_field_option['label'], 'mec-waiting-list') . '" />
                            ' . __($waite_field_option['label'], 'mec-waiting-list') . '
                        </label>';
					}
				} elseif ($waite_field['type'] == 'agreement') {
					$booking_form_options .= '<label for="mec_book_waite_field_reg' . $waite_field_id . '">
                        <input type="checkbox" id="mec_book_waite_field_reg' . $waite_field_id . '" name="mec_attendee[reg][' . $waite_field_id . ']" value="1" ' . ((!isset($waite_field['status']) or (isset($waite_field['status']) and $waite_field['status'] == 'checked')) ? 'checked="checked"' : '') . ' ' . ($mandatory ? 'required="required"' : '') . ' />
                        ' . sprintf(__($waite_field['label'], 'mec-waiting-list'), '<a href="' . get_the_permalink($waite_field['page']) . '" target="_blank">' . get_the_title($waite_field['page']) . '</a>') . '
                    </label>';
				}

				$booking_form_options .= '</div>';
				$booking_form_options .= '</div>';
			}
		}

		$output .= '<h3>' . __('Attendee Information', 'mec-waiting-list') . '</h3>';
		$output .= $booking_form_options;

		$this->main->response(array('success' => 1, 'output' => $output));
	}

	public function bbf_event_edit_options() {
		$event_id = isset($_REQUEST['event_id']) ? sanitize_text_field($_REQUEST['event_id']) : '';

		// Event is invalid!
		if (!trim($event_id)) {
			$this->main->response(array('success' => 0, 'output' => '<div class="warning-msg">' . __('Event is invalid. Please select an event.', 'mec-waiting-list') . '</div>'));
		}

		$tickets = get_post_meta($event_id, 'mec_tickets', true);

		$render = $this->getRender();
		$dates = $render->dates($event_id, NULL, 100);

		// Invalid Event, Tickets or Dates
		if (!is_array($tickets) or (is_array($tickets) and !count($tickets))) {
			$this->main->response(array('success' => 0, 'output' => '<div class="warning-msg">' . __('No ticket or future date found for this event! Please try another event.', 'mec-waiting-list') . '</div>'));
		}

		$date_format = (isset(self::$settings['booking_date_format1']) and trim(self::$settings['booking_date_format1'])) ? self::$settings['booking_date_format1'] : 'Y-m-d';

		$repeat_type = get_post_meta($event_id, 'mec_repeat_type', true);
		if ($repeat_type === 'custom_days') {
			$date_format .= ' ' . get_option('time_format');
		}

		// Date Option
		$date_options = '';
		foreach ($dates as $date) {
			$date_options .= '<option value="' . self::$book->timestamp($date['start'], $date['end']) . '">' . strip_tags($this->main->date_label($date['start'], $date['end'], $date_format)) . '</option>';
		}

		// Ticket option
		$ticket_options = '';
		foreach ($tickets as $ticket_id => $ticket) {
			$ticket_options .= '<option value="' . $ticket_id . '">' . $ticket['name'] . '</option>';
		}

		// Variations Options
		$variation_options = '';

		$ticket_variations = $this->main->ticket_variations($event_id);
		foreach ($ticket_variations as $ticket_variation_id => $ticket_variation) {
			if (!is_numeric($ticket_variation_id) or !isset($ticket_variation['title']) or (isset($ticket_variation['title']) and !trim($ticket_variation['title']))) {
				continue;
			}

			$key = ':key:';
			$variation_options .= '<div class="mec-form-row">
                <div class="mec-col-2">
                    <label for="mec_att_' . $key . '_variations_' . $ticket_variation_id . '" class="mec-ticket-variation-name">' . $ticket_variation['title'] . '</label>
                </div>
                <div class="mec-col-6">
                    <input id="mec_att_' . $key . '_variations_' . $ticket_variation_id . '" type="number" min="0" max="' . ((is_numeric($ticket_variation['max']) and $ticket_variation['max']) ? $ticket_variation['max'] : 1) . '" name="mec_att[' . $key . '][variations][' . $ticket_variation_id . ']" value="0">
                </div>
            </div>';
		}

		// Booking Form Options
		$booking_form_options = '';

		$waite_fields = $this->main->get_waite_fields($event_id);
		foreach ($waite_fields as $waite_field_id => $waite_field) {
			if (!is_numeric($waite_field_id) or !isset($waite_field['type']) or (isset($waite_field['type']) and !trim($waite_field['type']))) {
				continue;
			}

			if (in_array($waite_field['type'], array('name', 'mec_email'))) {
				continue;
			}

			$key = ':key:';
			$booking_form_options .= '<div class="mec-form-row">';

			if (isset($waite_field['label']) and $waite_field['type'] != 'agreement') {
				$booking_form_options .= '<div class="mec-col-2"><label for="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '">' . __($waite_field['label'], 'mec-waiting-list') . '</label></div>';
			} elseif (isset($waite_field['label']) and $waite_field['type'] == 'agreement') {
				$booking_form_options .= '<div class="mec-col-2"></div>';
			}

			$booking_form_options .= '<div class="mec-col-6">';
			$mandatory = (isset($waite_field['mandatory']) and $waite_field['mandatory']) ? true : false;

			if ($waite_field['type'] == 'text') {
				$booking_form_options .= '<input class="widefat" id="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '" type="text" name="mec_att[' . $key . '][reg][' . $waite_field_id . ']" value="" placeholder="' . __($waite_field['label'], 'mec-waiting-list') . '" ' . ($mandatory ? 'required="required"' : '') . ' />';
			} elseif ($waite_field['type'] == 'date') {
				$booking_form_options .= '<input class="widefat" id="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '" type="date" name="mec_att[' . $key . '][reg][' . $waite_field_id . ']" value="" placeholder="' . __($waite_field['label'], 'mec-waiting-list') . '" ' . ($mandatory ? 'required="required"' : '') . ' min="1970-01-01" max="2099-12-31" />';
			} elseif ($waite_field['type'] == 'email') {
				$booking_form_options .= '<input class="widefat" id="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '" type="email" name="mec_att[' . $key . '][reg][' . $waite_field_id . ']" value="" placeholder="' . __($waite_field['label'], 'mec-waiting-list') . '" ' . ($mandatory ? 'required="required"' : '') . ' />';
			} elseif ($waite_field['type'] == 'tel') {
				$booking_form_options .= '<input class="widefat" oninput="this.value=this.value.replace(/(?![0-9])./gmi,"")" id="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '" type="tel" name="mec_att[' . $key . '][reg][' . $waite_field_id . ']" value="" placeholder="' . __($waite_field['label'], 'mec-waiting-list') . '" ' . ($mandatory ? 'required="required"' : '') . ' />';
			} elseif ($waite_field['type'] == 'textarea') {
				$booking_form_options .= '<textarea class="widefat" id="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '" name="mec_att[' . $key . '][reg][' . $waite_field_id . ']" placeholder="' . __($waite_field['label'], 'mec-waiting-list') . '" ' . ($mandatory ? 'required="required"' : '') . '></textarea>';
			} elseif ($waite_field['type'] == 'select') {
				$booking_form_options .= '<select class="widefat" id="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '" name="mec_att[' . $key . '][reg][' . $waite_field_id . ']" placeholder="' . __($waite_field['label'], 'mec-waiting-list') . '" ' . ($mandatory ? 'required="required"' : '') . '>';
				foreach ($waite_field['options'] as $waite_field_option) {
					$booking_form_options .= '<option value="' . esc_attr__($waite_field_option['label'], 'mec-waiting-list') . '">' . __($waite_field_option['label'], 'mec-waiting-list') . '</option>';
				}

				$booking_form_options .= '</select>';
			} elseif ($waite_field['type'] == 'radio') {
				foreach ($waite_field['options'] as $waite_field_option) {
					$booking_form_options .= '<label for="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '_' . strtolower(str_replace(' ', '_', $waite_field_option['label'])) . '">
                        <input type="radio" id="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '_' . strtolower(str_replace(' ', '_', $waite_field_option['label'])) . '" name="mec_att[' . $key . '][reg][' . $waite_field_id . ']" value="' . __($waite_field_option['label'], 'mec-waiting-list') . '" />
                        ' . __($waite_field_option['label'], 'mec-waiting-list') . '
                    </label>';
				}
			} elseif ($waite_field['type'] == 'checkbox') {
				foreach ($waite_field['options'] as $waite_field_option) {
					$booking_form_options .= '<label for="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '_' . strtolower(str_replace(' ', '_', $waite_field_option['label'])) . '">
                        <input type="checkbox" id="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '_' . strtolower(str_replace(' ', '_', $waite_field_option['label'])) . '" name="mec_att[' . $key . '][reg][' . $waite_field_id . '][]" value="' . __($waite_field_option['label'], 'mec-waiting-list') . '" />
                        ' . __($waite_field_option['label'], 'mec-waiting-list') . '
                    </label>';
				}
			} elseif ($waite_field['type'] == 'agreement') {
				$booking_form_options .= '<label for="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '">
                    <input type="checkbox" id="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '" name="mec_att[' . $key . '][reg][' . $waite_field_id . ']" value="1" ' . ((!isset($waite_field['status']) or (isset($waite_field['status']) and $waite_field['status'] == 'checked')) ? 'checked="checked"' : '') . ' ' . ($mandatory ? 'required="required"' : '') . ' />
                    ' . sprintf(__($waite_field['label'], 'mec-waiting-list'), '<a href="' . get_the_permalink($waite_field['page']) . '" target="_blank">' . get_the_title($waite_field['page']) . '</a>') . '
                </label>';
			} elseif ($waite_field['type'] == 'file') {
				$booking_form_options .= '<button type="button" class="mec-choose-file" data-for="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '">' . __('Select File', 'mec-waiting-list') . '</button><input type="hidden" class="widefat" id="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '" name="mec_att[' . $key . '][reg][' . $waite_field_id . ']" value="" />';
			}

			$booking_form_options .= '</div>';
			$booking_form_options .= '</div>';
		}

		$this->main->response(array('success' => 1, 'dates' => $date_options, 'tickets' => $ticket_options, 'variations' => $variation_options, 'waite_fields' => $booking_form_options));
	}

	public function bbf_edit_event_add_attendee() {
		$event_id = isset($_REQUEST['event_id']) ? sanitize_text_field($_REQUEST['event_id']) : '';
		$key = isset($_REQUEST['key']) ? sanitize_text_field($_REQUEST['key']) : '';

		// Event is invalid!
		if (!trim($event_id)) {
			$this->main->response(array('success' => 0, 'output' => '<div class="warning-msg">' . __('Event is invalid. Please select an event.', 'mec-waiting-list') . '</div>'));
		}

		$tickets = get_post_meta($event_id, 'mec_tickets', true);

		// Invalid Event, Tickets or Dates
		if (!is_array($tickets) or (is_array($tickets) and !count($tickets))) {
			$this->main->response(array('success' => 0, 'output' => '<div class="warning-msg">' . __('No ticket or future date found for this event! Please try another event.', 'mec-waiting-list') . '</div>'));
		}

		// Ticket option
		$ticket_options = '';
		foreach ($tickets as $ticket_id => $ticket) {
			$ticket_options .= '<option value="' . $ticket_id . '">' . $ticket['name'] . '</option>';
		}

		// Variations Options
		$variation_options = '';

		$ticket_variations = $this->main->ticket_variations($event_id);
		foreach ($ticket_variations as $ticket_variation_id => $ticket_variation) {
			if (!is_numeric($ticket_variation_id) or !isset($ticket_variation['title']) or (isset($ticket_variation['title']) and !trim($ticket_variation['title']))) {
				continue;
			}

			$variation_options .= '<div class="mec-form-row">
                <div class="mec-col-2">
                    <label for="mec_att_' . $key . '_variations_' . $ticket_variation_id . '" class="mec-ticket-variation-name">' . $ticket_variation['title'] . '</label>
                </div>
                <div class="mec-col-6">
                    <input id="mec_att_' . $key . '_variations_' . $ticket_variation_id . '" type="number" min="0" max="' . ((is_numeric($ticket_variation['max']) and $ticket_variation['max']) ? $ticket_variation['max'] : 1) . '" name="mec_att[' . $key . '][variations][' . $ticket_variation_id . ']" value="0">
                </div>
            </div>';
		}

		// Booking Form Options
		$booking_form_options = '';

		$waite_fields = $this->main->get_waite_fields($event_id);
		foreach ($waite_fields as $waite_field_id => $waite_field) {
			if (!is_numeric($waite_field_id) or !isset($waite_field['type']) or (isset($waite_field['type']) and !trim($waite_field['type']))) {
				continue;
			}

			if (in_array($waite_field['type'], array('name', 'mec_email'))) {
				continue;
			}

			$booking_form_options .= '<div class="mec-form-row">';

			if (isset($waite_field['label']) and $waite_field['type'] != 'agreement') {
				$booking_form_options .= '<div class="mec-col-2"><label for="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '">' . __($waite_field['label'], 'mec-waiting-list') . '</label></div>';
			} elseif (isset($waite_field['label']) and $waite_field['type'] == 'agreement') {
				$booking_form_options .= '<div class="mec-col-2"></div>';
			}

			$booking_form_options .= '<div class="mec-col-6">';
			$mandatory = (isset($waite_field['mandatory']) and $waite_field['mandatory']) ? true : false;

			if ($waite_field['type'] == 'text') {
				$booking_form_options .= '<input class="widefat" id="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '" type="text" name="mec_att[' . $key . '][reg][' . $waite_field_id . ']" value="" placeholder="' . __($waite_field['label'], 'mec-waiting-list') . '" ' . ($mandatory ? 'required="required"' : '') . ' />';
			} elseif ($waite_field['type'] == 'date') {
				$booking_form_options .= '<input class="widefat" id="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '" type="date" name="mec_att[' . $key . '][reg][' . $waite_field_id . ']" value="" placeholder="' . __($waite_field['label'], 'mec-waiting-list') . '" ' . ($mandatory ? 'required="required"' : '') . ' min="1970-01-01" max="2099-12-31" />';
			} elseif ($waite_field['type'] == 'email') {
				$booking_form_options .= '<input class="widefat" id="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '" type="email" name="mec_att[' . $key . '][reg][' . $waite_field_id . ']" value="" placeholder="' . __($waite_field['label'], 'mec-waiting-list') . '" ' . ($mandatory ? 'required="required"' : '') . ' />';
			} elseif ($waite_field['type'] == 'tel') {
				$booking_form_options .= '<input class="widefat" oninput="this.value=this.value.replace(/(?![0-9])./gmi,"")" id="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '" type="tel" name="mec_att[' . $key . '][reg][' . $waite_field_id . ']" value="" placeholder="' . __($waite_field['label'], 'mec-waiting-list') . '" ' . ($mandatory ? 'required="required"' : '') . ' />';
			} elseif ($waite_field['type'] == 'textarea') {
				$booking_form_options .= '<textarea class="widefat" id="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '" name="mec_att[' . $key . '][reg][' . $waite_field_id . ']" placeholder="' . __($waite_field['label'], 'mec-waiting-list') . '" ' . ($mandatory ? 'required="required"' : '') . '></textarea>';
			} elseif ($waite_field['type'] == 'select') {
				$booking_form_options .= '<select class="widefat" id="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '" name="mec_att[' . $key . '][reg][' . $waite_field_id . ']" placeholder="' . __($waite_field['label'], 'mec-waiting-list') . '" ' . ($mandatory ? 'required="required"' : '') . '>';
				foreach ($waite_field['options'] as $waite_field_option) {
					$booking_form_options .= '<option value="' . esc_attr__($waite_field_option['label'], 'mec-waiting-list') . '">' . __($waite_field_option['label'], 'mec-waiting-list') . '</option>';
				}

				$booking_form_options .= '</select>';
			} elseif ($waite_field['type'] == 'radio') {
				foreach ($waite_field['options'] as $waite_field_option) {
					$booking_form_options .= '<label for="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '_' . strtolower(str_replace(' ', '_', $waite_field_option['label'])) . '">
                        <input type="radio" id="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '_' . strtolower(str_replace(' ', '_', $waite_field_option['label'])) . '" name="mec_att[' . $key . '][reg][' . $waite_field_id . ']" value="' . __($waite_field_option['label'], 'mec-waiting-list') . '" />
                        ' . __($waite_field_option['label'], 'mec-waiting-list') . '
                    </label>';
				}
			} elseif ($waite_field['type'] == 'checkbox') {
				foreach ($waite_field['options'] as $waite_field_option) {
					$booking_form_options .= '<label for="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '_' . strtolower(str_replace(' ', '_', $waite_field_option['label'])) . '">
                        <input type="checkbox" id="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '_' . strtolower(str_replace(' ', '_', $waite_field_option['label'])) . '" name="mec_att[' . $key . '][reg][' . $waite_field_id . '][]" value="' . __($waite_field_option['label'], 'mec-waiting-list') . '" />
                        ' . __($waite_field_option['label'], 'mec-waiting-list') . '
                    </label>';
				}
			} elseif ($waite_field['type'] == 'agreement') {
				$booking_form_options .= '<label for="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '">
                    <input type="checkbox" id="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '" name="mec_att[' . $key . '][reg][' . $waite_field_id . ']" value="1" ' . ((!isset($waite_field['status']) or (isset($waite_field['status']) and $waite_field['status'] == 'checked')) ? 'checked="checked"' : '') . ' ' . ($mandatory ? 'required="required"' : '') . ' />
                    ' . sprintf(__($waite_field['label'], 'mec-waiting-list'), '<a href="' . get_the_permalink($waite_field['page']) . '" target="_blank">' . get_the_title($waite_field['page']) . '</a>') . '
                </label>';
			} elseif ($waite_field['type'] == 'file') {
				$booking_form_options .= '<button type="button" class="mec-choose-file" data-for="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '">' . __('Select File', 'mec-waiting-list') . '</button><input type="hidden" class="widefat" id="mec_book_waite_field_reg' . $key . '_' . $waite_field_id . '" name="mec_att[' . $key . '][reg][' . $waite_field_id . ']" value="" />';
			}

			$booking_form_options .= '</div>';
			$booking_form_options .= '</div>';
		}

		// Date Option
		$output = '<div class="mec-attendee" id="mec_attendee' . $key . '">
        <hr>
        <div class="mec-form-row">
            <div class="mec-col-8" style="text-align: right;">
                <button type="button" class="button mec-remove-attendee" data-key="' . $key . '">' . __('Remove Attendee', 'mec-waiting-list') . '</button>
            </div>
        </div>
        <div class="mec-form-row">
            <div class="mec-col-2">
                <label for="att_' . $key . '_name">' . __('Name', 'mec-waiting-list') . '</label>
            </div>
            <div class="mec-col-6">
                <input type="text" value="" id="att_' . $key . '_name" name="mec_att[' . $key . '][name]" placeholder="' . esc_attr__('Name', 'mec-waiting-list') . '" class="widefat">
            </div>
        </div>
        <div class="mec-form-row">
            <div class="mec-col-2">
                <label for="att_' . $key . '_email">' . __('Email', 'mec-waiting-list') . '</label>
            </div>
            <div class="mec-col-6">
                <input type="email" value="" id="att_' . $key . '_email" name="mec_att[' . $key . '][email]" placeholder="' . esc_attr__('Email', 'mec-waiting-list') . '" class="widefat">
            </div>
        </div>
        <div class="mec-form-row">
            <div class="mec-col-2">
                <label for="att_' . $key . '_ticket">' . $this->main->m('ticket', __('Ticket', 'mec-waiting-list')) . '</label>
            </div>
            <div class="mec-col-6">
                <select id="att_' . $key . '_ticket" name="mec_att[' . $key . '][id]" class="widefat mec-booking-edit-form-tickets">' . $ticket_options . '</select>
            </div>
        </div>' . ($booking_form_options) . '
        ' . ((isset(self::$settings['ticket_variations_status']) and self::$settings['ticket_variations_status'] and count($ticket_variations)) ? '<div class="mec-book-ticket-variations" data-key="' . $key . '">' . $variation_options . '</div>' : '') . '</div>';

		$this->main->response(array('success' => 1, 'output' => $output));
	}

	public static function add_occurrence_filter($event_id) {
		$output = '<select name="mec_occurrence" id="mec_filter_occurrence">';
		$output .= '<option value="">' . __('Occurrence', 'mec-waiting-list') . '</option>';

		$q = new \WP_Query();
		$bookings = $q->query(array
			(
				'post_type' => self::$main->get_book_post_type(),
				'posts_per_page' => -1,
				'post_status' => array('future', 'publish'),
				'orderby' => 'post_date',
				'order' => 'ASC',
				'meta_query' => array
				(
					array(
						'key' => 'mec_event_id',
						'value' => $event_id,
					),
				),
			));

		if (!count($bookings)) {
			return '';
		}

		$dates = array();
		foreach ($bookings as $booking) {
			$dates[strtotime($booking->post_date)] = $booking->post_date;
		}

		$occurrence = isset($_REQUEST['mec_occurrence']) ? sanitize_text_field($_REQUEST['mec_occurrence']) : '';
		$datetime_format = get_option('date_format') . ' ' . get_option('time_format');

		foreach ($dates as $timestamp => $date) {
			$output .= '<option value="' . $timestamp . '" ' . ($occurrence == $timestamp ? 'selected="selected"' : '') . '>' . date($datetime_format, $timestamp) . '</option>';
		}

		$output .= '</select>';
		return $output;
	}

	public function add_occurrence_filter_ajax() {
		$event_id = isset($_REQUEST['event_id']) ? sanitize_text_field($_REQUEST['event_id']) : 0;

		$html = self::add_occurrence_filter($event_id);
		echo json_encode(array('html' => $html));
		exit;
	}

	public function trash_booking( $post_id ){

		if( 'mec-books' === get_post_type( $post_id ) ){

			self::$book->reject( $post_id );
		}
	}
}
