<?php
/** no direct access **/
defined('MECEXEC') or die();

$event_id = $event->ID;
$uniqueid = "{$event_id}_{$ticket_id}";
$ticket_uniqueid = "{$ticket_id}";

$js_data = array(
    'ajaxurl' => admin_url('admin-ajax.php'),
    'date_select_error' => __( 'You can not select more than one date', 'mec-waiting-list'),
);
echo '<script>var mec_waiting_list=' .json_encode( $js_data ). '</script>';

$event_tickets = isset($event->data->tickets) ? $event->data->tickets : array();
$current_user = wp_get_current_user();

$mec_email = false;
$mec_name = false;
$waite_fields = is_array($waite_fields) ? $waite_fields : array();
foreach($waite_fields as $field)
{
    if(isset($field['type']))
    {
        if($field['type'] == 'mec_email') $mec_email = true;
        if($field['type'] == 'name') $mec_name = true;
    }
    else
    {
        break;
    }
}

if(!$mec_name)
{
    $waite_fields[] = array(
        'mandatory' => '0',
        'type'      => 'name',
        'label'     => esc_html__( 'Name', 'mec-waiting-list' ),
    );
}

if(!$mec_email)
{
    $waite_fields[] = array(
        'mandatory' => '0',
        'type'      => 'mec_email',
        'label'     => esc_html__( 'Email', 'mec-waiting-list' ),
    );
}

if($single_load == true){
    ?>
    <div id="mec-events-meta-group-booking-<?php echo $ticket_uniqueid; ?>" class="mec-waiting-form mec-events-meta-group mec-events-meta-group-booking">
    <div class="mec-booking " id="mec_booking<?php echo $ticket_uniqueid; ?>">
    <form id="mec_book_form<?php echo $ticket_uniqueid; ?>" onsubmit="mec_book_form_submit(event, <?php echo $ticket_uniqueid; ?>);">
    <h4><?php echo __('Waiting List', 'mec-waiting-list') ?></h4>

        <input type="hidden" name="book[date]" id="mec_book_form_date<?php echo $ticket_uniqueid; ?>" value="<?php echo $date; ?>" />
    <?php
}

$list_user_waiting = self::list_user_waiting($event, $ticket_id);
$user_in_waiting = self::user_in_waiting($event, $ticket_id);
$user_limit = self::get_user_waiting_limit($event_id);
$unlimited = $user_limit[1];
$limit = $user_limit[0];
?>

<div id="mec_waiting_reg_field_count_area_<?php echo $uniqueid; ?>" data-ticket-id="<?php echo $ticket_id; ?>">
    <div class="mec_waiting_reg_field_count_area_labels">
    <?php
    if ($user_in_waiting == 0) {
        echo '<div class="waiting-counter-message">';
        echo _e('You\'re the first user in the Waiting List.', 'mec-waiting-list');
        echo '</div>';
    } else {
        echo '<div class="waiting-counter-message">';
        echo _e('Users in Waiting List:', 'mec-waiting-list');
        echo '&nbsp;';
        echo "<b></b></div>";
    }

    $ticket_seats = (isset($ticket['seats']) and is_numeric($ticket['seats'])) ? (int) $ticket['seats'] : 1;
    $ticket_seats = max(1, $ticket_seats);
    ?>

    <label for="mec_waiting_reg_field_count_<?php echo $uniqueid; ?>"><?php echo _e('Number of entries in the waiting list', 'mec-waiting-list').":" ?></label>
</div>
<input type="number" <?php echo  !$unlimited && (int)$limit === 1 ? 'style="display:none"' : '' ?> id="mec_waiting_reg_field_count_<?php echo $uniqueid; ?>" class="mec-waiting-list-ticket-limit" name="waiting[count][<?php echo $ticket_id; ?>]" title="Count" placeholder="Count" value="1" min="1" max="<?php echo !$unlimited ? $limit : '' ?>" data-seats="<?php echo esc_attr($ticket_seats); ?>"/>
<input type="hidden" name="list_user_waiting" value='<?php echo json_encode($list_user_waiting); ?>' />
</div>
<div class="display:none" id="waiting-data-date-<?php echo $uniqueid; ?>" data-date="<?php echo $date; ?>"></div>
<div class="mec-waiting-form-btn-wrap">
    <button data-max="<?php echo !$unlimited ? $limit : '' ?>" id="waiting_register_btn_<?php echo $uniqueid; ?>" type="submit" onclick="waiting_register('<?php echo $uniqueid; ?>',<?php echo $event_id; ?>,<?php echo $ticket_id; ?>);"><?php echo _e('Register Waiting', 'mec-waiting-list') ?>
    </button>
</div>
<div style="display: none;" class="mec-waiting-form-container row" id="mec_waiting_form_content_<?php echo $uniqueid; ?>">
</div>
<p id="mec_waiting_message<?php echo $uniqueid; ?>"></p>

<?php   if($single_load == true) :?>
<input type="hidden" name="event_id" value="<?php echo $event_id; ?>">
<input type="hidden" name="uniqueid" value="<?php echo $ticket_uniqueid; ?>">
</form>
</div>
</div>
<?php endif; ?>
