<?php
/**
 * Plugin Name: MEC Waiting List
 * Plugin URI: https://webnus.net/modern-events-calendar/
 * Description: This addon enables you to create a waiting form after selling out the tickets, so people can reserve one in case one of the attendees cancel their reservation. The people in the waiting list get transferred to the main list based on their reservation priority.
 * Author: Webnus
 * Version: 1.4.0
 * Text Domain: mec-waiting-list
 * Domain Path: /languages
 * Author URI: https://webnus.net
 **/
namespace MEC_Waiting_List;

// don't load directly.
if (!defined('ABSPATH')) {
	header('Status: 403 Forbidden');
	header('HTTP/1.1 403 Forbidden');
	exit;
}
/**
 * Base.
 *
 * @author     Webnus Team
 * @package     package
 * @since     1.0.0
 */
class MEC_Waiting_Base {

	/**
	 * Instance of this class.
	 *
	 * @since   0.0.1
	 * @access  public
	 * @var     MEC_Invoice
	 */
	public static $instance;

	/**
	 * Provides access to a single instance of a module using the singleton pattern.
	 *
	 * @since   0.0.1
	 * @return  object
	 */
	public static function instance() {
		if (self::$instance === null) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public static function install() {
		$notification = array(
			'waiting_verification' => array
			(
				'subject' => 'Please verify your waiting.',
				'recipients' => '',
				'content' => "Hi %%name%%,

                    Please verify your waiting by clicking on following link:

                    %%verification_link%%

                    Regards,
                    %%blog_name%%",
			),
			'waiting_confirmation' => array
			(
				'subject' => 'Your waiting status is confirmed.',
				'recipients' => '',
				'content' => "Hi %%name%%,

                    Your waiting is confirmed. You should be available at %%book_date%% in %%event_location_address%%.

                    You can contact to event organizer by calling %%event_organizer_tel%%.

                    For Cancel the Waiting, Use The following link
                    %%waiting_cancellation_link%%

                    Regards,
                    %%blog_name%%",
			),
		);

		$options = get_option('mec_options', array());
		if (!isset($options['notifications']['waiting_verification'])) {
			$options['notifications']['waiting_verification'] = $notification['waiting_verification'];

		}

		if (!isset($options['notifications']['waiting_confirmation'])) {
			$options['notifications']['waiting_confirmation'] = $notification['waiting_confirmation'];
		}

		if (!isset($options['settings']['waiting_notif_page'])) {
			$verify_page = array(
				'post_type' => 'page',
				'post_title' => __( 'Verify Waiting Email', 'mec-waiting-list' ),
				'post_content' => '[waiting_notif_page]',
				'post_status' => 'publish',
				'post_author' => 1,
			);
			$options['settings']['waiting_notif_page'] = wp_insert_post($verify_page);
		}

		if(!isset($options['settings']['waiting_confirmation'])){
			$options['settings']['waiting_confirmation'] = 1;
		}


		if(!isset($options['settings']['waiting_verified'])){
			$options['settings']['waiting_verified'] = 1;
		}

				if(!isset($options['settings']['waiting_first_for_all'])){
			$options['settings']['waiting_first_for_all'] = 1;
		}

		update_option('mec_options', $options);

	}

	public function __construct() {

		include_once(ABSPATH.'wp-admin/includes/plugin.php');
		if (!function_exists('is_plugin_active') || !is_plugin_active('modern-events-calendar/mec.php')) {
		   return;
		}

		self::settingUp();
		self::preLoad();
		self::setHooks($this);

		$options = get_option('mec_options', array());
		if (isset($options['settings']) && isset($options['settings']['booking_status']) && $options['settings']['booking_status'] == 1) {

			do_action('MEC_Waiting_List_init');
		}

	}

	/**
	 * Global Variables.
	 *
	 * @since   0.0.1
	 */
	public static function settingUp() {
		define('MECWAITINGLISTVERSION', '1.4.0');
		define('MECWAITINGLISTDIR', plugin_dir_path(__FILE__));
		define('MECWAITINGLISTURL', plugin_dir_url(__FILE__));
		define('MECWAITINGLISTASSETS', MECWAITINGLISTURL . 'assets');
		define('MECWAITINGLISTNAME' , 'Waiting List');
		define('MECWAITINGLISTSLUG' , 'mec-waiting-list');
		define('MECWAITINGLISTOPTIONS' , 'mec_waiting_list_options');
		define('MECWAITINGLISTTEXTDOMAIN' , 'mec-waiting-list');
		define('MECWAITINGLISTPMAINFILEPATH' ,__FILE__);
		define('MECWAITINGLISTPABSPATH', dirname(__FILE__));

		if (!defined('DS')) {
			define('DS', DIRECTORY_SEPARATOR);
		}
	}

	/**
		* Load Languages
		*
		* @since 1.0.0
		*/
		public function load_languages() {
			$locale = apply_filters('plugin_locale', get_locale(), 'mec-waiting-list');

			// WordPress language directory /wp-content/languages/mec-en_US.mo
			$language_filepath = MECWAITINGLISTDIR . 'languages' . DIRECTORY_SEPARATOR . 'mec-waiting-list-' . $locale . '.mo';
			// If language file exists on WordPress language directory use it
			if (file_exists($language_filepath)) {
				load_textdomain('mec-waiting-list', $language_filepath);
			} else {
				load_plugin_textdomain('mec-waiting-list', false, dirname(plugin_basename(__FILE__)) . DIRECTORY_SEPARATOR . 'languages' . DIRECTORY_SEPARATOR);
			}
		}

	/**
	 * Set Hooks
	 *
	 * @since     0.0.1
	 */
	public static function setHooks($This) {
		add_action( 'wp_loaded', [ $This, 'load_languages' ] );

		add_action( 'wp_enqueue_scripts', array( __CLASS__, 'enqueue_scripts') );
	}

	/**
	 * preLoad
	 *
	 * @since     1.0.0
	 */
	public static function preLoad() {
		include_once MECWAITINGLISTDIR . DS . 'core' . DS . 'autoloader.php';
	}

	public static function enqueue_scripts(){

		wp_enqueue_script( 'mec-waiting-list-frontend', MECWAITINGLISTASSETS . '/js/frontend.js', array('jquery'), MECWAITINGLISTVERSION, true );
	}
} //MEC_Waiting_Base

$waiting_list_init = MEC_Waiting_Base::instance();

register_activation_hook(__FILE__, array($waiting_list_init, 'install'));
