<?php

use Elementor\Plugin;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Box_Shadow;

/** no direct access */
defined('MECEXEC') or die();

/**
 * Webnus MEC elementor addon shortcode class
 *
 * @author Webnus <info@webnus.net>
 */
class MecShortCodeDesignerCategory extends Widget_Base
{

	/**
	 * Retrieve MEC widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'mec-category';
	}

	/**
	 * Retrieve MEC widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return __('MEC Category', 'mec-shortcode-designer');
	}

	/**
	 * Retrieve MEC widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-banner';
	}


	/**
	 * Set widget category.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return array Widget category.
	 */
	public function get_categories()
	{
		return ['mec_shortcode_designer'];
	}

	/**
	 * Register MEC widget controls.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls()
	{

		// Display Options
		$this->start_controls_section(
			'display_options',
			array(
				'label' => __('Display Options', 'mec-shortcode-builder'),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		// Localtime
		$this->add_control(
			'display_all_categories',
			[
				'label'        => __('Display All Categories', 'mec-shortcode-builder'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __('Yes', 'mec-shortcode-builder'),
				'label_off'    => __('No', 'mec-shortcode-builder'),
				'return_value' => '1',
				'default'      => '0',
			]
		);

		$this->end_controls_section();
		// typography
		$this->start_controls_section(
			'styling_section',
			[
				'label' => __('Typography', 'mec-shortcode-designer'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'category_typography',
				'label'    => __('Typography', 'mec-shortcode-designer'),
				'global' => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .mec-event-category',
			]
		);
		$this->add_control(
			'category_align',
			[
				'label'     => __('Alignment', 'mec-shortcode-designer'),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'left'   => [
						'title' => __('Left', 'mec-shortcode-designer'),
						'icon'  => 'mec-fa-align-left',
					],
					'center' => [
						'title' => __('Center', 'mec-shortcode-designer'),
						'icon'  => 'mec-fa-align-center',
					],
					'right'  => [
						'title' => __('Right', 'mec-shortcode-designer'),
						'icon'  => 'mec-fa-align-right',
					],
				],
				'default'   => 'left',
				'selectors' => [
					'{{WRAPPER}} .mec-event-category' => 'text-align: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'display',
			[
				'label'     => __('Display', 'mec-shortcode-designer'),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'block',
				'options'   => [
					'inherit'      => __('inherit', 'mec-shortcode-designer'),
					'inline'       => __('inline', 'mec-shortcode-designer'),
					'inline-block' => __('inline-block', 'mec-shortcode-designer'),
					'block'        => __('block', 'mec-shortcode-designer'),
					'none'         => __('none', 'mec-shortcode-designer'),
				],
				'selectors' => [
					'{{WRAPPER}} .mec-event-category' => 'display: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
		// color
		$this->start_controls_section(
			'category_color_style',
			[
				'label' => __('Colors', 'mec-shortcode-designer'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'category_color',
			[
				'label'     => __('Color', 'mec-shortcode-designer'),
				'type'      => Controls_Manager::COLOR,
				'global' => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
				],
				'default'   => '#000',
				'selectors' => [
					'{{WRAPPER}} .mec-event-category' => 'color: {{VALUE}} !important',
				],
			]
		);
		$this->add_control(
			'category_color_hover',
			[
				'label'     => __('Hover', 'mec-shortcode-designer'),
				'type'      => Controls_Manager::COLOR,
				'global' => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
				],
				'default'   => '#000',
				'selectors' => [
					'{{WRAPPER}} .mec-event-category:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
		// background
		$this->start_controls_section(
			'category_background_style',
			[
				'label' => __('Background', 'mec-shortcode-designer'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'category_background',
			[
				'label'     => __('Background', 'mec-shortcode-designer'),
				'type'      => Controls_Manager::COLOR,
				'global' => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
				],
				'default'   => 'rgba(255,255,255,0)',
				'selectors' => [
					'{{WRAPPER}} .mec-event-category' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'category_background_hover',
			[
				'label'     => __('Background Hover', 'mec-shortcode-designer'),
				'type'      => Controls_Manager::COLOR,
				'global' => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
				],
				'default'   => 'rgba(255,255,255,0)',
				'selectors' => [
					'{{WRAPPER}} .mec-event-category:hover' => 'background: {{VALUE}}',
				],
			]
		);
		// $this->add_control(
		// 	'category_background_canceled',
		// 	[
		// 		'label'     => __( 'Canceled Background', 'mec-shortcode-designer' ),
		// 		'type'      => Controls_Manager::COLOR,
		// 		'scheme'    => [
		// 			'type'  => Color::get_type(),
		// 			'value' => Color::COLOR_1,
		// 		],
		// 		'default'   => '#de0404',
		// 		'selectors' => [
		// 			'{{WRAPPER}} .mec-event-category.mec-label-canceled' => 'background: {{VALUE}}',
		// 		],
		// 	]
		// );
		// $this->add_control(
		// 	'category_background_canceled_hover',
		// 	[
		// 		'label'     => __( 'Canceled Background Hover', 'mec-shortcode-designer' ),
		// 		'type'      => Controls_Manager::COLOR,
		// 		'scheme'    => [
		// 			'type'  => Color::get_type(),
		// 			'value' => Color::COLOR_1,
		// 		],
		// 		'default'   => '#000',
		// 		'selectors' => [
		// 			'{{WRAPPER}} .mec-event-category.mec-label-canceled:hover' => 'background: {{VALUE}}',
		// 		],
		// 	]
		// );
		// $this->add_control(
		// 	'category_background_featured',
		// 	[
		// 		'label'     => __( 'Featured Background', 'mec-shortcode-designer' ),
		// 		'type'      => Controls_Manager::COLOR,
		// 		'scheme'    => [
		// 			'type'  => Color::get_type(),
		// 			'value' => Color::COLOR_1,
		// 		],
		// 		'default'   => '#04de78',
		// 		'selectors' => [
		// 			'{{WRAPPER}} .mec-event-category.mec-label-featured' => 'background: {{VALUE}}',
		// 		],
		// 	]
		// );
		// $this->add_control(
		// 	'category_background_featured_hover',
		// 	[
		// 		'label'     => __( 'Featured Background Hover', 'mec-shortcode-designer' ),
		// 		'type'      => Controls_Manager::COLOR,
		// 		'scheme'    => [
		// 			'type'  => Color::get_type(),
		// 			'value' => Color::COLOR_1,
		// 		],
		// 		'default'   => '#000',
		// 		'selectors' => [
		// 			'{{WRAPPER}} .mec-event-category.mec-label-featured:hover' => 'background: {{VALUE}}',
		// 		],
		// 	]
		// );

		$this->end_controls_section();
		// Spacing
		$this->start_controls_section(
			'category_spacing_style',
			[
				'label' => __('Spacing', 'mec-shortcode-designer'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'category_margin',
			[
				'label'      => __('Margin', 'mec-shortcode-designer'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors'  => [
					'{{WRAPPER}} .mec-event-category' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'category_padding',
			[
				'label'      => __('Padding', 'mec-shortcode-designer'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'default'    => [
					'top'      => '2',
					'right'    => '40',
					'bottom'   => '2',
					'left'     => '40',
					'isLinked' => false,
				],
				'selectors'  => [
					'{{WRAPPER}} .mec-event-category' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'border',
				'label'    => __('Border', 'mec-shortcode-designer'),
				'selector' => '{{WRAPPER}} .mec-event-category',
			]
		);
		$this->add_control(
			'category_border_radius', //param_name
			[
				'label' 		=> __('Border Radius', 'mec-shortcode-designer'),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .mec-event-category' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'label' => __('Box Shadow', 'mec-shortcode-designer'),
				'selector' => '{{WRAPPER}} .mec-event-category',
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render MEC widget output on the frontend.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings();

		if (get_post_type() == 'mec_designer') {
			$event_id = get_posts('post_type=mec-events&numberposts=1')[0]->ID;
		} else {
			$event_id = get_the_ID();
		}

		$display_all_categories = isset($settings['display_all_categories']) && '1' === $settings['display_all_categories'] ? true : false;

		$single = new \MEC_skin_single();
		$events = $single->get_event_mec($event_id);
		$event_detail = $events[0];
		$categories = isset($event_detail->data->categories) ? $event_detail->data->categories : array();

		if (!empty($categories)) {
			if (!$display_all_categories) {
				$categories = array(current($categories));
			}

			$mec_items = count($categories);
			$mec_i = 0;
			echo '<div class="mec-shortcode-designer">';
			foreach ($categories as $category) {
				$seperator = (++$mec_i === $mec_items) ? '' : ',';

				$icon = isset($category['icon']) ? $category['icon'] : '';

				if (!empty($icon)) {
					if (filter_var($icon, FILTER_VALIDATE_URL)) {
						$icon_html = '<img src="' . esc_url($icon) . '" alt="' . esc_attr($category["name"]) . '" class="mec-category-icon" style="width: 20px; height: 20px; margin-right: 5px;">';
					} else {
						$icon_html = '<i class="' . esc_attr($icon) . '" style="margin-right: 5px;"></i>';
					}
				} else {
					$icon_html = '<i class="mec-sl-folder" style="margin-right: 5px;"></i>';
				}

				echo '<span class="mec-event-category" style="color:' . esc_attr($category['color']) . '">'
					. $icon_html . esc_html($category["name"]) . $seperator .
					'</span>';
			}
			echo '</div>';
		} elseif (empty($categories) && get_post_type() == 'mec_designer') {
?>
			<div class="mec-shortcode-designer">
				<div class="mec-event-category">
					<span style="display: inline-block;"><?php echo esc_html__('Featured (for example)', 'mec-shortcode-designer'); ?></span>
				</div>
			</div>
<?php
		}
	}
}
