function MEC_SP_Show_Account(id, thus) {

    var data = jQuery.parseJSON(jQuery('#item-' + id).html());
    var html = '<h3>' + data.title + '<h3>';

    for (var k in data.config) {

        var label = jQuery('[name^="account['+ k +']"]').parents( '.mec-form-row').find('label').html();
        if( typeof label === 'undefined' ){

            continue;
        }

        var val = data.config[k];
        if (data.config[k] == 1) {
            val = 'yes';
        } else if (data.config[k] == 0) {
            val = 'no';
        }

        html += '<p style="font-weight: normal;">' + label + ': <strong>' + val + '</strong></p>';
    }
    jQuery('#mec-sp-account-view-content').html(html);
    jQuery('#mec-sp-account-view-click').click();

    return false;
}

jQuery(document).ready(function($){

    $('.mec-sp-action').on('click',function(e){

        var btn = jQuery(this);
        var action = jQuery(this).attr('data-action');
        var url = jQuery(this).attr('data-url');
        var authid = jQuery(this).attr('data-authid');
        var section = jQuery(this).attr('data-section');

        var win = window.open(url, '_blank', 'location=yes,height=570,width=520,scrollbars=yes,status=yes');

        var timer = setInterval(function() {
            if (win.closed) {
                clearInterval(timer);
                jQuery.ajax({
                        url: window.MEC_SP_VARS.ajaxurl,
                        type: 'POST',
                        dataType: 'json',
                        data: {
                            action: 'mec_social_poster_check_auth',
                            authid: authid,
                            account_type: section,

                        },
                    })
                    .done(function(data) {

                        if (data.success == true) {
                            btn.html(window.MEC_SP_VARS.title.authenticated);
                            btn.removeClass('button-info');
                            btn.addClass('button-success');
                        } else {

                            alert( data.message );
                            btn.html(window.MEC_SP_VARS.title.needauthentication);
                        }
                    });
            }
        }, 1000);

        return false;
    });
});
