<?php

namespace MEC_Social_Poster\APIs\Facebook;

defined('MECEXEC') or die();

use MEC\Singleton;
use MEC_Social_Poster\Accounts\Accounts;
use MEC_Social_Poster\Settings\Settings;

class Base extends Singleton{

	public $batch = array('my', 'page', 'group');
	public $limit_fetch = 500;
	public $base_url = 'https://graph.facebook.com/v20.0';
	public $base_url_login = 'https://facebook.com/v20.0';

	/**
	 * Return saved access token
	 *
	 * @param int $account_id
	 * @param string $token_type
	 *
	 * @since 1.0.0
	 *
	 * @return string|false
	 */
	public function get_saved_access_token( $account_id, $token_type = 'primary' ){

		return Settings::getInstance()->get_access_token( 'facebook', $account_id, $token_type );
	}

	/**
	 * Return saved facebook account id
	 *
	 * @param int $account_id
	 *
	 * @since 1.0.0
	 *
	 * @return string|false
	 */
	public function get_saved_fb_account_id( $account_id ){

		$data = Accounts::getInstance()->get_account_data( $account_id );

		return isset( $data['fb_account_id'] ) ? $data['fb_account_id'] : false;
	}

	/**
	 * Return facebook page id
	 *
	 * @param string $access_token
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	public function get_page_id( $access_token, $page_slug = 'me' ) {

		$url = "{$this->base_url}/{$page_slug}?access_token={$access_token}";
		$response = wp_remote_get($url);

		if (isset($response->errors)) {

			return false;
		}

		$body = json_decode( wp_remote_retrieve_body($response) );

		return isset( $body->id ) ? $body->id : false;
	}

	/**
	 * Return facebook accounts
	 *
	 * @param string $access_token
	 *
	 * @since 1.0.0
	 *
	 * @return array|false
	 */
	public function get_fb_accounts( $access_token ){

		$id = $this->get_page_id( $access_token );

		$token_url = "{$this->base_url}/{$id}/accounts?";
		$token_url .= "fields=name,access_token&";
		$token_url .= "access_token={$access_token}";

		$response = wp_remote_get( $token_url );
		$body = wp_remote_retrieve_body($response);

		if (!$body || empty($body)) {
			return false;
		} else {
			$body = json_decode($body);

			if (!$body) {
				return false;
			}

			if (!isset($body->data)) {
				return false;
			}

			return $body->data;
		}

		return false;
	}

	/**
	 * Return facebook account access token
	 *
	 * @param int $account_id
	 *
	 * @return bool|string
	 */
	public function get_fb_account_access_token( $account_id ){

		$access_token = $this->get_saved_access_token( $account_id );
		$page_id = $this->get_saved_fb_account_id( $account_id );

		$fb_accounts = $this->get_fb_accounts( $access_token );
		if( !$fb_accounts ){

			return false;
		}

		foreach( $fb_accounts as $fb_account ){

			if( $page_id == $fb_account->id ){

				return $fb_account->access_token;
			}
		}

		return false;
	}

	public function get_event_page_token( $access_token ) {

		$token_url = "{$this->base_url}/me?fields=id&access_token={$access_token}";
		$response = wp_remote_get($token_url);
		$body = wp_remote_retrieve_body($response);

		if (!$body || empty($body)) {
			return false;
		} else {
			$b = json_decode($body);

			$token_url = "{$this->base_url}/{$b->id}/accounts?";
			$token_url .= "fields=name,access_token&";
			$token_url .= "access_token={$access_token}";

			$response = wp_remote_get( $token_url );
			$body = wp_remote_retrieve_body($response);

			if (!$body || empty($body)) {
				return false;
			} else {
				$b = json_decode($body);

				if (!$b) {
					return false;
				}

				if (!isset($b->data)) {
					return false;
				}

				foreach ($b->data as $k => $page) {

					if (isset($page->name) && "{$page->name}" == 'Event Pages') {
						return $page;
					}
				}
			}
		}
	}
}
