<?php

namespace MEC_Social_Poster\APIs\Facebook;

defined('MECEXEC') or die();

/**
 * @since 1.0.0
 */
class Post extends Base{

	/**
	 * Publish Post
	 *
	 * @param int $account_id
	 * @param array $data
	 *
	 * @since 1.0.0
	 *
	 * @return string|false|\WP_Error
	 */
	public function publish_post( $account_id, $data ){

		$access_token = $this->get_saved_access_token( $account_id, 'account' );
		$page_id = $this->get_saved_fb_account_id( $account_id );

		if( empty( $page_id ) ){

			return new \WP_Error( 'empty_fb_account_id', __( 'Facebook account ID is empty', MECSPTEXTDOMAIN ) );
		}

		$link = $data['link'] ?? '';
		$message = html_entity_decode($data['message']) ?? '';
		$thumbnail = $data['thumbnail'] ?? '';
		$hashtags = $data['hashtags'] ?? array();
		$hashtags = !empty( $data['hashtags'] ) ? ' #' . implode( ' #', $hashtags ) : '';

        $_message = $message . PHP_EOL . $hashtags;

		if( !empty( $thumbnail ) ){

			$r_url = "https://graph.facebook.com/v20.0/{$page_id}/photos";
			$_message = $message . PHP_EOL . $link . PHP_EOL . $hashtags;
		}else{

			$r_url = "https://graph.facebook.com/v20.0/{$page_id}/feed";
		}

		$args = array(
			'body' => array(
				'url' => $thumbnail,
				'access_token' => $access_token,
				"published" => "true",
				'message' => $_message,
				'link' => $link,
			),
            'timeout'     => 120,
		);

		$response = wp_remote_post( $r_url, $args );
		if( is_wp_error( $response ) ) {

			return $response;
		}

		$body = wp_remote_retrieve_body( $response );
		$body = json_decode( $body );

		if( isset($body->error) ){

			$message = isset( $body->error->error_user_msg ) ? $body->error->error_user_msg : $body->error->message;
			return new \WP_Error( $body->error->fbtrace_id, $message );
		}

		return isset( $body->id ) ? $body->id : false;
	}
}
