<?php

namespace MEC_Social_Poster\APIs\Instagram;

defined('MECEXEC') or die();

use MEC_Social_Poster\Accounts\Accounts;
use MEC_Social_Poster\Settings\Settings;

class Authentication extends Base{

    public function authorize_user( $account_id ){

        if( !$account_id ){

            return new \WP_Error( 'empty_account', __('Please Select an account.', MECSPTEXTDOMAIN));
        }

		$s = Accounts::getInstance()->get_account_data( $account_id );

		$app_id = isset($s['app_id']) ? $s['app_id'] : null;
		$app_secret = isset($s['app_secret']) ? $s['app_secret'] : null;

		if (!$app_id || !$app_secret) {

            return new \WP_Error( 'empty_account', __('Please insert Instagram App ID and Secret.', MECSPTEXTDOMAIN));
		}


		$redirect_url = Settings::getInstance()->get_auth_callback_url( 'instagram' );
		$param_url = urlencode( $redirect_url );

		$scope_business = 'pages_show_list,instagram_basic,instagram_content_publish,pages_read_engagement';
		$scope_normal = 'pages_show_list,instagram_basic,instagram_content_publish,pages_read_engagement';

		$dialog_url = $this->base_url_login . '/dialog/oauth?display=popup&client_id=' . $app_id . '&redirect_uri=' . $param_url . '&auth_type=rerequest&scope=';

		if (isset($s['businessapp']) && $s['businessapp'] == 1) {

			$dialog_url .= urlencode( $scope_business );
		} else {

			$dialog_url .= urlencode( $scope_normal );
		}

		update_option('mec_sp_instagram_current_request',$account_id);

		header("Location: " . $dialog_url);
		exit;
    }

	public function authorize_callback() {

		$user_token_options = array('authorize_status' => 0);
		$code = isset($_GET['code']) && !empty($_GET['code']) ? sanitize_text_field($_GET['code']) : null;

		if ( empty( $code ) ) {

			$user_token_options['authorize_status'] = 0;
			$user_token_options['error_message'] = 'APP-ID or APP-Secret is null';
			wp_die(__('Response Failed, please try again.', MECSPTEXTDOMAIN));
		}

		$account_id = get_option('mec_sp_instagram_current_request', null);
		if ($account_id == null) {

			wp_die(__('Please Select an account.', MECSPTEXTDOMAIN));
			return false;
		}

		$s = Accounts::getInstance()->get_account_data( $account_id );

		$app_id = isset($s['app_id']) ? $s['app_id'] : '';
		$app_secret = isset($s['app_secret']) ? $s['app_secret'] : '';
		$title = $s['title'];

		$redirect_url = Settings::getInstance()->get_auth_callback_url( 'instagram' );
		$param_url = urlencode($redirect_url);

		$token_url = "{$this->base_url}/oauth/access_token?"
			. "client_id=" . $app_id . "&redirect_uri=" . $param_url
			. "&client_secret=" . $app_secret . "&code=" . $code;

		$access_token = "";

		$response = wp_remote_get($token_url);
		$body = wp_remote_retrieve_body($response);

		if (!$body || empty($body)) {

			$user_token_options['authorize_status'] = 0;
			$user_token_options['error_message'] = 'Network Error';
			wp_die($response);
		} else {
			$b = json_decode($body);

			if (isset($b->error) && isset($b->error->message)) {
				$msg = "<h3>Instagram Response Error!</h3>";
				$msg .= "{$b->error->code}:{$b->error->message}";
				$msg .= "<br/>";
				$msg .= "{$b->error->type}";
				wp_die($msg);
				return false;
			}

			if (isset($b->access_token)) {

				$base_expire = 60*3600;

				$expire_at = isset($b->expires_in)?$b->expires_in:$base_expire;


				$access_token = $b->access_token;
				$user_token_options['result'] = $b;
				$user_token_options['status'] = true;
				$user_token_options['request_at'] = time();
				$user_token_options['expire_at'] = time() + $expire_at;
				$user_token_options['title'] = $title;
				$user_token_options['access_token'] = sanitize_text_field( $access_token );
				Settings::getInstance()->update_auth_account_settings( 'instagram', $account_id, $user_token_options );

				$account_access_token = '';
				$instagram_account_id = '';
				if (isset($s['businessapp']) && $s['businessapp'] == 1) {//TODO: Develop

					$fb_account_data = $this->get_fb_account_data( $account_id );
					$account_access_token = $fb_account_data['access_token'] ?? '';
					$instagram_account_id = $fb_account_data['instagram_account_id'] ?? false;
					if(!$account_access_token && 'group' !== $s['fb_account_type']){

						wp_die('Failed Get Account Page token!');
						return false;
					}

					if(!$instagram_account_id && 'group' !== $s['fb_account_type']){

						wp_die( __( 'Failed Get Instagram ID!', MECSPTEXTDOMAIN ) );
						return false;
					}
				}

				$user_token_options['account_access_token'] = sanitize_text_field( $account_access_token );
				$user_token_options['instagram_account_id'] = sanitize_text_field( $instagram_account_id );
			}

			Settings::getInstance()->update_auth_account_settings( 'instagram', $account_id, $user_token_options );
		}

		?>
		<script type="text/javascript">
			window.close();
		</script>
		<?php

	}
}