<?php

namespace MEC_Social_Poster\APIs\Linkedin;

defined('MECEXEC') or die();

use MEC\Singleton;
use MEC_Social_Poster\Accounts\Accounts;
use MEC_Social_Poster\Settings\Settings;

class Base extends Singleton{

	public $base_url = 'https://www.linkedin.com/v2';
	public $api_base_url = 'https://api.linkedin.com/v2';

	/**
	 * Return saved access token
	 *
	 * @param int $account_id
	 * @param string $token_type
	 *
	 * @since 1.0.0
	 *
	 * @return string|false
	 */
	public function get_saved_access_token( $account_id, $token_type = 'primary' ){

		return Settings::getInstance()->get_access_token( 'linkedin', $account_id, $token_type );
	}

	/**
	 * Return owner
	 *
	 * @param int $account_id
	 *
	 * @since 1.0.0
	 *
	 * @return string|false
	 */
	public function get_owner( $account_id ){

		$data = Accounts::getInstance()->get_account_data( $account_id );

		$owner_id = isset( $data['linkedin_account_id'] ) ? $data['linkedin_account_id'] : false;
		$owner_type = isset( $data['linkedin_account_type'] ) && !empty( $data['linkedin_account_type'] ) ? $data['linkedin_account_type'] : 'me';

		$owner = false;
		if( 'me' === $owner_type ){

			if( empty( $owner_id ) ){

				$id = $this->get_person_id( $account_id );
				if( !is_wp_error( $id ) ){

					$data['linkedin_account_id'] = $id;
					Accounts::getInstance()->update_account_data( $account_id, $data );
				}
			}

			$owner = "urn:li:person:{$owner_id}";

		}elseif( 'company' === $owner_type ){

			$owner = "urn:li:organization:{$owner_id}";
		}

		return $owner;
	}


	/**
	 * Send Request
	 *
	 * @param string $url
	 * @param array $data
	 * @param int $account_id
	 *
	 * @since 1.0.0
	 *
	 * @return array|object|\WP_Error
	 */
	public function send_request( $url, $data, $account_id, $method = 'post' ){

		$access_token = $this->get_saved_access_token( $account_id );

		$args = array(
			'headers' => array(
				'Authorization' => 'Bearer ' . $access_token,
				'Content-Type'  => 'application/json',
            	'x-li-format'   => 'json',
			),
			'body' => $data,
			'timeout' => 120,
		);

		if( 'post' === $method ){

			$response = wp_remote_post( $url, $args );
		}else{

			$response = wp_remote_get( $url, $args );
		}

		if( is_wp_error( $response ) ) {

			return $response;
		}

		$body = wp_remote_retrieve_body( $response );
		$body = json_decode( $body );

		if( $body->serviceErrorCode || 404 == $body->status ){

			$body = new \WP_Error( ' ', $body->message );
		}

		return $body;
	}

	/**
	 * Return Person ID
	 *
	 * @param int $account_id
	 *
	 * @since 1.0.0
	 *
	 * @return string|\WP_Error
	 */
	public function get_person_id( $account_id, $page = 'me' ){

		$data = array();
		$r_url = "{$this->api_base_url}/{$page}?projection=(id,owner)";

		$r = $this->send_request( $r_url, $data, $account_id, 'get' );

		return isset( $r->id ) ? $r->id : $r;
	}
}