<?php

namespace MEC_Social_Poster\APIs\Linkedin;

defined('MECEXEC') or die();

/**
 * @since 1.0.0
 */
class Post extends Base{

	/**
	 * Share url
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $base_share_url = 'https://api.linkedin.com/v2/shares';

	/**
	 * Publish Post
	 *
	 * @param int $account_id
	 * @param array $data
	 *
	 * @since 1.0.0
	 *
	 * @return string|false|\WP_Error
	 */
	public function publish_post( $account_id, $data ){

		$owner = $this->get_owner( $account_id );

		$title = $data['title'] ?? '';
		$link = $data['link'] ?? '';
		$message = $data['message'] ?? '';
		$thumbnail = $data['thumbnail'] ?? '';
		$hashtags = $data['hashtags'] ?? array();
		$hashtags = !empty( $data['hashtags'] ) ? ' #' . implode( ' #', $hashtags ) : '';

		$_message = $message . PHP_EOL . $hashtags;

		$r_url = "{$this->base_share_url}";
		if( !empty( $thumbnail ) ){

			$_message = $message . PHP_EOL . $link . PHP_EOL . $hashtags;
		}

		$data = json_encode(array(
			'content' => array(
				'title' => $title,
				'contentEntities' => array(
					array(
						// 'entity' => 'urn:li:article:0',
						'entityLocation' => $link,
						'thumbnails' => array(
							array(
								'resolvedUrl' => $thumbnail,
							),
						)
					),
				),
			),
			'owner' => $owner,
			'subject' => $title,
			'text' => array(
				'text' => $_message,
			),
		));

		$body = $this->send_request( $r_url, $data, $account_id, 'post' );

		return isset( $body->id ) ? $body->id : $body;
	}
}