<?php

namespace MEC_Social_Poster\APIs\Meetup;

defined('MECEXEC') or die();

use MEC_Social_Poster\Accounts\Accounts;
use MEC_Social_Poster\Settings\Settings;

class Authentication extends Base{

	public $base_auth_url = 'https://secure.meetup.com/oauth2';

    public function authorize_user( $account_id ){

        if( !$account_id ){

            return new \WP_Error( 'empty_account', __('Please Select an account.', MECSPTEXTDOMAIN));
        }

		$s = Accounts::getInstance()->get_account_data( $account_id );

		$api_key = isset($s['api_key']) ? $s['api_key'] : null;
		$api_secret = isset($s['api_secret']) ? $s['api_secret'] : null;

		if (!$api_key || !$api_secret) {

            return new \WP_Error( 'empty_account', __('Please insert Meetup App ID and Secret.', MECSPTEXTDOMAIN) );
		}


		$redirect_url = Settings::getInstance()->get_auth_callback_url( 'meetup' );

		$url = add_query_arg(
			array(
				'display' => 'popup',
				'client_id' => $api_key,
				'redirect_uri' => urlencode( $redirect_url ),
				'response_type' => 'code',
			),
			$this->base_auth_url . '/authorize'
		);

		update_option('mec_sp_meetup_current_request',$account_id);

		header("Location: " . $url);
		exit;
    }

	public function authorize_callback() {

		$user_token_options = array('authorize_status' => 0);
		$code = isset($_GET['code']) && !empty($_GET['code']) ? sanitize_text_field($_GET['code']) : null;

		// if( isset( $_GET['state'] ) && !empty( $_GET['state'] ) ){

		// 	$user_token_options['authorize_status'] = 0;
		// 	$user_token_options['error_message'] = 'APP-ID or APP-Secret is null';
		// 	wp_die( $_GET['error_description'] ?? '' );
		// }

		if ( empty( $code ) ) {

			$user_token_options['authorize_status'] = 0;
			$user_token_options['error_message'] = 'API-Key or API-Secret is null';
			wp_die(__('Response Failed, please try again.', MECSPTEXTDOMAIN));
		}

		$account_id = get_option('mec_sp_meetup_current_request', null);
		if ($account_id == null) {

			wp_die(__('Please Select an account.', MECSPTEXTDOMAIN));
			return false;
		}

		$s = Accounts::getInstance()->get_account_data( $account_id );

		$api_key = isset($s['api_key']) ? $s['api_key'] : '';
		$api_secret = isset($s['api_secret']) ? $s['api_secret'] : '';
		$title = $s['title'];

		$redirect_url = Settings::getInstance()->get_auth_callback_url( 'meetup' );

		$token_url = add_query_arg(
			array(
				'grant_type' => 'authorization_code',
				'client_id' => $api_key,
				'client_secret' => $api_secret,
				'code' => $code,
				'redirect_uri' => urlencode( $redirect_url ),
			),
			$this->base_auth_url . '/access'
		);

		$access_token = "";

		$response = wp_remote_post($token_url);
		$body = wp_remote_retrieve_body($response);
		$b = json_decode($body);

		if (!$body || empty($body)) {

			$user_token_options['authorize_status'] = 0;
			$user_token_options['error_message'] = 'Network Error';
			wp_die($response);
		}elseif( isset( $b->error ) && !empty( $b->error ) ){

			wp_die( $b->error_description ?? '' );
		} else {
			$b = json_decode($body);

			if (isset($b->error) && isset($b->error->message)) {
				$msg = "<h3>Meetup Response Error!</h3>";
				$msg .= "{$b->error->code}:{$b->error->message}";
				$msg .= "<br/>";
				$msg .= "{$b->error->type}";
				wp_die($msg);
				return false;
			}

			if (isset($b->access_token)) {

				$base_expire = 60*3600;

				$expire_at = isset($b->expires_in)?$b->expires_in:$base_expire;
				$account_access_token = '';

				$access_token = $b->access_token;
				$user_token_options['result'] = $b;
				$user_token_options['status'] = true;
				$user_token_options['request_at'] = time();
				$user_token_options['expire_at'] = time() + $expire_at;
				$user_token_options['title'] = $title;
				$user_token_options['access_token'] = sanitize_text_field( $access_token );
				$user_token_options['account_access_token'] = sanitize_text_field( $account_access_token );
			}

			Settings::getInstance()->update_auth_account_settings( 'meetup', $account_id, $user_token_options );
		}

		?>
		<script type="text/javascript">
			window.close();
		</script>
		<?php
	}
}