<?php

namespace MEC_Social_Poster\APIs\Meetup;

defined('MECEXEC') or die();

use MEC\Singleton;
use MEC_Social_Poster\Accounts\Accounts;
use MEC_Social_Poster\Settings\Settings;

class Base extends Singleton{

	public $base_url = 'https://www.meetup.com/v2';

	/**
	 * Return saved access token
	 *
	 * @param int $account_id
	 * @param string $token_type
	 *
	 * @since 1.0.0
	 *
	 * @return string|false
	 */
	public function get_saved_access_token( $account_id, $token_type = 'primary' ){

		return Settings::getInstance()->get_access_token( 'meetup', $account_id, $token_type );
	}

	/**
	 * Send Request
	 *
	 * @param string $url
	 * @param array $data
	 * @param int $account_id
	 *
	 * @since 1.0.0
	 *
	 * @return array|object|\WP_Error
	 */
	public function send_request( $url, $data, $account_id, $method = 'post' ){

		$access_token = $this->get_saved_access_token( $account_id );

		$args = array(
			'headers' => array(
				'Authorization' => 'Bearer ' . $access_token,
				'Content-Type'  => 'application/json',
			),
			'body' => $data,
			'timeout' => 120,
		);

		if( 'post' === $method ){

			$response = wp_remote_post( $url, $args );
		}else{

			$response = wp_remote_get( $url, $args );
		}

		if( is_wp_error( $response ) ) {

			return $response;
		}

		$body = wp_remote_retrieve_body( $response );
		$r = json_decode( $body );

		if( !empty( $r->errors ) && is_array( $r->errors ) ){

			$wp_errors = $this->get_errors( $r->errors );
			$r = is_wp_error( $wp_errors ) ? $wp_errors : $r;
		}

		return $r;
	}

	/**
	 * Return Errors
	 *
	 * @param array $errors
	 *
	 * @since 1.0.0
	 *
	 * @return false|\WP_Error
	 */
	public function get_errors( $errors ){

		if( empty( $errors ) || !is_array( $errors ) ){

			return false;
		}

		$wp_errors = new \WP_Error();

		foreach( $errors as $error ){

			$wp_errors->add( time(), $error->message );
		}

		return $wp_errors;
	}

	/**
	 * Return saved group id or get and save it
	 *
	 * @param int $account_id
	 *
	 * @since 1.0.0
	 *
	 * @return false|\WP_Error
	 */
	public function get_group_id( $account_id ){

		$account_data = Accounts::getInstance()->get_account_data( $account_id );

		$group_slug = isset( $account_data['meetup_account_id'] ) ? $account_data['meetup_account_id'] : false;
		$group_id = isset( $account_data['meetup_group_id'] ) ? $account_data['meetup_group_id'] : false;

		if( empty( $group_id ) ){

			$r_url = "{$this->base_gql_url}";
			$query = 'query($urlname: String!) {
				groupByUrlname(urlname: $urlname) {
					id
				}
			}';

			$variables = array(
				'urlname' => $group_slug,
			);

			$data = json_encode(array(
				'query' => $query,
				'variables' => $variables,
			));

			$r = $this->send_request( $r_url, $data, $account_id, 'post' );

			$id = isset( $r->data->groupByUrlname->id ) ? $r->data->groupByUrlname->id : false;
			if( !empty( $id ) ){

				$account_data['meetup_group_id'] = $id;
				Accounts::getInstance()->update_account_data( $account_id, $account_data );
			}

			$group_id = $id;
		}

		return $group_id;
	}
}