<?php

namespace MEC_Social_Poster\APIs\Meetup;

defined('MECEXEC') or die();

/**
 * @since 1.0.0
 * @see https://www.meetup.com/api/schema/#CreateEventInput
 */
class Post extends Base{

	/**
	 * Share url
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $base_gql_url = 'https://api.meetup.com/gql';

	/**
	 * Upload Image
	 *
	 * @param int $account_id
	 * @param array $data
	 *
	 * @since 1.0.0
	 *
	 * @return string|false|\WP_Error
	 */
	public function upload_image( $account_id, $data ){

		$group_id = $this->get_group_id( $account_id );
		$filename = $data['thumbnail'] ?? '';

		if( empty( $filename ) ){

			return false;
		}

		$r_url = "{$this->base_gql_url}";

		$query = 'mutation($input: ImageUploadInput!) {
			uploadImage(input: $input) {
			  uploadUrl
			  image {
				id
				baseUrl
				preview
			  }
			  imagePath
			}
		  }';

		$input = array(
			'groupId' => $group_id,
			'photoType' => 'GROUP_PHOTO',
			'fileName' => $filename,
			'contentType' => 'JPEG'
		);

		$variables = array(
			'input' => $input,
		);

		$data = json_encode(array(
			'query' => $query,
			'variables' => $variables,
		));

		$r = $this->send_request( $r_url, $data, $account_id, 'post' );

		if( is_wp_error( $r ) ){

			return $r;
		}elseif( isset( $r->data->createEvent->errors ) && !empty( $r->data->createEvent->errors ) ){

			return $this->get_errors( $r->data->createEvent->errors );
		}

		return isset( $r->data->uploadImage->image->id ) ? $r->data->uploadImage->image->id : false;
	}

	/**
	 * Return repeat data
	 *
	 * @param array|false $repeat_data
	 *
	 * @since 1.0.0
	 *
	 * @return array|false
	 */
	public function repeat_data( $repeat_data ){

		if( !$repeat_data || !is_array( $repeat_data ) ){

			return false;
		}

		$date = $repeat_data['start']['date'] ?? '';
		$hour = $repeat_data['start']['hour'] ?? '';
		$hour = sprintf( '%02', $hour );
		$minutes = $repeat_data['start']['minutes'] ?? '';
		$minutes = sprintf( '%02', $minutes );
		$ampm = $repeat_data['start']['ampm'] ?? 'AM';

		$start_datetime = "{$date} {$hour}:{$minutes} {$ampm}";
		$repeat = $repeat_data['repeat'] ?? array();

		$repeat_status = $repeat['status'] ?? false;
		$repeat_type = $repeat['type'] ?? false;

		if( !$repeat_status || !$repeat_type ){

			return false;
		}

		$all_days = array(
			1 => 'MONDAY',
			2 => 'TUESDAY',
			3 => 'WEDNESDAY',
			4 => 'THURSDAY',
			5 => 'FRIDAY',
			6 => 'SATURDAY',
			7 => 'SUNDAY',
		);

		$r = false;

		switch( $repeat_type ){

			case 'daily':
			case 'weekday':
			case 'weekend':
			case 'certain_weekdays':
			case 'weekly':

				$setting_days = $all_days;
				$interval = 1;
				if( 'weekday' === $repeat_type ){

					$setting_days = \MEC\Settings\Settings::getInstance()->get_settings( 'weekdays' );
					$interval = isset( $repeat['interval'] ) ? (int)$repeat['interval'] : 1;
				}elseif( 'weekend' === $repeat_type ){

					$setting_days = \MEC\Settings\Settings::getInstance()->get_settings( 'weekends' );
				}elseif( 'certain_weekdays' === $repeat_type ){

					$setting_days = $repeat['certain_weekdays'] ?? array();
				}elseif( 'weekly' === $repeat_type ){

					$setting_days = array(
						date_i18n( 'w', strtotime( $start_datetime ))
					);
				}


				foreach( $setting_days as $day_number ){

					$days[ $day_number ] = $all_days[ $day_number ] ?? '';
				}

				$r['weeklyRecurrence'] = array(
					'weeklyInterval' => $interval,
					'weeklyDaysOfWeek' =>  array_values($days),
				);
				break;

			case 'monthly'://TODO: develop
			case 'yearly':
			// case 'custom_days':
			// case 'advanced':

				// $r['weeklyRecurrence'] = array(
				// 	'weeklyInterval' => isset( $repeat['interval'] ) ? (int)$repeat['interval'] : 1,
				// 	'weeklyDaysOfWeek' =>  $all_days,
				// );
				break;
		}

		return $r;
	}

	/**
	 * Publish Post
	 *
	 * @param int $account_id
	 * @param array $data
	 *
	 * @since 1.0.0
	 *
	 * @return string|false|\WP_Error
	 */
	public function publish_post( $account_id, $data ){

		$title = $data['title'] ?? '';
		$link = $data['link'] ?? '';
		$message = $data['message'] ?? '';
		$thumbnail = $data['thumbnail'] ?? '';
		$hashtags = $data['hashtags'] ?? array();
		$hashtags = !empty( $data['hashtags'] ) ? ' #' . implode( ' #', $hashtags ) : '';

		$group_id = $data['group_id'] ?? '';
		$start_datetime = $data['start_datetime'] ?? '';
		$duration = $data['duration'] ?? '';

		$latitude = $data['latitude'] ?? '';
		$longitude = $data['longitude'] ?? '';

		$repeat_data = $this->repeat_data( $data['repeat_data'] ?? false );

		$_message = $message;

		$r_url = "{$this->base_gql_url}";
		if( !empty( $thumbnail ) ){

			$_message .= PHP_EOL . $link;
		}


		if( !empty( $hashtags ) ){

			$_message .= PHP_EOL . $hashtags;
		}

		$query = 'mutation($input: CreateEventInput!) {
			createEvent(input: $input) {
			  event {
				id
			  }
			  errors {
				message
				code
				field
			  }
			}
		  }';

		$input = array(
			'groupUrlname' => $group_id,
			'title' => $title,
			'description' => $_message,
			'startDateTime' => $start_datetime,
			// 'duration' => $duration,
			// 'rsvpSettings' => '',
			// 'eventHosts' => '',
			// 'venueId' => '',
			// 'venueVisibility' => '',
			// 'selfRsvp' => '',
			// 'rsvpSurvey' => '',
			// 'topics' => '',
			// 'proNetworkEvents' => '',
			// 'zoomMeetingId' => '',
			'publishStatus' => 'PUBLISHED',
		);

		$thumbnail_id = $this->upload_image( $account_id, $data );//TODO:
		if( !is_wp_error( $thumbnail_id ) && !empty( $thumbnail_id ) ){

			$input['featuredPhotoId'] = (int) $thumbnail_id;
		}

		if( !empty( $latitude ) && !empty( $longitude ) ){

			$input['location']['latitude'] = (float) $latitude;
			$input['location']['longitude'] = (float) $longitude;
		}

		if( $repeat_data ){

			$input['recurring'] = $repeat_data;
		}

		$variables = array(
			'input' => $input,
		);

		$serialize_precision = ini_get( 'serialize_precision' );
		if (version_compare(phpversion(), '7.1', '>=')) {
			ini_set( 'serialize_precision', -1 );
		}
		// wp_die(print_r($variables));
		// wp_die(json_encode($variables));

		if (version_compare(phpversion(), '7.1', '>=')) {
			ini_set( 'serialize_precision', $serialize_precision );
		}

		$data = json_encode(array(
			'query' => $query,
			'variables' => $variables,
		));

		// wp_die(print_r($data));

		$r = $this->send_request( $r_url, $data, $account_id, 'post' );

		if( is_wp_error( $r ) ){

			return $r;
		}elseif( isset( $r->data->createEvent->errors ) && !empty( $r->data->createEvent->errors ) ){

			return $this->get_errors( $r->data->createEvent->errors );
		}else{


		}

		return isset( $r->event->id ) ? $r->event->id : false;
	}
}