<?php

namespace MEC_Social_Poster\APIs\Twitter;

defined('MECEXEC') or die();

use MEC_Social_Poster\Accounts\Accounts;
use MEC_Social_Poster\Settings\Settings;

class Authentication extends Base{

	public $auth2_url = "https://api.twitter.com/2/oauth2";

    public function authorize_user( $account_id ){

        if( !$account_id ){

            return new \WP_Error( 'empty_account', __('Please Select an account.', MECSPTEXTDOMAIN));
        }

		$s = Accounts::getInstance()->get_account_data( $account_id );

		$client_id = isset($s['client_id']) ? $s['client_id'] : null;
		$client_secret = isset($s['client_secret']) ? $s['client_secret'] : null;
		// $api_key = isset($s['api_key']) ? $s['api_key'] : null;
		// $api_secret_key = isset($s['api_secret']) ? $s['api_secret'] : null;
		// $api_access_token = isset($s['access_token']) ? $s['access_token'] : null;
		// $api_access_token_secret = isset($s['api_secret']) ? $s['api_secret'] : null;

		if (!$client_id || !$client_secret) {

            return new \WP_Error( 'empty_account', __('Please insert Twitter App ID and Secret.', MECSPTEXTDOMAIN) );
		}

		$redirect_url = Settings::getInstance()->get_auth_callback_url( 'twitter' );
		$scope = 'offline.access%20tweet.read%20tweet.write%20users.read%20follows.read%20follows.write';

		$url = add_query_arg(
			array(
				'response_type' => 'code',
				'display' => 'popup',
				'client_id' => $client_id,
				'redirect_uri' => urlencode( $redirect_url ),
				'scope' => $scope,
				'state' => 'state',
				'code_challenge' => 'challenge',
				'code_challenge_method' => 'plain',
				 'grant_type' => 'PKCE',
			),
			'https://twitter.com/i/oauth2/authorize'
		);

		update_option('mec_sp_twitter_current_request',$account_id);

		header("Location: " . $url);
		exit;
    }

	public function get_v2_access_token( $api_key, $api_secret_key ){

		$user_pass = base64_encode( "{$api_key}:{$api_secret_key}" );
		$args = array(
			'headers' => array(
				'Authorization' => "Basic {$user_pass}",
				'Content-Type' =>'application/x-www-form-urlencoded;charset=UTF-8',
			),
			'body' => array(
				'grant_type' => 'client_credentials',
			),
		);
		$token_url = 'https://api.twitter.com/oauth2/token';

		$response = wp_remote_post( $token_url, $args );
		$body = wp_remote_retrieve_body($response);
		$b = json_decode($body);

		return isset( $b->access_token ) ? $b->access_token : false;
	}

	public function authorize_callback() {

		$user_token_options = array('authorize_status' => 0);
		$code = isset($_GET['code']) && !empty($_GET['code']) ? sanitize_text_field($_GET['code']) : null;

		if ( empty( $code ) ) {

			$user_token_options['authorize_status'] = 0;
			$user_token_options['error_message'] = __( 'Verification Code is empty', MECSPTEXTDOMAIN );
			wp_die(__('Response Failed, please try again.', MECSPTEXTDOMAIN));
		}

		if( isset( $_GET['error'] ) && !empty( $_GET['error'] ) ){

			$user_token_options['authorize_status'] = 0;
			wp_die( $_GET['error_description'] ?? '' );
		}

		$account_id = get_option('mec_sp_twitter_current_request', null);
		if ($account_id == null) {

			wp_die(__('Please Select an account.', MECSPTEXTDOMAIN));
			return false;
		}

		$s = Accounts::getInstance()->get_account_data( $account_id );

		$client_id = isset($s['client_id']) ? $s['client_id'] : null;
		$client_secret = isset($s['client_secret']) ? $s['client_secret'] : null;
		// $api_key = isset($s['api_key']) ? $s['api_key'] : null;
		// $api_secret_key = isset($s['api_secret']) ? $s['api_secret'] : null;
		// $api_access_token = isset($s['access_token']) ? $s['access_token'] : null;
		// $api_access_token_secret = isset($s['api_secret']) ? $s['api_secret'] : null;

		$title = $s['title'];

		$redirect_url = Settings::getInstance()->get_auth_callback_url( 'twitter' );
		$user_pass = base64_encode( $client_id . ':' . $client_secret );

		$args = array(
			'headers' => array(
				'Authorization' => "Basic {$user_pass}",
				'Content-Type' =>'application/x-www-form-urlencoded;charset=UTF-8',
			),
			'body' => array(
				'code' => $code,
				'grant_type' => 'authorization_code',
				'client_id' => $client_id,
				'redirect_uri' => $redirect_url,
				'code_verifier' => 'challenge',
			),
		);

		$token_url = $this->auth2_url . '/token';

		$access_token = "";

		$response = wp_remote_post( $token_url, $args );
		$body = wp_remote_retrieve_body($response);
		$b = json_decode($body);

		if( isset( $b->errors ) && !empty( $b->errors ) ){

			$errors_html = 'Errors:<br>';
			foreach( $b->errors as $error ){

				$errors_html .= $error->code . ': ' . $error->message;
			}

			wp_die( $errors_html );
		}

		if (!$body || empty($body)) {

			$user_token_options['authorize_status'] = 0;
			$user_token_options['error_message'] = 'Network Error';
			wp_die($response);
		}elseif( isset( $b->error ) && !empty( $b->error ) ){

			wp_die( $b->error_description ?? '' );
		} else {
			$b = json_decode($body);

			if (isset($b->error) && isset($b->error->message)) {
				$msg = "<h3>Twitter Response Error!</h3>";
				$msg .= "{$b->error->code}:{$b->error->message}";
				$msg .= "<br/>";
				$msg .= "{$b->error->type}";
				wp_die($msg);
				return false;
			}

			if (isset($b->access_token)) {

				$base_expire = 2880*3600;

//				$expire_at = isset($b->expires_in) ? $b->expires_in : $base_expire;
				$expire_at = $base_expire;

				$access_token = $b->access_token;
				$user_token_options['authorize_status'] = 1;
				$user_token_options['result'] = $b;
				$user_token_options['status'] = true;
				$user_token_options['request_at'] = time();
				$user_token_options['expire_at'] = time() + $expire_at;
				$user_token_options['title'] = $title;
				$user_token_options['access_token'] = sanitize_text_field( $access_token );
			}

			Settings::getInstance()->update_auth_account_settings( 'twitter', $account_id, $user_token_options );
		}

		?>
		<script type="text/javascript">
			window.close();
		</script>
		<?php

	}
}
