<?php

namespace MEC_Social_Poster\APIs\Twitter;

defined('MECEXEC') or die();

use MEC\Singleton;
use MEC_Social_Poster\Accounts\Accounts;
use MEC_Social_Poster\Settings\Settings;

class Base extends Singleton{

	/**
	 * Base url
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $base_url = 'https://api.twitter.com/2';

	/**
	 * Return saved access token
	 *
	 * @param int $account_id
	 * @param string $token_type
	 *
	 * @since 1.0.0
	 *
	 * @return string|false
	 */
	public function get_saved_access_token( $account_id, $token_type = 'primary' ){

		return Settings::getInstance()->get_access_token( 'twitter', $account_id, $token_type );
	}

	/**
	 * Send Request
	 *
	 * @param string $url
	 * @param array $data
	 * @param int $account_id
	 *
	 * @since 1.0.0
	 *
	 * @return array|object|\WP_Error
	 */
	public function send_request( $url, $data, $account_id, $method = 'post' ){

		$access_token = $this->get_saved_access_token( $account_id );

		$args = array(
			'headers' => array(
				'Authorization' => 'Bearer ' . $access_token,
				'Content-Type'  => 'application/json',
            	'x-li-format'   => 'json',
			),
			'body' => $data,
			'timeout' => 120,
		);

		if( 'post' === $method ){

			$response = wp_remote_post( $url, $args );
		}else{

			$response = wp_remote_get( $url, $args );
		}

		if( is_wp_error( $response ) ) {

			return $response;
		}

		$body = wp_remote_retrieve_body( $response );
		$body = json_decode( $body );
		if( $body->detail || ( isset( $body->status ) && 200 != $body->status ) ){

			$body = new \WP_Error( ' ', $body->detail );
		}

		return $body;
	}
}