<?php

namespace MEC_Social_Poster\APIs\Twitter;

defined('MECEXEC') or die();

/**
 * @since 1.0.0
 */
class Post extends Base{

	/**
	 * Publish Post
	 *
	 * @param int $account_id
	 * @param array $data
	 *
	 * @since 1.0.0
	 *
	 * @return string|false|\WP_Error
	 */
	public function publish_post( $account_id, $data ){

		$title = $data['title'] ?? '';
		$link = $data['link'] ?? '';
		$message = $data['message'] ?? '';
		$thumbnail = $data['thumbnail'] ?? '';
		$hashtags = $data['hashtags'] ?? array();
		$hashtags = !empty( $data['hashtags'] ) ? ' #' . implode( ' #', $hashtags ) : '';

		$title_length = strlen( $title );
		$hashtags_length = strlen( $hashtags );
		$link_length = strlen( $link );

		$allowed_message_length = 280 - ( $title_length + $hashtags_length + $link_length );
		$message = substr( $message, 0, $allowed_message_length - 7 ) . ' ...';
		$_message = $title  . PHP_EOL . $message . PHP_EOL . $hashtags;

		$r_url = "{$this->base_url}/tweets";
		if( !empty( $thumbnail ) ){

			$allowed_message_length = 280 - ( $title_length + $hashtags_length + $link_length );
			$message = substr( $message, 0, $allowed_message_length - 7 ) . ' ...';
			$_message = $message . PHP_EOL . $link . PHP_EOL . $hashtags;
		}

		$data = json_encode(array(
			'text' => $_message,
		));

		$body = $this->send_request( $r_url, $data, $account_id, 'post' );

		return isset( $body->data->id ) ? $body->data->id : $body;
	}
}