<?php

namespace MEC_Social_Poster\Accounts;

use MEC_Social_Poster\Settings\Settings;

/**
 * @since 1.0.0
 */
class AccountsListTable extends \WP_List_Table {

	public $section;
	public $setting_class;

	public function __construct() {
		global $status, $page;
		parent::__construct(array(
			'singular' => 'setting',
			'plural' => 'settings',
			'ajax' => false,
		));
	}

	function column_default($item, $column_name) {

		return $item[$column_name];
	}

	function column_title($item) {

		$wpea_url_delete_args = array(
			'page' => sanitize_text_field(wp_unslash($_REQUEST['page'])),
			'tab' => sanitize_text_field(wp_unslash($_REQUEST['tab'])),
			'action' => 'delete',
			'id' => $item['ID'],
		);
		$wpea_url_edit_args = array(
			'page' => sanitize_text_field(wp_unslash($_REQUEST['page'])),
			'tab' => sanitize_text_field(wp_unslash($_REQUEST['tab'])),
			'mec_sp_action' => 'mec_sp_setting_edit',
			'id' => $item['ID'],
		);
		// Build row actions.
		$actions = array(
			'delete' => sprintf(
				'<a href="%1$s" onclick="return confirm(\'Warning!! Are you sure to Delete this account? Account history will be permanatly deleted.\')">%2$s</a>',
				esc_url(wp_nonce_url(add_query_arg($wpea_url_delete_args),'mec_sp_delete_account_nonce')),
				esc_html__('Delete', MECSPTEXTDOMAIN)
			),
			'edit' => sprintf('<a href="%1$s">%2$s</a>', esc_url(wp_nonce_url(add_query_arg($wpea_url_edit_args), 'mec_sp_edit_account_nonce')), esc_html__('Edit', MECSPTEXTDOMAIN)),
		);

		// Return the title contents.
		return sprintf('<strong>%1$s</strong><span>%3$s</span> %2$s',
			$item['title'],
			$this->row_actions($actions),
			''
		);
	}

	function column_action($item) {

		$url = add_query_arg(array(
			'action' => 'mec_sp_view_account',
			'account' => $item['ID'],
			'TB_iframe' => 'true',
			'width' => '800',
			'height' => '500',
		), admin_url('admin.php'));

		$ret = sprintf(
			'<div style="display:none" id="item-'.$item['ID'].'">'.json_encode($item).'</div><button title="%1$s" class="button button-primary" onclick="return MEC_SP_Show_Account(\''.$item['ID'].'\',this)">%2$s</button>',
			$item['title'],
			__('View Account', MECSPTEXTDOMAIN)
		);

		if ($item['need_auth'] == 1) {

			$color = $item['auth_status'] == true?'success':'info';
			$title = $item['auth_status'] == true?__('Authentication successful', MECSPTEXTDOMAIN):__('Needs authentication', MECSPTEXTDOMAIN);


			$auth_url = $this->setting_class->get_auth_url();
			$auth_url .= '&authid='.$item['ID'];

			$ret .= '&nbsp;'.sprintf(
				'<a href="#" data-url="%1$s" data-action="auth" data-section="%2$s" data-authid="%3$s" title="%4$s" class="mec-sp-action open-account-details-modal button button-%5$s ">%6$s</a>',
				$auth_url,
				$this->section,
				$item['ID'],
				$item['title'],
				$color,
				$title
			);
		}

		return $ret;

	}

	function column_cb($item) {
		return sprintf(
			'<input type="checkbox" name="%1$s[]" value="%2$s" />',
			/*$1%s*/$this->_args['singular'],
			/*$2%s*/$item['ID']
		);
	}

	/**
	 * Get column title.
	 *
	 * @since    1.0.0
	 */
	function get_columns() {
		$columns = array(
			'cb' => '<input type="checkbox" />',
			'title' => __('Account', MECSPTEXTDOMAIN),
			'active' => __('Active/Deactive', MECSPTEXTDOMAIN),
			// 'status' => __('Status', MECSPTEXTDOMAIN),
			'action' => __('Action', MECSPTEXTDOMAIN),
		);
		return $columns;
	}

	public function get_bulk_actions() {

		return array(
			'delete' => __('Delete', MECSPTEXTDOMAIN),
		);

	}

	 public function process_bulk_action() {

		$bulk_action = $this->current_action();
        // security check!
        if ( $bulk_action && isset( $_REQUEST['_wpnonce'] ) && ! empty( $_REQUEST['_wpnonce'] ) ) {

			$redirect_url = $_SERVER['HTTP_REFERER'];
            $nonce  = sanitize_text_field(  $_REQUEST['_wpnonce'] );
            $action = 'mec_sp_delete_account_nonce';

            if ( !wp_verify_nonce( $nonce, $action ) ){

				wp_die(__( 'Nope! Security check failed!', MECSPTEXTDOMAIN ));
			}


			// wp_die(print_r($bulk_action));
			if( 'delete' === $bulk_action ){

				$ids = isset($_POST['setting']) ? $_POST['setting']: null;
				$id = isset($_GET['id']) ? $_GET['id']: null;
				$ids = empty( $ids ) && !is_null( $id ) ? [ $id ] : $ids;

				if($ids == null || !is_array($ids)){

					return;
				}

				foreach ( $ids as $id ) {

					$this->setting_class->delete_account($id);
				}

				echo '<script>window.location.href = "' . $redirect_url . '"</script>';
			}
        }
    }

	public function prepare_items() {

		$this->process_bulk_action();

		$per_page = 10;
		$columns = $this->get_columns();
		$hidden = array('ID');
		$sortable = $this->get_sortable_columns();

		$this->_column_headers = array($columns, $hidden, $sortable);


		$data = $this->get_account_data();

		$total_items = $data['total_records'];
		$this->items = $data['data'];

		$this->set_pagination_args(array(
			'total_items' => $total_items,
			'per_page' => $per_page,
			'total_pages' => ceil($total_items / $per_page),
		));

	}

	function get_account_data() {

		$ret = array('total_records' => 0, 'data' => array());
		$per_page = 10;
		$current_page = $this->get_pagenum();
        $accounts = $this->setting_class->get_accounts( $this->section );

		$ret['total_records'] = count( $accounts );
		foreach ($accounts as $k => $v) {

			$auth_status = Settings::getInstance()->get_auth_status( $this->section, $v['id'] );

			$ret['data'][] = array(
				'ID' => $v['id'],
				'title' => $v['title'],
				'active' => isset($v['active']) ? $v['active'] : '',
				'need_auth' => isset($v['need_auth']) && $v['need_auth']==1 ?true: false,
				'auth_status'=> $auth_status,
				'config'=>$v
			);
		}

		wp_reset_postdata();
		return $ret;
	}
}
