<?php

namespace MEC_Social_Poster;

use MEC\Singleton;
use MEC_Social_Poster\Settings\Settings;
use MEC_Social_Poster\Settings\SettingsPage;

class Admin extends Singleton{

    public function init(){

        SettingsPage::getInstance()->init();
        add_action( 'add_meta_boxes', array( $this, 'add_meta_boxes' ) );
        add_action( 'admin_enqueue_scripts', array( __CLASS__, 'enqueue' ) );
        add_action( 'admin_menu', array( $this, 'add_menu' ) );
        add_action('parent_file', array($this, 'mec_parent_menu_highlight'));
        add_action('submenu_file', array($this, 'mec_sub_menu_highlight'));

        EventSocialMetaBox::getInstance()->init();
        if( wp_doing_ajax() ){

            $this->ajax_handler();
        }

        $this->authentication_and_verification_handler();
    }

    public function add_menu(){

        add_submenu_page(
            'mec-intro',
            __( 'Social Tags', MECSPTEXTDOMAIN ),
            __( 'Social Tags', MECSPTEXTDOMAIN ),
            'edit_others_posts',
            'edit-tags.php?taxonomy=mec_social_tag&post_type=mec-events',
            null,
            9
        );
    }


    public function mec_sub_menu_highlight($submenu_file){

        global $current_screen;

        $taxonomy = $current_screen->taxonomy;

        switch($taxonomy){
            case 'mec_social_tag':

                $submenu_file = 'edit-tags.php?taxonomy=mec_social_tag&post_type=mec-events';
                break;
        }

        return $submenu_file;
    }

    public function mec_parent_menu_highlight($parent_file){

        global $current_screen;

        $taxonomy = $current_screen->taxonomy;

        switch($taxonomy){
            case 'mec_social_tag':

                $parent_file = 'mec-intro';
                break;

            default:
                //nothing
                break;
        }

        return $parent_file;
    }


    public function ajax_handler(){

        add_action( 'wp_ajax_mec_social_poster_check_auth', array( __CLASS__, 'check_auth' ) );
    }

    public function add_meta_boxes(){

        $post_type = get_post_type();
        $post_type = empty($post_type) && isset($_GET['post_type']) ? $_GET['post_type'] : $post_type;

        if( 'mec-events' === $post_type ){

            add_meta_box(
                'mec-social-poster-options',
                __( 'Social Auto Poster', MECSPTEXTDOMAIN ),
                [EventSocialMetaBox::getInstance(),'render'],
                null,
                'normal',
                'high'
            );
        }
    }

    public static function enqueue(){

        $vars = array(
			'ajaxurl' => admin_url('admin-ajax.php'),
			'title' => array(
				'needauthentication' => __('Needs authentication', MECSPTEXTDOMAIN),
				'authenticated' => __('Authentication successful', MECSPTEXTDOMAIN),
                'no_account_selected' => __('No accounts selected', MECSPTEXTDOMAIN),
			),
		);

        wp_enqueue_style( 'mec-social-poster-backend-style', MEC_SOCIAL_POSTER_PU_CSS.'/backend.css', null, '1.0.0' );
        wp_enqueue_script( 'mec-social-poster-backend-script', MEC_SOCIAL_POSTER_PU_JS.'/backend.js', null, '1.0.0' );
        wp_enqueue_script( 'mec-social-poster-repost-script', MEC_SOCIAL_POSTER_PU_JS.'/repost.js', null, '1.0.0' );
		wp_localize_script('mec-social-poster-backend-script', 'MEC_SP_VARS', $vars);
        wp_localize_script('mec-social-poster-repost-script', 'MEC_SP_VARS', $vars);

        wp_enqueue_script('mec-select2-script');
		wp_enqueue_style('mec-select2-style');
    }

    public static function check_auth(){

        $account_id = isset($_POST['authid']) ? $_POST['authid'] : null;
        $account_type = isset($_POST['account_type']) ? $_POST['account_type'] : null;

        $option = Settings::getInstance()->get_auth_account_settings( $account_type, $account_id );

        if (!$option || count($option) == 0) {

            return wp_send_json_error('Response error.');
        }

        if (!isset($option['status'])) {

            return wp_send_json_error('Result Failed!');
        }

        if ($option['status'] != true) {

            return wp_send_json_error($option['error_message']);
        }

        return wp_send_json_success('Success Authorized', 200);
    }

    public function authentication_and_verification_handler(){

        if( isset( $_GET['page'] ) && 'mec-social-poster' === $_GET['page'] && isset( $_GET['cmd'] ) ){

            $class = isset($_GET['class']) ? sanitize_text_field( $_GET['class'] ) : false;
            $cmd = str_replace( strtolower( $class ) .'_', '', sanitize_text_field( $_GET['cmd'] ) );

            if( !$class || !$cmd  ){

                wp_die( __('Error in params', MECSPTEXTDOMAIN ) );
            }

            $class = ucfirst( $class );
            $class = apply_filters(
                'mec_social_poster_get_authentication_and_verification_handler_class',
                "\\". __NAMESPACE__ . "\\APIs\\{$class}\\Authentication",
                $class
            );

            $r = false;
            if( class_exists( $class ) ){

                switch( $cmd ){

                    case 'auth':
                        $auth_id = isset( $_GET['authid'] ) ? $_GET['authid'] : 0;
                        $r = $class::getInstance()->authorize_user( $auth_id );


                        break;
                    case 'callback':

                        $r = $class::getInstance()->authorize_callback();

                        break;
                }
            }

            if( is_wp_error( $r ) ){

                wp_die( $r->get_error_message());
            }

        }
    }
}
