<?php

namespace MEC_Social_Poster;

use MEC\Singleton;
use MEC_Social_Poster\Accounts\Accounts;
use MEC_Social_Poster\Settings\Settings;
use MEC_Social_Poster\Settings\SettingsPage;

/**
 * @since 1.0.0
 */
class EventSocialFESMetaBox extends Singleton {

    /**
     * Init
     *
     * @since 1.0.0
     *
     * @return void
     */
	public function init() {

		add_action( 'mec_fes_metabox_details', [$this,'enqueue'], 99 );
        add_action( 'mec_fes_metabox_details', [$this,'meta_box_social_poster_options'], 99 );
        add_action( 'mec_fes_metabox_details', [$this,'meta_box_repost_options'], 99 );

        add_action( 'save_post_mec-events', [$this,'save_event'] );
        add_action( 'edit_post_mec-events', [$this,'save_event'] );
	}

    /**
     * Enqueue styles and scripts
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function enqueue(){
        ?>
        <script>
            jQuery(document).ready(function($){

                function mec_social_poster_status_change(status){

                    if(true === status){

                        $('.mec-add-social-poster-tabs-left .mec-add-social-poster-tabs-link').show();
                        $('#mec-social-poster .mec-social-poster-option-container').show();
                    }else{

                        $('.mec-add-social-poster-tabs-left .mec-add-social-poster-tabs-link:not(:first-child)').hide();
                        $('#mec-social-poster .mec-social-poster-option-container').hide();
                    }
                }

                jQuery(".mec-add-social-poster-tabs-link").on("click", function(e){

                    e.preventDefault();
                    var href = jQuery(this).attr("data-href");
                    jQuery(".mec-social-poster-tab-content,.mec-add-social-poster-tabs-link").removeClass("mec-tab-active");
                    jQuery(this).addClass("mec-tab-active");
                    jQuery("#" + href ).addClass("mec-tab-active");
                });

                $('.mec_social_poster_status').on('change',function(e){

                    var social_poster_status = $(this).is(':checked');
                    mec_social_poster_status_change(social_poster_status);

                    $("input[type=checkbox].social_poster_form_fields_global_inheritance").trigger('change');
                });
                var social_poster_status = $('.mec_social_poster_status').is(':checked');
                mec_social_poster_status_change(social_poster_status);


                $("input[type=checkbox].social_poster_form_fields_global_inheritance").on('change',function(){

                    var status = $(this).is(":checked");
                    var social_poster_status = $('.mec_social_poster_status').is(':checked');

                    if(true !== status && true === social_poster_status){
                        $('.mec-social-poster-forms').show();
                    }else{
                        $('.mec-social-poster-forms').hide();
                    }
                });

                $("input[type=checkbox].social_poster_form_fields_global_inheritance").trigger('change');

                $("#mec_social_poster_custom_accounts").select2();
                $(".mec-select2").select2();

            });
        </script>
        <?php
    }

    public function save_event($event_id){

        if(!isset($_POST['mec']['mec_social_poster_nonce'])) return;
        if(!wp_verify_nonce(sanitize_text_field($_POST['mec']['mec_social_poster_nonce']), 'mec_social_poster_data')) return;
        if(defined('DOING_AUTOSAVE') and DOING_AUTOSAVE) return;

        $social_poster_status_for_this_event = isset($_POST['mec_social_poster_status']) ? $_POST['mec_social_poster_status'] : "0";
        update_post_meta($event_id,'mec_social_poster_status',$social_poster_status_for_this_event);

        $social_poster_options = isset($_POST['mec']['mec-social-poster']) && is_array( $_POST['mec']['mec-social-poster'] ) ? $_POST['mec']['mec-social-poster'] : array();
        $social_poster_options['global_accounts_status'] = isset( $social_poster_options['global_accounts_status'] ) ? $social_poster_options['global_accounts_status'] : 1;
        $social_poster_options['schedules'] = isset( $social_poster_options['schedules'] ) && is_array( $social_poster_options['schedules'] ) ? $social_poster_options['schedules'] : array();

        $accounts = isset( $social_poster_options['accounts'] ) && is_array( $social_poster_options['accounts'] ) ? $social_poster_options['accounts'] : array();
        foreach( $accounts as $account_id ){

            $social_poster_options['schedules'][ $account_id ] = array(
                'account_id' => $account_id,
                'publish_on_type' => 'now',
            );
        }

        unset( $social_poster_options['schedules']['{{key}}'] );

        update_post_meta( $event_id, 'mec_social_poster', $social_poster_options );

        $repost_accounts = isset( $_POST['mec_social_poster_repost_custom_accounts'] ) && is_array( $_POST['mec_social_poster_repost_custom_accounts'] ) ? $_POST['mec_social_poster_repost_custom_accounts'] : array();
        update_post_meta( $event_id, 'mec_social_poster_repost_custom_accounts', $repost_accounts );
    }

    public function get_accounts( $event_id ){

        $settings = Settings::getInstance()->get_settings( 'general', array() );
        $allowed_accounts_in_fes_form_selected =  $settings['allowed_accounts_in_fes_form'] ?? array();
        $accounts = Accounts::getInstance()->get_accounts(array(
			'account_type' => '',
			'account_status' => true,
		));

        foreach( $accounts as $k => $account ){

            $account_id = $account['id'] ?? false;

            if( !$account_id || !in_array( $account_id, $allowed_accounts_in_fes_form_selected, false ) ){

                unset( $accounts[ $k ] );
                continue;
            }
        }

        return apply_filters( 'mec_filter_fes_form_social_accounts', $accounts, $event_id, $allowed_accounts_in_fes_form_selected );
    }

    public function meta_box_social_poster_options($post){

        $event_id = $post->ID;
        $social_poster_status_for_this_event = (bool)get_post_meta($post->ID,'mec_social_poster_status',true);
        $social_poster_options = get_post_meta($post->ID, 'mec_social_poster', true);
        if(!is_array($social_poster_options)) {
            $social_poster_options = array();
        }

        $base_name = 'mec[mec-social-poster]';
        $accounts = $this->get_accounts( $event_id );
        if( empty( $accounts ) ){

            return;
        }

        $selected_accounts = isset( $social_poster_options['accounts'] ) ? (array)$social_poster_options['accounts'] : array();

        $global_accounts_status = isset( $social_poster_options['global_accounts_status'] ) ? (bool)$social_poster_options['global_accounts_status'] : true;

        wp_nonce_field('mec_social_poster_data', 'mec[mec_social_poster_nonce]');
        ?>
        <style>.hidden{display:none;}</style>
        <div id="mec-social-poster">
            <div class="mec-meta-box-fields mec-social-poster-tab-content mec-tab-active" id="mec_meta_box_social_poster_options_form_1">

                <h4 class="mec-title"><?php esc_html_e('Publish on Socials', MECSPTEXTDOMAIN); ?></h4>
                <div class="mec-form-row mec-social-poster-primary-option">
                    <label for="mec_social_poster_status">
                        <input class="mec_social_poster_status" value="1" type="checkbox" name="mec_social_poster_status" <?php checked(true,$social_poster_status_for_this_event) ?> /> <?php _e( 'Enable', MECSPTEXTDOMAIN ); ?>
                    </label>
                </div>

                <div class="mec-social-poster-option-container">
                    <h4 class="mec-title"><label for="mec_social_poster_custom_accounts"><?php esc_html_e('Social Accounts', MECSPTEXTDOMAIN); ?></label></h4>
                    <div class="mec-form-row">
                            <label class="mec-col-6" onchange="jQuery('#mec_social_poster_custom_accounts_box, #mec-social-poster-schedules').toggle()" for="mec_social_poster_global_accounts_status" id="mec_social_poster_custom_accounts_label">
                            <input type="hidden" name="<?php echo $base_name ?>[global_accounts_status]" value="0"/>
                            <input id="mec_social_poster_global_accounts_status" <?php checked( $global_accounts_status, true ) ?> type="checkbox" value="1" name="<?php echo $base_name ?>[global_accounts_status]"/>
                            <?php esc_html_e('Inherit from global options', MECSPTEXTDOMAIN); ?>
                        </label>
                        <div class="mec-col-3 <?php echo $global_accounts_status ? 'hidden' : ''  ?>" id="mec_social_poster_custom_accounts_box">
                            <select class="mec-col-12 mec-select2" name="<?php echo $base_name ?>[accounts][]" multiple>
                                <?php

                                    $tabs = SettingsPage::getInstance()->get_primary_tabs();
                                    foreach( $accounts as $account ){

                                        $account_id = $account['id'];
                                        $account_type = $account['account_type'];
                                        $account_type_title =  $tabs[ $account_type ]['title'] ?? false;
                                        if( empty( $account_type_title ) ){

                                            continue;
                                        }
                                        $account_title = $account_type_title . ' - ' . $account['title'];
                                        $selected = in_array( $account_id, $selected_accounts, false );
                                        $can = EventSocial::getInstance()->can_send_event_to_social_account( $event_id, $account_id );
                                        $class = is_wp_error($can) || !$can ? 'mec-red' : '';
                                        echo '<option class="'.$class.'" value="'. $account_id .'" '. selected( $selected, true, false ) .'>'. esc_html( $account_title ) .'</option>';
                                    }
                                ?>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }

    /**
     * Render repost options
     *
     * @param \WP_Post $event
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function meta_box_repost_options($post){

        $event_id = $post->ID;
        if( !$event_id || -1 === $event_id ){

            return;
        }

        wp_enqueue_script( 'mec-social-poster-repost-script' );

        $accounts = Accounts::getInstance()->get_accounts(array(
			'account_type' => '',
			'account_status' => true,
            'check_auth' => true,
		));

        $selected_accounts = get_post_meta( $event_id, 'mec_social_poster_repost_custom_accounts', true );
        $selected_accounts = is_array( $selected_accounts ) ? $selected_accounts : array();

        wp_nonce_field( 'mec_social_poster_nf_repost', '_mec_sp_nonce' );
        ?>
        <input type="hidden" name="mec_social_poster_post_ID" id="mec_social_poster_post_ID" value="<?php echo $event_id; ?>" />
        <div class="mec-meta-box-fields mec-social-poster-tab-content" id="mec_meta_box_social_poster_options_repost_form">
            <h4 class="mec-title"><?php esc_html_e('Manual Publish and Repost', MECSPTEXTDOMAIN); ?></h4>
            <div class="mec-social-poster-messages"></div>
            <div class="mec-form-row">
                <label class="mec-col-6" for="mec_social_poster_global_accounts_status">
                    <?php esc_html_e('Accounts', MECSPTEXTDOMAIN); ?>
                </label>
                <div class="mec-col-6" id="mec_social_poster_repost_custom_accounts_box">
                    <select class="mec-col-12 mec-select2" id="mec_social_poster_repost_custom_accounts" multiple>
                        <?php

                            $tabs = SettingsPage::getInstance()->get_primary_tabs();
                            foreach( $accounts as $account ){

                                $account_id = $account['id'];
                                $account_type = $account['account_type'];
                                $account_type_title =  $tabs[ $account_type ]['title'] ?? false;
                                if( empty( $account_type_title ) ){

                                    continue;
                                }
                                $account_title = $account_type_title . ' - ' . $account['title'];
                                $selected = in_array( $account_id, $selected_accounts, false );
                                $can = EventSocial::getInstance()->can_send_event_to_social_account( $event_id, $account_id );
                                $class = is_wp_error($can) || !$can ? 'mec-red' : '';
                                echo '<option class="'.$class.'" value="'. $account_id .'" '. selected( $selected, true, false ) .'>'. esc_html( $account_title ) .'</option>';
                            }
                        ?>
                    </select>
                </div>
            </div>
            <div class="mec-form-row">
                <label class="mec-col-6" onchange="" for="mec_social_poster_repost_disable_check_accounts_conditions">
                    <input id="mec_social_poster_repost_disable_check_accounts_conditions" type="checkbox" value="1" />
                    <?php esc_html_e('Disable Check Account Conditions', MECSPTEXTDOMAIN); ?>
                    <span class="mec-tooltip">
                        <div class="box left">
                            <h5 class="title"><?php esc_html_e('Disable Check Account Conditions', MECSPTEXTDOMAIN); ?></h5>
                            <div class="content"><p><?php esc_attr_e('If this option is enabled, release conditions are not checked', MECSPTEXTDOMAIN); ?></p></div>
                        </div>
                        <i title="" class="dashicons-before dashicons-editor-help"></i>
                    </span>
                </label>
            </div>
            <div class="mec-form-row">
                <button class="button" type="button" id="mec_repost_on_socials"><?php esc_html_e( 'Publish', MECSPTEXTDOMAIN ) ?></button>
            </div>
        </div>
        <?php
    }
}