<?php

namespace MEC_Social_Poster;

use MEC\Singleton;
use MEC\Settings\Settings as MECSettings;
use MEC_Social_Poster\Accounts\Accounts;
use MEC_Social_Poster\Settings\SettingsPage;

/**
 * @since 1.0.0
 */
class EventSocialMetaBox extends Singleton {

    /**
     * Init
     *
     * @since 1.0.0
     *
     * @return void
     */
	public function init() {

		add_action( 'mec_event_social_poster_options_metabox', [$this,'meta_box_social_poster_options'] );
        add_action( 'mec_event_social_poster_options_metabox', [$this,'meta_box_repost_options'] );

        add_action( 'save_post_mec-events', [$this,'save_event'] );
        add_action( 'edit_post_mec-events', [$this,'save_event'] );
	}

    /**
     * Enqueue styles and scripts
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function enqueue(){

        ?>
        <style>
            .mec-add-social-poster-tabs-wrap,.mec-add-event-tabs-wrap,.mec-create-shortcode-tabs-wrap {
                display: flex;
                display: -webkit-box;
                display: -webkit-flex;
                display: -ms-flexbox;
            }

            .mec-add-social-poster-tabs-left,.mec-add-event-tabs-left {
                min-width: 200px;
            }

            @media(max-width: 1366px) {
                .mec-add-social-poster-tabs-left,.mec-add-event-tabs-left {
                    min-width:137px;
                }
            }

            .mec-add-social-poster-tabs-left,.mec-add-event-tabs-left,.mec-create-shortcode-tabs-left {
                flex: 1;
            }

            .mec-add-social-poster-tabs-right,.mec-add-event-tabs-right,.mec-create-shortcode-tabs-right {
                flex: 6;
            }

            a.mec-add-social-poster-tabs-link,a.mec-add-event-tabs-link,a.mec-create-shortcode-tabs-link {
                display: block;
            }

            .mec-social-poster-tab-content,.mec-create-shortcode-tab-content,.mec-event-tab-content {
                display: none;
                transition: all .3s ease;
            }

            .mec-social-poster-tab-content.mec-tab-active,.mec-create-shortcode-tab-content.mec-tab-active,.mec-event-tab-content.mec-tab-active {
                display: block;
            }

            .mec-add-social-poster-tabs-wrap,.mec-add-event-tabs-wrap {
                background: #fff;
                margin: -6px -12px -12px;
            }

            .mec-create-shortcode-tabs-wrap {
                margin: -30px -22px -42px;
            }

            .mec-add-social-poster-tabs-left,.mec-add-event-tabs-left,.mec-create-shortcode-tabs-left {
                background: #f7f8f9;
            }

            .mec-add-social-poster-tabs-left a,.mec-add-event-tabs-left a,.mec-create-shortcode-tabs-left a {
                display: block;
                position: relative;
                outline: 0;
                padding: 13px 4px 13px 20px;
                background: #e3e5e7;
                background: 0 0;
                border: solid;
                border-width: 1px 0 1px 0;
                border-color: transparent;
                color: #3f454a;
                font-size: 13px;
                font-weight: 600;
                text-decoration: none;
                border-radius: 0;
                transition: all 0.2s ease;
            }

            .mec-add-social-poster-tabs-left a:first-of-type,.mec-add-event-tabs-left a:first-of-type,.mec-create-shortcode-tabs-left a:first-of-type {
                border-top: none;
            }

            .mec-add-social-poster-tabs-left a:hover,.mec-add-event-tabs-left a:hover,.mec-create-shortcode-tabs-left a:hover {
                background: #fff;
                color: #07bbe9;
            }

            .mec-add-social-poster-tabs-left a:focus,.mec-add-event-tabs-left a:focus,.mec-create-shortcode-tabs-left a:focus {
                box-shadow: none;
                outline: unset;
            }

            .mec-add-social-poster-tabs-left a.mec-tab-active,.mec-add-event-tabs-left a.mec-tab-active,.mec-create-shortcode-tabs-left a.mec-tab-active {
                background: #ecf9fd;
                color: #07bbe9;
                border-color: #ccecf4;
                position: relative;
                padding-left: 22px;
            }

            .inside div div > a.mec-tab-active:after,.inside div div > a.mec-tab-active:before {
                position: absolute;
                z-index: 9999;
                content: " ";
                height: 0;
                width: 0;
                border: 8px solid transparent;
                border-right-color: #fff;
                right: -1px;
                top: 13px;
            }

            .inside div div > a.mec-tab-active:before {
                border-right-color: #d7d8d9;
                right: 0;
            }

            .mec-add-social-poster-tabs-right,.mec-add-event-tabs-right,.mec-create-shortcode-tabs-right {
                padding: 0 30px 40px;
                border-left: 1px solid #e2e2e2;
            }

            .mec-social-poster-tab-content.mec-tab-active,.mec-create-shortcode-tab-content.mec-tab-active,.mec-event-tab-content.mec-tab-active {
                animation: fadeEffect2 .31s;
            }

            @media(max-width: 1366px) {
                .mec-add-social-poster-tabs-right,.mec-add-event-tabs-right,.mec-create-shortcode-tabs-right {
                    padding:0 15px 20px;
                }

                .mec-form-row select {
                    min-width: 60px;
                }
            }

            @media (min-width: 1199px) and (max-width:1280px) {
                .mec-add-social-poster-tabs-right,.mec-add-event-tabs-right,.mec-create-shortcode-tabs-right {
                    padding:0 0 0 10px;
                }

                #mec_meta_box_hourly_schedule_days {
                    padding: 0 40px 0 0;
                }

                #mec_meta_box_hourly_schedule_days .mec-form-row.mec-box {
                    margin-right: -40px;
                }

                #mec_comment,#mec_cost,#mec_countdown_method,#mec_event_timezone,#mec_public,#mec_repeat_type {
                    min-width: 220px;
                    width: 220px;
                }

                #mec_meta_box_hourly_schedule_days .mec-box.mec-form-row input[type=text] {
                    max-width: 120px;
                }

                .mec-form-row .mec-time-picker select {
                    min-width: 60px;
                }

                #mec_countdown_method,#mec_repeat_type {
                    min-width: 220px;
                    width: 220px;
                }

                #mec_exceptions_in_days_container .mec-col-4 {
                    width: 25%;
                }

                #mec_exceptions_in_days_container .mec-col-3 {
                    width: 50%;
                }

                #mec_exceptions_in_days_container .mec-col-5 {
                    width: 20%;
                }

                #mec_exceptions_in_days_container input[type=text] {
                    width: 95%;
                }

                #mec_repeat_certain_weekdays_container label:not(.mec-col-3) {
                    display: block;
                    padding-left: 25%;
                }
            }

            @media (max-width: 1023px) {
                .post-type-mec-events h4 {
                    margin-top:20px
                }

                .post-type-mec-events .mec-form-row {
                    padding-bottom: 20px
                }

                .post-type-mec-events .mec-form-row .mec-form-row {
                    padding: 0
                }

                .post-type-mec-events .mec-form-row .mec-col-1,.post-type-mec-events .mec-form-row .mec-col-10,.post-type-mec-events .mec-form-row .mec-col-11,.post-type-mec-events .mec-form-row .mec-col-12,.post-type-mec-events .mec-form-row .mec-col-2,.post-type-mec-events .mec-form-row .mec-col-3,.post-type-mec-events .mec-form-row .mec-col-4,.post-type-mec-events .mec-form-row .mec-col-5,.post-type-mec-events .mec-form-row .mec-col-6,.post-type-mec-events .mec-form-row .mec-col-7,.post-type-mec-events .mec-form-row .mec-col-8,.post-type-mec-events .mec-form-row .mec-col-9 {
                    display: block;
                    width: 100%;
                    margin: 20px 0 0 0;
                    max-width: 285px
                }

                .post-type-mec-events .mec-add-social-poster-tabs-left,.post-type-mec-events .mec-add-event-tabs-left {
                    min-width: 180px
                }

                .post-type-mec-events .mec-add-social-poster-tabs-left a,.post-type-mec-events .mec-add-event-tabs-left a,.post-type-mec-events .mec-create-shortcode-tabs-left a {
                    padding-left: 10px
                }

                #mec_repeat_type,.post-type-mec-events #mec_settings_fes_thankyou_page_url,.post-type-mec-events .mec-form-row .mec-col-4 input[type=number],.post-type-mec-events .mec-form-row .mec-col-4 input[type=text],.post-type-mec-events .mec-form-row .mec-col-4 select,.post-type-mec-events .mec-form-row .mec-col-4 textarea {
                    width: 100%;
                    max-width: 255px
                }

                #mec-exceptional-days .mec-certain-day>div,#mec_exceptions_in_days_container .mec-certain-day>div {
                    width: 100%;
                    max-width: 255px;
                    padding: 12px;
                    margin: 20px 10px 0 0;
                    border-radius: 8px
                }

                .mec-certain-day .mec-in-days-day,.mec-certain-day>div .mec-not-in-days-day {
                    line-height: 21px;
                    font-size: 10px
                }

                #mec_repeat_certain_weekdays_container label {
                    display: block;
                    margin: 20px 0 20px 0
                }
            }

            @media (max-width: 640px) {
                .mec-add-social-poster-tabs-wrap,.mec-add-event-tabs-wrap,.mec-create-shortcode-tabs-wrap {
                    display:block
                }

                .post-type-mec-events .mec-add-social-poster-tabs-left,.post-type-mec-events .mec-add-event-tabs-left {
                    min-width: 100%;
                    width: 100%!important;
                    display: block!important;
                    float: unset;
                    margin: 0;
                    flex: unset;
                    height: auto
                }

                .post-type-mec-events .mec-add-social-poster-tabs-right,.post-type-mec-events .mec-add-event-tabs-right,.post-type-mec-events .mec-create-shortcode-tabs-right {
                    display: block;
                    min-width: 100%;
                    width: 100%;
                    margin: 0;
                    flex: unset
                }

                .post-type-mec-events .mec-add-social-poster-tabs-left a,.post-type-mec-events .mec-add-event-tabs-left a,.post-type-mec-events .mec-create-shortcode-tabs-left a {
                    font-size: 14px;
                    padding: 14px 10px 14px 15px;
                    line-height: 1.2;
                    letter-spacing: 0
                }

                .mec-add-social-poster-tabs-right,.mec-add-event-tabs-right,.mec-create-shortcode-tabs-right {
                    padding-left: 10px;
                    padding-right: 10px
                }

                #mec_tickets .mec-box {
                    max-width: 290px
                }
            }
        </style>

        <script>
            jQuery(document).ready(function($){

                function mec_social_poster_status_change(status){

                    if(true === status){

                        $('.mec-add-social-poster-tabs-left .mec-add-social-poster-tabs-link').show();
                        $('#mec-social-poster .mec-social-poster-option-container').show();
                    }else{

                        $('.mec-add-social-poster-tabs-left .mec-add-social-poster-tabs-link:not(:first-child)').hide();
                        $('#mec-social-poster .mec-social-poster-option-container').hide();
                    }
                }

                jQuery(".mec-add-social-poster-tabs-link").on("click", function(e){

                    e.preventDefault();
                    var href = jQuery(this).attr("data-href");
                    jQuery(".mec-social-poster-tab-content,.mec-add-social-poster-tabs-link").removeClass("mec-tab-active");
                    jQuery(this).addClass("mec-tab-active");
                    jQuery("#" + href ).addClass("mec-tab-active");
                });

                $('.mec_social_poster_status').on('change',function(e){

                    var social_poster_status = $(this).is(':checked');
                    mec_social_poster_status_change(social_poster_status);

                    $("input[type=checkbox].social_poster_form_fields_global_inheritance").trigger('change');
                });
                var social_poster_status = $('.mec_social_poster_status').is(':checked');
                mec_social_poster_status_change(social_poster_status);


                $("input[type=checkbox].social_poster_form_fields_global_inheritance").on('change',function(){

                    var status = $(this).is(":checked");
                    var social_poster_status = $('.mec_social_poster_status').is(':checked');

                    if(true !== status && true === social_poster_status){
                        $('.mec-social-poster-forms').show();
                    }else{
                        $('.mec-social-poster-forms').hide();
                    }
                });

                $("input[type=checkbox].social_poster_form_fields_global_inheritance").trigger('change');

                $("#mec_social_poster_custom_accounts").select2();
            });
        </script>
        <?php
    }

    /**
     * Render Metabox
     *
     * @param \WP_Post $event
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function render($event) {

        $this->init();

        $this->enqueue();
        ?>
        <div class="mec-add-social-poster-tabs-wrap">
            <div class="mec-add-social-poster-tabs-left">
                <a class="mec-add-social-poster-tabs-link mec-tab-active" data-href="mec_meta_box_social_poster_options_form_1" href="#"><?php echo esc_html__('Social Auto Poster Options',MECSPTEXTDOMAIN); ?></a>
                <?php if( 'publish' == $event->post_status ): ?>
                    <a class="mec-add-social-poster-tabs-link" data-href="mec_meta_box_social_poster_options_repost_form" href="#"><?php echo esc_html__('Manual Publish and Repost',MECSPTEXTDOMAIN); ?></a>
                <?php endif; ?>
                <!-- <a class="mec-add-social-poster-tabs-link" data-href="mec_meta_box_social_poster_options_form_2" href="#"><?php echo esc_html__('Limits',MECSPTEXTDOMAIN); ?></a> -->
                <?php do_action('add_event_social_poster_sections_left_menu'); ?>
            </div>
            <div class="mec-add-social-poster-tabs-right">
                <?php do_action('mec_event_social_poster_options_metabox', $event); ?>
            </div>
        </div>
        <?php
    }

    public function save_event($event_id){
        if(!isset($_POST['mec_social_poster_nonce'])) return;
        if(!wp_verify_nonce(sanitize_text_field($_POST['mec_social_poster_nonce']), 'mec_social_poster_data')) return;
        if(defined('DOING_AUTOSAVE') and DOING_AUTOSAVE) return;


        $social_poster_status_for_this_event = isset($_POST['mec_social_poster_status']) ? $_POST['mec_social_poster_status'] : "0";
        update_post_meta($event_id,'mec_social_poster_status',$social_poster_status_for_this_event);

        $social_poster_options = isset($_POST['mec-social-poster']) ? $_POST['mec-social-poster'] : array();

        unset( $social_poster_options['schedules']['{{key}}'] );

        update_post_meta( $event_id, 'mec_social_poster', $social_poster_options );

        $repost_accounts = isset( $_POST['mec_social_poster_repost_custom_accounts'] ) && is_array( $_POST['mec_social_poster_repost_custom_accounts'] ) ? $_POST['mec_social_poster_repost_custom_accounts'] : array();
        update_post_meta( $event_id, 'mec_social_poster_repost_custom_accounts', $repost_accounts );
    }

    public function meta_box_social_poster_options($post){

        $social_poster_status_for_this_event = (bool)get_post_meta($post->ID,'mec_social_poster_status',true);
        $social_poster_options = get_post_meta($post->ID, 'mec_social_poster', true);
        if(!is_array($social_poster_options)) {
            $social_poster_options = array();
        }

        $global_accounts_status = isset( $social_poster_options['global_accounts_status'] ) ? (bool)$social_poster_options['global_accounts_status'] : true;

        wp_nonce_field('mec_social_poster_data', 'mec_social_poster_nonce');
        ?>
        <div id="mec-social-poster">
            <div class="mec-meta-box-fields mec-social-poster-tab-content mec-tab-active" id="mec_meta_box_social_poster_options_form_1">

                <h4 class="mec-title"><?php esc_html_e('Publish Status', MECSPTEXTDOMAIN); ?></h4>
                <div class="mec-form-row mec-social-poster-primary-option">
                    <label for="mec_social_poster_status">
                        <input id="mec_social_poster_status" class="mec_social_poster_status" value="1" type="checkbox" name="mec_social_poster_status" <?php checked(true,$social_poster_status_for_this_event) ?> /> <?php _e( 'Enable', MECSPTEXTDOMAIN ); ?>
                    </label>
                </div>

                <div class="mec-social-poster-option-container">
                    <h4 class="mec-title"><label for="mec_social_poster_custom_accounts"><?php _e('Social Accounts', MECSPTEXTDOMAIN); ?></label></h4>
                    <?php $this->schedules_settings( $social_poster_options, $global_accounts_status ) ?>
                </div>
            </div>
        </div>
        <?php
    }

    /**
     * Render repost options
     *
     * @param \WP_Post $event
     *
     * @since 1.0.0
     *
     * @return void
     */
    public function meta_box_repost_options($post){

        $event_id = $post->ID;
        $accounts = Accounts::getInstance()->get_accounts(array(
			'account_type' => '',
			'account_status' => true,
            'check_auth' => true,
		));

        wp_enqueue_script( 'mec-social-poster-repost-script' );

        $selected_accounts = get_post_meta( $event_id, 'mec_social_poster_repost_custom_accounts', true );
        $selected_accounts = is_array( $selected_accounts ) ? $selected_accounts : array();

        wp_nonce_field( 'mec_social_poster_nf_repost', '_mec_sp_nonce' );
        ?>
        <input type="hidden" name="mec_social_poster_post_ID" id="mec_social_poster_post_ID" value="<?php echo $event_id; ?>" />
        <div class="mec-meta-box-fields mec-social-poster-tab-content" id="mec_meta_box_social_poster_options_repost_form">
            <h4 class="mec-title"><?php esc_html_e('Manual Publish and Repost', MECSPTEXTDOMAIN); ?></h4>
            <div class="mec-social-poster-messages"></div>
            <div class="mec-form-row">
                <label class="mec-col-3" for="mec_social_poster_global_accounts_status">
                    <?php esc_html_e('Accounts', MECSPTEXTDOMAIN); ?>
                </label>
                <div class="mec-col-6" id="mec_social_poster_repost_custom_accounts_box">
                    <select class="mec-col-12 mec-select2" style="width:100%" id="mec_social_poster_repost_custom_accounts" name="mec_social_poster_repost_custom_accounts[]" multiple>
                        <?php

                            $tabs = SettingsPage::getInstance()->get_primary_tabs();
                            foreach( $accounts as $account ){

                                $account_id = $account['id'];
                                $account_type = $account['account_type'];
                                $account_type_title =  $tabs[ $account_type ]['title'] ?? false;
                                if( empty( $account_type_title ) ){

                                    continue;
                                }
                                $account_title = $account_type_title . ' - ' . $account['title'];
                                $selected = in_array( $account_id, $selected_accounts, false );
                                $can = EventSocial::getInstance()->can_send_event_to_social_account( $event_id, $account_id );
                                $class = is_wp_error($can) || !$can ? 'mec-red' : '';
                                echo '<option class="'.$class.'" value="'. $account_id .'" '. selected( $selected, true, false ) .'>'. esc_html( $account_title ) .'</option>';
                            }
                        ?>
                    </select>
                </div>
            </div>
            <div class="mec-form-row">
                <label class="mec-col-6" onchange="" for="mec_social_poster_repost_disable_check_accounts_conditions">
                    <input id="mec_social_poster_repost_disable_check_accounts_conditions" type="checkbox" value="1" />
                    <?php esc_html_e('Disable Check Account Conditions', MECSPTEXTDOMAIN); ?>
                    <span class="mec-tooltip">
                        <div class="box left">
                            <h5 class="title"><?php esc_html_e('Disable Check Account Conditions', MECSPTEXTDOMAIN); ?></h5>
                            <div class="content"><p><?php esc_attr_e('If this option is enabled, release conditions are not checked', MECSPTEXTDOMAIN); ?></p></div>
                        </div>
                        <i title="" class="dashicons-before dashicons-editor-help"></i>
                    </span>
                </label>
            </div>
            <div class="mec-form-row">
                <button class="button" type="button" id="mec_repost_on_socials"><?php esc_html_e( 'Publish', MECSPTEXTDOMAIN ) ?></button>
            </div>
        </div>
        <?php
    }



    public function schedules_settings( $options, $global_accounts_status = false, $base_name = 'mec-social-poster' ){

        global $pagenow;
        $event_id = in_array( $pagenow, array( 'post.php', 'edit.php' ) ) ? get_the_ID() : false;

        $accounts = Accounts::getInstance()->get_accounts(array(
			'account_type' => '',
			'account_status' => true,
            'check_auth' => true,
		));

        $selected_accounts = isset( $options['accounts'] ) ? (array)$options['accounts'] : array();
        $schedules = isset( $options['schedules'] ) ? $options['schedules'] : array();
        $datepicker_format = MECSettings::getInstance()->get_settings('datepicker_format');
        $datepicker_format = !empty( $datepicker_format ) ? $datepicker_format : 'Y-m-d';
        $time_format = MECSettings::getInstance()->get_settings('time_format');

        $is_global_setting = 'mec-social-poster[general]' === $base_name;

        if( $event_id && !empty( $selected_accounts) ){

            foreach( $selected_accounts as $account_id ){

                $account_title = $accounts[ $account_id ]['title'] ?? '';

                $can = EventSocial::getInstance()->can_send_event_to_social_account( $event_id, $account_id );
                if( is_wp_error($can) || !$can ){

                    $error_message = is_wp_error($can) ? '<br>' . $can->get_error_message() : '';
                    echo sprintf(
                        '<div class="mec-error">'. esc_html__( 'It is not possible to publish this event on %1s account %2s', MECSPTEXTDOMAIN ) .'</div>',
                        $account_title,
                        $error_message
                    );
                }
            }
        }

        ?>
        <script>
            jQuery(document).ready(function($){

                var datepicker_format = "<?php echo $datepicker_format ?>";
                var s = datepicker_format.split('&');
                datepicker_format = s[0];

                function mec_social_poster_schedules_init(){

                    if($.fn.datepicker){

                        $('.mec-date-picker').datepicker({
                            changeYear: true,
                            changeMonth: true,
                            dateFormat: datepicker_format,
                            gotoCurrent: true,
                            yearRange: 'c-3:c+5',
                        });
                    }

                    $('.mec-social-poster-publish-on-type').on('change',function(e){

                        var type = $(this).val();
                        $(this).parents('tr').find('.mec-publish-detail > div').hide();
                        $(this).parents('tr').find('.mec-publish-detail > div').find('select, input, textarea').prop('disabled',true);

                        if( 'global' === type || 'now' === type ){

                        }else{

                            $(this).parents('tr').find('.mec-publish-detail > div.'+type).show();
                            $(this).parents('tr').find('.mec-publish-detail > div.'+type).find('select, input, textarea').prop('disabled',false);
                        }
                    });

                    $('.mec-social-poster-publish-on-type').trigger('change');
                }

                mec_social_poster_schedules_init();


                $('#mec_social_poster_custom_accounts').on('change',function(e){

                    var selected_accounts = $(this).val();

                    var t_accounts = {};
                    $.each($('#mec-social-poster-schedules table tbody tr'),function(i,v){

                        var account_id = $(v).data('account_id')
                        t_accounts[ account_id ] = account_id;
                    });

                    delete t_accounts['{{key}}'];

                    $.each(selected_accounts,function(i,account_id){

                        if( typeof t_accounts[account_id] !== 'undefined' ){

                            delete t_accounts[account_id];
                        }else{

                            var title = $('#mec_social_poster_custom_accounts option[value="'+account_id+'"]').text();
                            var html = '<tr data-account_id="{{key}}">' + $('#mec-schedule-row').html() + '</tr>';
                            html = html.replaceAll('{{key}}',account_id);
                            html = html.replaceAll('{{account_title}}',title);
                            html = html.replaceAll('hasDatepicker','');
                            $('#mec-social-poster-schedules table tbody').append( html );
                        }
                    });

                    if( selected_accounts.length > 0 ){

                        $('.no-items-found', $('#mec-social-poster-schedules')).addClass('hidden');
                    }else{

                        $('.no-items-found', $('#mec-social-poster-schedules')).removeClass('hidden');
                    }

                    $.each(t_accounts,function(i,id){

                        $('tr[data-account_id="'+id+'"]', $('#mec-social-poster-schedules') ).remove();
                    });

                    mec_social_poster_schedules_init();
                });

                $('.mec-select2').select2({
                    templateResult: function (data, container) {
                        if (data.element) {
                            $(container).addClass($(data.element).attr("class"));
                        }

                        return data.text;
                    }
                });
            });
        </script>
        <style>
            #mec-social-poster-schedules table{
                width: 100%;
                text-align: left;
            }

            #mec-schedule-row{
                display: none;
            }
            .mec-social-poster-publish-on-type,
            .mec-publish-on-box input{
                width: 100%;
                margin: 10px auto;
            }
            .mec-social-poster-publish-on{
                display: flex;
                flex:auto;
                line-height: 3;
            }
        </style>
        <div class="mec-form-row">
        <h4 class="mec-form-subtitle"><?php esc_html_e('General Settings', MECSPTEXTDOMAIN);?></h4>
            <?php if( !$is_global_setting ): ///hide in global settings ?>
                <label class="mec-col-3" onchange="jQuery('#mec_social_poster_custom_accounts_box, #mec-social-poster-schedules').toggle()" for="mec_social_poster_global_accounts_status" id="mec_social_poster_custom_accounts_label">
                    <input type="hidden" name="<?php echo $base_name ?>[global_accounts_status]" value="0"/>
                    <input id="mec_social_poster_global_accounts_status" <?php checked( $global_accounts_status, true ) ?> type="checkbox" value="1" name="<?php echo $base_name ?>[global_accounts_status]"/>
                    <?php esc_html_e('Inherit from global options', MECSPTEXTDOMAIN); ?>
                </label>
            <?php else: ?>
                <label class="mec-col-3" for="mec_social_poster_global_accounts_status">
                    <?php esc_html_e('Accounts', MECSPTEXTDOMAIN); ?>
                    <span class="mec-tooltip">
                        <div class="box">
                            <h5 class="title">
                                <?php esc_html_e('Accounts',MECSPTEXTDOMAIN); ?>
                            </h5>
                            <div class="content">
                                <p><?php esc_html_e('Select the accounts you want to publish the events in', MECSPTEXTDOMAIN); ?></p>
                            </div>
                        </div>
                        <i title="" class="dashicons-before dashicons-editor-help"></i>
                    </span>
                </label>
            <?php endif; ?>
            <div class="mec-col-3 <?php echo $global_accounts_status ? 'hidden' : ''  ?>" id="mec_social_poster_custom_accounts_box">
                <select class="mec-col-12 mec-select2" style="width:100%" name="<?php echo $base_name ?>[accounts][]" <?php echo !$is_global_setting ? 'id="mec_social_poster_custom_accounts"' : '' ?> multiple>
                    <?php
                        $tabs = SettingsPage::getInstance()->get_primary_tabs();
                        foreach( $accounts as $account ){

                            $account_id = $account['id'];
                            $account_type = $account['account_type'];
                            $account_type_title =  $tabs[ $account_type ]['title'] ?? false;
                            if( empty( $account_type_title ) ){

                                continue;
                            }
                            $account_title = $account_type_title . ' - ' . $account['title'];
                            $selected = in_array( $account_id, $selected_accounts, false );
                            $can = $event_id ? EventSocial::getInstance()->can_send_event_to_social_account( $event_id, $account_id ) : true;
                            $class = is_wp_error($can) || !$can ? 'mec-red' : '';
                            echo '<option class="'. $class .'" value="'. $account_id .'" '. selected( $selected, true, false ) .'>'. esc_html( $account_title ) .'</option>';
                        }
                    ?>
                </select>
            </div>
        </div>

        <?php
        if( $is_global_setting ):
            $allowed_accounts_in_fes_form_selected =  $options['allowed_accounts_in_fes_form'] ?? array();
            ?>
            <div class="mec-form-row">
                <label class="mec-col-3">
                    <?php esc_html_e('Allowed Accounts in FES Form', MECSPTEXTDOMAIN); ?>
                    <span class="mec-tooltip">
                        <div class="box">
                            <h5 class="title">
                                <?php esc_html_e('Allowed Accounts in FES Form',MECSPTEXTDOMAIN); ?>
                            </h5>
                            <div class="content">
                                <p><?php esc_html_e('Select the accounts authorized to choose and publish events in the form.', MECSPTEXTDOMAIN); ?></p>
                            </div>
                        </div>
                        <i title="" class="dashicons-before dashicons-editor-help"></i>
                    </span>
                </label>
                <div class="mec-col-3">
                    <select class="mec-col-12 mec-select2" style="width:100%" name="<?php echo $base_name ?>[allowed_accounts_in_fes_form][]" multiple>
                        <?php
                            foreach( $accounts as $account ){

                                $account_id = $account['id'];
                                $account_title = $account['title'];
                                $selected = in_array( $account_id, $allowed_accounts_in_fes_form_selected, false );
                                echo '<option value="'. $account_id .'" '. selected( $selected, true, false ) .'>'. esc_html( $account_title ) .'</option>';
                            }
                        ?>
                    </select>
                </div>
            </div>
        <?php endif; ?>

        <div class="mec-form-row <?php echo $global_accounts_status ? 'hidden' : ''  ?>" id="mec-social-poster-schedules">
            <?php if( $is_global_setting ): ///hide in global settings ?>
                <h5 class="mec-form-subtitle"><?php esc_html_e( 'Default Schedule' ,MECSPTEXTDOMAIN ) ?></h5>
            <?php endif; ?>
            <table class="wp-list-table widefat fixed striped table-view-list">
                <thead>
                    <tr>
                        <th><?php esc_html_e( 'Account', MECSPTEXTDOMAIN ); ?></th>
                        <th><?php esc_html_e( 'Publish on', MECSPTEXTDOMAIN ); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                        $schedules['{{key}}'] = array(
                            'account_id' => '{{key}}',
                            'title' => '{{account_title}}',
                            'publish_on_type' => '',
                            'publish_on' => array()
                        );

                        foreach( $schedules as $schedule_args ):

                            $account_id = $schedule_args['account_id'] ?? '';

                            if( !$account_id ){

                                continue;
                            }

                            if( '{{key}}' !== $account_id && !isset( $accounts[ $account_id ] ) ){

                                continue;
                            }
                            $account_title = isset( $accounts[ $account_id ]['title'] ) ? $accounts[ $account_id ]['title'] : '';
                            if( '{{key}}' === $account_id ){
                                $account_title = '{{account_title}}';
                            }
                            $publish_on_type = $schedule_args['publish_on_type'] ?? 'global';
                            $publish_on = isset( $schedule_args['publish_on'] ) ? $schedule_args['publish_on'] : array();

                            ?>
                            <tr data-account_id="<?php echo $account_id ?>" <?php echo '{{key}}' === $account_id ? 'id="mec-schedule-row"' : '' ?>>
                                <td style="width: 48%;">
                                    <input type="hidden" name="<?php echo $base_name ?>[schedules][<?php echo $account_id ?>][account_id]" value="<?php echo $account_id ?>" />
                                    <?php echo esc_html( $account_title ); ?>
                                </td>
                                <td style="width: 50%;" >
                                    <div class="mec-publish-on-box">
                                        <select name="<?php echo $base_name ?>[schedules][<?php echo $account_id ?>][publish_on_type]" class="mec-social-poster-publish-on-type">
                                            <?php if( !$is_global_setting ): ///hide in global settings ?>
                                                <option value="global" <?php selected( 'global', $publish_on_type ) ?>><?php esc_html_e( 'Global', MECSPTEXTDOMAIN ) ?></option>
                                            <?php endif; ?>
                                            <option value="now" <?php selected( 'now', $publish_on_type ) ?>><?php esc_html_e( 'After Publication', MECSPTEXTDOMAIN ) ?></option>
                                            <option value="x_hours_after_publish" <?php selected( 'x_hours_after_publish', $publish_on_type ) ?>><?php esc_html_e( 'x Hours After Publication', MECSPTEXTDOMAIN ) ?></option>
                                            <option value="x_days_after_publish" <?php selected( 'x_days_after_publish', $publish_on_type ) ?>><?php esc_html_e( 'x Days After Publication', MECSPTEXTDOMAIN ) ?></option>
                                            <?php if( !$is_global_setting ): ///hide in global settings ?>
                                                <option value="custom" <?php selected( 'custom', $publish_on_type ) ?>><?php esc_html_e( 'Custom', MECSPTEXTDOMAIN ) ?></option>
                                            <?php endif; ?>
                                        </select>
                                        <?php if( !$is_global_setting ): ///hide in global settings ?>
                                            <span class="mec-tooltip">
                                                <div class="box left">
                                                    <h5 class="title"><?php esc_html_e('Publish on type', MECSPTEXTDOMAIN); ?></h5>
                                                    <div class="content"><p><?php esc_attr_e('If set to global, follows the global settings for this settings', MECSPTEXTDOMAIN); ?></p></div>
                                                </div>
                                                <i title="" class="dashicons-before dashicons-editor-help"></i>
                                            </span>
                                        <?php endif; ?>

                                        <div class="mec-publish-detail">
                                            <div class="custom">
                                                <?php
                                                    $publish_on_date = isset( $publish_on['date'] ) ? $publish_on['date'] : current_time( 'Y-m-d' );
                                                    $publish_on_date = \MEC\Base::get_main()->standardize_format($publish_on_date, $datepicker_format);
                                                    $publish_on_time = isset( $publish_on['time'] ) ? $publish_on['time'] : array(
                                                        'hour' => 8,
                                                        'minutes' => 0,
                                                        'ampm' => 'AM',
                                                    );
                                                ?>

                                                <div>
                                                    <input type="text" class="mec-date-picker" value="<?php echo esc_attr( $publish_on_date ) ?>" name="<?php echo $base_name ?>[schedules][<?php echo $account_id ?>][publish_on][date]" placeholder="<?php _e('Publish Date', MECSPTEXTDOMAIN); ?>" autocomplete="off" style="width:100%"/>
                                                </div>

                                                <div class="mec-social-poster-publish-on mec-time-picker">
                                                    <?php
                                                        \MEC\Base::get_main()->timepicker(array(
                                                            'method' => $time_format,
                                                            'time_hour' => $publish_on_time['hour'] ?? '00',
                                                            'time_minutes' => $publish_on_time['minutes'] ?? '00',
                                                            'time_ampm' => $publish_on_time['ampm'] ?? '',
                                                            'name' => $base_name . '[schedules]['. $account_id .'][publish_on][time]',
                                                            'id_key' => 'publish_on_',
                                                            'include_h0' => true,
                                                        ));
                                                    ?>
                                                </div>
                                            </div>

                                            <div class="x_hours_after_publish x_days_after_publish">
                                                <div>
                                                    <?php $value = $publish_on['value'] ?? 1; ?>
                                                    <input type="number" min="1" value="<?php echo esc_attr( (int)$value ) ?>" name="<?php echo $base_name ?>[schedules][<?php echo $account_id; ?>][publish_on][value]" placeholder="<?php _e('ex: 1', MECSPTEXTDOMAIN); ?>" />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>

                        <tr class="no-items-found <?php echo count( $schedules ) > 1 ? 'hidden' : ''; ?>">
                            <td colspan="2"><?php esc_html_e( 'No items found.', MECSPTEXTDOMAIN ); ?></td>
                        </tr>

                </tbody>
            </table>
        </div>
        <?php
    }
}