<?php

namespace MEC_Social_Poster\History;

/**
 * @since 1.0.0
 */
class HistoryListTable extends \WP_List_Table {

	public $section;
	public $setting_class;

	public function __construct() {
		global $status, $page;
		parent::__construct(array(
			'singular' => 'setting',
			'plural' => 'settings',
			'ajax' => false,
		));
	}

	function column_default($item, $column_name) {

		return $item[$column_name];
	}

	function column_title($item) {

		$wpea_url_delete_args = array(
			'page' => sanitize_text_field(wp_unslash($_REQUEST['page'])),
			'tab' => sanitize_text_field(wp_unslash($_REQUEST['tab'])),
			'action' => 'delete',
			'id' => $item['ID'],
		);

		// Build row actions.
		$actions = array(
			'delete' => sprintf(
				'<a href="%1$s" onclick="return confirm(\'Warning!! Are you sure to Delete this log? log history will be permanatly deleted.\')">%2$s</a>',
				esc_url(wp_nonce_url(add_query_arg($wpea_url_delete_args),'mec_sp_delete_history_nonce')),
				esc_html__('Delete', MECSPTEXTDOMAIN)
			),
		);

		// Return the title contents.
		return sprintf('<strong>%1$s</strong><span>%3$s</span> %2$s',
			$item['title'],
			$this->row_actions($actions),
			''
		);
	}

	function column_cb($item) {

		return sprintf(
			'<input type="checkbox" name="%1$s[]" value="%2$s" />',
			/*$1%s*/$this->_args['singular'],
			/*$2%s*/$item['ID']
		);
	}

	public function column_date( $item ) {

		return $item['creation_date'];
	}

	public function column_status( $item ) {

		return is_wp_error( $item['result_object'] ) ? '<span style="color:red">' . $item['result_object']->get_error_message() . '</span>' : __( 'Done', MECSPTEXTDOMAIN );
	}

	/**
	 * Get column title.
	 *
	 * @since    1.0.0
	 */
	function get_columns() {
		$columns = array(
			'cb' => '<input type="checkbox" />',
			'title' => __('Account', MECSPTEXTDOMAIN),
			'date' => __('Date', MECSPTEXTDOMAIN),
			'status' => __('Status', MECSPTEXTDOMAIN),
		);
		return $columns;
	}

	public function get_bulk_actions() {

		return array(
			'delete' => __('Delete', MECSPTEXTDOMAIN),
		);
	}

	public function process_bulk_action() {

		$bulk_action = $this->current_action();
        // security check!
        if ( $bulk_action && isset( $_REQUEST['_wpnonce'] ) && ! empty( $_REQUEST['_wpnonce'] ) ) {

			$redirect_url = $_SERVER['HTTP_REFERER'];
            $nonce  = sanitize_text_field(  $_REQUEST['_wpnonce'] );
            $action = 'mec_sp_delete_history_nonce';

            if ( !wp_verify_nonce( $nonce, $action ) ){

				wp_die(__( 'Nope! Security check failed!', MECSPTEXTDOMAIN ));
			}


			// wp_die(print_r($bulk_action));
			if( 'delete' === $bulk_action ){

				$ids = isset($_POST['setting']) ? $_POST['setting']: null;
				$id = isset($_GET['id']) ? $_GET['id']: null;
				$ids = empty( $ids ) && !is_null( $id ) ? [ $id ] : $ids;

				if($ids == null || !is_array($ids)){

					return;
				}

				foreach ( $ids as $id ) {

					$this->setting_class->delete_account($id);
				}

				echo '<script>window.location.href = "' . $redirect_url . '"</script>';
			}
        }
    }

	public function prepare_items() {

		$this->process_bulk_action();

		$per_page = 10;
		$columns = $this->get_columns();
		$hidden = array('ID');
		$sortable = $this->get_sortable_columns();

		$this->_column_headers = array($columns, $hidden, $sortable);


		$data = $this->get_data();

		$total_items = $data['total_records'];
		$this->items = $data['data'];

		$this->set_pagination_args(array(
			'total_items' => $total_items,
			'per_page' => $per_page,
			'total_pages' => ceil($total_items / $per_page),
		));
	}

	public function get_data() {

		$ret = array('total_records' => 0, 'data' => array());
		$per_page = 10;
		$current_page = $this->get_pagenum();
        $rows = $this->setting_class->get_history( $this->section );

		$ret['total_records'] = count( $rows );
		foreach ( $rows as $k => $row ) {

			$account_id = $row['account_id'] ?? false;

			$account_data = $this->setting_class->get_account_data( $account_id );
			$account_name = $account_data['title'] ?? '';

			$row['ID'] = $row['id'];
			$row['title'] = "EventID: {$row['event_id']} <br> Account: {$account_name}";

			$ret['data'][] = $row;
		}

		wp_reset_postdata();
		return $ret;
	}
}
