<?php

namespace MEC_Social_Poster\Settings;

use MEC\Singleton;
use MEC\Libraries\FlushNotices;

/**
 * @since 1.0.0
 */
class SettingsPage extends Singleton {

	/**
	 * @var array
	 *
	 * @since 1.0.0
	 */
	public $settings;

	/**
	 * Init
	 *
	 * @since 1.0.0
	 */
	public function init() {

		define( 'MEC_RS_SETTINGS_PAGE_TEMPLATES' , __DIR__ . '/templates/' );

		add_action( 'admin_menu', array( $this, 'admin_menu' ) );
		add_action( 'admin_post_mec-social-poster', array( $this, 'process_settings_page' ) );
	}

	/**
	 * Admin menu
	 *
	 * @since 1.0.0
	 */
	public function admin_menu() {

		add_submenu_page(
            'mec-intro',
            __( 'Social Auto Poster', MECSPTEXTDOMAIN ),
            __( 'Social Auto Poster', MECSPTEXTDOMAIN ),
            'manage_options',
            'mec-social-poster',
            array( $this, 'display' )
        );
	}

	/**
	 * Return Primary Tabs - Args
	 *
	 * @since 1.0.0
	 *
	 * @return array
	 */
	public function get_primary_tabs(){

		$tabs = array(
			'settings' => array(
				'title' => __( 'Settings', MECSPTEXTDOMAIN ),
				'link' => 'settings',
			),

			'facebook' => array(
				'title' => __( 'Facebook', MECSPTEXTDOMAIN ),
				'link' => 'facebook',
			),
			'twitter' => array(
				'title' => __( 'X (Twitter)', MECSPTEXTDOMAIN ),
				'link' => 'twitter',
			),
			'linkedin' => array(
				'title' => __( 'Linkedin', MECSPTEXTDOMAIN ),
				'link' => 'linkedin',
			),
			'meetup' => array(
				'title' => __( 'Meetup', MECSPTEXTDOMAIN ),
				'link' => 'meetup',
			),
			'instagram' =>  array(
				'title' => __( 'Instagram', MECSPTEXTDOMAIN ),
				'link' => 'instagram',
			),

			'history' => array(
				'title' => __( 'History', MECSPTEXTDOMAIN ),
				'link' => 'history',
			),
		);

		return apply_filters( "mec_social_poster_setting_tabs", $tabs );
	}

	/**
	 * Return current primary tab slug
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	public function get_current_primary_tab_slug(){

		return isset($_REQUEST['tab']) ? sanitize_text_field($_REQUEST['tab']) : 'mec-settings';
	}

	/**
	 * Return current primary tab id
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	public function get_current_primary_tab_id(){

		$slug = $this->get_current_primary_tab_slug();

		return str_replace( 'mec-', '', $slug );
	}

	/**
	 * Return Builder page class name
	 *
	 * @return string|false
	 */
	public function get_builder_page_class(){ //TODO: Cache

		$slug = $this->get_current_primary_tab_slug();
		$class_name = ucfirst( str_replace( 'mec-', '', $slug ) );
		$class = __NAMESPACE__ . '\\Tabs\\'. $class_name;

		return class_exists( $class ) ? $class : false;
	}

	/**
	 * Return Output HTML
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	public function display_primary_tab_content(){

		$class = $this->get_builder_page_class();
		if( !$class ){

			return;
		}
		ob_start();

			$class::getInstance()->display();
		return ob_get_clean();
	}

	/**
	 * Display Settings Page
	 *
	 * @since 1.0.0
	 */
	public function display() {

		include MEC_RS_SETTINGS_PAGE_TEMPLATES . 'template-settings-page.php';
	}

	/**
	 * Process settings page - submit form
	 *
	 * @since 1.0.0
	 */
	public function process_settings_page() {

		$class = $this->get_builder_page_class();
		if( !$class ){

			return;
		}

		$validate = $class::getInstance()->validate_nonce();
		$redirect_to = false;
		if( method_exists($class::getInstance(),'get_redirect_url') ){

			$redirect_to = $class::getInstance()->get_redirect_url();
		}

		if( true === $validate ){

			$class::getInstance()->process_form();
			FlushNotices::getInstance()->add_flash_notice( __( 'Settings saved', MECSPTEXTDOMAIN ), 'success' );
		}elseif( is_wp_error( $validate ) ){

			FlushNotices::getInstance()->add_flash_notice( $validate->get_error_message(), 'error' );
		}

		$redirect_to = !empty( $redirect_to ) ? $redirect_to : $_SERVER['HTTP_REFERER'];
		wp_redirect( $redirect_to );
	}


}