<?php

namespace MEC_Social_Poster\Settings\Tabs;

use MEC\Libraries\FlushNotices;
use MEC_Social_Poster\Accounts\Accounts;
use MEC_Social_Poster\Accounts\AccountsListTable;
use MEC_Social_Poster\Settings\Settings as SettingsSettings;

/**
 * @since 1.0.0
 */
class AccountSettings extends Base {

	/**
	 * Return Primary Tabs - Args
	 *
	 * @since 1.0.0
	 *
	 * @return array
	 */
	public function get_tabs(){

		$tabs = array(
			'general' => array(
				'title' => __( 'General', MECSPTEXTDOMAIN ),
				'link' => 'general',
			),
		);

		$tabs = apply_filters( 'mec_social_poster_account_settings_tabs_args', $tabs );

		return $this->prepare_tabs_args( $tabs );
	}

	/**
	 * Return redirect url
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	public function get_redirect_url(){

		$p_tab_id = $this->get_current_primary_tab_id();
		$tab_id = $this->get_current_tab_id();

		$admin_url = admin_url( 'admin.php' );
		$args = array(
			'page'=> "mec-social-poster",
			'tab'=> "mec-{$p_tab_id}",
			// 'ctab' => "mec-{$tab_id}",
		);

		return add_query_arg( $args , $admin_url );
	}


	/**
	 * Return auth callback url
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	public function get_auth_callback_url(){

		$p_tab_id = $this->get_current_primary_tab_id();
		$tab_id = $this->get_current_tab_id();

		return SettingsSettings::getInstance()->get_auth_callback_url( $p_tab_id );
	}

	/**
	 * Return auth url
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	public function get_auth_url(){

		$p_tab_id = $this->get_current_primary_tab_id();
		$tab_id = $this->get_current_tab_id();

		return SettingsSettings::getInstance()->get_auth_url( $p_tab_id );
	}

	/**
	 * Process and save accounts settings
	 *
	 * @param string $
	 *
	 * @since 1.0.0
	 *
	 * @return bool
	 */
	public function process_account_form_settings( $tab_id ){

		$account = isset( $_POST['account'] ) ? $_POST['account'] : false;

		if( !$account || !is_array( $account ) ){

			return false;
		}

		$id = isset( $account['id'] ) && !empty( $account['id'] ) ? $account['id'] : time();
		$account['id'] = $id;
		$account['title'] = $account['title'] ?? __( 'Undefined', MECSPTEXTDOMAIN );
		$account['active'] = isset( $account['active'] ) && $account['active'] ? true : false;

		switch( $tab_id ){

			case 'facebook':

				$account['businessapp'] = true;
				$account['app_id'] = isset( $account['app_id'] ) ? sanitize_text_field( $account['app_id'] ) : false;
				$account['app_secret'] = isset( $account['app_secret'] ) ? sanitize_text_field( $account['app_secret'] ) : false;
				$account['need_auth'] = isset( $account['need_auth'] ) && $account['need_auth'] ? true : false;
				$account['fb_account_type'] = isset( $account['fb_account_type'] ) && $account['fb_account_type'] ? sanitize_text_field( $account['fb_account_type'] ) : 'page';
				$account['fb_account_id'] = isset( $account['fb_account_id'] ) && $account['fb_account_id'] ? sanitize_text_field( $account['fb_account_id'] ) : false;

				if ( empty( $account['app_id'] ) || empty( $account['app_secret'] ) ) {

					FlushNotices::getInstance()->add_flash_notice(
						__( 'Please insert Facebook App ID and Secret.', MECSPTEXTDOMAIN ),
						'error'
					);
					return false;
				}

				break;
			case 'twitter':

				$account['api_key'] = isset( $account['api_key'] ) ? sanitize_text_field( $account['api_key'] ) : false;
				$account['api_secret'] = isset( $account['api_secret'] ) ? sanitize_text_field( $account['api_secret'] ) : false;
				$account['access_token'] = isset( $account['access_token'] ) ? sanitize_text_field( $account['access_token'] ) : false;
				$account['access_token_secret'] = isset( $account['access_token_secret'] ) ? sanitize_text_field( $account['access_token_secret'] ) : false;

				break;
			case 'linkedin':

				$account['api_key'] = isset( $account['api_key'] ) ? sanitize_text_field( $account['api_key'] ) : false;
				$account['api_secret'] = isset( $account['api_secret'] ) ? sanitize_text_field( $account['api_secret'] ) : false;
				$account['linkedin_account_type'] = isset( $account['linkedin_account_type'] ) && $account['linkedin_account_type'] ? sanitize_text_field( $account['linkedin_account_type'] ) : 'page';
				$account['linkedin_account_id'] = isset( $account['linkedin_account_id'] ) && $account['linkedin_account_id'] ? sanitize_text_field( $account['linkedin_account_id'] ) : false;

				break;
			case 'meetup':



				break;
			case 'instagram':

				$account['app_id'] = isset( $account['app_id'] ) ? sanitize_text_field( $account['app_id'] ) : false;
				$account['app_secret'] = isset( $account['app_secret'] ) ? sanitize_text_field( $account['app_secret'] ) : false;
				$account['businessapp'] = true;
				$account['need_auth'] = isset( $account['need_auth'] ) && $account['need_auth'] ? true : false;
				$account['fb_account_type'] = isset( $account['fb_account_type'] ) && $account['fb_account_type'] ? sanitize_text_field( $account['fb_account_type'] ) : 'page';
				$account['fb_account_id'] = isset( $account['fb_account_id'] ) && $account['fb_account_id'] ? sanitize_text_field( $account['fb_account_id'] ) : false;

				break;
			default:

				$account = apply_filters( 'mec_social_poster_process_account_form_settings', $account, $tab_id );
				break;
		}

		$taxonomies = array(
			'mec_category',
			'mec_organizer',
			'mec_speaker',
			'mec_location',
		);
		foreach( $taxonomies as $tax ){

			$account[ $tax ] = isset( $account[ $tax ] ) && !empty( $account[ $tax ] ) ? $account[ $tax ] : false;
		}


		$accounts = $this->get_settings( 'accounts', array() );

		$account['account_type'] = $tab_id;
		$accounts[ $id ] = $account;

		return $this->update_settings( 'accounts', $accounts );
	}

	/**
	 * Process form
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function process_form(){

		$tab_id = $this->get_current_primary_tab_id();

		$account_settings_tabs = array(
			'facebook',
			'twitter',
			'linkedin',
			'meetup',
			'instagram',
		);

		$account_settings_tabs = apply_filters( 'mec_social_poster_account_settings_process_form_tabs', $account_settings_tabs );

		if( in_array( $tab_id, $account_settings_tabs ) ){

			$this->process_account_form_settings( $tab_id );
		}
	}

	/**
	 * Return accounts list
	 *
	 * @since 1.0.0
	 *
	 * @return array
	 */
	public function get_accounts( $tab_id ){

		return Accounts::getInstance()->get_accounts(array(
			'account_type' => $tab_id,
		));
	}

	/**
	 * Return account data
	 *
	 * @param string $account_id
	 *
	 * @since 1.0.0
	 *
	 * @return array
	 */
	public function get_account_data( $account_id ){

		return Accounts::getInstance()->get_account_data( $account_id );
	}

	/**
	 * Delete account
	 *
	 * @param string $account_id
	 *
	 * @since 1.0.0
	 *
	 * @return bool
	 */
	public function delete_account( $account_id ){

		return Accounts::getInstance()->delete_account( $account_id );
	}

	/**
	 * Display Settings Page
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function display(){

		parent::display();
		$this->display_table();
	}

	/**
	 * Display accounts list
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function display_table(){

		$table = new AccountsListTable();
		$table->section = $this->get_current_primary_tab_id();
		$table->setting_class = $this;

		?>
		<form method="post">
			<?php
			$page  = filter_input( INPUT_GET, 'page', FILTER_SANITIZE_STRIPPED );
			$paged = filter_input( INPUT_GET, 'paged', FILTER_SANITIZE_NUMBER_INT );
			printf( '<input type="hidden" name="page" value="%s" />', $page );
			printf( '<input type="hidden" name="paged" value="%d" />', $paged );
			$table->prepare_items();
			echo $table->display();
			?>
		</form>
		<?php
	}

}