<?php

namespace MEC_Social_Poster\Settings\Tabs;

use MEC\Singleton;
use MEC_Social_Poster\Settings\Settings;
use MEC_Social_Poster\Settings\SettingsPage;

/**
 * @since 1.0.0
 */
abstract class Base extends Singleton {

	/**
	 * Default current tab slug
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $default_ctab_slug = 'mec-general';

	/**
	 * Return current primary tab slug
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	public function get_current_tab_slug(){

		return isset($_REQUEST['ctab']) ? sanitize_text_field($_REQUEST['ctab']) : $this->default_ctab_slug;
	}

	/**
	 * Return current tab id
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	public function get_current_tab_id(){

		$slug = $this->get_current_tab_slug();

		return str_replace( 'mec-', '', $slug );
	}

	/**
	 * Return current primary tab id
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	public function get_current_primary_tab_id(){

		return SettingsPage::getInstance()->get_current_primary_tab_id();
	}

	/**
	 * Return Prepare Tabs - Args
	 *
	 * @since 1.0.0
	 *
	 * @return array
	 */
	public function prepare_tabs_args( $tabs ){

		return apply_filters( "mec_social_poster_setting_child_tabs", $tabs, $this );
	}

	/**
	 * Return Output HTML
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	public function display_tab_content(){

		$primary_tab_id = $this->get_current_primary_tab_id();
		$tab_id = $this->get_current_tab_id();

		$template = MEC_RS_SETTINGS_PAGE_TEMPLATES . "{$primary_tab_id}/{$tab_id}-tab.php";

		$template = apply_filters( 'mec_social_poster_settings_tab_template', $template, $primary_tab_id, $tab_id );

		ob_start();
			if( file_exists($template) ){

				include $template;
			}else{

				error_log( $template );
			}

		return ob_get_clean();
	}

	/**
	 * Validate nonce
	 *
	 * @return bool
	 */
	public function validate_nonce(){

		$nonce = isset( $_POST['mec_sp_settings_nonce'] ) ? sanitize_text_field( $_POST['mec_sp_settings_nonce'] ) : false;
		if( !$nonce ){

			return false;
		}

		$action = MEC_RS_SETTINGS_PAGE_TEMPLATES;
		if( !wp_verify_nonce( $nonce, $action ) ){

			return new \WP_Error( 'nonce_error', __( 'Nonce error', MECSPTEXTDOMAIN ) );
		}

		return true;
	}

	/**
	 * Return saved settings
	 *
	 * @param string $key
	 *
	 * @return mixed
	 */
	public function get_settings( $key, $default = '' ){

		return Settings::getInstance()->get_settings( $key, $default );
	}

	/**
	 * Update settings
	 *
	 * @param string $key
	 * @param mixed $value
	 *
	 * @return bool
	 */
	public function update_settings( $key, $value ){

		return Settings::getInstance()->update_settings( $key, $value );
	}

	/**
	 * Process form
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function process_form(){

	}

	/**
	 * Display Settings Page
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function display(){

		$this->display_fields_form();
	}

	/**
	 * Display Form
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function display_fields_form(){

		$current_tab_id = $this->get_current_tab_id();
		$current_primary_tab_id = $this->get_current_primary_tab_id();

		?>
		<form id="mec_setting_form" method="POST" action="<?php echo admin_url( 'admin-post.php' ); ?>">

			<?php wp_nonce_field( MEC_RS_SETTINGS_PAGE_TEMPLATES, 'mec_sp_settings_nonce' ); ?>
			<input type="hidden" name="mec-sp-setting-section" value="<?php echo $current_tab_id; ?>">
			<input type="hidden" name="action" value="<?php echo 'mec-social-poster'; ?>">
			<input type="hidden" name="tab" value="<?php echo $current_primary_tab_id; ?>">
			<input type="hidden" name="ctab" value="<?php echo $current_tab_id; ?>">

			<?php include MEC_RS_SETTINGS_PAGE_TEMPLATES . 'template-child-tabs.php'; ?>

			<div class="mec-options-fields">
				<button id="mec-sp-action" class="button button-primary mec-button-primary" type="submit"><?php esc_html_e( 'Save', MECSPTEXTDOMAIN );?></button>
			</div>
		</form>
		<?php
	}


}