<?php

namespace MEC_Social_Poster\Settings\Tabs;

use MEC\Libraries\FlushNotices;
use MEC_Social_Poster\Accounts\Accounts;
use MEC_Social_Poster\History\History as HistoryHistory;
use MEC_Social_Poster\History\HistoryListTable;

/**
 * @since 1.0.0
 */
class History extends Base {

	/**
	 * Return Primary Tabs - Args
	 *
	 * @since 1.0.0
	 *
	 * @return array
	 */
	public function get_tabs(){

		$tabs = array(
			'general' => array(
				'title' => __( 'List', MECSPTEXTDOMAIN ),
				'link' => 'general',
			),
			'chart' => array(
				'title' => __( 'Chart', MECSPTEXTDOMAIN ),
				'link' => 'chart',
			),
		);

		return $this->prepare_tabs_args( $tabs );
	}


	/**
	 * Return redirect url
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	public function get_redirect_url(){

		$p_tab_id = $this->get_current_primary_tab_id();
		$tab_id = $this->get_current_tab_id();

		$admin_url = admin_url( 'admin.php' );
		$args = array(
			'page'=> "mec-social-poster",
			'tab'=> "mec-{$p_tab_id}",
			'ctab' => "mec-{$tab_id}",
		);

		return add_query_arg( $args , $admin_url );
	}

	/**
	 * Process form
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function process_form(){

		$tab_id = $this->get_current_tab_id();

	}

	/**
	 * Return history list
	 *
	 * @since 1.0.0
	 *
	 * @return array
	 */
	public function get_history( $tab_id ){

		return HistoryHistory::getInstance()->get_logs();
	}

	/**
	 * Return account data
	 *
	 * @param string $account_id
	 *
	 * @since 1.0.0
	 *
	 * @return array
	 */
	public function get_account_data( $account_id ){

		return Accounts::getInstance()->get_account_data( $account_id );
	}

	/**
	 * Delete account
	 *
	 * @param int $id
	 *
	 * @since 1.0.0
	 *
	 * @return bool
	 */
	public function delete_account( $id ){

		return HistoryHistory::getInstance()->delete_log( $id );
	}

	/**
	 * Display Settings Page
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function display(){

		include MEC_RS_SETTINGS_PAGE_TEMPLATES . 'template-child-tabs.php';

		if( 'general' === $this->get_current_tab_id() ){

			$this->display_table();
		}
	}

	/**
	 * Display history list
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function display_table(){

		$table = new HistoryListTable();
		$table->section = $this->get_current_tab_id();
		$table->setting_class = $this;

		?>
		<form method="post">
			<?php
			wp_nonce_field( 'mec_sp_delete_history_nonce' );
			$page  = filter_input( INPUT_GET, 'page', FILTER_SANITIZE_STRIPPED );
			$paged = filter_input( INPUT_GET, 'paged', FILTER_SANITIZE_NUMBER_INT );
			printf( '<input type="hidden" name="page" value="%s" />', $page );
			printf( '<input type="hidden" name="paged" value="%d" />', $paged );
			$table->prepare_items();
			echo $table->display();
			?>
		</form>
		<?php
	}

}