<?php

namespace MEC_Social_Poster\Settings\Tabs;

use MEC\Libraries\FlushNotices;
use MEC_Social_Poster\Accounts\Accounts;
use MEC_Social_Poster\Accounts\AccountsListTable;
use MEC_Social_Poster\Settings\Settings as SettingsSettings;

/**
 * @since 1.0.0
 */
class Settings extends Base {

	/**
	 * Return Primary Tabs - Args
	 *
	 * @since 1.0.0
	 *
	 * @return array
	 */
	public function get_tabs(){

		$tabs = array(
			'general' => array(
				'title' => __( 'General', MECSPTEXTDOMAIN ),
				'link' => 'general',
			),
		);

		$tabs = apply_filters( 'mec_social_poster_account_settings_tabs_args', $tabs );

		return $this->prepare_tabs_args( $tabs );
	}

	/**
	 * Process and save general
	 *
	 * @since 1.0.0
	 *
	 * @return bool
	 */
	public function process_general_form_settings(){

		$settings = isset($_POST['mec-social-poster']['general']) ? $_POST['mec-social-poster']['general'] : array();

        unset( $settings['schedules']['{{key}}'] );

		return $this->update_settings( 'general', $settings );
	}

	/**
	 * Process form
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function process_form(){

		$this->process_general_form_settings();
	}
}