<?php
/** no direct access **/

use MEC_Social_Poster\History\History;

defined('MECEXEC') or die();

wp_enqueue_script('mec-chartjs-script');

$date_start = '- 30 days';
$date_end = 'now';
$_mec = $_POST['mec'] ?? array();
if( isset( $_POST['mec'] ) ){

    $date_start = $_mec['date']['start'] ?? $date_start;
    $date_end = $_mec['date']['end'] ?? $date_end;
}

$data = History::getInstance()->get_chart_data(
    array(),
    'daily',
    $date_start,
    $date_end
);

?>
<div class="mec-form-row">
    <form action="" method="post">
        <div class="mec-col-12">
            <input type="text" name="mec[date][start]" id="mec_start_date" value="<?php echo $_mec['date']['start'] ?? ''; ?>" placeholder="<?php esc_attr_e( 'Start Date', MECSPTEXTDOMAIN ); ?>">
            <input type="text" name="mec[date][end]" id="mec_end_date" value="<?php echo $_mec['date']['end'] ?? ''; ?>" placeholder="<?php esc_attr_e( 'End Date', MECSPTEXTDOMAIN ); ?>">
            <button type="submit" class="button button-primary" style="line-height: 2.5;"><?php esc_html_e( 'Filter', MECSPTEXTDOMAIN ); ?></button>
        </div>
    </form>
</div>
<div style="max-height: 400px;">
    <canvas id="mec-history-chart" width="400" height="400"></canvas>
</div>
<script>
    jQuery(document).ready(function($){

        var datepicker_format = 'yy-mm-dd';
        if($.fn.datepicker){

            $('#mec_start_date, #mec_end_date').datepicker({
                changeYear: true,
                changeMonth: true,
                dateFormat: datepicker_format,
                gotoCurrent: true,
                yearRange: 'c-3:c+5',
            });
        }

        const ctx = document.getElementById('mec-history-chart').getContext('2d');
        const history_chart = new Chart(ctx, {
            type: 'line',
            data: <?php echo json_encode( $data ); ?>,
            options: {
                maintainAspectRatio: false,
                scales: {
                    yAxes:  {
                        ticks: {
                            min: 0,
                            stepSize: 1,
                        },
                        scaleLabel: {
                            display: true
                        }
                    },
                    xAxes: {

                        scaleLabel: {
                            display: true
                        },
                    }
                },
            },
        });
    });
</script>