<?php
/** no direct access **/
defined('MECEXEC') or die();

$account_data = array();
$account_id = isset($_GET['id']) ? (int) $_GET['id'] : null;
if( !is_null( $account_id ) ){

    $account_data = $this->get_account_data( $account_id );
}

?>
<script>
    jQuery(document).ready(function($){
        $('.mec-sp-terms-select2').select2();
    });
</script>
<div class="mec-form-row">
    <h4 class="mec-form-subtitle"><?php esc_html_e('Instagram Settings', MECSPTEXTDOMAIN);?></h4>

    <input type="hidden" name="mec-sp-setting-id" value="<?php echo $account_id ?>">
    <input type="hidden" name="account[id]" value="<?php echo $account_id; ?>">
    <input type="hidden" name="account[need_auth]" value="1">
    <div class="mec-url-content-message">
        <p  class="description"><?php esc_html_e('Add Redirect URL: ',MECSPTEXTDOMAIN); ?><strong><code><?php echo $this->get_auth_callback_url(); ?></code></strong><?php esc_html_e('To Facebook Domain Auth.',MECSPTEXTDOMAIN); ?></p>
        <p class="description"><a href="https://webnus.net/dox/modern-events-calendar/social-auto-poster-addon/#Instagram" target="_blank"><?php esc_html_e( 'Documentation', MECSPTEXTDOMAIN ); ?></a></p>
    </div>
</div>

<div class="mec-form-row">
    <?php add_thickbox(); ?>
    <div id="mec-sp-account-view" style="display:none;">
        <div id="mec-sp-account-view-content"></div>
    </div>
    <a href="#TB_inline?&width=400&height=300&inlineId=mec-sp-account-view" id="mec-sp-account-view-click" class="thickbox"></a>
</div>

<div class="mec-form-row">
    <label class="mec-col-3" for="mec-sp-active">
        <?php esc_html_e('Account Status', MECSPTEXTDOMAIN); ?>
    </label>
    <div class="mec-col-6">

        <input type="hidden" name="account[active]" value="0">
        <label class="mec-col-6" for="mec-sp-active">
            <input type="checkbox" id="mec-sp-active" name="account[active]" value="1" <?php echo (isset($account_data['active']) and $account_data['active'] == '1') ? 'checked="checked"' : ''; ?>>
            <?php esc_html_e('Active', MECSPTEXTDOMAIN);?>
        </label>
    </div>
</div>

<div class="mec-form-row">
    <label class="mec-col-3" for="mec-sp-account-name">
        <?php esc_html_e('Account Title', MECSPTEXTDOMAIN);?>
        <span class="wbmec-mandatory">*</span>
    </label>
    <div class="mec-col-4">
        <input type="text" id="mec-sp-account-name" name="account[title]" value="<?php echo isset($account_data['title'])?$account_data['title']:''; ?>" required>
    </div>
</div>
<div class="mec-form-row">
    <label class="mec-col-3" for="mec-sp-app-id">
        <?php esc_html_e('Facebook App ID', MECSPTEXTDOMAIN);?>
        <span class="wbmec-mandatory">*</span>
    </label>
    <div class="mec-col-4">
        <input type="text" id="mec-sp-app-id" name="account[app_id]" value="<?php echo isset($account_data['app_id'])?$account_data['app_id']:''; ?>" required>
    </div>
</div>
<div class="mec-form-row">
    <label class="mec-col-3" for="mec-sp-app-secret">
        <?php esc_html_e('Facebook App secret', MECSPTEXTDOMAIN);?>
        <span class="wbmec-mandatory">*</span>
    </label>
    <div class="mec-col-4">
        <input type="text" id="mec-sp-app-secret" name="account[app_secret]" value="<?php echo isset($account_data['app_secret'])?$account_data['app_secret']:''; ?>" required>
    </div>
</div>

<div class="mec-form-row">
    <label class="mec-col-3" for="mec-sp-facebook-account-id">
        <?php esc_html_e('Facebook Account ID', MECSPTEXTDOMAIN);?>
        <span class="wbmec-mandatory">*</span>
    </label>
    <div class="mec-col-4">
        <input type="text" id="mec-sp-facebook-account-id" name="account[fb_account_id]" value="<?php echo isset($account_data['fb_account_id'])? $account_data['fb_account_id'] : ''; ?>" required>
        <span class="mec-tooltip">
            <div class="box">
                <h5 class="title">
                    <?php esc_html_e('Facebook Account ID',MECSPTEXTDOMAIN); ?>
                </h5>
                <div class="content">
                    <p>
                        <?php _e('To find your Page ID: <br>
                                            1. From News Feed, click Pages in the left side menu.<br>
                                            2. Click your Page name to go to your Page.<br>
                                            3. Click About at the top of your Page. If you don\'t see it, click More.<br>
                                            4. Scroll down to find your Page ID below MORE INFO.',MECSPTEXTDOMAIN); ?>
                    </p>
                </div>
            </div>
            <i title="" class="dashicons-before dashicons-editor-help"></i>
        </span>
    </div>
</div>

<?php include( MEC_RS_SETTINGS_PAGE_TEMPLATES . '/terms-fields.php' ) ?>