<?php
/** no direct access **/
defined('MECEXEC') or die();

$account_data = array();
$account_id = isset($_GET['id']) ? (int) $_GET['id'] : null;
if( !is_null( $account_id ) ){

    $account_data = $this->get_account_data( $account_id );
}

?>
<div class="mec-form-row">
    <h4 class="mec-form-subtitle"><?php esc_html_e('Linkedin Settings', MECSPTEXTDOMAIN);?></h4>

    <input type="hidden" name="mec-sp-setting-id" value="<?php echo $account_id ?>">
    <input type="hidden" name="account[id]" value="<?php echo $account_id; ?>">
    <input type="hidden" name="account[need_auth]" value="1">
    <div class="mec-url-content-message">
        <p class="description"><?php esc_html_e('Add Redirect URL: ',MECSPTEXTDOMAIN); ?><strong><code><?php echo $this->get_auth_callback_url(); ?></code></strong><?php esc_html_e('To Linkedin Domain Auth.',MECSPTEXTDOMAIN); ?></p>
        <p class="description"><a href="https://webnus.net/dox/modern-events-calendar/social-auto-poster-addon/#Linkedin" target="_blank"><?php esc_html_e( 'Documentation', MECSPTEXTDOMAIN ); ?></a></p>
    </div>
</div>

<div class="mec-form-row">
    <?php add_thickbox(); ?>
    <div id="mec-sp-account-view" style="display:none;">
        <div id="mec-sp-account-view-content"></div>
    </div>
    <a href="#TB_inline?&width=400&height=300&inlineId=mec-sp-account-view" id="mec-sp-account-view-click" class="thickbox"></a>
</div>

<div class="mec-form-row">
    <label class="mec-col-3" for="mec-sp-active">
        <?php esc_html_e('Account Status', MECSPTEXTDOMAIN); ?>
    </label>
    <div class="mec-col-6">

        <input type="hidden" name="account[active]" value="0">
        <label class="mec-col-6" for="mec-sp-active">
            <input type="checkbox" id="mec-sp-active" name="account[active]" value="1" <?php echo (isset($account_data['active']) and $account_data['active'] == '1') ? 'checked="checked"' : ''; ?>>
            <?php esc_html_e('Active', MECSPTEXTDOMAIN);?>
        </label>
    </div>
</div>

<div class="mec-form-row">
    <label class="mec-col-3" for="mec-sp-account-name">
        <?php esc_html_e('Account Title', MECSPTEXTDOMAIN);?>
        <span class="wbmec-mandatory">*</span>
    </label>
    <div class="mec-col-4">
        <input type="text" id="mec-sp-account-name" name="account[title]" value="<?php echo isset($account_data['title'])?$account_data['title']:''; ?>" required>
    </div>
</div>
<div class="mec-form-row">
    <label class="mec-col-3" for="mec-sp-api-key">
        <?php esc_html_e('Linkedin Client ID', MECSPTEXTDOMAIN);?>
        <span class="wbmec-mandatory">*</span>
    </label>
    <div class="mec-col-4">
        <input type="text" id="mec-sp-api-key" name="account[api_key]" value="<?php echo isset($account_data['api_key'])?$account_data['api_key']:''; ?>" required>
    </div>
</div>
<div class="mec-form-row">
    <label class="mec-col-3" for="mec-sp-api-secret">
        <?php esc_html_e('Linkedin Client Secret', MECSPTEXTDOMAIN);?>
        <span class="wbmec-mandatory">*</span>
    </label>
    <div class="mec-col-4">
        <input type="text" id="mec-sp-api-secret" name="account[api_secret]" value="<?php echo isset($account_data['api_secret'])?$account_data['api_secret']:''; ?>" required>
    </div>
</div>

<script>
    jQuery(document).ready(function($){
        $('#mec-sp-linkedin-account-type').on('change',function(e){

            if('me' === $(this).val()){
                $('#mec-sp-linkedin-account-id').prop('disabled',true).parents('.mec-form-row').hide();
            }else{
                $('#mec-sp-linkedin-account-id').prop('disabled',false).parents('.mec-form-row').show();
            }
        }).trigger('change');
    });
</script>
<div class="mec-form-row">
    <label class="mec-col-3" for="mec-sp-account-type">
        <?php esc_html_e('Linkedin Account Type',MECSPTEXTDOMAIN); ?>
        <span class="wbmec-mandatory">*</span>
    </label>
    <div class="mec-col-4">
    <?php $linkedin_account_type = isset($account_data['linkedin_account_type']) ? $account_data['linkedin_account_type'] : ''; ?>
    <select id="mec-sp-linkedin-account-type" name="account[linkedin_account_type]">
        <option value="me" <?php selected( $linkedin_account_type, 'me' ) ?>><?php esc_html_e('Primary Account',MECSPTEXTDOMAIN); ?></option>
        <option value="page" <?php selected( $linkedin_account_type, 'page' ) ?>><?php esc_html_e('Page',MECSPTEXTDOMAIN); ?></option>
    </select>
    <span class="mec-tooltip">
        <div class="box">
            <h5 class="title">
                <?php esc_html_e('Account Type',MECSPTEXTDOMAIN); ?>
            </h5>
            <div class="content">
                <p>
                </p>
            </div>
        </div>
        <i title="" class="dashicons-before dashicons-editor-help"></i>
    </span>
    </div>
</div>
<div class="mec-form-row">
    <label class="mec-col-3" for="mec-sp-linkedin-account-id">
        <?php esc_html_e('Linkedin Account ID', MECSPTEXTDOMAIN);?>
        <span class="wbmec-mandatory">*</span>
    </label>
    <div class="mec-col-4">
        <input type="text" id="mec-sp-linkedin-account-id" name="account[linkedin_account_id]" value="<?php echo isset($account_data['linkedin_account_id'])? $account_data['linkedin_account_id'] : ''; ?>" required>
    </div>
</div>

<?php include( MEC_RS_SETTINGS_PAGE_TEMPLATES . '/terms-fields.php' ) ?>