<?php
/** no direct access **/

use MEC_Social_Poster\Settings\SettingsPage;

defined('MECEXEC') or die();

$admin_url = admin_url( 'admin.php' );
$tabs = $this->get_tabs();

$current_tab_id = $this->get_current_tab_id();

if( empty( $tabs ) ){

    return;
}

$primary_tab_slug = SettingsPage::getInstance()->get_current_primary_tab_slug();

if( count( $tabs ) > 1 ):
    ?>
    <div class="wp-filter">
        <ul class="filter-links">
            <?php
                foreach ( $tabs as $tab_key => $tab_args) {

                    $args = array(
                        'page'=> "mec-social-poster",
                        'tab'=> $primary_tab_slug,
                        'ctab' => "mec-{$tab_args['link']}",
                    );

                    $url = add_query_arg( $args , $admin_url );
                    $tab_title = __( $tab_args['title'], MECSPTEXTDOMAIN );
                    $class = $tab_args['link'] == $current_tab_id ? 'current' : ''
                    ?>
                    <li>
                        <a href="<?php echo $url; ?>" class="<?php echo $class; ?>">
                            <?php echo esc_html( $tab_title ); ?>
                        </a>
                    </li>
                    <?php
                }
            ?>
        </ul>
    </div>
<?php endif; ?>

<div class="mec-tab-content w-clearfix extra">
    <?php echo $this->display_tab_content(); ?>
</div>

