<?php
/** no direct access **/
defined('MECEXEC') or die();

?>
<script>
    jQuery(document).ready(function($){
        $('.mec-sp-terms-select2').select2();
    });
</script>
<?php
$taxonomies = array(
    'mec_category',
    'mec_organizer',
    'mec_speaker',
    'mec_location',
);

foreach( $taxonomies as $tax ):
    $taxonomy = get_taxonomy( $tax );
    if( is_wp_error( $taxonomy ) || empty( $taxonomy ) ){

        continue;
    }
    ?>

    <div class="mec-form-row">
        <label class="mec-col-3">
            <?php echo $taxonomy->label; ?>
        </label>
        <div class="mec-col-4">

            <div class="mec-terms-tab-contents mec-sp-category">

                <select id="mec-sp-term-<?php echo esc_attr( $tax ); ?>" class="mec-sp-terms-select2" name="account[<?php echo $tax ?>][]" multiple="multiple">
                    <?php
                    $all = get_terms(array(
                        'taxonomy'=> $tax,
                        'hide_empty'       => 0,
                        'hierarchical'     => true,
                        'post_type'=>'mec-events'
                    ));

                    $selected_ids = isset( $account_data[ $tax ] ) && is_array( $account_data[ $tax ] ) ? $account_data[ $tax ] : array();
                    foreach ($all as $k => $v) {

                        $term_id = $v->term_id;
                        $selected = in_array( $term_id, $selected_ids, false );
                        ?>
                        <option value="<?php echo $term_id; ?>" <?php selected( true, $selected ); ?> ><?php echo esc_html($v->name); ?></option>
                        <?php
                    }
                    ?>
                </select>

                <span class="mec-tooltip">
                    <div class="box">
                        <h5 class="title">
                            <?php esc_html_e('Filter Events',MECSPTEXTDOMAIN); ?>
                        </h5>
                        <div class="content">
                            <p>
                                <?php esc_html_e('If you want to filter the posts sent to this account, you can use this section.',MECSPTEXTDOMAIN); ?>
                            </p>
                        </div>
                    </div>
                    <i title="" class="dashicons-before dashicons-editor-help"></i>
                </span>
            </div>

        </div>
    </div>
<?php endforeach ?>