<?php
/** no direct access **/
defined('MECEXEC') or die();

$account_data = array();
$account_id = isset($_GET['id']) ? (int) $_GET['id'] : null;
if( !is_null( $account_id ) ){

    $account_data = $this->get_account_data( $account_id );
}

?>
<div class="mec-form-row">
    <h4 class="mec-form-subtitle"><?php esc_html_e('X (Twitter) Settings', MECSPTEXTDOMAIN);?></h4>

    <input type="hidden" name="mec-sp-setting-id" value="<?php echo $account_id ?>">
    <input type="hidden" name="account[id]" value="<?php echo $account_id; ?>">
    <input type="hidden" name="account[need_auth]" value="1">
    <div class="mec-url-content-message">
        <p class="description"><?php esc_html_e('Add Redirect URL: ',MECSPTEXTDOMAIN); ?><strong><code><?php echo $this->get_auth_callback_url(); ?></code></strong><?php esc_html_e('To Twitter Domain Auth.',MECSPTEXTDOMAIN); ?></p>
        <p class="description"><a href="https://webnus.net/dox/modern-events-calendar/social-auto-poster-addon/#X_Twitter" target="_blank"><?php esc_html_e( 'Documentation', MECSPTEXTDOMAIN ); ?></a></p>
    </div>
</div>

<div class="mec-form-row">
    <?php add_thickbox(); ?>
    <div id="mec-sp-account-view" style="display:none;">
        <div id="mec-sp-account-view-content"></div>
    </div>
    <a href="#TB_inline?&width=400&height=300&inlineId=mec-sp-account-view" id="mec-sp-account-view-click" class="thickbox"></a>
</div>

<div class="mec-form-row">
    <label class="mec-col-3" for="mec-sp-active">
        <?php esc_html_e('Account Status', MECSPTEXTDOMAIN); ?>
    </label>
    <div class="mec-col-6">

        <input type="hidden" name="account[active]" value="0">
        <label class="mec-col-6" for="mec-sp-active">
            <input type="checkbox" id="mec-sp-active" name="account[active]" value="1" <?php echo (isset($account_data['active']) and $account_data['active'] == '1') ? 'checked="checked"' : ''; ?>>
            <?php esc_html_e('Active', MECSPTEXTDOMAIN);?>
        </label>
    </div>
</div>

<div class="mec-form-row">
    <label class="mec-col-3" for="mec-sp-account-name">
        <?php esc_html_e('Account Title', MECSPTEXTDOMAIN);?>
        <span class="wbmec-mandatory">*</span>
    </label>
    <div class="mec-col-4">
        <input type="text" id="mec-sp-account-name" name="account[title]" value="<?php echo isset($account_data['title'])?$account_data['title']:''; ?>" required>
    </div>
</div>
<div class="mec-form-row">
    <label class="mec-col-3" for="mec-sp-client-id">
        <?php esc_html_e('Twitter Client ID', MECSPTEXTDOMAIN);?>
        <span class="wbmec-mandatory">*</span>
    </label>
    <div class="mec-col-4">
        <input type="text" id="mec-sp-client-id" name="account[client_id]" value="<?php echo isset($account_data['client_id'])?$account_data['client_id']:''; ?>" required>
    </div>
</div>
<div class="mec-form-row">
    <label class="mec-col-3" for="mec-sp-client-secret">
        <?php esc_html_e('Twitter Client Secret', MECSPTEXTDOMAIN);?>
        <span class="wbmec-mandatory">*</span>
    </label>
    <div class="mec-col-4">
        <input type="text" id="mec-sp-client-secret" name="account[client_secret]" value="<?php echo isset($account_data['client_secret'])?$account_data['client_secret']:''; ?>" required>
    </div>
</div>

<!-- <div class="mec-form-row">
    <label class="mec-col-3" for="mec-sp-api-key">
        <?php esc_html_e('Twitter API Key', MECSPTEXTDOMAIN);?>
        <span class="wbmec-mandatory">*</span>
    </label>
    <div class="mec-col-4">
        <input type="text" id="mec-sp-api-key" name="account[api_key]" value="<?php echo isset($account_data['api_key'])?$account_data['api_key']:''; ?>" required>
    </div>
</div>
<div class="mec-form-row">
    <label class="mec-col-3" for="mec-sp-api-secret">
        <?php esc_html_e('Twitter API Secret', MECSPTEXTDOMAIN);?>
        <span class="wbmec-mandatory">*</span>
    </label>
    <div class="mec-col-4">
        <input type="text" id="mec-sp-api-secret" name="account[api_secret]" value="<?php echo isset($account_data['api_secret'])?$account_data['api_secret']:''; ?>" required>
    </div>
</div>
<div class="mec-form-row">
    <label class="mec-col-3" for="mec-sp-access-token">
        <?php esc_html_e('Twitter Access Token', MECSPTEXTDOMAIN);?>
        <span class="wbmec-mandatory">*</span>
    </label>
    <div class="mec-col-4">
        <input type="text" id="mec-sp-access-token" name="account[access_token]" value="<?php echo isset($account_data['access_token'])?$account_data['access_token']:''; ?>" required>
    </div>
</div>
<div class="mec-form-row">
    <label class="mec-col-3" for="mec-sp-access-token-secret">
        <?php esc_html_e('Twitter Access Token Secret', MECSPTEXTDOMAIN);?>
        <span class="wbmec-mandatory">*</span>
    </label>
    <div class="mec-col-4">
        <input type="text" id="mec-sp-access-token-secret" name="account[access_token_secret]" value="<?php echo isset($account_data['access_token_secret'])?$account_data['access_token_secret']:''; ?>" required>
    </div>
</div> -->

<?php include( MEC_RS_SETTINGS_PAGE_TEMPLATES . '/terms-fields.php' ) ?>