<?php
/**
 * PHPUnit bootstrap file
 *
 * @package MEC_Social_Poster
 */

$_tests_dir = getenv( 'WP_TESTS_DIR' );

if ( !$_tests_dir ) {
	$_tests_dir = rtrim( sys_get_temp_dir(), '/\\' ) . '/wordpress-tests-lib';
}

if ( !file_exists( $_tests_dir . '/includes/functions.php' ) ) {
	echo "Could not find $_tests_dir/includes/functions.php, have you run bin/install-wp-tests.sh ?" . PHP_EOL; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	exit( 1 );
}

// Give access to tests_add_filter() function.
require_once $_tests_dir . '/includes/functions.php';

/**
 * Manually load the plugin being tested.
 */
function _manually_load_plugin() {

	$plugins_dir = dirname( __FILE__, 4 );
	$plugin_dir  = dirname( __FILE__, 3 );

	require $plugin_dir . '/mec-social-poster.php';
	require $plugins_dir . '/modern-events-calendar/mec.php';

	$plugins_to_active = array(
		'mec-social-poster/mec-social-poster.php',
		'modern-events-calendar/mec.php',
	);
	update_option( 'active_plugins', $plugins_to_active );
}

tests_add_filter( 'muplugins_loaded', '_manually_load_plugin' );

// Start up the WP testing environment.
require $_tests_dir . '/includes/bootstrap.php';
